//////////////////////////////////////////////////////////////////////////////////
//                                                                              //
// StyleAsCode exporter v2.0 - Style data exported as a values array            //
//                                                                              //
// USAGE: On init call: GuiLoadStyleBluish();                                   //
//                                                                              //
// more info and bugs-report:  github.com/raysan5/raygui                        //
// feedback and support:       ray[at]raylibtech.com                            //
//                                                                              //
// Copyright (c) 2020-2024 raylib technologies (@raylibtech)                    //
//                                                                              //
//////////////////////////////////////////////////////////////////////////////////

#define BLUISH_STYLE_PROPS_COUNT  14

// Custom style name: Bluish
static const GuiStyleProp bluishStyleProps[BLUISH_STYLE_PROPS_COUNT] = {
    { 0, 0, 0x5ca6a6ff },    // DEFAULT_BORDER_COLOR_NORMAL 
    { 0, 1, 0xb4e8f3ff },    // DEFAULT_BASE_COLOR_NORMAL 
    { 0, 2, 0x447e77ff },    // DEFAULT_TEXT_COLOR_NORMAL 
    { 0, 3, 0x5f8792ff },    // DEFAULT_BORDER_COLOR_FOCUSED 
    { 0, 4, 0xcdeff7ff },    // DEFAULT_BASE_COLOR_FOCUSED 
    { 0, 5, 0x4c6c74ff },    // DEFAULT_TEXT_COLOR_FOCUSED 
    { 0, 6, 0x3b5b5fff },    // DEFAULT_BORDER_COLOR_PRESSED 
    { 0, 7, 0xeaffffff },    // DEFAULT_BASE_COLOR_PRESSED 
    { 0, 8, 0x275057ff },    // DEFAULT_TEXT_COLOR_PRESSED 
    { 0, 9, 0x96aaacff },    // DEFAULT_BORDER_COLOR_DISABLED 
    { 0, 10, 0xc8d7d9ff },    // DEFAULT_BASE_COLOR_DISABLED 
    { 0, 11, 0x8c9c9eff },    // DEFAULT_TEXT_COLOR_DISABLED 
    { 0, 18, 0x84adb7ff },    // DEFAULT_LINE_COLOR 
    { 0, 19, 0xe8eef1ff },    // DEFAULT_BACKGROUND_COLOR 
};

// WARNING: This style uses a custom font: "homespun.ttf" (size: 10, spacing: 1)

#define BLUISH_STYLE_FONT_ATLAS_COMP_SIZE 2914

// Font atlas image pixels data: DEFLATE compressed
static unsigned char bluishFontData[BLUISH_STYLE_FONT_ATLAS_COMP_SIZE] = { 0xed,
    0x9d, 0xb1, 0x8e, 0x24, 0x49, 0x11, 0x86, 0x2b, 0xf3, 0x00, 0x09, 0x13, 0x01, 0x12, 0xe0, 0x20, 0x81, 0x90, 0xf0, 0x10,
    0x12, 0x2e, 0x16, 0x3c, 0x02, 0x2f, 0x02, 0x0e, 0xef, 0x81, 0x07, 0x12, 0x06, 0x12, 0xce, 0x99, 0x38, 0x48, 0x20, 0xe1,
    0x81, 0x83, 0xc0, 0xc3, 0xc5, 0xe5, 0x2c, 0x8c, 0xc3, 0x81, 0x93, 0x26, 0x33, 0xd0, 0x4e, 0xcf, 0x2e, 0xe2, 0xae, 0xfe,
    0xc8, 0x8a, 0xac, 0xa8, 0xea, 0xea, 0x9b, 0x6f, 0x3f, 0xed, 0x1a, 0x95, 0x5d, 0xd5, 0x99, 0x19, 0x59, 0x35, 0xb3, 0x9d,
    0x5f, 0x47, 0xd8, 0x02, 0x00, 0x00, 0x00, 0xf0, 0x09, 0xaa, 0x38, 0x56, 0xe5, 0xab, 0x6b, 0xe0, 0x4a, 0xb7, 0xe3, 0xd5,
    0x69, 0x8f, 0x5d, 0xad, 0x06, 0xae, 0xe0, 0xb5, 0xf8, 0x6d, 0x1f, 0xa7, 0xbc, 0x90, 0x31, 0xb3, 0xf5, 0xdd, 0x7c, 0xac,
    0xcf, 0x52, 0xe4, 0xf5, 0x35, 0x34, 0x8a, 0x75, 0x4c, 0x1c, 0xeb, 0xab, 0xe3, 0x35, 0x2b, 0xa2, 0xa5, 0x9a, 0x89, 0xfe,
    0xd8, 0xf3, 0x59, 0xeb, 0x57, 0xf4, 0xce, 0x5a, 0x7b, 0x8f, 0xb6, 0x72, 0x8d, 0x26, 0x57, 0xc5, 0x9b, 0x77, 0x54, 0x33,
    0xd4, 0x45, 0x3c, 0x6d, 0xf5, 0xb5, 0x37, 0xca, 0xa6, 0x57, 0x7b, 0xef, 0x60, 0xd6, 0xac, 0xbd, 0xcc, 0xc7, 0xc7, 0x47,
    0x61, 0xa1, 0xd7, 0xeb, 0x96, 0xfd, 0xf1, 0xef, 0xcf, 0xfd, 0x29, 0x2b, 0xf7, 0xc1, 0x9b, 0x68, 0x75, 0x11, 0x2f, 0xd5,
    0x9f, 0xdb, 0xcc, 0x95, 0xd5, 0x2b, 0x7a, 0x67, 0x2d, 0x9b, 0x67, 0x7b, 0xfd, 0xfc, 0x5b, 0x4f, 0xd7, 0xc7, 0x51, 0x9e,
    0xdb, 0xd6, 0xe6, 0xae, 0x25, 0x3d, 0x57, 0xd5, 0x78, 0x17, 0xf7, 0xde, 0x5a, 0x9f, 0x85, 0x1e, 0x6a, 0xd9, 0x1f, 0x7f,
    0xbd, 0xa2, 0xed, 0xe5, 0xaf, 0x1a, 0x59, 0x13, 0xfd, 0x29, 0xa2, 0xc5, 0x3f, 0x6b, 0x4f, 0xfc, 0xcb, 0x4b, 0x4f, 0xab,
    0xb8, 0x9f, 0x4d, 0xdc, 0xd1, 0x47, 0x46, 0x3f, 0x1e, 0xff, 0xf2, 0xb2, 0x56, 0x8b, 0xf8, 0xa9, 0x74, 0x6e, 0xfc, 0xcb,
    0xcb, 0xf3, 0xbf, 0x8a, 0xde, 0x17, 0x19, 0x7d, 0xfd, 0xb4, 0x8d, 0xfc, 0x5c, 0x8d, 0xdd, 0xff, 0xb7, 0x79, 0x56, 0x6b,
    0xeb, 0xb8, 0xd8, 0xfb, 0xe3, 0x8d, 0xc5, 0xdf, 0xe4, 0x4f, 0x9e, 0xb7, 0xab, 0x78, 0xef, 0x28, 0x7a, 0xd2, 0xfd, 0xdf,
    0x65, 0x7f, 0xca, 0xcb, 0xf3, 0x7f, 0x7d, 0xcc, 0x91, 0xbb, 0x30, 0x12, 0xff, 0x51, 0x8c, 0x8f, 0xbc, 0xf7, 0xf5, 0xb5,
    0xe3, 0xf1, 0xbf, 0x5d, 0x71, 0xed, 0x5d, 0x8e, 0x5e, 0xc5, 0x4b, 0xe8, 0xf7, 0xbf, 0xe2, 0xfc, 0xce, 0xf3, 0x76, 0xed,
    0x44, 0xc6, 0x97, 0x15, 0xe7, 0xf3, 0xb1, 0xe1, 0x08, 0x22, 0xf1, 0x2f, 0x72, 0x56, 0xcb, 0xe9, 0x3f, 0xff, 0xbd, 0xf8,
    0x7b, 0x3d, 0xf5, 0xe2, 0x1f, 0x1b, 0x85, 0x05, 0x7f, 0x07, 0xbf, 0x5e, 0xfc, 0xed, 0xdd, 0xff, 0x87, 0xb6, 0x8d, 0x4d,
    0xbd, 0xde, 0xbb, 0xd2, 0x7d, 0x46, 0x3d, 0xd3, 0x9f, 0xab, 0x8d, 0x02, 0xf6, 0xf0, 0x34, 0x11, 0xc7, 0x27, 0x62, 0x0f,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x66, 0xf9, 0x64, 0x19, 0x26, 0xd9, 0x2d, 0xfb, 0xac, 0x20, 0x6d, 0xe7,
    0x78, 0x46, 0x92, 0xdf, 0xcb, 0xb3, 0xe6, 0x63, 0x39, 0xc9, 0xf9, 0xb1, 0x09, 0x23, 0xe5, 0xac, 0x96, 0xb6, 0xd9, 0xc2,
    0x58, 0xdf, 0xcd, 0xd5, 0x76, 0x4e, 0x17, 0x73, 0x35, 0xea, 0xe5, 0x79, 0xf3, 0x51, 0x27, 0x7a, 0x37, 0xf3, 0x69, 0xb9,
    0x0d, 0x76, 0xe7, 0x5a, 0xa8, 0xa5, 0x0f, 0xf7, 0xfa, 0x62, 0xe6, 0xcb, 0xbe, 0x7d, 0x55, 0xcf, 0xce, 0x53, 0xfe, 0x87,
    0xd7, 0x4b, 0xe5, 0x55, 0xd8, 0xf4, 0xa8, 0x5b, 0xea, 0x39, 0x6d, 0x2a, 0xfe, 0x7a, 0x54, 0x7a, 0x6f, 0xde, 0xb7, 0x1e,
    0xf5, 0xd5, 0x62, 0x2d, 0xdb, 0xed, 0x03, 0x15, 0x63, 0xed, 0x48, 0x44, 0xdd, 0x19, 0x73, 0xbc, 0x8a, 0xd1, 0xd8, 0x5a,
    0x68, 0x6f, 0xd2, 0x06, 0x73, 0xb8, 0xdf, 0x96, 0xd9, 0x66, 0x67, 0x74, 0x67, 0xbc, 0xbe, 0x61, 0xd2, 0x43, 0xe7, 0xf4,
    0x04, 0x5f, 0x25, 0xba, 0x7a, 0x3c, 0x0f, 0xa7, 0x3b, 0xf1, 0xaf, 0xc1, 0xb1, 0xdd, 0x5a, 0x6a, 0x68, 0x2f, 0xd8, 0x06,
    0x73, 0xb8, 0xdf, 0x96, 0xd9, 0x36, 0x7f, 0x65, 0xfa, 0x89, 0x9d, 0x75, 0xce, 0x71, 0x2b, 0xc0, 0xc2, 0xd7, 0xb1, 0x77,
    0x2b, 0x35, 0xf3, 0xf9, 0x5f, 0x26, 0x7e, 0x22, 0x97, 0xdd, 0xae, 0xc6, 0xf6, 0x27, 0xf6, 0x9c, 0x61, 0x92, 0x75, 0xce,
    0xb5, 0xdc, 0x8d, 0x32, 0xf9, 0xc4, 0x3e, 0xa7, 0xe5, 0x88, 0xf8, 0xcf, 0x1a, 0x26, 0x3d, 0xed, 0x9c, 0xe5, 0x74, 0xa7,
    0xc7, 0xe4, 0xfd, 0xef, 0xcd, 0x47, 0xe6, 0x1c, 0x7a, 0x1e, 0x90, 0xdf, 0x83, 0xd7, 0x40, 0xe3, 0x33, 0x1b, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0xff, 0xe3, 0xdb, 0x37, 0x31, 0x43, 0xc5, 0xb7, 0x76, 0xa2, 0x39, 0x7a,
    0xea, 0xe9, 0xd6, 0x4d, 0x76, 0xcb, 0xcc, 0x5c, 0x8c, 0x5a, 0x62, 0x67, 0x8e, 0x3f, 0xef, 0xd6, 0x4e, 0x89, 0xfa, 0x54,
    0xbb, 0x3d, 0x9f, 0x95, 0xb3, 0xfb, 0x67, 0xc3, 0x9e, 0xdd, 0xfe, 0xad, 0x17, 0xf4, 0x93, 0x3c, 0x73, 0xe9, 0x6d, 0xcf,
    0x33, 0x77, 0x0b, 0x6f, 0x2d, 0x6d, 0x75, 0x2e, 0x66, 0xf7, 0xd0, 0x66, 0x3c, 0x14, 0x7f, 0x37, 0x2c, 0x2f, 0xfe, 0xb3,
    0x63, 0x3e, 0xb7, 0x25, 0x9a, 0x47, 0xe4, 0x7a, 0xf1, 0xf7, 0x2c, 0x9f, 0xac, 0xf8, 0xef, 0xf3, 0x60, 0xf2, 0xe2, 0x3f,
    0xe3, 0x70, 0xe9, 0xbe, 0x7b, 0x1e, 0xd4, 0x99, 0xf1, 0xd7, 0x79, 0xb4, 0xb6, 0xc4, 0x3f, 0x6e, 0xf9, 0xc4, 0xe3, 0xbf,
    0xcf, 0x83, 0xc9, 0x8b, 0xff, 0x8c, 0xc3, 0xd1, 0x9d, 0x6c, 0x51, 0x3d, 0x9c, 0x7b, 0xc4, 0x06, 0x8e, 0x61, 0x9b, 0x88,
    0x7f, 0x91, 0x7d, 0xdc, 0xeb, 0x7f, 0x46, 0xee, 0xff, 0x72, 0x98, 0x07, 0x93, 0xfb, 0xfc, 0xcf, 0x9a, 0x87, 0x32, 0xb0,
    0x0f, 0xcb, 0x84, 0x2d, 0xd2, 0x93, 0xe7, 0x62, 0x9b, 0xef, 0x90, 0x13, 0xff, 0x99, 0x6b, 0x6d, 0x3b, 0x27, 0x1a, 0xff,
    0x32, 0x11, 0xff, 0xcc, 0xbe, 0xfb, 0xf1, 0x2f, 0x8e, 0x2d, 0x32, 0x3e, 0x27, 0x3b, 0xfe, 0xb3, 0x56, 0x4b, 0x49, 0xbc,
    0x96, 0x25, 0xc7, 0x3f, 0xee, 0xc9, 0xe4, 0xf6, 0xdd, 0x8f, 0xff, 0x7c, 0xef, 0x6e, 0x7f, 0xea, 0x01, 0x0e, 0x3d, 0x90,
    0x71, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc8, 0xff, 0xb3, 0x38, 0x15, 0xa9, 0x7c, 0xcb, 0x68, 0xbb,
    0x2d, 0xf4, 0xd6, 0xa0, 0x58, 0xf7, 0x27, 0x72, 0x32, 0xfd, 0x8c, 0x6b, 0x77, 0x45, 0xdf, 0x47, 0xcd, 0xd6, 0x4c, 0xdf,
    0x8e, 0xae, 0x71, 0xb6, 0xcd, 0xf2, 0xf1, 0xbc, 0x97, 0xd8, 0x77, 0x50, 0x55, 0x6e, 0x9a, 0x2a, 0x32, 0xdd, 0x44, 0xbf,
    0xbb, 0xef, 0xe5, 0xaa, 0xd0, 0xd7, 0xc9, 0xcc, 0x62, 0x61, 0x72, 0xbd, 0xda, 0x44, 0xdf, 0x9a, 0x38, 0xaa, 0xae, 0x51,
    0xa7, 0xbf, 0x29, 0x3d, 0x9f, 0xcb, 0x61, 0x6b, 0x4e, 0x25, 0xbd, 0x63, 0x78, 0xdb, 0xeb, 0x8e, 0xae, 0x80, 0x2e, 0xef,
    0xb1, 0xf5, 0xbe, 0x56, 0xe9, 0xb7, 0x2c, 0xb2, 0x9a, 0x59, 0x3c, 0x57, 0x8d, 0x89, 0xaa, 0x61, 0xfe, 0xfe, 0x91, 0xea,
    0x9b, 0xaa, 0x96, 0xb4, 0x88, 0x6b, 0xb4, 0xe9, 0xef, 0x84, 0xdb, 0xa0, 0x8e, 0x54, 0xe4, 0xca, 0xde, 0x0a, 0xf0, 0x2a,
    0xb9, 0xb5, 0x84, 0x5a, 0x25, 0xf1, 0x5c, 0x35, 0x9e, 0x79, 0xe0, 0x5f, 0x2d, 0x9a, 0x9b, 0x45, 0xaf, 0x99, 0xd8, 0x93,
    0x21, 0x2b, 0xc3, 0xcc, 0xb6, 0x27, 0x67, 0x71, 0x46, 0xb4, 0x84, 0x57, 0xc0, 0xb1, 0x95, 0x3c, 0x8e, 0x33, 0x0f, 0xb6,
    0x8e, 0x22, 0x7b, 0x67, 0x79, 0x7b, 0xfc, 0x97, 0x5d, 0x39, 0x41, 0xca, 0xb4, 0x2b, 0x13, 0x5b, 0x01, 0x47, 0xc7, 0xff,
    0x28, 0xf3, 0x20, 0x2b, 0x03, 0x47, 0xbf, 0x68, 0xfc, 0x47, 0xd9, 0x66, 0xe2, 0xb1, 0x8c, 0x1b, 0xa3, 0xcb, 0x5d, 0x9e,
    0x0c, 0xd9, 0xe7, 0x2c, 0xe1, 0xff, 0xc9, 0x5c, 0x23, 0xfe, 0x73, 0x19, 0x6a, 0x4a, 0x38, 0x97, 0xd0, 0xbd, 0xe2, 0x1f,
    0xaf, 0x23, 0x35, 0x77, 0x4e, 0xbe, 0x7b, 0x79, 0x46, 0xfc, 0xe1, 0x71, 0x32, 0x1f, 0x35, 0xfc, 0x24, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x52, 0xfe, 0x8f, 0x88, 0xbd, 0x72, 0xff, 0x96, 0x3a, 0xd8, 0xd5, 0x2a, 0xd3, 0x2d,
    0x25, 0xed, 0x9a, 0x9e, 0x63, 0xb4, 0xb7, 0xe6, 0xd9, 0xdb, 0x6b, 0x97, 0x69, 0xfb, 0xe7, 0x7f, 0x7b, 0xd0, 0xb7, 0x7f,
    0x6b, 0xd2, 0xce, 0x7a, 0x7e, 0xcb, 0xf1, 0xdf, 0xe6, 0x3f, 0x22, 0xdf, 0x80, 0x97, 0x21, 0xa2, 0x6e, 0x76, 0x2b, 0x9a,
    0xdc, 0x53, 0xed, 0x32, 0x67, 0x40, 0x9b, 0xd8, 0x83, 0xb8, 0x7f, 0x96, 0x9d, 0x16, 0xac, 0x43, 0x55, 0x4f, 0xcc, 0xb1,
    0xd1, 0x07, 0x3e, 0x4c, 0xcc, 0xa1, 0xd1, 0x39, 0x14, 0x96, 0xd0, 0x6b, 0x55, 0x4d, 0xa2, 0xf2, 0x90, 0xf1, 0x5f, 0x82,
    0x6e, 0x5f, 0xdf, 0x90, 0x2f, 0x23, 0x2b, 0xc7, 0x46, 0x99, 0x30, 0x7c, 0x8a, 0x53, 0x7f, 0x2c, 0x16, 0x7f, 0x55, 0xad,
    0x2e, 0xfe, 0x6c, 0x3c, 0x23, 0xcb, 0x46, 0x7e, 0x05, 0x9b, 0xbc, 0x6c, 0x1e, 0xf9, 0x39, 0x36, 0xbc, 0x9d, 0x72, 0xed,
    0x55, 0xc6, 0xe2, 0x1f, 0xcd, 0xed, 0x70, 0x46, 0xfc, 0x67, 0x6b, 0xdb, 0xe4, 0x66, 0xe6, 0x28, 0x17, 0xc9, 0xb1, 0x11,
    0xcd, 0x10, 0xb2, 0xff, 0xf9, 0x9f, 0xed, 0x23, 0xe4, 0xed, 0x54, 0x9f, 0x93, 0x67, 0x63, 0xc6, 0xd3, 0x39, 0x6a, 0x67,
    0x3e, 0xbe, 0x3b, 0x1f, 0x71, 0x2b, 0xfb, 0x43, 0xc5, 0xff, 0xca, 0x6e, 0xcf, 0x95, 0x38, 0xb2, 0xe6, 0x19, 0xf6, 0xcf,
    0xa3, 0xae, 0x69, 0xe6, 0xe0, 0x75, 0x5b, 0x5e, 0xcc, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x93, 0x01,
    0x68, 0x91, 0x39, 0x6d, 0x3e, 0x79, 0xfc, 0x8b, 0x56, 0xed, 0x5b, 0xf6, 0x35, 0xfb, 0x8e, 0x7d, 0xd7, 0xbe, 0xe2, 0x5c,
    0xb1, 0xa6, 0xe5, 0x1b, 0x1a, 0x9d, 0x53, 0x83, 0x75, 0xca, 0x4a, 0xd8, 0xd7, 0xd9, 0x57, 0x8b, 0x2c, 0x36, 0xf3, 0xd1,
    0x6b, 0x8d, 0xe2, 0xe1, 0xfb, 0x5f, 0x9e, 0x45, 0xb1, 0x9e, 0xb7, 0xe7, 0xe7, 0xf6, 0x64, 0x1f, 0xda, 0x3f, 0xed, 0x1f,
    0xf6, 0x37, 0xfb, 0xd0, 0x3e, 0x2b, 0x3f, 0xc3, 0x5c, 0xf7, 0x52, 0xde, 0x8c, 0xe1, 0x29, 0x58, 0x4d, 0xcb, 0x3f, 0x47,
    0x55, 0x08, 0x53, 0xd7, 0x2b, 0xcf, 0xd6, 0x44, 0x0b, 0xf9, 0x3a, 0xe3, 0x77, 0x52, 0xdf, 0xf1, 0x6e, 0xe1, 0x0a, 0x01,
    0x7e, 0x55, 0xb1, 0x78, 0x3c, 0xe6, 0x32, 0xa7, 0xdc, 0xf6, 0xd7, 0xd6, 0xc6, 0xf4, 0x7b, 0xfb, 0x8f, 0xfd, 0xc0, 0xaa,
    0xfd, 0xd0, 0xbe, 0x6a, 0x7f, 0xb5, 0xcf, 0xc9, 0xbc, 0x36, 0xeb, 0xe3, 0x6b, 0xd2, 0x87, 0xd1, 0xb9, 0x60, 0xbc, 0x73,
    0xca, 0xcb, 0x2e, 0x60, 0x5d, 0xbd, 0x5f, 0xd6, 0xad, 0xac, 0xe2, 0xe6, 0xaa, 0xd1, 0xde, 0x50, 0x19, 0xe6, 0x39, 0x5a,
    0x9b, 0x8b, 0x2e, 0x72, 0x0c, 0x75, 0x71, 0xe7, 0xa9, 0x7e, 0xab, 0xe3, 0xa3, 0x78, 0x8c, 0xf7, 0x1b, 0xd6, 0xb3, 0x20,
    0x99, 0x18, 0xe9, 0xaf, 0xed, 0xcf, 0xf6, 0x0d, 0xfb, 0xb6, 0xfd, 0xcb, 0xfe, 0x6d, 0x1f, 0xd9, 0x67, 0x56, 0xef, 0x22,
    0xe5, 0xe6, 0xe8, 0x27, 0xa5, 0x97, 0x0d, 0xa9, 0x38, 0x39, 0x9c, 0xba, 0x8c, 0xa7, 0xbe, 0xf7, 0xba, 0x5c, 0x9d, 0xde,
    0x3c, 0xf5, 0xe1, 0xca, 0x51, 0x7b, 0xc3, 0x25, 0x34, 0x47, 0xaa, 0x72, 0xa0, 0xba, 0xff, 0x47, 0xf1, 0x18, 0xc7, 0xbf,
    0x08, 0x43, 0x65, 0x7d, 0x8e, 0x7e, 0x61, 0x7f, 0xb7, 0xaf, 0xdb, 0x97, 0xec, 0x0b, 0xf6, 0x79, 0x7b, 0x5f, 0xc4, 0x4b,
    0xad, 0xed, 0x51, 0x06, 0xa5, 0xb8, 0x01, 0x7a, 0x8b, 0xc7, 0x7a, 0xfc, 0x6b, 0x9a, 0x1d, 0x60, 0xef, 0x9e, 0x0b, 0x73,
    0x75, 0xb6, 0x22, 0xcf, 0x7f, 0xf5, 0x13, 0x59, 0x3d, 0x53, 0x47, 0xf1, 0x98, 0x75, 0x28, 0x4c, 0xdc, 0x75, 0x7f, 0xb0,
    0x9f, 0xd9, 0x4f, 0xed, 0x7b, 0xf6, 0x2b, 0xfb, 0xc8, 0x9a, 0x7d, 0x33, 0xb8, 0xb6, 0x4b, 0xb8, 0xde, 0xa0, 0x4d, 0xde,
    0xff, 0x5d, 0xda, 0x77, 0xd7, 0x8e, 0xbf, 0xea, 0xb7, 0x3a, 0x3e, 0x8a, 0xc7, 0xac, 0x43, 0xa1, 0x5c, 0xc9, 0xf7, 0xed,
    0xc7, 0xf6, 0x81, 0xfd, 0xd2, 0x7e, 0x64, 0xdf, 0xb7, 0xdf, 0xd8, 0x97, 0x27, 0xc6, 0x66, 0xa1, 0xdf, 0xbd, 0xbc, 0xdf,
    0xca, 0xca, 0x20, 0xef, 0x54, 0x6e, 0x1e, 0xa1, 0x33, 0xde, 0x29, 0xce, 0x96, 0x78, 0xc4, 0x6d, 0x2c, 0xbd, 0x32, 0x7e,
    0x62, 0xbf, 0xb5, 0x3f, 0xd9, 0x07, 0xf6, 0x3b, 0xfb, 0xa3, 0xfd, 0xc5, 0xde, 0x73, 0x4c, 0xba, 0x68, 0xcd, 0xbc, 0x59,
    0xbf, 0xce, 0xe4, 0xef, 0x2a, 0xd9, 0xae, 0x51, 0xd6, 0x3b, 0x59, 0xa2, 0xbd, 0x34, 0x8a, 0xc7, 0xb5, 0xfc, 0x96, 0x99,
    0xac, 0x7b, 0x8f, 0xed, 0x79, 0xc1, 0x96, 0x58, 0xce, 0x59, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb0,
    0xc5, 0xfe, 0xf1, 0xdd, 0x9a, 0x65, 0x53, 0x76, 0x89, 0xb1, 0x15, 0x14, 0x71, 0x5a, 0x8a, 0xcc, 0x61, 0x51, 0x37, 0xd4,
    0xda, 0x2a, 0xa1, 0x91, 0xce, 0x1c, 0x1f, 0xf9, 0x3b, 0xfa, 0x78, 0x9e, 0x15, 0x35, 0xe3, 0x23, 0x45, 0x3f, 0x75, 0x6d,
    0x6e, 0xe5, 0x9e, 0x88, 0x85, 0xa2, 0x6b, 0x89, 0x99, 0x70, 0x34, 0x9a, 0xf0, 0x04, 0x9a, 0x3c, 0xcb, 0x5e, 0x76, 0x1e,
    0x4d, 0x66, 0xc4, 0x79, 0x92, 0xce, 0x8d, 0x3a, 0xfe, 0x9e, 0x8c, 0xf2, 0x93, 0xcc, 0xeb, 0xb3, 0x7e, 0x96, 0x3d, 0x1f,
    0xef, 0xa1, 0xbe, 0x99, 0x5b, 0x85, 0xcd, 0x9c, 0xb6, 0xb6, 0xe9, 0x13, 0xf3, 0x51, 0xfc, 0xb7, 0x7b, 0x12, 0x63, 0x0b,
    0xc5, 0xe4, 0x0e, 0xfe, 0xba, 0xa3, 0xa5, 0xb3, 0xed, 0xf8, 0x6d, 0xca, 0x9e, 0xf1, 0x73, 0x69, 0x69, 0x83, 0x23, 0xba,
    0x62, 0x54, 0x2c, 0x9b, 0x34, 0x99, 0x7c, 0x2b, 0xa6, 0x3a, 0xee, 0x83, 0x97, 0x91, 0xa8, 0x9d, 0x1a, 0xff, 0xb1, 0x85,
    0x12, 0x89, 0x7f, 0x77, 0x33, 0x24, 0x68, 0xbb, 0x64, 0x94, 0x11, 0x47, 0xbb, 0x58, 0x65, 0xea, 0xe9, 0x9b, 0xd3, 0xe2,
    0xdf, 0xe5, 0x4d, 0xee, 0x7d, 0x7b, 0xf3, 0x10, 0xcf, 0xff, 0xb2, 0x66, 0x71, 0x6c, 0x8f, 0xff, 0xd8, 0x42, 0x31, 0x51,
    0x03, 0x6f, 0xce, 0xc4, 0x8a, 0x65, 0x77, 0xf2, 0x57, 0xba, 0xce, 0xec, 0x74, 0x56, 0x8e, 0xbb, 0x99, 0x8c, 0x59, 0x9e,
    0x65, 0xb3, 0x6c, 0xcc, 0x01, 0x66, 0x03, 0x5b, 0x63, 0x7b, 0xfc, 0xc7, 0x16, 0x4a, 0xc4, 0x69, 0x19, 0x9b, 0x38, 0x25,
    0xb8, 0xab, 0xee, 0xf9, 0x45, 0x3a, 0x8f, 0xd0, 0x4c, 0x25, 0xc8, 0xb3, 0x5a, 0xbc, 0x79, 0x28, 0x1b, 0x23, 0xe7, 0xe7,
    0xd0, 0x89, 0xc4, 0x7f, 0x9f, 0x85, 0x12, 0x33, 0x08, 0xe2, 0xfe, 0xe6, 0xd8, 0x22, 0xea, 0x77, 0xcf, 0x71, 0x19, 0x7f,
    0x66, 0x74, 0xb9, 0x36, 0xb6, 0x1a, 0x13, 0xfe, 0x2b, 0x23, 0xf3, 0x7c, 0x96, 0x85, 0x32, 0x6b, 0xce, 0x94, 0x09, 0xbf,
    0xe4, 0xdc, 0xec, 0x87, 0xf1, 0x96, 0x3e, 0x88, 0x1d, 0xf9, 0x46, 0xb6, 0x3e, 0xe9, 0xe2, 0xbf, 0x1d, 0xdf, 0xbb, 0x65,
    0x64, 0xf5, 0x61, 0xd2, 0xec, 0xb7, 0xc8, 0x1e, 0x37, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x47, 0x19,
    0x2e, 0x4b, 0xb0, 0x86, 0x95, 0x6e, 0xd3, 0x47, 0x6b, 0x28, 0x6b, 0x8e, 0xe7, 0xdd, 0xdc, 0xdf, 0xef, 0x29, 0xee, 0x3e,
    0x5d, 0x5e, 0x9f, 0xbd, 0x4f, 0x80, 0xf3, 0x0c, 0x17, 0xcf, 0x7d, 0xa8, 0xa1, 0x77, 0xa9, 0xce, 0x3b, 0x3c, 0x89, 0x3d,
    0xaf, 0xb8, 0x77, 0x73, 0x7f, 0xbf, 0x47, 0x19, 0x1c, 0x55, 0x7a, 0x1f, 0x33, 0x7d, 0x1e, 0xad, 0x80, 0x2c, 0xc3, 0xc5,
    0xf3, 0xce, 0x62, 0xef, 0xd2, 0x44, 0x8b, 0xbe, 0xbe, 0xfe, 0x7c, 0xbf, 0x39, 0x19, 0x84, 0xee, 0xed, 0xf7, 0xe8, 0x6a,
    0x54, 0xca, 0xfb, 0xa8, 0x72, 0x05, 0xdc, 0x72, 0x5a, 0xd5, 0xe0, 0xd3, 0xff, 0x1c, 0x8f, 0x25, 0x9a, 0xd3, 0x4c, 0x1d,
    0xbf, 0x39, 0x6f, 0x3a, 0x5b, 0x51, 0x2c, 0xe7, 0xd0, 0xfd, 0xfd, 0x9e, 0xee, 0xe6, 0x9b, 0x3a, 0x7e, 0xaf, 0x60, 0x94,
    0x8f, 0xa7, 0x4f, 0x54, 0x64, 0x5c, 0xcf, 0x77, 0x64, 0xc2, 0xff, 0x88, 0x1d, 0x5f, 0x64, 0x46, 0x27, 0x73, 0x76, 0xc3,
    0xaf, 0xb0, 0x57, 0x1f, 0x8b, 0xcc, 0xcd, 0x72, 0xb0, 0x13, 0xe2, 0x5f, 0x9c, 0x7a, 0x68, 0x79, 0x2d, 0xcb, 0xa0, 0xee,
    0x5a, 0xd6, 0xf1, 0xeb, 0xee, 0xd5, 0x47, 0xe3, 0x6f, 0x27, 0xc5, 0xdf, 0x77, 0xdf, 0xb2, 0x5a, 0x88, 0x7f, 0x34, 0xfe,
    0xfd, 0xa4, 0xe7, 0xbf, 0x76, 0xdf, 0x32, 0x5b, 0xce, 0x88, 0xbf, 0xb9, 0x35, 0xf5, 0x1e, 0x2d, 0xfe, 0xe5, 0x14, 0x57,
    0x20, 0xbb, 0x8a, 0xa7, 0x9f, 0x4d, 0xee, 0xc8, 0xf8, 0xcf, 0x59, 0x1c, 0xe5, 0xce, 0x2d, 0x71, 0x5b, 0x25, 0xf3, 0x5d,
    0xf2, 0xab, 0x78, 0xfa, 0x2d, 0xc7, 0x1d, 0xdf, 0xf3, 0x1d, 0x07, 0xbb, 0x63, 0x4b, 0xdc, 0xcb, 0xcb, 0x7c, 0x17, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x2d, 0xfe, 0x4f, 0xd4, 0xe5, 0x99, 0x31, 0x53, 0xaa, 0xeb, 0xe7, 0x5c, 0x35,
    0xc7, 0x8e, 0x97, 0x4f, 0x48, 0xb7, 0xdc, 0xdb, 0xa9, 0xaa, 0xa1, 0xe8, 0xc7, 0x5d, 0x1e, 0xed, 0x99, 0xd8, 0xc4, 0x0e,
    0xb8, 0xef, 0x06, 0xb5, 0x09, 0x07, 0xa7, 0x3a, 0x0e, 0x4e, 0x0b, 0xe5, 0xd8, 0xe8, 0x4e, 0x3e, 0x21, 0x73, 0x72, 0x17,
    0x64, 0x8e, 0x48, 0xf7, 0xbb, 0x89, 0x55, 0xd1, 0xc2, 0x9f, 0x33, 0x3e, 0x85, 0xf2, 0xe5, 0x68, 0xcf, 0x64, 0x76, 0x07,
    0x7c, 0xce, 0xc1, 0x69, 0x21, 0x07, 0xc7, 0xab, 0x22, 0x55, 0x07, 0x55, 0xba, 0xf4, 0x6e, 0x4b, 0xae, 0x53, 0x15, 0xeb,
    0xb7, 0x9e, 0x81, 0x8c, 0xfc, 0x6f, 0xd9, 0x3b, 0x60, 0x45, 0x98, 0x6e, 0x33, 0x4f, 0xd8, 0x99, 0x16, 0x9d, 0xff, 0xc1,
    0xab, 0xde, 0x37, 0x53, 0xc9, 0x28, 0xb7, 0xdf, 0x5e, 0x85, 0xbe, 0x12, 0xca, 0x64, 0x75, 0xdf, 0x6f, 0x38, 0x77, 0x51,
    0x39, 0x27, 0xb7, 0x22, 0x90, 0x6e, 0x29, 0x32, 0x27, 0x4a, 0x71, 0x6b, 0x52, 0xf5, 0x70, 0x7d, 0x9c, 0x6c, 0x77, 0xa8,
    0x38, 0x96, 0x60, 0xd9, 0x91, 0xfb, 0x69, 0xdf, 0xbd, 0xdc, 0x27, 0x72, 0xec, 0xf4, 0x89, 0xb8, 0x64, 0xb5, 0xd8, 0x54,
    0x7d, 0xa9, 0x71, 0x7e, 0x94, 0xe3, 0xb3, 0x06, 0x75, 0xc7, 0xb7, 0xb9, 0x47, 0xfc, 0xc7, 0xf3, 0x15, 0x7f, 0x32, 0x9c,
    0x73, 0x1f, 0x45, 0x57, 0xe0, 0x5c, 0x8e, 0x8d, 0x6c, 0xa7, 0xb2, 0x0c, 0xec, 0x8d, 0xb3, 0xe3, 0x5f, 0x06, 0xe7, 0xe8,
    0xac, 0x5d, 0x76, 0x57, 0x07, 0x23, 0xfe, 0xbc, 0xde, 0x93, 0x69, 0x26, 0xaf, 0xc5, 0xaf, 0xd0, 0xb7, 0x37, 0xfe, 0x67,
    0xd8, 0x2c, 0x57, 0x30, 0x50, 0x72, 0x33, 0x03, 0x9d, 0x37, 0xa2, 0xe8, 0x4a, 0xb3, 0x8b, 0xf6, 0xf5, 0xd3, 0x95, 0x19,
    0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xd1, 0xf3, 0xff, 0xd4, 0x70, 0xcb, 0x95, 0xb3, 0xec, 0xe4, 0xe5,
    0x1f, 0xca, 0x76, 0x78, 0xe6, 0x5c, 0xaa, 0xb9, 0x4c, 0x3f, 0xca, 0x47, 0xa9, 0x81, 0xfc, 0x2b, 0x37, 0xeb, 0x44, 0x55,
    0xaa, 0xaa, 0x27, 0xf8, 0x30, 0x33, 0x86, 0x8f, 0x3a, 0xea, 0xed, 0xfc, 0x9c, 0xe3, 0xf0, 0xe8, 0xab, 0xd9, 0xc0, 0xd9,
    0xc9, 0xc9, 0xef, 0xde, 0x9c, 0xb9, 0x99, 0x59, 0x31, 0xed, 0x92, 0x86, 0xcf, 0x8c, 0x5b, 0x91, 0xeb, 0xf0, 0xe8, 0x19,
    0x6d, 0xd2, 0x2f, 0xf0, 0xab, 0x2f, 0x66, 0x7d, 0x5a, 0x1d, 0xdd, 0x91, 0x6a, 0x61, 0x8b, 0xa2, 0xdc, 0xdd, 0x94, 0xe9,
    0xae, 0xc3, 0xd3, 0x43, 0x11, 0x9b, 0x69, 0x19, 0xed, 0xa5, 0x96, 0x44, 0x97, 0x2e, 0x6b, 0xb7, 0xd2, 0x82, 0x4f, 0xcc,
    0x6b, 0x67, 0xd9, 0x29, 0x4e, 0xf6, 0x93, 0x47, 0xac, 0xfc, 0x72, 0xaf, 0xf8, 0x3f, 0xe6, 0x8c, 0xf9, 0x39, 0x29, 0x1e,
    0x2d, 0xca, 0x36, 0xe9, 0xab, 0xe4, 0xc4, 0xff, 0xda, 0xf3, 0x92, 0x97, 0x65, 0xe3, 0x9c, 0x9e, 0xcd, 0x19, 0x61, 0x99,
    0xfb, 0xd5, 0xd1, 0xf8, 0x97, 0xe4, 0xd1, 0x9f, 0x61, 0xf8, 0xcc, 0x64, 0xd9, 0x38, 0xcb, 0x3d, 0x9a, 0xb5, 0x2c, 0x8e,
    0xbe, 0xff, 0x33, 0xef, 0x98, 0x7b, 0x1b, 0x3e, 0x57, 0x76, 0x78, 0xe2, 0x2e, 0x9d, 0xf6, 0xd5, 0xe1, 0xd1, 0xd0, 0xb1,
    0x7c, 0x3d, 0x95, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xe6, 0xb9, 0xfd, 0x61, 0x1e, 0x88, 0x3f, 0xbc, 0xda, 0xf8, 0xff, 0x17 };

// Font glyphs rectangles data (on atlas)
static const Rectangle bluishFontRecs[189] = {
    { 4, 4, 5 , 10 },
    { 17, 4, 2 , 8 },
    { 27, 4, 4 , 3 },
    { 39, 4, 6 , 8 },
    { 53, 4, 5 , 10 },
    { 66, 4, 6 , 8 },
    { 80, 4, 5 , 10 },
    { 93, 4, 2 , 3 },
    { 103, 4, 3 , 8 },
    { 114, 4, 3 , 8 },
    { 125, 4, 6 , 6 },
    { 139, 4, 6 , 6 },
    { 153, 4, 2 , 3 },
    { 163, 4, 5 , 2 },
    { 176, 4, 2 , 2 },
    { 186, 4, 6 , 8 },
    { 200, 4, 5 , 8 },
    { 213, 4, 3 , 8 },
    { 224, 4, 5 , 8 },
    { 237, 4, 5 , 8 },
    { 4, 22, 5 , 8 },
    { 17, 22, 5 , 8 },
    { 30, 22, 5 , 8 },
    { 43, 22, 5 , 8 },
    { 56, 22, 5 , 8 },
    { 69, 22, 5 , 8 },
    { 82, 22, 2 , 8 },
    { 92, 22, 2 , 9 },
    { 102, 22, 4 , 6 },
    { 114, 22, 5 , 4 },
    { 127, 22, 4 , 6 },
    { 139, 22, 5 , 8 },
    { 152, 22, 6 , 8 },
    { 166, 22, 5 , 8 },
    { 179, 22, 5 , 8 },
    { 192, 22, 5 , 8 },
    { 205, 22, 5 , 8 },
    { 218, 22, 5 , 8 },
    { 231, 22, 5 , 8 },
    { 4, 40, 5 , 8 },
    { 17, 40, 5 , 8 },
    { 30, 40, 4 , 8 },
    { 42, 40, 5 , 8 },
    { 55, 40, 5 , 8 },
    { 68, 40, 5 , 8 },
    { 81, 40, 8 , 8 },
    { 97, 40, 5 , 8 },
    { 110, 40, 5 , 8 },
    { 123, 40, 5 , 8 },
    { 136, 40, 5 , 9 },
    { 149, 40, 5 , 8 },
    { 162, 40, 5 , 8 },
    { 175, 40, 6 , 8 },
    { 189, 40, 5 , 8 },
    { 202, 40, 5 , 8 },
    { 215, 40, 8 , 8 },
    { 231, 40, 5 , 8 },
    { 4, 58, 5 , 8 },
    { 17, 58, 5 , 8 },
    { 30, 58, 3 , 8 },
    { 41, 58, 6 , 8 },
    { 55, 58, 3 , 8 },
    { 66, 58, 6 , 4 },
    { 80, 58, 5 , 1 },
    { 93, 58, 2 , 3 },
    { 103, 58, 5 , 6 },
    { 116, 58, 5 , 8 },
    { 129, 58, 5 , 6 },
    { 142, 58, 5 , 8 },
    { 155, 58, 5 , 6 },
    { 168, 58, 5 , 8 },
    { 181, 58, 5 , 7 },
    { 194, 58, 5 , 8 },
    { 207, 58, 2 , 8 },
    { 217, 58, 3 , 9 },
    { 228, 58, 5 , 8 },
    { 241, 58, 2 , 8 },
    { 4, 76, 8 , 6 },
    { 20, 76, 5 , 6 },
    { 33, 76, 5 , 6 },
    { 46, 76, 5 , 7 },
    { 59, 76, 5 , 7 },
    { 72, 76, 5 , 6 },
    { 85, 76, 5 , 6 },
    { 98, 76, 5 , 8 },
    { 111, 76, 5 , 6 },
    { 124, 76, 5 , 6 },
    { 137, 76, 8 , 6 },
    { 153, 76, 5 , 6 },
    { 166, 76, 5 , 7 },
    { 179, 76, 5 , 6 },
    { 192, 76, 4 , 8 },
    { 204, 76, 2 , 10 },
    { 214, 76, 4 , 8 },
    { 226, 76, 6 , 4 },
    { 240, 76, 2 , 8 },
    { 4, 94, 5 , 8 },
    { 17, 94, 5 , 8 },
    { 30, 94, 8 , 8 },
    { 46, 94, 6 , 8 },
    { 60, 94, 5 , 10 },
    { 73, 94, 5 , 10 },
    { 86, 94, 5 , 9 },
    { 99, 94, 7 , 8 },
    { 114, 94, 4 , 6 },
    { 126, 94, 5 , 4 },
    { 139, 94, 5 , 3 },
    { 152, 94, 7 , 8 },
    { 167, 94, 5 , 2 },
    { 180, 94, 4 , 4 },
    { 192, 94, 6 , 8 },
    { 206, 94, 4 , 6 },
    { 218, 94, 4 , 6 },
    { 230, 94, 8 , 8 },
    { 4, 112, 5 , 9 },
    { 17, 112, 6 , 8 },
    { 31, 112, 2 , 2 },
    { 41, 112, 8 , 8 },
    { 57, 112, 3 , 6 },
    { 68, 112, 4 , 6 },
    { 80, 112, 5 , 4 },
    { 93, 112, 6 , 8 },
    { 107, 112, 6 , 6 },
    { 121, 112, 5 , 10 },
    { 134, 112, 5 , 8 },
    { 147, 112, 5 , 10 },
    { 160, 112, 5 , 10 },
    { 173, 112, 5 , 10 },
    { 186, 112, 5 , 10 },
    { 199, 112, 5 , 10 },
    { 212, 112, 5 , 10 },
    { 225, 112, 6 , 8 },
    { 239, 112, 5 , 9 },
    { 4, 130, 5 , 10 },
    { 17, 130, 5 , 10 },
    { 30, 130, 5 , 10 },
    { 43, 130, 5 , 10 },
    { 56, 130, 4 , 10 },
    { 68, 130, 4 , 10 },
    { 80, 130, 4 , 10 },
    { 92, 130, 4 , 10 },
    { 104, 130, 6 , 8 },
    { 118, 130, 5 , 10 },
    { 131, 130, 5 , 10 },
    { 144, 130, 5 , 10 },
    { 157, 130, 5 , 10 },
    { 170, 130, 5 , 10 },
    { 183, 130, 5 , 10 },
    { 196, 130, 4 , 4 },
    { 208, 130, 5 , 10 },
    { 221, 130, 5 , 10 },
    { 234, 130, 5 , 10 },
    { 4, 148, 5 , 10 },
    { 17, 148, 5 , 10 },
    { 30, 148, 5 , 10 },
    { 43, 148, 5 , 8 },
    { 56, 148, 5 , 8 },
    { 69, 148, 5 , 9 },
    { 82, 148, 5 , 9 },
    { 95, 148, 5 , 9 },
    { 108, 148, 5 , 9 },
    { 121, 148, 5 , 8 },
    { 134, 148, 5 , 10 },
    { 147, 148, 6 , 6 },
    { 161, 148, 5 , 7 },
    { 174, 148, 5 , 9 },
    { 187, 148, 5 , 9 },
    { 200, 148, 5 , 9 },
    { 213, 148, 5 , 8 },
    { 226, 148, 3 , 9 },
    { 237, 148, 3 , 9 },
    { 4, 166, 4 , 9 },
    { 16, 166, 4 , 8 },
    { 28, 166, 5 , 9 },
    { 41, 166, 5 , 9 },
    { 54, 166, 5 , 9 },
    { 67, 166, 5 , 9 },
    { 80, 166, 5 , 9 },
    { 93, 166, 5 , 9 },
    { 106, 166, 5 , 8 },
    { 119, 166, 4 , 6 },
    { 131, 166, 5 , 8 },
    { 144, 166, 5 , 9 },
    { 157, 166, 5 , 9 },
    { 170, 166, 5 , 9 },
    { 183, 166, 5 , 8 },
    { 196, 166, 5 , 10 },
    { 209, 166, 5 , 10 },
    { 222, 166, 5 , 9 },
};

// Font glyphs info data
// NOTE: No glyphs.image data provided
static const GlyphInfo bluishFontGlyphs[189] = {
    { 32, 0, 9, 5, { 0 }},
    { 33, 0, 1, 2, { 0 }},
    { 34, 0, 1, 4, { 0 }},
    { 35, 0, 1, 6, { 0 }},
    { 36, 0, 0, 5, { 0 }},
    { 37, 0, 1, 6, { 0 }},
    { 38, 0, 0, 5, { 0 }},
    { 39, 0, 1, 2, { 0 }},
    { 40, 0, 1, 3, { 0 }},
    { 41, 0, 1, 3, { 0 }},
    { 42, 0, 1, 6, { 0 }},
    { 43, 0, 2, 6, { 0 }},
    { 44, 0, 7, 2, { 0 }},
    { 45, 0, 4, 5, { 0 }},
    { 46, 0, 7, 2, { 0 }},
    { 47, 0, 1, 6, { 0 }},
    { 48, 0, 1, 5, { 0 }},
    { 49, 0, 1, 3, { 0 }},
    { 50, 0, 1, 5, { 0 }},
    { 51, 0, 1, 5, { 0 }},
    { 52, 0, 1, 5, { 0 }},
    { 53, 0, 1, 5, { 0 }},
    { 54, 0, 1, 5, { 0 }},
    { 55, 0, 1, 5, { 0 }},
    { 56, 0, 1, 5, { 0 }},
    { 57, 0, 1, 5, { 0 }},
    { 58, 0, 1, 2, { 0 }},
    { 59, 0, 1, 2, { 0 }},
    { 60, 0, 2, 4, { 0 }},
    { 61, 0, 3, 5, { 0 }},
    { 62, 0, 2, 4, { 0 }},
    { 63, 0, 1, 5, { 0 }},
    { 64, 0, 1, 6, { 0 }},
    { 65, 0, 1, 5, { 0 }},
    { 66, 0, 1, 5, { 0 }},
    { 67, 0, 1, 5, { 0 }},
    { 68, 0, 1, 5, { 0 }},
    { 69, 0, 1, 5, { 0 }},
    { 70, 0, 1, 5, { 0 }},
    { 71, 0, 1, 5, { 0 }},
    { 72, 0, 1, 5, { 0 }},
    { 73, 0, 1, 4, { 0 }},
    { 74, 0, 1, 5, { 0 }},
    { 75, 0, 1, 5, { 0 }},
    { 76, 0, 1, 5, { 0 }},
    { 77, 0, 1, 8, { 0 }},
    { 78, 0, 1, 5, { 0 }},
    { 79, 0, 1, 5, { 0 }},
    { 80, 0, 1, 5, { 0 }},
    { 81, 0, 1, 5, { 0 }},
    { 82, 0, 1, 5, { 0 }},
    { 83, 0, 1, 5, { 0 }},
    { 84, 0, 1, 6, { 0 }},
    { 85, 0, 1, 5, { 0 }},
    { 86, 0, 1, 5, { 0 }},
    { 87, 0, 1, 8, { 0 }},
    { 88, 0, 1, 5, { 0 }},
    { 89, 0, 1, 5, { 0 }},
    { 90, 0, 1, 5, { 0 }},
    { 91, 0, 1, 3, { 0 }},
    { 92, 0, 1, 6, { 0 }},
    { 93, 0, 1, 3, { 0 }},
    { 94, 0, 1, 6, { 0 }},
    { 95, 0, 9, 5, { 0 }},
    { 96, 0, 1, 2, { 0 }},
    { 97, 0, 3, 5, { 0 }},
    { 98, 0, 1, 5, { 0 }},
    { 99, 0, 3, 5, { 0 }},
    { 100, 0, 1, 5, { 0 }},
    { 101, 0, 3, 5, { 0 }},
    { 102, 0, 1, 5, { 0 }},
    { 103, 0, 3, 5, { 0 }},
    { 104, 0, 1, 5, { 0 }},
    { 105, 0, 1, 2, { 0 }},
    { 106, 0, 1, 3, { 0 }},
    { 107, 0, 1, 5, { 0 }},
    { 108, 0, 1, 2, { 0 }},
    { 109, 0, 3, 8, { 0 }},
    { 110, 0, 3, 5, { 0 }},
    { 111, 0, 3, 5, { 0 }},
    { 112, 0, 3, 5, { 0 }},
    { 113, 0, 3, 5, { 0 }},
    { 114, 0, 3, 5, { 0 }},
    { 115, 0, 3, 5, { 0 }},
    { 116, 0, 1, 5, { 0 }},
    { 117, 0, 3, 5, { 0 }},
    { 118, 0, 3, 5, { 0 }},
    { 119, 0, 3, 8, { 0 }},
    { 120, 0, 3, 5, { 0 }},
    { 121, 0, 3, 5, { 0 }},
    { 122, 0, 3, 5, { 0 }},
    { 123, 0, 1, 4, { 0 }},
    { 124, 0, 0, 2, { 0 }},
    { 125, 0, 1, 4, { 0 }},
    { 126, 0, 3, 6, { 0 }},
    { 161, 0, 1, 2, { 0 }},
    { 162, 0, 2, 5, { 0 }},
    { 163, 0, 1, 5, { 0 }},
    { 8364, 0, 1, 7, { 0 }},
    { 165, 0, 1, 6, { 0 }},
    { 352, 0, -1, 5, { 0 }},
    { 167, 0, 0, 5, { 0 }},
    { 353, 0, 0, 5, { 0 }},
    { 169, 0, 1, 7, { 0 }},
    { 170, 0, -1, 4, { 0 }},
    { 171, 0, 3, 5, { 0 }},
    { 172, 0, 4, 5, { 0 }},
    { 174, 0, 1, 7, { 0 }},
    { 175, 0, -1, 5, { 0 }},
    { 176, 0, -1, 4, { 0 }},
    { 177, 0, 1, 6, { 0 }},
    { 178, 0, -1, 4, { 0 }},
    { 179, 0, -1, 4, { 0 }},
    { 381, 0, 1, 7, { 0 }},
    { 181, 0, 1, 5, { 0 }},
    { 182, 0, 1, 6, { 0 }},
    { 183, 0, 4, 2, { 0 }},
    { 382, 0, 1, 7, { 0 }},
    { 185, 0, -1, 3, { 0 }},
    { 186, 0, -1, 4, { 0 }},
    { 187, 0, 3, 5, { 0 }},
    { 338, 0, 1, 6, { 0 }},
    { 339, 0, 3, 6, { 0 }},
    { 376, 0, -1, 5, { 0 }},
    { 191, 0, 1, 5, { 0 }},
    { 192, 0, -1, 5, { 0 }},
    { 193, 0, -1, 5, { 0 }},
    { 194, 0, -1, 5, { 0 }},
    { 195, 0, -1, 5, { 0 }},
    { 196, 0, -1, 5, { 0 }},
    { 197, 0, -1, 5, { 0 }},
    { 198, 0, 1, 6, { 0 }},
    { 199, 0, 1, 5, { 0 }},
    { 200, 0, -1, 5, { 0 }},
    { 201, 0, -1, 5, { 0 }},
    { 202, 0, -1, 5, { 0 }},
    { 203, 0, -1, 5, { 0 }},
    { 204, 0, -1, 4, { 0 }},
    { 205, 0, -1, 4, { 0 }},
    { 206, 0, -1, 4, { 0 }},
    { 207, 0, -1, 4, { 0 }},
    { 208, 0, 1, 6, { 0 }},
    { 209, 0, -1, 5, { 0 }},
    { 210, 0, -1, 5, { 0 }},
    { 211, 0, -1, 5, { 0 }},
    { 212, 0, -1, 5, { 0 }},
    { 213, 0, -1, 5, { 0 }},
    { 214, 0, -1, 5, { 0 }},
    { 215, 0, 3, 4, { 0 }},
    { 216, 0, 0, 5, { 0 }},
    { 217, 0, -1, 5, { 0 }},
    { 218, 0, -1, 5, { 0 }},
    { 219, 0, -1, 5, { 0 }},
    { 220, 0, -1, 5, { 0 }},
    { 221, 0, -1, 5, { 0 }},
    { 222, 0, 1, 5, { 0 }},
    { 223, 0, 1, 5, { 0 }},
    { 224, 0, 0, 5, { 0 }},
    { 225, 0, 0, 5, { 0 }},
    { 226, 0, 0, 5, { 0 }},
    { 227, 0, 0, 5, { 0 }},
    { 228, 0, 1, 5, { 0 }},
    { 229, 0, -1, 5, { 0 }},
    { 230, 0, 3, 6, { 0 }},
    { 231, 0, 3, 5, { 0 }},
    { 232, 0, 0, 5, { 0 }},
    { 233, 0, 0, 5, { 0 }},
    { 234, 0, 0, 5, { 0 }},
    { 235, 0, 1, 5, { 0 }},
    { 236, 0, 0, 3, { 0 }},
    { 237, 0, 0, 2, { 0 }},
    { 238, 0, 0, 3, { 0 }},
    { 239, 0, 1, 3, { 0 }},
    { 240, 0, 0, 5, { 0 }},
    { 241, 0, 0, 5, { 0 }},
    { 242, 0, 0, 5, { 0 }},
    { 243, 0, 0, 5, { 0 }},
    { 244, 0, 0, 5, { 0 }},
    { 245, 0, 0, 5, { 0 }},
    { 246, 0, 1, 5, { 0 }},
    { 247, 0, 2, 4, { 0 }},
    { 248, 0, 2, 5, { 0 }},
    { 249, 0, 0, 5, { 0 }},
    { 250, 0, 0, 5, { 0 }},
    { 251, 0, 0, 5, { 0 }},
    { 252, 0, 1, 5, { 0 }},
    { 253, 0, 0, 5, { 0 }},
    { 254, 0, 0, 5, { 0 }},
    { 255, 0, 1, 5, { 0 }},
};

// Style loading function: Bluish
static void GuiLoadStyleBluish(void)
{
    // Load style properties provided
    // NOTE: Default properties are propagated
    for (int i = 0; i < BLUISH_STYLE_PROPS_COUNT; i++)
    {
        GuiSetStyle(bluishStyleProps[i].controlId, bluishStyleProps[i].propertyId, bluishStyleProps[i].propertyValue);
    }

    // Custom font loading
    // NOTE: Compressed font image data (DEFLATE), it requires DecompressData() function
    int bluishFontDataSize = 0;
    unsigned char *data = DecompressData(bluishFontData, BLUISH_STYLE_FONT_ATLAS_COMP_SIZE, &bluishFontDataSize);
    Image imFont = { data, 256, 256, 1, 2 };

    Font font = { 0 };
    font.baseSize = 10;
    font.glyphCount = 189;

    // Load texture from image
    font.texture = LoadTextureFromImage(imFont);
    UnloadImage(imFont);  // Uncompressed image data can be unloaded from memory

    // Copy char recs data from global fontRecs
    // NOTE: Required to avoid issues if trying to free font
    font.recs = (Rectangle *)RAYGUI_MALLOC(font.glyphCount*sizeof(Rectangle));
    memcpy(font.recs, bluishFontRecs, font.glyphCount*sizeof(Rectangle));

    // Copy font char info data from global fontChars
    // NOTE: Required to avoid issues if trying to free font
    font.glyphs = (GlyphInfo *)RAYGUI_MALLOC(font.glyphCount*sizeof(GlyphInfo));
    memcpy(font.glyphs, bluishFontGlyphs, font.glyphCount*sizeof(GlyphInfo));

    GuiSetFont(font);

    // Setup a white rectangle on the font to be used on shapes drawing,
    // it makes possible to draw shapes and text (full UI) in a single draw call
    Rectangle fontWhiteRec = { 254, 254, 1, 1 };
    SetShapesTexture(font.texture, fontWhiteRec);

    //-----------------------------------------------------------------

    // TODO: Custom user style setup: Set specific properties here (if required)
    // i.e. Controls specific BORDER_WIDTH, TEXT_PADDING, TEXT_ALIGNMENT
}
