//////////////////////////////////////////////////////////////////////////////////
//                                                                              //
// StyleAsCode exporter v2.0 - Style data exported as a values array            //
//                                                                              //
// USAGE: On init call: GuiLoadStyleTerminal();                                   //
//                                                                              //
// more info and bugs-report:  github.com/raysan5/raygui                        //
// feedback and support:       ray[at]raylibtech.com                            //
//                                                                              //
// Copyright (c) 2020-2024 raylib technologies (@raylibtech)                    //
//                                                                              //
//////////////////////////////////////////////////////////////////////////////////

#define TERMINAL_STYLE_PROPS_COUNT  17

// Custom style name: Terminal
static const GuiStyleProp terminalStyleProps[TERMINAL_STYLE_PROPS_COUNT] = {
    { 0, 0, 0x1c8d00ff },    // DEFAULT_BORDER_COLOR_NORMAL 
    { 0, 1, 0x161313ff },    // DEFAULT_BASE_COLOR_NORMAL 
    { 0, 2, 0x38f620ff },    // DEFAULT_TEXT_COLOR_NORMAL 
    { 0, 3, 0xc3fbc6ff },    // DEFAULT_BORDER_COLOR_FOCUSED 
    { 0, 4, 0x43bf2eff },    // DEFAULT_BASE_COLOR_FOCUSED 
    { 0, 5, 0xdcfadcff },    // DEFAULT_TEXT_COLOR_FOCUSED 
    { 0, 6, 0x1f5b19ff },    // DEFAULT_BORDER_COLOR_PRESSED 
    { 0, 7, 0x43ff28ff },    // DEFAULT_BASE_COLOR_PRESSED 
    { 0, 8, 0x1e6f15ff },    // DEFAULT_TEXT_COLOR_PRESSED 
    { 0, 9, 0x223b22ff },    // DEFAULT_BORDER_COLOR_DISABLED 
    { 0, 10, 0x182c18ff },    // DEFAULT_BASE_COLOR_DISABLED 
    { 0, 11, 0x244125ff },    // DEFAULT_TEXT_COLOR_DISABLED 
    { 0, 16, 0x00000010 },    // DEFAULT_TEXT_SIZE 
    { 0, 17, 0x00000000 },    // DEFAULT_TEXT_SPACING 
    { 0, 18, 0xe6fce3ff },    // DEFAULT_LINE_COLOR 
    { 0, 19, 0x0c1505ff },    // DEFAULT_BACKGROUND_COLOR 
    { 0, 20, 0x00000018 },    // DEFAULT_TEXT_LINE_SPACING 
};

// WARNING: This style uses a custom font: "Mecha.ttf" (size: 16, spacing: 0)

#define TERMINAL_STYLE_FONT_ATLAS_COMP_SIZE 1860

// Font atlas image pixels data: DEFLATE compressed
static unsigned char terminalFontData[TERMINAL_STYLE_FONT_ATLAS_COMP_SIZE] = { 0xed,
    0xdd, 0x41, 0x92, 0xa4, 0x36, 0x10, 0x05, 0x50, 0xee, 0x7f, 0xe9, 0xf4, 0x62, 0x62, 0x16, 0x76, 0xb8, 0x1b, 0x94, 0x4a,
    0x89, 0x04, 0x9e, 0x5f, 0x78, 0xd3, 0xd5, 0x53, 0x4d, 0x01, 0xbf, 0x24, 0x84, 0x94, 0xc4, 0x01, 0x00, 0x00, 0x00, 0x7c,
    0x5e, 0xfc, 0xef, 0x4f, 0xe2, 0xc7, 0xdf, 0x8c, 0xcb, 0xef, 0xf3, 0xe7, 0xa7, 0xf1, 0xe3, 0x5f, 0xf9, 0xfb, 0xdf, 0x95,
    0x77, 0xba, 0xfe, 0x5b, 0x31, 0xb4, 0x75, 0x73, 0x5b, 0x95, 0x7b, 0x9f, 0xd1, 0xdf, 0xfe, 0x7d, 0x7b, 0xaa, 0xde, 0xad,
    0xf6, 0x95, 0xb1, 0xb3, 0x23, 0xbf, 0xe7, 0xae, 0x6e, 0x61, 0x6c, 0xdf, 0x2b, 0xc7, 0xa6, 0x7d, 0x1c, 0x0d, 0xf2, 0x7f,
    0x7e, 0xcc, 0x46, 0xf2, 0x14, 0xe9, 0xf4, 0x8e, 0x7f, 0x3b, 0xad, 0xfc, 0x0e, 0x1d, 0xdd, 0xc6, 0xdc, 0x3e, 0x89, 0x92,
    0xf7, 0x9f, 0xf9, 0x3b, 0x51, 0xb6, 0xd7, 0x72, 0xff, 0x26, 0x86, 0xdb, 0x88, 0xf9, 0x4f, 0x78, 0xbe, 0x8f, 0x63, 0xd1,
    0x71, 0xef, 0x99, 0xff, 0xfc, 0x51, 0xcb, 0x9f, 0x29, 0x57, 0xb7, 0x3c, 0xd7, 0xa6, 0xaf, 0x3a, 0x27, 0xe5, 0xff, 0xec,
    0x9b, 0xfa, 0xe7, 0x16, 0xb4, 0xa2, 0xdd, 0x90, 0xff, 0x5c, 0x06, 0x62, 0x22, 0x47, 0xbb, 0xf2, 0x5f, 0xdb, 0xd6, 0xc8,
    0xff, 0x33, 0xda, 0xff, 0xb3, 0x6d, 0xff, 0xf7, 0x79, 0x2b, 0xff, 0xd9, 0xa3, 0x90, 0x6d, 0xff, 0x63, 0x7a, 0xfb, 0x3b,
    0xe7, 0x7f, 0x74, 0xdc, 0x43, 0xfe, 0xcf, 0xaf, 0xe8, 0x73, 0xbf, 0x7d, 0xb6, 0x27, 0xe4, 0x7f, 0x5d, 0xfe, 0x7f, 0xeb,
    0xb3, 0x9d, 0xf5, 0xf4, 0x76, 0xe4, 0xff, 0xd8, 0x9e, 0xff, 0xb3, 0xeb, 0xa8, 0xeb, 0xfb, 0x62, 0xc7, 0x08, 0xd4, 0x91,
    0x1c, 0xdb, 0x89, 0xc1, 0x0c, 0xdf, 0xd3, 0x0b, 0x3b, 0xcb, 0x7f, 0x66, 0x4f, 0x66, 0xf2, 0x7f, 0x76, 0x5c, 0x8e, 0x5f,
    0x7a, 0x30, 0xab, 0xf6, 0x7e, 0x45, 0xfe, 0x67, 0x46, 0xe4, 0x9e, 0x9d, 0xff, 0x38, 0xd9, 0x57, 0x31, 0x31, 0xbe, 0xb9,
    0xb3, 0xcf, 0x30, 0xd3, 0x4f, 0xeb, 0x7b, 0x1c, 0xde, 0xd3, 0xff, 0x8f, 0xd6, 0xed, 0xbf, 0xfc, 0xcf, 0x5d, 0xff, 0xbf,
    0x2d, 0xff, 0xb1, 0xfd, 0x58, 0xc5, 0x85, 0x33, 0x56, 0xfe, 0xe7, 0xf6, 0xf0, 0x79, 0x8f, 0x23, 0x16, 0x5d, 0xbf, 0x74,
    0xcd, 0x7f, 0xee, 0xd3, 0x7d, 0xb1, 0xfd, 0x8f, 0x1b, 0x8f, 0x8f, 0xfc, 0xaf, 0xd8, 0x9b, 0x23, 0x77, 0xd8, 0x66, 0xe7,
    0x2f, 0xc8, 0xbf, 0xfc, 0xcb, 0x7f, 0xef, 0xfe, 0x7f, 0x0c, 0x8e, 0xdc, 0xc6, 0xe3, 0xc7, 0xff, 0xe2, 0x52, 0x6f, 0x69,
    0x7e, 0xb6, 0xe0, 0x78, 0x9f, 0x2b, 0xf7, 0x6e, 0xf9, 0xd9, 0x75, 0x4f, 0xb9, 0xfe, 0xdf, 0x39, 0x93, 0xf2, 0x28, 0x99,
    0x87, 0xb2, 0x7e, 0xfe, 0xdf, 0x33, 0xe7, 0x28, 0x77, 0xcf, 0x3f, 0xb0, 0x7a, 0x95, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x65, 0x0d, 0x4d, 0x94, 0xad, 0x7b, 0x8c, 0x16, 0x95, 0xe7, 0xf7, 0xd4, 0x58,
    0xbf, 0xb6, 0x87, 0xaa, 0xde, 0x71, 0xec, 0x59, 0x02, 0x63, 0xeb, 0x30, 0x73, 0x2b, 0xff, 0x56, 0xaf, 0x6e, 0x9b, 0x59,
    0xdd, 0x58, 0xb3, 0x65, 0x15, 0xb5, 0x2d, 0xee, 0x49, 0xc7, 0xca, 0x75, 0xe2, 0x71, 0x69, 0x75, 0x70, 0x6d, 0x92, 0x56,
    0xaf, 0xd8, 0xce, 0xac, 0x7d, 0xdf, 0x99, 0xff, 0xb1, 0x33, 0x70, 0xfc, 0x73, 0x46, 0x62, 0x35, 0x55, 0x6d, 0x0d, 0x98,
    0x63, 0xe9, 0xb9, 0x19, 0x8b, 0xd6, 0x90, 0x8d, 0xef, 0x83, 0x3d, 0xe9, 0x90, 0xff, 0x2f, 0xe7, 0x3f, 0x57, 0x23, 0x7b,
    0xc7, 0xb3, 0x50, 0xe4, 0x5f, 0xfe, 0xe5, 0xff, 0xad, 0xf9, 0x8f, 0xe2, 0xfe, 0x77, 0xbe, 0x5a, 0x47, 0xcd, 0x95, 0x55,
    0x6d, 0x4a, 0xe4, 0x5f, 0xfe, 0x7f, 0xef, 0x6d, 0xc7, 0xc5, 0x56, 0x6c, 0xa4, 0xc5, 0xdb, 0x59, 0xb3, 0x64, 0x5f, 0x15,
    0xad, 0xd1, 0x6f, 0x93, 0x28, 0x4c, 0xf0, 0x57, 0xf2, 0x9f, 0xaf, 0x7b, 0xbe, 0x67, 0xdc, 0x2b, 0xb3, 0xe5, 0x99, 0xda,
    0x57, 0xf5, 0xf9, 0x3f, 0x7b, 0x1e, 0x42, 0xe6, 0xfb, 0xe9, 0x5b, 0xf9, 0x1f, 0xfd, 0x6c, 0xf2, 0x7f, 0x6c, 0x7e, 0xb6,
    0xcc, 0xfd, 0x35, 0x16, 0x23, 0xd9, 0xd2, 0x57, 0x6d, 0x75, 0xa4, 0x46, 0xdb, 0xaa, 0x7e, 0x9e, 0xab, 0xd2, 0xf8, 0xde,
    0xfc, 0x47, 0xc1, 0x7d, 0xae, 0xb9, 0x56, 0x52, 0xfe, 0xe5, 0xff, 0x98, 0xac, 0xc0, 0xdb, 0x3d, 0xff, 0x2b, 0xae, 0xbf,
    0x2b, 0x9f, 0xe6, 0xfa, 0xcc, 0xf6, 0xff, 0x59, 0xf7, 0xff, 0xbe, 0x92, 0xff, 0xb3, 0x63, 0x79, 0x77, 0xfe, 0x3b, 0xd5,
    0x4c, 0xcd, 0x8c, 0x30, 0xce, 0xfc, 0x9b, 0x8e, 0xf9, 0xdf, 0x35, 0x9f, 0x47, 0xfe, 0x77, 0xe5, 0xff, 0xe7, 0xa7, 0x8d,
    0xcb, 0x7f, 0xaf, 0xfc, 0xaf, 0xeb, 0xff, 0x3f, 0x3b, 0xff, 0xeb, 0x7a, 0x5f, 0xab, 0xfb, 0x73, 0xb5, 0x5b, 0x9e, 0x99,
    0x01, 0xf7, 0xdb, 0xfc, 0xbb, 0x48, 0x57, 0x6d, 0xaf, 0x98, 0x87, 0x37, 0x33, 0x3b, 0x68, 0xf7, 0x95, 0x41, 0xf5, 0xbf,
    0xa9, 0x1f, 0xb3, 0xe8, 0x9b, 0x7f, 0x78, 0x46, 0xfe, 0xbf, 0xb0, 0xaf, 0x71, 0x3c, 0xee, 0x69, 0x59, 0x57, 0xfe, 0x3e,
    0xce, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 0xd3, 0x2a, 0xac, 0xaa, 0xba, 0x8d, 0x3b,
    0xab, 0x65, 0xe4, 0xd6, 0xf9, 0xc5, 0xe5, 0xba, 0x2e, 0x99, 0x55, 0xe4, 0x23, 0x6b, 0xf9, 0x6a, 0xd6, 0x34, 0xe6, 0xcf,
    0x81, 0x48, 0xad, 0x96, 0x3b, 0x3f, 0x53, 0x32, 0x35, 0xec, 0xd7, 0xcd, 0xb6, 0xff, 0xbd, 0x7e, 0x43, 0xbe, 0x92, 0xc8,
    0xaa, 0xf5, 0x05, 0x75, 0xf5, 0x9f, 0x8e, 0x82, 0xd5, 0x8a, 0xd9, 0x35, 0xf4, 0xf7, 0xe6, 0x7f, 0x74, 0xf5, 0xdb, 0xf5,
    0x9f, 0x55, 0xd4, 0x5b, 0x89, 0xc4, 0xca, 0xbc, 0xca, 0xfc, 0x57, 0x9c, 0xe3, 0x51, 0xf6, 0xbe, 0xb1, 0xb8, 0x4e, 0xc1,
    0x95, 0x56, 0xe2, 0xd9, 0x6b, 0xa2, 0xe2, 0xd5, 0xf9, 0xaf, 0xad, 0x96, 0x5b, 0xff, 0x9d, 0x90, 0xaf, 0x4f, 0x70, 0x5f,
    0xfe, 0xff, 0x6e, 0x57, 0x75, 0xfe, 0x33, 0xef, 0x5b, 0x53, 0xd9, 0x6a, 0x2e, 0xff, 0x3d, 0x56, 0xf6, 0xc5, 0xf2, 0x9e,
    0x47, 0x26, 0xff, 0x63, 0xfd, 0xb6, 0x15, 0xf9, 0xcf, 0x57, 0xe6, 0x39, 0x36, 0x65, 0xfd, 0x28, 0x4e, 0xf9, 0xfa, 0xfc,
    0xd7, 0x9f, 0x69, 0xf1, 0x9f, 0xff, 0xbb, 0xac, 0xb6, 0x7d, 0x4b, 0xfe, 0x73, 0xd5, 0x69, 0x66, 0xf3, 0x9f, 0xbd, 0xe2,
    0xbd, 0xbb, 0xfd, 0x5f, 0x73, 0x4d, 0xb0, 0x3e, 0xff, 0x91, 0xaa, 0x0c, 0xde, 0x27, 0xff, 0xb1, 0x20, 0xb9, 0xf2, 0x9f,
    0x6d, 0x03, 0xdf, 0x90, 0xff, 0xea, 0xe7, 0x7c, 0x74, 0xc8, 0x7f, 0x6e, 0xc4, 0x2b, 0x4a, 0x73, 0x1a, 0xed, 0xdb, 0xff,
    0x63, 0xdb, 0xf8, 0x5f, 0xff, 0xfc, 0x47, 0x49, 0xbf, 0xf0, 0xce, 0xfc, 0xd7, 0x57, 0xcb, 0xcd, 0x56, 0x0d, 0xbc, 0x3e,
    0xd6, 0xd7, 0xa7, 0xfd, 0xaf, 0xbf, 0x1e, 0x5e, 0xd1, 0xfe, 0x1f, 0x0b, 0xee, 0x52, 0xac, 0xbf, 0xaa, 0xee, 0x9f, 0xff,
    0xaa, 0xeb, 0xc2, 0xcc, 0x73, 0x93, 0x46, 0xef, 0xff, 0xc5, 0xe9, 0x59, 0x3c, 0x7a, 0xe7, 0x68, 0x3c, 0x4f, 0x31, 0xf8,
    0xf4, 0xa2, 0xfe, 0xd7, 0xff, 0x95, 0xed, 0xff, 0x9a, 0x51, 0xef, 0xae, 0xa3, 0xe9, 0xd7, 0x9e, 0x2f, 0xde, 0x63, 0x8b,
    0xf3, 0x4f, 0xdc, 0x8a, 0xed, 0x57, 0x56, 0x7d, 0x8e, 0xf1, 0xfc, 0x67, 0x5f, 0x93, 0xff, 0x8a, 0x8a, 0xd3, 0xf5, 0xed,
    0xe1, 0xf7, 0xe6, 0xbc, 0xcc, 0xdc, 0x75, 0xef, 0xb1, 0xb5, 0xd5, 0xe7, 0xc5, 0x3b, 0xf2, 0x5f, 0xf7, 0xd9, 0x63, 0xc9,
    0xb7, 0x4a, 0xa6, 0x96, 0x77, 0x2c, 0x9f, 0x0f, 0x23, 0xff, 0xcf, 0xcd, 0x7f, 0xdc, 0x70, 0xcf, 0xf0, 0x58, 0x3c, 0x1e,
    0xdd, 0x61, 0x0f, 0xef, 0xcd, 0x3f, 0xfd, 0xce, 0x88, 0xee, 0xf9, 0x5f, 0x3f, 0x2f, 0xf4, 0xcb, 0xed, 0x81, 0x2a, 0xf9,
    0x3c, 0xf1, 0x5a, 0x56, 0xfe, 0x73, 0xfd, 0x96, 0xd9, 0xf9, 0xff, 0x20, 0xff, 0xdf, 0xdd, 0xeb, 0xd0, 0x7f, 0x76, 0x03,
    0xf2, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xfb, 0x67, 0xbb, 0x45, 0x6a, 0x7d, 0x5b, 0x0c, 0x56,
    0x32, 0x88, 0x74, 0xa5, 0xf8, 0x6c, 0x7d, 0x8c, 0x18, 0x5c, 0xf7, 0x35, 0x5f, 0x37, 0xf8, 0xfa, 0xf3, 0x15, 0x66, 0xd6,
    0x0f, 0xae, 0x3f, 0x8e, 0x75, 0x15, 0xd6, 0xeb, 0x8f, 0x52, 0xe6, 0xef, 0x47, 0x79, 0xed, 0xb5, 0xfe, 0x99, 0x99, 0xdf,
    0xcf, 0x99, 0x95, 0xbe, 0xb5, 0x67, 0xd4, 0xb5, 0x63, 0x5b, 0xb7, 0xba, 0x33, 0x26, 0x92, 0x3e, 0x3e, 0x4f, 0xfb, 0xf7,
    0xaa, 0x9f, 0x5d, 0x8f, 0x63, 0x2e, 0x4b, 0x51, 0xba, 0x06, 0x37, 0xf7, 0xd7, 0x9f, 0xb6, 0xaf, 0xaf, 0x57, 0x01, 0xd8,
    0xdd, 0x5f, 0xc8, 0x3f, 0x35, 0x28, 0x6e, 0x9f, 0x8b, 0xbf, 0xae, 0xa2, 0x4e, 0x5d, 0xad, 0xe2, 0xbb, 0x8f, 0xe3, 0x71,
    0xfa, 0x0c, 0x93, 0x68, 0xb8, 0xbe, 0xe5, 0xac, 0xff, 0x18, 0x2d, 0xf7, 0x75, 0x5c, 0xee, 0x23, 0xe6, 0xf3, 0x9f, 0x7f,
    0x3e, 0x53, 0x14, 0x57, 0xe6, 0xcd, 0x57, 0xc7, 0xac, 0xde, 0xfa, 0x7c, 0xfb, 0x9f, 0xb9, 0x52, 0x88, 0xe5, 0x9f, 0xaa,
    0xf6, 0x3b, 0x39, 0x4e, 0x6a, 0xb9, 0xae, 0x3e, 0x2b, 0x56, 0xbc, 0x12, 0x1b, 0xce, 0xad, 0xdc, 0xf5, 0xde, 0xb5, 0x33,
    0x64, 0x26, 0xff, 0x7d, 0x8f, 0xcd, 0xd1, 0xe6, 0x95, 0xdd, 0xf9, 0x7f, 0xee, 0x2b, 0xef, 0xc9, 0x7f, 0x9f, 0xb3, 0xef,
    0xb7, 0xcf, 0x33, 0xfb, 0xac, 0xc2, 0x0e, 0x47, 0xe0, 0xac, 0x4e, 0xec, 0x5b, 0xf3, 0x1f, 0x3f, 0x8e, 0x0c, 0xf6, 0xff,
    0x4e, 0xfe, 0xb9, 0x5f, 0xf0, 0xb4, 0xfc, 0x57, 0xb6, 0xcb, 0x15, 0x6d, 0xf9, 0xde, 0x6b, 0x66, 0xed, 0xbf, 0xf6, 0xff,
    0xdb, 0xf9, 0xbf, 0xff, 0x2a, 0x6c, 0x6f, 0x66, 0xfa, 0xed, 0xb3, 0x3e, 0xf9, 0x1f, 0x19, 0xf3, 0x92, 0xff, 0xb7, 0xe7,
    0xff, 0x09, 0xdf, 0x4d, 0xb3, 0xf7, 0xff, 0xde, 0x31, 0xfe, 0x57, 0xf5, 0x8a, 0xf6, 0x7f, 0x6e, 0x8c, 0xfd, 0xee, 0x6d,
    0xcb, 0x1f, 0xf3, 0xb7, 0x1c, 0x85, 0xd1, 0x3e, 0x80, 0xfe, 0xbf, 0xfc, 0xbf, 0x27, 0xff, 0x47, 0x7a, 0xf6, 0xc1, 0xb3,
    0xae, 0x33, 0x46, 0x8e, 0xc7, 0x73, 0xf2, 0x5f, 0x79, 0xc7, 0xee, 0x29, 0xe3, 0x7f, 0x4f, 0xfb, 0x66, 0x78, 0x63, 0xfe,
    0xef, 0xbd, 0xd7, 0xda, 0x63, 0xe6, 0xef, 0x33, 0xfb, 0x32, 0x4f, 0xce, 0xff, 0xb3, 0xfb, 0x64, 0xc7, 0x6d, 0x57, 0x85,
    0x51, 0xb8, 0xa7, 0x79, 0x46, 0xfe, 0x63, 0x53, 0xfe, 0x47, 0xc6, 0x06, 0xde, 0x9d, 0xff, 0xf1, 0xd6, 0x2a, 0x6e, 0x1f,
    0x63, 0x96, 0xff, 0xbb, 0xf3, 0xbf, 0x7f, 0xeb, 0x77, 0xf5, 0xc4, 0x62, 0x49, 0xd2, 0xc7, 0x8f, 0xc9, 0x13, 0xfb, 0xa4,
    0x3b, 0xb7, 0x4d, 0xfe, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xef, 0xcc, 0x00, 0x1e, 0x7b, 0xb5,
    0x43, 0x05, 0xfd, 0x23, 0x5d, 0x6d, 0xbd, 0xee, 0xf3, 0x1e, 0x89, 0xaa, 0xee, 0x99, 0x6d, 0xe8, 0x5c, 0x41, 0xdf, 0xac,
    0xdb, 0xb7, 0x7e, 0x03, 0xf4, 0xae, 0xa0, 0x7f, 0x5e, 0xe5, 0x63, 0xfd, 0xe7, 0xad, 0x9c, 0x3f, 0xdf, 0xbb, 0x82, 0x7e,
    0xbf, 0xb5, 0xab, 0xf4, 0xfb, 0x26, 0xd9, 0x59, 0x41, 0x7f, 0xbc, 0xbf, 0x71, 0x6c, 0xdc, 0xae, 0x6c, 0x35, 0x83, 0xae,
    0x15, 0xf4, 0xbb, 0xaf, 0x05, 0xe3, 0xfe, 0xb5, 0x59, 0x63, 0xcf, 0xb4, 0xa8, 0xaa, 0xa0, 0xf1, 0xb4, 0x0a, 0xfa, 0x67,
    0x19, 0x7b, 0x52, 0x9d, 0x6c, 0xf9, 0xb7, 0xfe, 0xf7, 0xbe, 0xfc, 0xf7, 0xad, 0x93, 0x91, 0xad, 0x52, 0xd3, 0xbb, 0x82,
    0xa6, 0xfc, 0xcb, 0xbf, 0xfc, 0xaf, 0xaa, 0x91, 0x20, 0xff, 0x3c, 0x3d, 0xff, 0x3b, 0x2b, 0xe8, 0xa8, 0xa0, 0xb9, 0xbb,
    0x22, 0xd0, 0x21, 0xff, 0xae, 0xff, 0x1f, 0xf1, 0x04, 0x3d, 0xf9, 0x5f, 0xf3, 0x8a, 0xfc, 0x7f, 0xfd, 0xde, 0x9f, 0x0a,
    0xda, 0x2b, 0xf3, 0x1f, 0x4d, 0xc7, 0xff, 0xf6, 0xdf, 0xf1, 0xe1, 0x89, 0xf9, 0xd7, 0xff, 0xcf, 0xe7, 0xe2, 0xfe, 0x0a,
    0x9a, 0xf9, 0x34, 0xcb, 0xbf, 0xfe, 0x7f, 0xc5, 0xfc, 0x9f, 0x9a, 0xb6, 0x47, 0x05, 0xcd, 0xb9, 0x6d, 0x93, 0x7f, 0xd0,
    0x2b, 0xd4, 0xff, 0x07, 0xbd, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf6, 0xf9, 0xf3, 0x9f, 0xfd, 0x00, 0xf2, 0x0f, 0x7c, 0x2e, 0xff, 0xff, 0x00 };

// Font glyphs rectangles data (on atlas)
static const Rectangle terminalFontRecs[189] = {
    { 4, 4, 4 , 16 },
    { 16, 4, 1 , 11 },
    { 25, 4, 3 , 3 },
    { 36, 4, 6 , 11 },
    { 50, 4, 5 , 11 },
    { 63, 4, 5 , 11 },
    { 76, 4, 5 , 11 },
    { 89, 4, 1 , 2 },
    { 98, 4, 2 , 13 },
    { 108, 4, 2 , 13 },
    { 118, 4, 3 , 3 },
    { 129, 4, 5 , 5 },
    { 142, 4, 1 , 3 },
    { 151, 4, 5 , 1 },
    { 164, 4, 1 , 1 },
    { 173, 4, 6 , 12 },
    { 187, 4, 5 , 11 },
    { 200, 4, 2 , 11 },
    { 210, 4, 5 , 11 },
    { 223, 4, 5 , 11 },
    { 236, 4, 5 , 11 },
    { 249, 4, 5 , 11 },
    { 262, 4, 5 , 11 },
    { 275, 4, 5 , 11 },
    { 288, 4, 5 , 11 },
    { 301, 4, 5 , 11 },
    { 314, 4, 1 , 8 },
    { 323, 4, 1 , 10 },
    { 332, 4, 4 , 5 },
    { 344, 4, 5 , 3 },
    { 357, 4, 4 , 5 },
    { 369, 4, 5 , 11 },
    { 382, 4, 11 , 11 },
    { 401, 4, 5 , 11 },
    { 414, 4, 5 , 11 },
    { 427, 4, 5 , 11 },
    { 440, 4, 5 , 11 },
    { 453, 4, 5 , 11 },
    { 466, 4, 5 , 11 },
    { 479, 4, 5 , 11 },
    { 492, 4, 5 , 11 },
    { 4, 28, 1 , 11 },
    { 13, 28, 5 , 11 },
    { 26, 28, 5 , 11 },
    { 39, 28, 5 , 11 },
    { 52, 28, 7 , 11 },
    { 67, 28, 5 , 11 },
    { 80, 28, 5 , 11 },
    { 93, 28, 5 , 11 },
    { 106, 28, 5 , 13 },
    { 119, 28, 5 , 11 },
    { 132, 28, 5 , 11 },
    { 145, 28, 5 , 11 },
    { 158, 28, 5 , 11 },
    { 171, 28, 5 , 11 },
    { 184, 28, 7 , 11 },
    { 199, 28, 5 , 11 },
    { 212, 28, 5 , 11 },
    { 225, 28, 5 , 11 },
    { 238, 28, 2 , 13 },
    { 248, 28, 6 , 12 },
    { 262, 28, 2 , 13 },
    { 272, 28, 5 , 4 },
    { 285, 28, 5 , 1 },
    { 298, 28, 2 , 2 },
    { 308, 28, 5 , 8 },
    { 321, 28, 5 , 11 },
    { 334, 28, 5 , 8 },
    { 347, 28, 5 , 11 },
    { 360, 28, 5 , 8 },
    { 373, 28, 4 , 11 },
    { 385, 28, 5 , 10 },
    { 398, 28, 5 , 11 },
    { 411, 28, 1 , 11 },
    { 420, 28, 1 , 13 },
    { 429, 28, 5 , 11 },
    { 442, 28, 1 , 11 },
    { 451, 28, 7 , 8 },
    { 466, 28, 5 , 8 },
    { 479, 28, 5 , 8 },
    { 492, 28, 5 , 10 },
    { 4, 52, 5 , 10 },
    { 17, 52, 4 , 8 },
    { 29, 52, 5 , 8 },
    { 42, 52, 3 , 11 },
    { 53, 52, 5 , 8 },
    { 66, 52, 5 , 8 },
    { 79, 52, 7 , 8 },
    { 94, 52, 5 , 8 },
    { 107, 52, 5 , 10 },
    { 120, 52, 5 , 8 },
    { 133, 52, 3 , 13 },
    { 144, 52, 1 , 15 },
    { 153, 52, 3 , 13 },
    { 164, 52, 5 , 3 },
    { 177, 52, 1 , 11 },
    { 186, 52, 5 , 11 },
    { 199, 52, 5 , 10 },
    { 212, 52, 5 , 10 },
    { 225, 52, 5 , 10 },
    { 238, 52, 0 , 0 },
    { 246, 52, 0 , 0 },
    { 254, 52, 0 , 0 },
    { 262, 52, 7 , 8 },
    { 277, 52, 0 , 0 },
    { 285, 52, 0 , 0 },
    { 293, 52, 5 , 3 },
    { 306, 52, 7 , 8 },
    { 321, 52, 5 , 1 },
    { 334, 52, 3 , 3 },
    { 345, 52, 5 , 7 },
    { 358, 52, 0 , 0 },
    { 366, 52, 0 , 0 },
    { 374, 52, 0 , 0 },
    { 382, 52, 5 , 10 },
    { 395, 52, 7 , 11 },
    { 410, 52, 1 , 1 },
    { 419, 52, 0 , 0 },
    { 427, 52, 0 , 0 },
    { 435, 52, 0 , 0 },
    { 443, 52, 0 , 0 },
    { 451, 52, 0 , 0 },
    { 459, 52, 0 , 0 },
    { 467, 52, 5 , 13 },
    { 480, 52, 5 , 11 },
    { 493, 52, 5 , 14 },
    { 4, 76, 5 , 14 },
    { 17, 76, 5 , 14 },
    { 30, 76, 5 , 14 },
    { 43, 76, 5 , 13 },
    { 56, 76, 5 , 13 },
    { 69, 76, 9 , 11 },
    { 86, 76, 5 , 13 },
    { 99, 76, 5 , 14 },
    { 112, 76, 5 , 14 },
    { 125, 76, 5 , 14 },
    { 138, 76, 5 , 13 },
    { 151, 76, 2 , 14 },
    { 161, 76, 2 , 14 },
    { 171, 76, 3 , 14 },
    { 182, 76, 3 , 13 },
    { 193, 76, 5 , 11 },
    { 206, 76, 5 , 14 },
    { 219, 76, 5 , 14 },
    { 232, 76, 5 , 14 },
    { 245, 76, 5 , 14 },
    { 258, 76, 5 , 14 },
    { 271, 76, 5 , 13 },
    { 284, 76, 5 , 5 },
    { 297, 76, 5 , 13 },
    { 310, 76, 5 , 14 },
    { 323, 76, 5 , 14 },
    { 336, 76, 5 , 14 },
    { 349, 76, 5 , 13 },
    { 362, 76, 5 , 14 },
    { 375, 76, 5 , 11 },
    { 388, 76, 5 , 11 },
    { 401, 76, 5 , 11 },
    { 414, 76, 5 , 11 },
    { 427, 76, 5 , 11 },
    { 440, 76, 5 , 11 },
    { 453, 76, 5 , 10 },
    { 466, 76, 5 , 10 },
    { 479, 76, 9 , 8 },
    { 496, 76, 5 , 10 },
    { 4, 100, 5 , 11 },
    { 17, 100, 5 , 11 },
    { 30, 100, 5 , 11 },
    { 43, 100, 5 , 10 },
    { 56, 100, 2 , 11 },
    { 66, 100, 2 , 11 },
    { 76, 100, 3 , 11 },
    { 87, 100, 3 , 10 },
    { 98, 100, 5 , 11 },
    { 111, 100, 5 , 11 },
    { 124, 100, 5 , 11 },
    { 137, 100, 5 , 11 },
    { 150, 100, 5 , 11 },
    { 163, 100, 5 , 11 },
    { 176, 100, 5 , 10 },
    { 189, 100, 5 , 5 },
    { 202, 100, 5 , 10 },
    { 215, 100, 5 , 11 },
    { 228, 100, 5 , 11 },
    { 241, 100, 5 , 11 },
    { 254, 100, 5 , 10 },
    { 267, 100, 5 , 13 },
    { 280, 100, 4 , 8 },
    { 292, 100, 5 , 12 },
};

// Font glyphs info data
// NOTE: No glyphs.image data provided
static const GlyphInfo terminalFontGlyphs[189] = {
    { 32, 0, 14, 4, { 0 }},
    { 33, 1, 3, 3, { 0 }},
    { 34, 1, 3, 5, { 0 }},
    { 35, 1, 3, 8, { 0 }},
    { 36, 1, 3, 7, { 0 }},
    { 37, 1, 3, 7, { 0 }},
    { 38, 1, 3, 7, { 0 }},
    { 39, 1, 3, 3, { 0 }},
    { 40, 1, 2, 4, { 0 }},
    { 41, 1, 2, 4, { 0 }},
    { 42, 1, 3, 5, { 0 }},
    { 43, 1, 7, 7, { 0 }},
    { 44, 1, 13, 3, { 0 }},
    { 45, 1, 9, 7, { 0 }},
    { 46, 1, 13, 3, { 0 }},
    { 47, 1, 2, 8, { 0 }},
    { 48, 1, 3, 7, { 0 }},
    { 49, 1, 3, 4, { 0 }},
    { 50, 1, 3, 7, { 0 }},
    { 51, 1, 3, 7, { 0 }},
    { 52, 1, 3, 7, { 0 }},
    { 53, 1, 3, 7, { 0 }},
    { 54, 1, 3, 7, { 0 }},
    { 55, 1, 3, 7, { 0 }},
    { 56, 1, 3, 7, { 0 }},
    { 57, 1, 3, 7, { 0 }},
    { 58, 1, 6, 3, { 0 }},
    { 59, 1, 6, 3, { 0 }},
    { 60, 1, 7, 6, { 0 }},
    { 61, 1, 8, 7, { 0 }},
    { 62, 1, 7, 6, { 0 }},
    { 63, 1, 3, 7, { 0 }},
    { 64, 2, 3, 15, { 0 }},
    { 65, 1, 3, 7, { 0 }},
    { 66, 1, 3, 7, { 0 }},
    { 67, 1, 3, 7, { 0 }},
    { 68, 1, 3, 7, { 0 }},
    { 69, 1, 3, 7, { 0 }},
    { 70, 1, 3, 7, { 0 }},
    { 71, 1, 3, 7, { 0 }},
    { 72, 1, 3, 7, { 0 }},
    { 73, 1, 3, 3, { 0 }},
    { 74, 1, 3, 7, { 0 }},
    { 75, 1, 3, 7, { 0 }},
    { 76, 1, 3, 7, { 0 }},
    { 77, 1, 3, 9, { 0 }},
    { 78, 1, 3, 7, { 0 }},
    { 79, 1, 3, 7, { 0 }},
    { 80, 1, 3, 7, { 0 }},
    { 81, 1, 3, 7, { 0 }},
    { 82, 1, 3, 7, { 0 }},
    { 83, 1, 3, 7, { 0 }},
    { 84, 1, 3, 7, { 0 }},
    { 85, 1, 3, 7, { 0 }},
    { 86, 1, 3, 7, { 0 }},
    { 87, 1, 3, 9, { 0 }},
    { 88, 1, 3, 7, { 0 }},
    { 89, 1, 3, 7, { 0 }},
    { 90, 1, 3, 7, { 0 }},
    { 91, 1, 2, 4, { 0 }},
    { 92, 1, 2, 8, { 0 }},
    { 93, 1, 2, 4, { 0 }},
    { 94, 1, 3, 7, { 0 }},
    { 95, 1, 15, 7, { 0 }},
    { 96, 1, 0, 4, { 0 }},
    { 97, 1, 6, 7, { 0 }},
    { 98, 1, 3, 7, { 0 }},
    { 99, 1, 6, 7, { 0 }},
    { 100, 1, 3, 7, { 0 }},
    { 101, 1, 6, 7, { 0 }},
    { 102, 1, 3, 6, { 0 }},
    { 103, 1, 6, 7, { 0 }},
    { 104, 1, 3, 7, { 0 }},
    { 105, 1, 3, 3, { 0 }},
    { 106, 1, 3, 3, { 0 }},
    { 107, 1, 3, 7, { 0 }},
    { 108, 1, 3, 3, { 0 }},
    { 109, 1, 6, 9, { 0 }},
    { 110, 1, 6, 7, { 0 }},
    { 111, 1, 6, 7, { 0 }},
    { 112, 1, 6, 7, { 0 }},
    { 113, 1, 6, 7, { 0 }},
    { 114, 1, 6, 6, { 0 }},
    { 115, 1, 6, 7, { 0 }},
    { 116, 1, 3, 5, { 0 }},
    { 117, 1, 6, 7, { 0 }},
    { 118, 1, 6, 7, { 0 }},
    { 119, 1, 6, 9, { 0 }},
    { 120, 1, 6, 7, { 0 }},
    { 121, 1, 6, 7, { 0 }},
    { 122, 1, 6, 7, { 0 }},
    { 123, 1, 2, 5, { 0 }},
    { 124, 1, 1, 3, { 0 }},
    { 125, 1, 2, 5, { 0 }},
    { 126, 1, 8, 7, { 0 }},
    { 161, 1, 3, 3, { 0 }},
    { 162, 1, 3, 7, { 0 }},
    { 163, 1, 3, 7, { 0 }},
    { 8364, 1, 3, 7, { 0 }},
    { 165, 1, 3, 7, { 0 }},
    { 352, 0, 14, 4, { 0 }},
    { 167, 0, 14, 4, { 0 }},
    { 353, 0, 14, 4, { 0 }},
    { 169, 1, 3, 9, { 0 }},
    { 170, 0, 14, 4, { 0 }},
    { 171, 0, 14, 4, { 0 }},
    { 172, 1, 8, 7, { 0 }},
    { 174, 1, 3, 9, { 0 }},
    { 175, 1, 1, 7, { 0 }},
    { 176, 1, 0, 5, { 0 }},
    { 177, 1, 7, 7, { 0 }},
    { 178, 0, 14, 4, { 0 }},
    { 179, 0, 14, 4, { 0 }},
    { 381, 0, 14, 4, { 0 }},
    { 181, 1, 6, 7, { 0 }},
    { 182, 1, 3, 9, { 0 }},
    { 183, 1, 8, 3, { 0 }},
    { 382, 0, 14, 4, { 0 }},
    { 185, 0, 14, 4, { 0 }},
    { 186, 0, 14, 4, { 0 }},
    { 187, 0, 14, 4, { 0 }},
    { 338, 0, 14, 4, { 0 }},
    { 339, 0, 14, 4, { 0 }},
    { 376, 1, 1, 7, { 0 }},
    { 191, 1, 3, 7, { 0 }},
    { 192, 1, 0, 7, { 0 }},
    { 193, 1, 0, 7, { 0 }},
    { 194, 1, 0, 7, { 0 }},
    { 195, 1, 0, 7, { 0 }},
    { 196, 1, 1, 7, { 0 }},
    { 197, 1, 1, 7, { 0 }},
    { 198, 1, 3, 11, { 0 }},
    { 199, 1, 3, 7, { 0 }},
    { 200, 1, 0, 7, { 0 }},
    { 201, 1, 0, 7, { 0 }},
    { 202, 1, 0, 7, { 0 }},
    { 203, 1, 1, 7, { 0 }},
    { 204, 0, 0, 3, { 0 }},
    { 205, 1, 0, 3, { 0 }},
    { 206, 0, 0, 3, { 0 }},
    { 207, 0, 1, 3, { 0 }},
    { 208, 1, 3, 7, { 0 }},
    { 209, 1, 0, 7, { 0 }},
    { 210, 1, 0, 7, { 0 }},
    { 211, 1, 0, 7, { 0 }},
    { 212, 1, 0, 7, { 0 }},
    { 213, 1, 0, 7, { 0 }},
    { 214, 1, 1, 7, { 0 }},
    { 215, 1, 7, 7, { 0 }},
    { 216, 1, 2, 7, { 0 }},
    { 217, 1, 0, 7, { 0 }},
    { 218, 1, 0, 7, { 0 }},
    { 219, 1, 0, 7, { 0 }},
    { 220, 1, 1, 7, { 0 }},
    { 221, 1, 0, 7, { 0 }},
    { 222, 1, 3, 7, { 0 }},
    { 223, 1, 3, 7, { 0 }},
    { 224, 1, 3, 7, { 0 }},
    { 225, 1, 3, 7, { 0 }},
    { 226, 1, 3, 7, { 0 }},
    { 227, 1, 3, 7, { 0 }},
    { 228, 1, 4, 7, { 0 }},
    { 229, 1, 4, 7, { 0 }},
    { 230, 1, 6, 11, { 0 }},
    { 231, 1, 6, 7, { 0 }},
    { 232, 1, 3, 7, { 0 }},
    { 233, 1, 3, 7, { 0 }},
    { 234, 1, 3, 7, { 0 }},
    { 235, 1, 4, 7, { 0 }},
    { 236, 0, 3, 3, { 0 }},
    { 237, 1, 3, 3, { 0 }},
    { 238, 0, 3, 3, { 0 }},
    { 239, 0, 4, 3, { 0 }},
    { 240, 1, 3, 7, { 0 }},
    { 241, 1, 3, 7, { 0 }},
    { 242, 1, 3, 7, { 0 }},
    { 243, 1, 3, 7, { 0 }},
    { 244, 1, 3, 7, { 0 }},
    { 245, 1, 3, 7, { 0 }},
    { 246, 1, 4, 7, { 0 }},
    { 247, 1, 7, 7, { 0 }},
    { 248, 1, 5, 7, { 0 }},
    { 249, 1, 3, 7, { 0 }},
    { 250, 1, 3, 7, { 0 }},
    { 251, 1, 3, 7, { 0 }},
    { 252, 1, 4, 7, { 0 }},
    { 253, 1, 3, 7, { 0 }},
    { 254, 1, 6, 6, { 0 }},
    { 255, 1, 4, 7, { 0 }},
};

// Style loading function: Terminal
static void GuiLoadStyleTerminal(void)
{
    // Load style properties provided
    // NOTE: Default properties are propagated
    for (int i = 0; i < TERMINAL_STYLE_PROPS_COUNT; i++)
    {
        GuiSetStyle(terminalStyleProps[i].controlId, terminalStyleProps[i].propertyId, terminalStyleProps[i].propertyValue);
    }

    // Custom font loading
    // NOTE: Compressed font image data (DEFLATE), it requires DecompressData() function
    int terminalFontDataSize = 0;
    unsigned char *data = DecompressData(terminalFontData, TERMINAL_STYLE_FONT_ATLAS_COMP_SIZE, &terminalFontDataSize);
    Image imFont = { data, 512, 256, 1, 2 };

    Font font = { 0 };
    font.baseSize = 16;
    font.glyphCount = 189;

    // Load texture from image
    font.texture = LoadTextureFromImage(imFont);
    UnloadImage(imFont);  // Uncompressed image data can be unloaded from memory

    // Copy char recs data from global fontRecs
    // NOTE: Required to avoid issues if trying to free font
    font.recs = (Rectangle *)RAYGUI_MALLOC(font.glyphCount*sizeof(Rectangle));
    memcpy(font.recs, terminalFontRecs, font.glyphCount*sizeof(Rectangle));

    // Copy font char info data from global fontChars
    // NOTE: Required to avoid issues if trying to free font
    font.glyphs = (GlyphInfo *)RAYGUI_MALLOC(font.glyphCount*sizeof(GlyphInfo));
    memcpy(font.glyphs, terminalFontGlyphs, font.glyphCount*sizeof(GlyphInfo));

    GuiSetFont(font);

    // Setup a white rectangle on the font to be used on shapes drawing,
    // it makes possible to draw shapes and text (full UI) in a single draw call
    Rectangle fontWhiteRec = { 510, 254, 1, 1 };
    SetShapesTexture(font.texture, fontWhiteRec);

    //-----------------------------------------------------------------

    // TODO: Custom user style setup: Set specific properties here (if required)
    // i.e. Controls specific BORDER_WIDTH, TEXT_PADDING, TEXT_ALIGNMENT
}
