//////////////////////////////////////////////////////////////////////////////////
//                                                                              //
// StyleAsCode exporter v2.0 - Style data exported as a values array            //
//                                                                              //
// USAGE: On init call: GuiLoadStyleAshes();                                   //
//                                                                              //
// more info and bugs-report:  github.com/raysan5/raygui                        //
// feedback and support:       ray[at]raylibtech.com                            //
//                                                                              //
// Copyright (c) 2020-2025 raylib technologies (@raylibtech)                    //
//                                                                              //
//////////////////////////////////////////////////////////////////////////////////

#define ASHES_STYLE_PROPS_COUNT  16

// Custom style name: Ashes
static const GuiStyleProp ashesStyleProps[ASHES_STYLE_PROPS_COUNT] = {
    { 0, 0, (int)0xf0f0f0ff },    // DEFAULT_BORDER_COLOR_NORMAL 
    { 0, 1, (int)0x868686ff },    // DEFAULT_BASE_COLOR_NORMAL 
    { 0, 2, (int)0xe6e6e6ff },    // DEFAULT_TEXT_COLOR_NORMAL 
    { 0, 3, (int)0x929999ff },    // DEFAULT_BORDER_COLOR_FOCUSED 
    { 0, 4, (int)0xeaeaeaff },    // DEFAULT_BASE_COLOR_FOCUSED 
    { 0, 5, (int)0x98a1a8ff },    // DEFAULT_TEXT_COLOR_FOCUSED 
    { 0, 6, (int)0x3f3f3fff },    // DEFAULT_BORDER_COLOR_PRESSED 
    { 0, 7, (int)0xf6f6f6ff },    // DEFAULT_BASE_COLOR_PRESSED 
    { 0, 8, (int)0x414141ff },    // DEFAULT_TEXT_COLOR_PRESSED 
    { 0, 9, (int)0x8b8b8bff },    // DEFAULT_BORDER_COLOR_DISABLED 
    { 0, 10, (int)0x777777ff },    // DEFAULT_BASE_COLOR_DISABLED 
    { 0, 11, (int)0x959595ff },    // DEFAULT_TEXT_COLOR_DISABLED 
    { 0, 16, (int)0x00000010 },    // DEFAULT_TEXT_SIZE 
    { 0, 18, (int)0x9dadb1ff },    // DEFAULT_LINE_COLOR 
    { 0, 19, (int)0x6b6b6bff },    // DEFAULT_BACKGROUND_COLOR 
    { 0, 20, (int)0x00000018 },    // DEFAULT_TEXT_LINE_SPACING 
};

// WARNING: This style uses a custom font: "v5loxical.ttf" (size: 16, spacing: 1)

#define ASHES_STYLE_FONT_ATLAS_COMP_SIZE 1800

// Font atlas image pixels data: DEFLATE compressed
static unsigned char ashesFontData[ASHES_STYLE_FONT_ATLAS_COMP_SIZE] = { 0xed,
    0x9d, 0x51, 0xb6, 0xa4, 0x36, 0x0c, 0x44, 0xbd, 0xff, 0x4d, 0x57, 0xbe, 0x72, 0x32, 0xc9, 0x49, 0x83, 0x25, 0x97, 0xb0,
    0x0c, 0x77, 0xee, 0x5f, 0xbf, 0x1e, 0x1a, 0x5c, 0xc8, 0x06, 0xbb, 0x24, 0x6b, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x07, 0xfd,
    0xef, 0x27, 0xfa, 0xf9, 0x4d, 0x4d, 0x1f, 0xe7, 0xdf, 0x9f, 0xeb, 0xc7, 0x5f, 0x63, 0xc7, 0xd3, 0xf4, 0xef, 0x66, 0xfe,
    0xa2, 0xff, 0x3d, 0x3f, 0x2d, 0xff, 0xaa, 0xa6, 0xaf, 0xe6, 0xea, 0xbb, 0x57, 0xbf, 0xa9, 0xa6, 0xfa, 0xeb, 0xe2, 0x78,
    0xd7, 0x47, 0xd4, 0xc2, 0x3d, 0x31, 0xf7, 0xbb, 0xf3, 0x9a, 0xae, 0xb7, 0xe7, 0xaf, 0x7b, 0x6b, 0xfe, 0xbb, 0xf7, 0x6d,
    0x5c, 0xab, 0xff, 0x9f, 0xff, 0xc6, 0x8f, 0xbf, 0xe6, 0x34, 0xae, 0x89, 0xf4, 0xeb, 0x33, 0x95, 0x49, 0xed, 0xf9, 0xbb,
    0x56, 0x4b, 0xfd, 0x50, 0xe6, 0xe8, 0xf9, 0x33, 0x1e, 0x41, 0xb5, 0x74, 0x73, 0x17, 0x2a, 0x7c, 0xc4, 0xd5, 0xfe, 0x3c,
    0x13, 0xff, 0x5d, 0xf4, 0xcf, 0xdd, 0xcd, 0x6a, 0xa0, 0x7f, 0x46, 0x39, 0x19, 0xce, 0x54, 0xa6, 0xf1, 0xbf, 0x42, 0xfd,
    0xa8, 0xfe, 0x32, 0xb6, 0x80, 0x53, 0xff, 0x6c, 0xff, 0x9f, 0xe9, 0xff, 0x46, 0x13, 0x3d, 0x9f, 0xd7, 0x5f, 0x8f, 0xb7,
    0x80, 0x23, 0xfe, 0xc7, 0x6d, 0x6f, 0xab, 0x9b, 0xa7, 0x1a, 0xbd, 0x40, 0x7f, 0xc7, 0xfd, 0x9f, 0x1d, 0x29, 0xfb, 0x8e,
    0xff, 0x9a, 0xe8, 0xeb, 0xf4, 0x8a, 0xf8, 0x8f, 0x8f, 0x72, 0xf3, 0xef, 0x9b, 0x77, 0x23, 0xa5, 0xb6, 0x5f, 0x7b, 0xee,
    0x09, 0xe4, 0xef, 0xff, 0x77, 0x7e, 0xfc, 0x77, 0x19, 0x83, 0x76, 0x9d, 0xb7, 0xb6, 0xc6, 0x17, 0xfa, 0x7f, 0xe1, 0xfa,
    0x45, 0xcb, 0x73, 0x97, 0xa1, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xca, 0x59,
    0x10, 0x77, 0x22, 0x68, 0xd9, 0xe3, 0xe6, 0xf1, 0xdf, 0x2b, 0xdc, 0x02, 0x19, 0xdf, 0xfd, 0xaf, 0xf3, 0x8a, 0x7d, 0x7f,
    0x84, 0x3d, 0x75, 0x4a, 0xae, 0x83, 0x29, 0xed, 0xea, 0x5a, 0x77, 0xa8, 0x57, 0xac, 0x20, 0xe7, 0xbd, 0x76, 0x11, 0x8f,
    0xae, 0x4c, 0x3e, 0x2d, 0x99, 0x73, 0x54, 0xdc, 0xfa, 0x8f, 0xed, 0xfa, 0xab, 0xd4, 0x0f, 0xa2, 0x1b, 0xbf, 0xd9, 0x17,
    0xf4, 0xcf, 0x3a, 0x77, 0x23, 0xfd, 0xbc, 0xec, 0xde, 0xc9, 0xf8, 0xf9, 0xdd, 0xe7, 0x03, 0x7c, 0x51, 0xff, 0x11, 0x8e,
    0xdb, 0x78, 0x0f, 0x3b, 0x3b, 0x52, 0x6b, 0x63, 0xfc, 0x5f, 0x8d, 0xdb, 0x0a, 0x44, 0x4d, 0x54, 0x9d, 0xd8, 0xef, 0xfe,
    0x73, 0xae, 0xeb, 0x4f, 0x44, 0x4f, 0xe9, 0x3f, 0x16, 0x7d, 0x9c, 0xb2, 0xf5, 0x18, 0xd9, 0x71, 0xae, 0x5f, 0xfc, 0xbb,
    0x9f, 0xff, 0xea, 0xf4, 0x97, 0xc1, 0x8d, 0xa5, 0x52, 0x2f, 0x68, 0x26, 0x47, 0xe5, 0x3d, 0xfa, 0x67, 0xde, 0x70, 0x3c,
    0xc7, 0x39, 0xc1, 0x87, 0xfa, 0x05, 0xfd, 0x01, 0xfd, 0xf1, 0xa1, 0x67, 0x9e, 0xdb, 0xea, 0xe6, 0x7f, 0x14, 0xee, 0xaf,
    0xd1, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0xeb, 0xdb, 0xd9, 0x2a,
    0xe0, 0x8e, 0xef, 0x67, 0x7f, 0x41, 0x36, 0xc7, 0xa7, 0xcf, 0x3f, 0xfa, 0x7b, 0xfd, 0xd8, 0x91, 0xeb, 0x50, 0xa7, 0xff,
    0xb0, 0xbb, 0x68, 0xe3, 0x9e, 0xb4, 0x78, 0x7d, 0xfc, 0xd1, 0x4c, 0xff, 0x11, 0x68, 0x77, 0x15, 0xe6, 0x4c, 0xa0, 0x7f,
    0x7f, 0xfd, 0x7d, 0x95, 0x2f, 0xdf, 0xae, 0xff, 0x38, 0x4a, 0xff, 0xb5, 0x1d, 0x01, 0x5c, 0xfa, 0xe7, 0xfd, 0xed, 0xae,
    0x51, 0x70, 0x3d, 0xc7, 0x60, 0xa4, 0x77, 0x12, 0x72, 0xe9, 0x3f, 0x12, 0x79, 0x7f, 0x0e, 0x6f, 0xfc, 0x1b, 0xe2, 0x7f,
    0x18, 0xe2, 0x7f, 0x34, 0xed, 0xff, 0x87, 0xc9, 0x0f, 0x8a, 0xfe, 0xdf, 0xd6, 0xdf, 0x53, 0xfb, 0xf8, 0xbd, 0xfa, 0x77,
    0x7d, 0xfe, 0x43, 0xff, 0x13, 0xf5, 0x97, 0xed, 0xca, 0x7d, 0xfa, 0xaf, 0x66, 0x4d, 0x7a, 0x9e, 0xb4, 0x94, 0x7e, 0x6e,
    0x57, 0x38, 0x57, 0x2b, 0x9e, 0x7d, 0xea, 0xc8, 0x14, 0xbc, 0xab, 0x10, 0x11, 0x9b, 0x4d, 0x8a, 0x56, 0xd7, 0xa8, 0xd3,
    0xff, 0xcc, 0x8a, 0x25, 0xcc, 0xd0, 0x56, 0x64, 0xbb, 0xc0, 0x3b, 0xee, 0xf9, 0x2f, 0x46, 0x08, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0xad, 0x84, 0xc7, 0x56, 0x23, 0x5d, 0x6b, 0xb9, 0xc3, 0xb2, 0xbb, 0x80,
    0x0c, 0xeb, 0xeb, 0x6b, 0xff, 0x5f, 0x7f, 0xac, 0x0c, 0xbb, 0x72, 0x1c, 0x1c, 0x9f, 0xcf, 0x3a, 0x1b, 0x32, 0xeb, 0x8b,
    0x55, 0x8e, 0x06, 0x25, 0x7c, 0xd1, 0x15, 0xeb, 0xe2, 0x0a, 0xaf, 0xc1, 0xef, 0xf2, 0x44, 0x2b, 0x78, 0x45, 0xb2, 0xac,
    0x51, 0x3a, 0x9c, 0xc4, 0x5a, 0x76, 0x0a, 0xc7, 0x7d, 0xc2, 0x2a, 0xb8, 0x0f, 0xcf, 0xd0, 0xdf, 0x3b, 0x86, 0x54, 0x45,
    0xae, 0x37, 0xfe, 0xb5, 0xa0, 0x7f, 0x74, 0x37, 0x1b, 0xf4, 0xf7, 0xe8, 0x1f, 0x7b, 0x12, 0xa9, 0xd3, 0x9f, 0xf8, 0xdf,
    0x17, 0xff, 0xab, 0x1e, 0x3e, 0xf4, 0xff, 0x86, 0xfe, 0x32, 0xd5, 0xe1, 0x46, 0xff, 0x75, 0x8f, 0x5a, 0xcc, 0x01, 0xeb,
    0x72, 0x0a, 0xf7, 0x89, 0xff, 0x61, 0xf3, 0x44, 0xfb, 0x2a, 0x88, 0x77, 0xe8, 0x17, 0x1c, 0xdf, 0xee, 0x3d, 0xfe, 0x3f,
    0xe9, 0x00, 0xee, 0xec, 0xf7, 0xac, 0xf4, 0xae, 0x76, 0xd1, 0xbf, 0x5e, 0x81, 0x73, 0xf5, 0x3f, 0x37, 0x47, 0xa0, 0x53,
    0xab, 0xa2, 0x7f, 0xff, 0xac, 0x0b, 0xa0, 0x07, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe8,
    0x3c, 0xd3, 0x9d, 0xf3, 0x4f, 0xc8, 0xe4, 0x82, 0x88, 0xfa, 0x00, 0xc7, 0x74, 0x8d, 0x7c, 0xa5, 0x9c, 0xc7, 0xab, 0xbe,
    0x93, 0xbb, 0x56, 0x96, 0x71, 0x45, 0x42, 0x97, 0xad, 0x54, 0xeb, 0xcf, 0xda, 0x55, 0x1f, 0x3d, 0x53, 0xe3, 0x71, 0x25,
    0x0b, 0xc2, 0xed, 0x3b, 0x90, 0xcd, 0x19, 0xa3, 0xe0, 0xfa, 0xa5, 0xcb, 0x87, 0x9f, 0xd3, 0x3f, 0xee, 0x1a, 0xab, 0xfb,
    0xd4, 0x91, 0x8b, 0x94, 0xcd, 0x1b, 0x91, 0x6d, 0x2d, 0x5a, 0x97, 0xf9, 0x4f, 0xbb, 0xfa, 0xff, 0xea, 0xfa, 0xf8, 0x4f,
    0xea, 0x1f, 0xf7, 0x00, 0x5d, 0x8f, 0x5a, 0x6b, 0x3a, 0x5d, 0x1d, 0x4f, 0xcb, 0x57, 0xd9, 0x4f, 0x7f, 0x5f, 0x8d, 0x6f,
    0x6f, 0xcb, 0xdc, 0xab, 0xbc, 0x16, 0xd9, 0x91, 0xfe, 0x5f, 0xe1, 0xfe, 0xdf, 0x93, 0x59, 0x51, 0xef, 0x82, 0x7e, 0x7e,
    0x7f, 0x04, 0x19, 0x7a, 0xf9, 0xbb, 0x2c, 0x58, 0xa1, 0x7f, 0x59, 0x1e, 0x48, 0x07, 0xfd, 0xaf, 0x9f, 0xc7, 0x65, 0x75,
    0x24, 0xd5, 0x8e, 0xff, 0xf9, 0x7a, 0xda, 0xae, 0x3a, 0xe3, 0x8e, 0x7d, 0x53, 0x6a, 0xfa, 0xff, 0xda, 0xf8, 0x1f, 0x45,
    0xcf, 0xff, 0x9d, 0xbd, 0x8f, 0x2e, 0x27, 0xf8, 0xb3, 0xcf, 0x7f, 0x9e, 0xf7, 0x99, 0x7c, 0x66, 0x44, 0xec, 0xfd, 0xbf,
    0xb3, 0x03, 0xb2, 0xa7, 0xfe, 0xf1, 0x3d, 0x25, 0x73, 0xfd, 0xe6, 0xb7, 0x1d, 0xa9, 0xeb, 0x7b, 0x58, 0x56, 0xf6, 0x6d,
    0x78, 0x83, 0x4f, 0xbd, 0x63, 0xde, 0x97, 0x19, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x10, 0xf3, 0xc8, 0xac, 0xae, 0x38, 0x2b, 0x51, 0x01, 0xdc, 0xb7, 0x6e, 0x73, 0xe7, 0x2f, 0xd1, 0x42, 0x2d, 0xb7, 0x4c,
    0x1d, 0xe8, 0x2b, 0x77, 0x8c, 0x82, 0xde, 0x19, 0xdf, 0xba, 0x94, 0x16, 0xd5, 0xcf, 0xfa, 0xaa, 0x64, 0x73, 0xd1, 0x64,
    0xdc, 0x6d, 0x0a, 0xd6, 0x88, 0x9f, 0xcb, 0x36, 0xf1, 0xf9, 0x42, 0xee, 0xbd, 0xf3, 0x75, 0xeb, 0xa6, 0x0a, 0xc6, 0x81,
    0x42, 0x8e, 0xb3, 0xdf, 0x6d, 0xb5, 0x1e, 0x95, 0xeb, 0xfa, 0xe7, 0xe3, 0x5f, 0xb6, 0xba, 0xf6, 0x59, 0xfd, 0x73, 0x11,
    0xb2, 0x1e, 0xff, 0x4a, 0x65, 0xd0, 0x54, 0x79, 0x76, 0x56, 0xf5, 0x1f, 0x66, 0xfd, 0x9f, 0x8b, 0x7f, 0x6d, 0x18, 0xff,
    0xff, 0x1c, 0xa1, 0x64, 0xfb, 0xdd, 0x35, 0x9f, 0xe4, 0x1e, 0xfd, 0xb3, 0xde, 0x3f, 0xdd, 0xb8, 0x63, 0xf5, 0xa8, 0xb7,
    0x25, 0xdb, 0x83, 0xa8, 0xa1, 0x2f, 0xe6, 0x2e, 0xef, 0xac, 0x87, 0xc3, 0x71, 0xfd, 0x09, 0x7c, 0xa5, 0x87, 0x5c, 0xbd,
    0x6b, 0x9c, 0xfa, 0xbb, 0xbc, 0xab, 0xb3, 0xb1, 0x87, 0xfe, 0xde, 0xf7, 0xc7, 0x7e, 0xf1, 0x7f, 0xed, 0xbb, 0xed, 0xad,
    0x7f, 0xec, 0xfd, 0x4f, 0x9b, 0x5b, 0xb9, 0xa3, 0x3f, 0x59, 0xa9, 0x27, 0xd0, 0x3e, 0xfa, 0xef, 0x3a, 0xd6, 0xdb, 0xe7,
    0xb6, 0xba, 0xe8, 0x7f, 0x37, 0xff, 0x73, 0x5a, 0xc6, 0xc6, 0x49, 0xfa, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x71, 0x8d, 0x74, 0x76, 0x95, 0x51, 0x41, 0x27, 0xf1, 0x75, 0xa5, 0xb4, 0xeb, 0x7c,
    0x82, 0xaa, 0xab, 0x58, 0xdd, 0x1f, 0x3e, 0x5a, 0x1b, 0x55, 0x41, 0xb7, 0xa3, 0x4b, 0xab, 0xbc, 0x13, 0x53, 0x26, 0xef,
    0xab, 0xaf, 0xf2, 0xbf, 0xfb, 0x2a, 0x66, 0x75, 0x55, 0xc0, 0xd5, 0xee, 0x69, 0x4b, 0xd7, 0x55, 0xf6, 0xf1, 0x66, 0x0d,
    0xa3, 0xfe, 0xa7, 0xf6, 0xbc, 0xfb, 0x3d, 0x48, 0x6a, 0xf4, 0x79, 0x56, 0xff, 0xf8, 0x78, 0xb1, 0x3a, 0xbe, 0xac, 0xef,
    0x38, 0xa2, 0xcb, 0x2c, 0x98, 0xca, 0xb6, 0xf7, 0xf7, 0xcf, 0xbe, 0xcf, 0x65, 0xcb, 0x19, 0x74, 0xd6, 0x05, 0xf7, 0xeb,
    0xbf, 0xaf, 0x8d, 0x7b, 0xeb, 0xbf, 0x53, 0x67, 0xf4, 0x47, 0xff, 0xaf, 0xe9, 0x1f, 0xab, 0xb4, 0x5f, 0xff, 0x79, 0x4e,
    0xb7, 0xda, 0xd1, 0x9f, 0xf8, 0x27, 0xfe, 0xd1, 0xff, 0xc9, 0xcf, 0x63, 0x11, 0x7a, 0xaa, 0xfe, 0x2a, 0x9d, 0x33, 0x39,
    0x51, 0x7f, 0x5f, 0xde, 0x6d, 0x7f, 0xfd, 0x77, 0x69, 0x72, 0xb6, 0xfe, 0xe3, 0x35, 0xf1, 0x8f, 0xfe, 0xbe, 0x7a, 0x05,
    0xe7, 0xcd, 0xff, 0xe4, 0xb3, 0xd6, 0x9d, 0xf3, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0,
    0x5e, 0xff, 0xbf, 0xc2, 0xf3, 0xf6, 0x19, 0x27, 0x7a, 0xa5, 0x3f, 0x7f, 0x7e, 0x96, 0x5d, 0xa9, 0x19, 0xfa, 0xbd, 0x79,
    0x10, 0xb3, 0xd7, 0x91, 0x5d, 0x4d, 0x89, 0xd7, 0xac, 0x8e, 0xfa, 0x70, 0xea, 0xfd, 0xf9, 0x91, 0xbd, 0x0a, 0x1c, 0xfb,
    0x0e, 0x54, 0xe7, 0x41, 0x64, 0xf2, 0x51, 0x9e, 0xf2, 0x92, 0x5f, 0x57, 0x54, 0xed, 0xbc, 0xe2, 0x94, 0xe9, 0x3f, 0xb4,
    0xd1, 0x7f, 0x1f, 0xd5, 0x3f, 0xb7, 0x03, 0x80, 0xc2, 0x3d, 0xa5, 0xc2, 0xeb, 0x96, 0x3d, 0x56, 0x93, 0xcf, 0xa9, 0x91,
    0xaa, 0x54, 0xfc, 0xfb, 0x22, 0x22, 0x33, 0xfe, 0x9f, 0xa1, 0xbf, 0x8e, 0xca, 0x83, 0x89, 0xfa, 0xdd, 0x54, 0xac, 0x7f,
    0xd6, 0xb7, 0x70, 0x46, 0xfc, 0xf7, 0xf1, 0x9d, 0xe6, 0x47, 0x2a, 0xa1, 0xff, 0xad, 0xbe, 0xda, 0xe2, 0x20, 0x8a, 0x3b,
    0x5a, 0xd1, 0x3f, 0xf2, 0x16, 0xb5, 0xa2, 0x7f, 0x3f, 0x1f, 0x5c, 0xf6, 0xfd, 0xef, 0x9b, 0xfa, 0xaf, 0xc6, 0xff, 0x69,
    0x3e, 0xc8, 0xd8, 0x5e, 0x8b, 0x4f, 0xe9, 0xaf, 0x03, 0xf4, 0x57, 0xab, 0x11, 0xca, 0xe9, 0x83, 0xd5, 0x03, 0xcf, 0xff,
    0xf1, 0x99, 0xc4, 0x8e, 0xf1, 0x7f, 0xbe, 0xfe, 0x4f, 0xec, 0x90, 0xe8, 0xd9, 0xcf, 0xed, 0x0c, 0xfd, 0xbb, 0xbd, 0xff,
    0x79, 0xe7, 0x92, 0x9c, 0xf3, 0x3f, 0x67, 0x55, 0x99, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xf8, 0x72, 0x0e, 0xc0, 0xaa, 0x03, 0x5f, 0xcb, 0x2b, 0x55, 0x0a, 0x38, 0xf8, 0xd5, 0xc8, 0xbf, 0x3f, 0x26, 0x6b, 0x2c,
    0x57, 0x9c, 0xad, 0xa7, 0x5a, 0x7a, 0x55, 0x85, 0xfc, 0x61, 0xa9, 0x92, 0x1f, 0x73, 0x1f, 0x3f, 0xed, 0xdf, 0x5f, 0x5b,
    0x11, 0xdf, 0x9d, 0x0f, 0x51, 0xe1, 0x25, 0x7e, 0x3e, 0x1f, 0x61, 0xa7, 0x7f, 0xff, 0xae, 0x5a, 0xb9, 0x36, 0x65, 0x1b,
    0xb0, 0x1a, 0xda, 0x3d, 0xdb, 0xa4, 0x53, 0xfe, 0x9f, 0x67, 0xa5, 0x7d, 0x35, 0x4f, 0x49, 0x8b, 0x3d, 0xea, 0x2e, 0x87,
    0x81, 0x8e, 0xf5, 0x43, 0x7b, 0x8f, 0xfc, 0x8c, 0xfe, 0xe7, 0xf8, 0xb4, 0xd0, 0x1f, 0xfd, 0xd1, 0xff, 0xcb, 0xfa, 0xeb,
    0x00, 0xfd, 0x3d, 0xfb, 0x36, 0xa0, 0x7f, 0x27, 0x3f, 0x74, 0x34, 0xfe, 0x87, 0x25, 0xc3, 0x1c, 0xfd, 0xbb, 0xf8, 0xa1,
    0xd1, 0xbf, 0x4f, 0x9e, 0x46, 0x6f, 0xfd, 0xcf, 0x7b, 0xff, 0x1b, 0xc5, 0xb5, 0xd1, 0xdf, 0xe3, 0x87, 0x67, 0x0e, 0x88,
    0xf9, 0x27, 0x40, 0x7f, 0xf8, 0xa2, 0xf6, 0xa8, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa7, 0x7a, 0x16,
    0x01, 0xfd, 0x01, 0x00, 0x80, 0xfe, 0x1f, 0xd0, 0x1f, 0xd0, 0x1f, 0xd0, 0x1f, 0xd0, 0x1f, 0xd0, 0x1f, 0xd0, 0x1f, 0xb2,
    0x15, 0x0d, 0x68, 0x07, 0x7a, 0x01, 0x40, 0x7f, 0xc0, 0x39, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xbb, 0x01, 0xfd, 0x61, 0xab, 0xfe, 0x7f, 0x01 };

// Font glyphs rectangles data (on atlas)
static const Rectangle ashesFontRecs[189] = {
    { 4, 4, 4 , 16 },
    { 16, 4, 1 , 10 },
    { 25, 4, 3 , 3 },
    { 36, 4, 6 , 8 },
    { 50, 4, 5 , 11 },
    { 63, 4, 7 , 8 },
    { 78, 4, 6 , 9 },
    { 92, 4, 1 , 3 },
    { 101, 4, 3 , 12 },
    { 112, 4, 3 , 12 },
    { 123, 4, 5 , 5 },
    { 136, 4, 5 , 5 },
    { 149, 4, 2 , 2 },
    { 159, 4, 4 , 1 },
    { 171, 4, 1 , 1 },
    { 180, 4, 5 , 10 },
    { 193, 4, 4 , 8 },
    { 205, 4, 2 , 8 },
    { 215, 4, 4 , 8 },
    { 227, 4, 4 , 8 },
    { 239, 4, 6 , 8 },
    { 4, 28, 4 , 8 },
    { 16, 28, 4 , 8 },
    { 28, 28, 4 , 8 },
    { 40, 28, 4 , 8 },
    { 52, 28, 4 , 8 },
    { 64, 28, 1 , 5 },
    { 73, 28, 2 , 6 },
    { 83, 28, 4 , 7 },
    { 95, 28, 4 , 4 },
    { 107, 28, 4 , 7 },
    { 119, 28, 4 , 10 },
    { 131, 28, 8 , 7 },
    { 147, 28, 4 , 10 },
    { 159, 28, 4 , 10 },
    { 171, 28, 4 , 10 },
    { 183, 28, 4 , 10 },
    { 195, 28, 4 , 10 },
    { 207, 28, 5 , 10 },
    { 220, 28, 4 , 10 },
    { 232, 28, 4 , 10 },
    { 244, 28, 1 , 10 },
    { 4, 52, 3 , 10 },
    { 15, 52, 4 , 10 },
    { 27, 52, 4 , 10 },
    { 39, 52, 7 , 10 },
    { 54, 52, 4 , 10 },
    { 66, 52, 4 , 10 },
    { 78, 52, 4 , 10 },
    { 90, 52, 5 , 11 },
    { 103, 52, 4 , 10 },
    { 115, 52, 4 , 10 },
    { 127, 52, 5 , 10 },
    { 140, 52, 4 , 10 },
    { 152, 52, 4 , 10 },
    { 164, 52, 7 , 10 },
    { 179, 52, 4 , 10 },
    { 191, 52, 4 , 10 },
    { 203, 52, 4 , 10 },
    { 215, 52, 2 , 12 },
    { 225, 52, 5 , 10 },
    { 238, 52, 2 , 12 },
    { 4, 76, 5 , 3 },
    { 17, 76, 5 , 1 },
    { 30, 76, 2 , 2 },
    { 40, 76, 4 , 8 },
    { 52, 76, 4 , 10 },
    { 64, 76, 3 , 8 },
    { 75, 76, 4 , 10 },
    { 87, 76, 4 , 8 },
    { 99, 76, 3 , 10 },
    { 110, 76, 5 , 11 },
    { 123, 76, 4 , 10 },
    { 135, 76, 1 , 10 },
    { 144, 76, 3 , 13 },
    { 155, 76, 4 , 10 },
    { 167, 76, 2 , 10 },
    { 177, 76, 7 , 8 },
    { 192, 76, 4 , 8 },
    { 204, 76, 4 , 8 },
    { 216, 76, 4 , 11 },
    { 228, 76, 4 , 11 },
    { 240, 76, 3 , 8 },
    { 4, 100, 4 , 8 },
    { 16, 100, 3 , 10 },
    { 27, 100, 4 , 8 },
    { 39, 100, 5 , 8 },
    { 52, 100, 7 , 8 },
    { 67, 100, 4 , 8 },
    { 79, 100, 4 , 11 },
    { 91, 100, 4 , 8 },
    { 103, 100, 4 , 12 },
    { 115, 100, 1 , 10 },
    { 124, 100, 4 , 12 },
    { 136, 100, 4 , 2 },
    { 148, 100, 1 , 10 },
    { 157, 100, 4 , 12 },
    { 169, 100, 5 , 10 },
    { 182, 100, 5 , 10 },
    { 195, 100, 5 , 10 },
    { 208, 100, 0 , 0 },
    { 216, 100, 4 , 10 },
    { 228, 100, 0 , 0 },
    { 236, 100, 7 , 9 },
    { 4, 124, 3 , 7 },
    { 15, 124, 6 , 5 },
    { 29, 124, 0 , 0 },
    { 37, 124, 7 , 9 },
    { 52, 124, 4 , 1 },
    { 64, 124, 3 , 5 },
    { 75, 124, 5 , 7 },
    { 88, 124, 3 , 5 },
    { 99, 124, 0 , 0 },
    { 107, 124, 0 , 0 },
    { 115, 124, 4 , 11 },
    { 127, 124, 6 , 10 },
    { 141, 124, 3 , 3 },
    { 152, 124, 0 , 0 },
    { 160, 124, 2 , 5 },
    { 170, 124, 3 , 5 },
    { 181, 124, 6 , 5 },
    { 195, 124, 7 , 10 },
    { 210, 124, 7 , 8 },
    { 225, 124, 0 , 0 },
    { 233, 124, 4 , 10 },
    { 4, 148, 4 , 13 },
    { 16, 148, 4 , 13 },
    { 28, 148, 4 , 13 },
    { 40, 148, 4 , 13 },
    { 52, 148, 4 , 13 },
    { 64, 148, 4 , 13 },
    { 76, 148, 7 , 10 },
    { 91, 148, 4 , 13 },
    { 103, 148, 4 , 13 },
    { 115, 148, 4 , 13 },
    { 127, 148, 4 , 13 },
    { 139, 148, 4 , 13 },
    { 151, 148, 2 , 13 },
    { 161, 148, 2 , 13 },
    { 171, 148, 3 , 13 },
    { 182, 148, 3 , 13 },
    { 193, 148, 5 , 10 },
    { 206, 148, 4 , 13 },
    { 218, 148, 4 , 13 },
    { 230, 148, 4 , 13 },
    { 242, 148, 4 , 13 },
    { 4, 172, 4 , 13 },
    { 16, 172, 4 , 13 },
    { 28, 172, 5 , 5 },
    { 41, 172, 6 , 12 },
    { 55, 172, 4 , 13 },
    { 67, 172, 4 , 13 },
    { 79, 172, 4 , 13 },
    { 91, 172, 4 , 13 },
    { 103, 172, 4 , 13 },
    { 115, 172, 0 , 0 },
    { 123, 172, 5 , 12 },
    { 136, 172, 4 , 12 },
    { 148, 172, 4 , 12 },
    { 160, 172, 4 , 12 },
    { 172, 172, 4 , 12 },
    { 184, 172, 4 , 12 },
    { 196, 172, 4 , 12 },
    { 208, 172, 7 , 8 },
    { 223, 172, 3 , 11 },
    { 234, 172, 4 , 12 },
    { 4, 196, 4 , 12 },
    { 16, 196, 4 , 12 },
    { 28, 196, 4 , 12 },
    { 40, 196, 3 , 12 },
    { 51, 196, 3 , 12 },
    { 62, 196, 3 , 12 },
    { 73, 196, 3 , 12 },
    { 84, 196, 0 , 0 },
    { 92, 196, 4 , 12 },
    { 104, 196, 4 , 12 },
    { 116, 196, 4 , 12 },
    { 128, 196, 4 , 12 },
    { 140, 196, 4 , 12 },
    { 152, 196, 4 , 12 },
    { 164, 196, 5 , 5 },
    { 177, 196, 6 , 10 },
    { 191, 196, 4 , 12 },
    { 203, 196, 4 , 12 },
    { 215, 196, 4 , 12 },
    { 227, 196, 4 , 12 },
    { 239, 196, 4 , 15 },
    { 4, 220, 0 , 0 },
    { 12, 220, 4 , 15 },
};

// Font glyphs info data
// NOTE: No glyphs.image data provided
static const GlyphInfo ashesFontGlyphs[189] = {
    { 32, 0, 0, 4, { 0 }},
    { 33, 0, 3, 4, { 0 }},
    { 34, 0, 1, 5, { 0 }},
    { 35, 0, 4, 8, { 0 }},
    { 36, 0, 2, 7, { 0 }},
    { 37, 0, 5, 9, { 0 }},
    { 38, 0, 4, 8, { 0 }},
    { 39, 0, 1, 3, { 0 }},
    { 40, 0, 2, 5, { 0 }},
    { 41, 0, 2, 5, { 0 }},
    { 42, 0, 3, 7, { 0 }},
    { 43, 0, 6, 7, { 0 }},
    { 44, 0, 12, 4, { 0 }},
    { 45, 0, 9, 5, { 0 }},
    { 46, 0, 12, 3, { 0 }},
    { 47, 0, 3, 7, { 0 }},
    { 48, 0, 5, 6, { 0 }},
    { 49, 0, 5, 4, { 0 }},
    { 50, 0, 5, 6, { 0 }},
    { 51, 0, 5, 6, { 0 }},
    { 52, 0, 5, 8, { 0 }},
    { 53, 0, 5, 6, { 0 }},
    { 54, 0, 5, 6, { 0 }},
    { 55, 0, 5, 6, { 0 }},
    { 56, 0, 5, 6, { 0 }},
    { 57, 0, 5, 6, { 0 }},
    { 58, 0, 8, 3, { 0 }},
    { 59, 0, 8, 4, { 0 }},
    { 60, 0, 5, 6, { 0 }},
    { 61, 0, 7, 7, { 0 }},
    { 62, 0, 5, 6, { 0 }},
    { 63, 1, 3, 7, { 0 }},
    { 64, 0, 5, 10, { 0 }},
    { 65, 0, 3, 6, { 0 }},
    { 66, 0, 3, 6, { 0 }},
    { 67, 0, 3, 6, { 0 }},
    { 68, 0, 3, 6, { 0 }},
    { 69, 0, 3, 6, { 0 }},
    { 70, 0, 3, 6, { 0 }},
    { 71, 0, 3, 6, { 0 }},
    { 72, 0, 3, 6, { 0 }},
    { 73, 0, 3, 3, { 0 }},
    { 74, 0, 3, 5, { 0 }},
    { 75, 0, 3, 6, { 0 }},
    { 76, 0, 3, 6, { 0 }},
    { 77, 0, 3, 9, { 0 }},
    { 78, 0, 3, 6, { 0 }},
    { 79, 0, 3, 6, { 0 }},
    { 80, 0, 3, 6, { 0 }},
    { 81, 0, 3, 7, { 0 }},
    { 82, 0, 3, 6, { 0 }},
    { 83, 0, 3, 6, { 0 }},
    { 84, 0, 3, 6, { 0 }},
    { 85, 0, 3, 6, { 0 }},
    { 86, 0, 3, 6, { 0 }},
    { 87, 0, 3, 9, { 0 }},
    { 88, 0, 3, 6, { 0 }},
    { 89, 0, 3, 6, { 0 }},
    { 90, 0, 3, 6, { 0 }},
    { 91, 0, 2, 4, { 0 }},
    { 92, 0, 3, 7, { 0 }},
    { 93, 0, 2, 4, { 0 }},
    { 94, 0, 3, 7, { 0 }},
    { 95, 0, 12, 7, { 0 }},
    { 96, 0, 1, 4, { 0 }},
    { 97, 0, 5, 6, { 0 }},
    { 98, 0, 3, 6, { 0 }},
    { 99, 0, 5, 5, { 0 }},
    { 100, 0, 3, 6, { 0 }},
    { 101, 0, 5, 6, { 0 }},
    { 102, 0, 3, 5, { 0 }},
    { 103, 0, 5, 6, { 0 }},
    { 104, 0, 3, 6, { 0 }},
    { 105, 0, 3, 3, { 0 }},
    { 106, 0, 3, 5, { 0 }},
    { 107, 0, 3, 6, { 0 }},
    { 108, 0, 3, 4, { 0 }},
    { 109, 0, 5, 9, { 0 }},
    { 110, 0, 5, 6, { 0 }},
    { 111, 0, 5, 6, { 0 }},
    { 112, 0, 5, 6, { 0 }},
    { 113, 0, 5, 6, { 0 }},
    { 114, 0, 5, 5, { 0 }},
    { 115, 0, 5, 6, { 0 }},
    { 116, 0, 3, 5, { 0 }},
    { 117, 0, 5, 6, { 0 }},
    { 118, 0, 5, 7, { 0 }},
    { 119, 0, 5, 9, { 0 }},
    { 120, 0, 5, 6, { 0 }},
    { 121, 0, 5, 6, { 0 }},
    { 122, 0, 5, 6, { 0 }},
    { 123, 0, 2, 6, { 0 }},
    { 124, 0, 3, 3, { 0 }},
    { 125, 0, 2, 6, { 0 }},
    { 126, 0, 1, 6, { 0 }},
    { 161, 0, 4, 4, { 0 }},
    { 162, 0, 3, 6, { 0 }},
    { 163, 0, 3, 7, { 0 }},
    { 8364, 0, 3, 7, { 0 }},
    { 165, 0, 3, 7, { 0 }},
    { 352, 0, 0, 0, { 0 }},
    { 167, 0, 3, 6, { 0 }},
    { 353, 0, 0, 0, { 0 }},
    { 169, 0, 1, 9, { 0 }},
    { 170, 0, 1, 5, { 0 }},
    { 171, 0, 6, 8, { 0 }},
    { 172, 0, 0, 0, { 0 }},
    { 174, 0, 1, 9, { 0 }},
    { 175, 0, 0, 6, { 0 }},
    { 176, 0, 1, 5, { 0 }},
    { 177, 0, 5, 7, { 0 }},
    { 178, 0, 1, 5, { 0 }},
    { 179, 0, 0, 0, { 0 }},
    { 381, 0, 0, 0, { 0 }},
    { 181, 0, 5, 6, { 0 }},
    { 182, 0, 3, 8, { 0 }},
    { 183, 0, 7, 5, { 0 }},
    { 382, 0, 0, 0, { 0 }},
    { 185, 0, 1, 4, { 0 }},
    { 186, 0, 1, 5, { 0 }},
    { 187, 0, 6, 8, { 0 }},
    { 338, 0, 3, 9, { 0 }},
    { 339, 0, 5, 9, { 0 }},
    { 376, 0, 0, 0, { 0 }},
    { 191, 0, 4, 6, { 0 }},
    { 192, 0, 0, 6, { 0 }},
    { 193, 0, 0, 6, { 0 }},
    { 194, 0, 0, 6, { 0 }},
    { 195, 0, 0, 6, { 0 }},
    { 196, 0, 0, 6, { 0 }},
    { 197, 0, 0, 6, { 0 }},
    { 198, 0, 3, 9, { 0 }},
    { 199, 0, 3, 6, { 0 }},
    { 200, 0, 0, 6, { 0 }},
    { 201, 0, 0, 6, { 0 }},
    { 202, 0, 0, 6, { 0 }},
    { 203, 0, 0, 6, { 0 }},
    { 204, 0, 0, 4, { 0 }},
    { 205, 0, 0, 4, { 0 }},
    { 206, 0, 0, 5, { 0 }},
    { 207, 0, 0, 5, { 0 }},
    { 208, 0, 3, 7, { 0 }},
    { 209, 0, 0, 6, { 0 }},
    { 210, 0, 0, 6, { 0 }},
    { 211, 0, 0, 6, { 0 }},
    { 212, 0, 0, 6, { 0 }},
    { 213, 0, 0, 6, { 0 }},
    { 214, 0, 0, 6, { 0 }},
    { 215, 0, 7, 7, { 0 }},
    { 216, 0, 2, 8, { 0 }},
    { 217, 0, 0, 6, { 0 }},
    { 218, 0, 0, 6, { 0 }},
    { 219, 0, 0, 6, { 0 }},
    { 220, 0, 0, 6, { 0 }},
    { 221, 0, 0, 6, { 0 }},
    { 222, 0, 0, 0, { 0 }},
    { 223, 0, 3, 7, { 0 }},
    { 224, 0, 1, 6, { 0 }},
    { 225, 0, 1, 6, { 0 }},
    { 226, 0, 1, 6, { 0 }},
    { 227, 0, 1, 6, { 0 }},
    { 228, 0, 1, 6, { 0 }},
    { 229, 0, 1, 6, { 0 }},
    { 230, 0, 5, 9, { 0 }},
    { 231, 0, 5, 5, { 0 }},
    { 232, 0, 1, 6, { 0 }},
    { 233, 0, 1, 6, { 0 }},
    { 234, 0, 1, 6, { 0 }},
    { 235, 0, 1, 6, { 0 }},
    { 236, 0, 1, 5, { 0 }},
    { 237, 0, 1, 5, { 0 }},
    { 238, 0, 1, 5, { 0 }},
    { 239, 0, 1, 5, { 0 }},
    { 240, 0, 0, 0, { 0 }},
    { 241, 0, 1, 6, { 0 }},
    { 242, 0, 1, 6, { 0 }},
    { 243, 0, 1, 6, { 0 }},
    { 244, 0, 1, 6, { 0 }},
    { 245, 0, 1, 6, { 0 }},
    { 246, 0, 1, 6, { 0 }},
    { 247, 0, 7, 7, { 0 }},
    { 248, 0, 4, 8, { 0 }},
    { 249, 0, 1, 6, { 0 }},
    { 250, 0, 1, 6, { 0 }},
    { 251, 0, 1, 6, { 0 }},
    { 252, 0, 1, 6, { 0 }},
    { 253, 0, 1, 6, { 0 }},
    { 254, 0, 0, 0, { 0 }},
    { 255, 0, 1, 6, { 0 }},
};

// Style loading function: Ashes
static void GuiLoadStyleAshes(void)
{
    // Load style properties provided
    // NOTE: Default properties are propagated
    for (int i = 0; i < ASHES_STYLE_PROPS_COUNT; i++)
    {
        GuiSetStyle(ashesStyleProps[i].controlId, ashesStyleProps[i].propertyId, ashesStyleProps[i].propertyValue);
    }

    // Custom font loading
    // NOTE: Compressed font image data (DEFLATE), it requires DecompressData() function
    int ashesFontDataSize = 0;
    unsigned char *data = DecompressData(ashesFontData, ASHES_STYLE_FONT_ATLAS_COMP_SIZE, &ashesFontDataSize);
    Image imFont = { data, 256, 256, 1, 2 };

    Font font = { 0 };
    font.baseSize = 16;
    font.glyphCount = 189;

    // Load texture from image
    font.texture = LoadTextureFromImage(imFont);
    UnloadImage(imFont);  // Uncompressed image data can be unloaded from memory

    // Copy char recs data from global fontRecs
    // NOTE: Required to avoid issues if trying to free font
    font.recs = (Rectangle *)RAYGUI_MALLOC(font.glyphCount*sizeof(Rectangle));
    memcpy(font.recs, ashesFontRecs, font.glyphCount*sizeof(Rectangle));

    // Copy font char info data from global fontChars
    // NOTE: Required to avoid issues if trying to free font
    font.glyphs = (GlyphInfo *)RAYGUI_MALLOC(font.glyphCount*sizeof(GlyphInfo));
    memcpy(font.glyphs, ashesFontGlyphs, font.glyphCount*sizeof(GlyphInfo));

    GuiSetFont(font);

    // Setup a white rectangle on the font to be used on shapes drawing,
    // it makes possible to draw shapes and text (full UI) in a single draw call
    Rectangle fontWhiteRec = { 254, 254, 1, 1 };
    SetShapesTexture(font.texture, fontWhiteRec);

    //-----------------------------------------------------------------

    // TODO: Custom user style setup: Set specific properties here (if required)
    // i.e. Controls specific BORDER_WIDTH, TEXT_PADDING, TEXT_ALIGNMENT
}
