//////////////////////////////////////////////////////////////////////////////////
//                                                                              //
// StyleAsCode exporter v2.0 - Style data exported as a values array            //
//                                                                              //
// USAGE: On init call: GuiLoadStyleBluish();                                   //
//                                                                              //
// more info and bugs-report:  github.com/raysan5/raygui                        //
// feedback and support:       ray[at]raylibtech.com                            //
//                                                                              //
// Copyright (c) 2020-2025 raylib technologies (@raylibtech)                    //
//                                                                              //
//////////////////////////////////////////////////////////////////////////////////

#define BLUISH_STYLE_PROPS_COUNT  14

// Custom style name: Bluish
static const GuiStyleProp bluishStyleProps[BLUISH_STYLE_PROPS_COUNT] = {
    { 0, 0, (int)0x5ca6a6ff },    // DEFAULT_BORDER_COLOR_NORMAL 
    { 0, 1, (int)0xb4e8f3ff },    // DEFAULT_BASE_COLOR_NORMAL 
    { 0, 2, (int)0x447e77ff },    // DEFAULT_TEXT_COLOR_NORMAL 
    { 0, 3, (int)0x5f8792ff },    // DEFAULT_BORDER_COLOR_FOCUSED 
    { 0, 4, (int)0xcdeff7ff },    // DEFAULT_BASE_COLOR_FOCUSED 
    { 0, 5, (int)0x4c6c74ff },    // DEFAULT_TEXT_COLOR_FOCUSED 
    { 0, 6, (int)0x3b5b5fff },    // DEFAULT_BORDER_COLOR_PRESSED 
    { 0, 7, (int)0xeaffffff },    // DEFAULT_BASE_COLOR_PRESSED 
    { 0, 8, (int)0x275057ff },    // DEFAULT_TEXT_COLOR_PRESSED 
    { 0, 9, (int)0x96aaacff },    // DEFAULT_BORDER_COLOR_DISABLED 
    { 0, 10, (int)0xc8d7d9ff },    // DEFAULT_BASE_COLOR_DISABLED 
    { 0, 11, (int)0x8c9c9eff },    // DEFAULT_TEXT_COLOR_DISABLED 
    { 0, 18, (int)0x84adb7ff },    // DEFAULT_LINE_COLOR 
    { 0, 19, (int)0xe8eef1ff },    // DEFAULT_BACKGROUND_COLOR 
};

// WARNING: This style uses a custom font: "homespun.ttf" (size: 10, spacing: 1)

#define BLUISH_STYLE_FONT_ATLAS_COMP_SIZE 2730

// Font atlas image pixels data: DEFLATE compressed
static unsigned char bluishFontData[BLUISH_STYLE_FONT_ATLAS_COMP_SIZE] = { 0xed,
    0x9d, 0xdb, 0x92, 0xdb, 0x38, 0x0c, 0x44, 0x45, 0xee, 0xff, 0xff, 0xf1, 0x90, 0xdc, 0xca, 0xc8, 0x33, 0xa9, 0x4d, 0xd4,
    0x10, 0x01, 0x41, 0x17, 0xef, 0x9c, 0x9c, 0x4a, 0x1e, 0x44, 0x8b, 0x26, 0x09, 0x4a, 0x76, 0x84, 0x76, 0x63, 0x2c, 0x00,
    0x00, 0x00, 0x00, 0x7f, 0x51, 0xc5, 0xb1, 0x2a, 0x5f, 0x5d, 0x1d, 0x3d, 0xad, 0xc7, 0xab, 0xd1, 0xee, 0xeb, 0xad, 0x3a,
    0x7a, 0xb0, 0x5a, 0xec, 0xb6, 0x3f, 0x29, 0x2f, 0x32, 0x56, 0xb6, 0x7e, 0xaf, 0xc7, 0xf6, 0x2a, 0x79, 0x5e, 0x5f, 0x5d,
    0xb3, 0xd8, 0x66, 0x88, 0x63, 0x7d, 0x73, 0xbe, 0x63, 0x14, 0xd1, 0x52, 0xc7, 0x10, 0xe3, 0x19, 0x9f, 0x67, 0x6d, 0xf7,
    0x68, 0x9d, 0xb5, 0xf5, 0x1e, 0x6d, 0xa3, 0x8f, 0x26, 0x77, 0xc5, 0xaf, 0x77, 0x54, 0x2b, 0xd4, 0x45, 0x3c, 0xc7, 0xe6,
    0x6b, 0x57, 0xca, 0xd4, 0xab, 0xad, 0x77, 0x18, 0xa3, 0x8d, 0xf6, 0x5a, 0x8f, 0x3f, 0x67, 0x31, 0x5c, 0xaf, 0xd7, 0x2d,
    0xc7, 0xe3, 0xdf, 0x3f, 0xc7, 0x53, 0x36, 0xae, 0x83, 0x5f, 0xd1, 0xea, 0x22, 0x5e, 0x6a, 0x3c, 0xeb, 0xca, 0x95, 0xcd,
    0x1e, 0xad, 0xb3, 0x96, 0xe9, 0xd5, 0xde, 0x3e, 0x7f, 0x1d, 0xe9, 0xf6, 0x3c, 0xca, 0x67, 0xdb, 0xd6, 0xda, 0xb5, 0xa4,
    0xfb, 0xaa, 0x9a, 0xef, 0x62, 0x5e, 0x5b, 0xdb, 0xab, 0xd0, 0x5d, 0x2d, 0xc7, 0xe3, 0xaf, 0x77, 0xf4, 0x78, 0xfd, 0x55,
    0x33, 0x6b, 0x62, 0x3c, 0x45, 0xb4, 0xd8, 0x67, 0x1d, 0x89, 0x7f, 0x79, 0x8d, 0xb4, 0x8a, 0xeb, 0x79, 0x88, 0x2b, 0xfa,
    0xcc, 0xe8, 0xfb, 0xe3, 0x5f, 0x5e, 0x7b, 0xb5, 0x88, 0x4f, 0xa5, 0x6b, 0xe3, 0x5f, 0x5e, 0xf7, 0xff, 0x2a, 0x46, 0x5f,
    0x64, 0xf4, 0xf5, 0xdd, 0xd6, 0xf3, 0xb9, 0xea, 0xbb, 0xfe, 0xd7, 0x75, 0x56, 0x7b, 0xeb, 0xbc, 0xd8, 0xdb, 0xf3, 0xf5,
    0xc5, 0x7f, 0xc8, 0x4f, 0x9e, 0xaf, 0x5d, 0x7c, 0x74, 0x16, 0x3d, 0xe9, 0xfa, 0xef, 0x72, 0x3c, 0xe5, 0x75, 0xff, 0xdf,
    0x9e, 0xb3, 0xe7, 0x2a, 0xf4, 0xc4, 0x7f, 0x2f, 0xc6, 0x67, 0x5e, 0xfb, 0xba, 0x6f, 0x7f, 0xfc, 0xd7, 0x1e, 0xb7, 0xde,
    0xe5, 0xec, 0x5d, 0xbc, 0xb8, 0xbe, 0xff, 0x15, 0xe3, 0x3b, 0xcf, 0xd7, 0xde, 0xf1, 0xcc, 0x2f, 0x2b, 0xce, 0xd7, 0x33,
    0x76, 0x67, 0xe0, 0x89, 0x7f, 0x91, 0xab, 0x5a, 0x2e, 0xff, 0xfc, 0xb7, 0xe2, 0x6f, 0x8d, 0xd4, 0x8a, 0xbf, 0x6f, 0x16,
    0xc3, 0xf9, 0x1d, 0xfc, 0x79, 0xf1, 0x1f, 0xdf, 0xff, 0x1f, 0x9a, 0x9b, 0x9b, 0x7a, 0xbd, 0xd5, 0xd3, 0x3d, 0xb3, 0x8e,
    0x8c, 0xe7, 0x69, 0xb3, 0x80, 0x23, 0x7c, 0x04, 0xe2, 0xf8, 0x41, 0xec, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xd2, 0x54, 0x3e, 0x59, 0x0a, 0x93, 0xec, 0x96, 0x63, 0xaa, 0x20, 0xad, 0xce, 0xb1, 0x14, 0x49, 0xf6, 0x28, 0xaf, 0x5a,
    0x8f, 0xe5, 0x22, 0xcd, 0xcf, 0x08, 0x28, 0x52, 0xae, 0x6a, 0x69, 0xd3, 0x2a, 0x8c, 0xed, 0x6c, 0xae, 0x56, 0xe7, 0x74,
    0xb1, 0x56, 0x7b, 0xa3, 0xbc, 0x6e, 0x3d, 0x6a, 0x60, 0x74, 0x91, 0xa7, 0xe5, 0x63, 0x27, 0x3b, 0xd7, 0x5c, 0x2d, 0x7d,
    0x37, 0xd7, 0xe7, 0x53, 0xbe, 0x1c, 0xcb, 0xab, 0x5a, 0xea, 0x3c, 0xa5, 0xff, 0xb0, 0x46, 0xa9, 0x74, 0x15, 0x23, 0x3c,
    0xeb, 0x96, 0x7a, 0x4e, 0x0b, 0xc5, 0x5f, 0xcf, 0x4a, 0xe7, 0xe6, 0x6d, 0xd5, 0xa3, 0xee, 0xcd, 0xd7, 0x32, 0xaf, 0x3e,
    0x50, 0x31, 0xd6, 0x1a, 0x09, 0xaf, 0x76, 0x66, 0x18, 0xba, 0x8a, 0xbd, 0xb9, 0x35, 0x57, 0x6e, 0x72, 0xec, 0xac, 0xe1,
    0x71, 0xb5, 0xcc, 0x9c, 0x3a, 0xa3, 0x1b, 0xf3, 0xb5, 0x15, 0x26, 0xdd, 0x75, 0x4e, 0x4f, 0xd0, 0xab, 0x78, 0x77, 0x8f,
    0xa5, 0xc3, 0xe9, 0x46, 0xfc, 0xab, 0x73, 0x6e, 0x6b, 0x4b, 0x75, 0xe5, 0x82, 0xc7, 0xce, 0x1a, 0x1e, 0x57, 0xcb, 0xcc,
    0xad, 0x5f, 0x09, 0xdf, 0xb1, 0xb3, 0xce, 0x39, 0x6f, 0x07, 0x0c, 0x77, 0x3f, 0xe3, 0x7b, 0xa7, 0x66, 0xde, 0xff, 0x4b,
    0xe0, 0x13, 0xb9, 0x1c, 0xd6, 0x6a, 0xcc, 0xdf, 0xb1, 0x63, 0x0a, 0x93, 0xac, 0x73, 0x9e, 0xa5, 0xdd, 0x28, 0xc1, 0x3b,
    0xf6, 0x35, 0x2d, 0x67, 0xc4, 0x3f, 0xaa, 0x30, 0xe9, 0x69, 0xe7, 0x2c, 0x97, 0x6b, 0x7a, 0x86, 0xbc, 0xfe, 0xad, 0xf5,
    0xc8, 0x5c, 0x43, 0x4b, 0x07, 0x64, 0x8f, 0xe0, 0x27, 0xd0, 0x78, 0x66, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xe0, 0xd0, 0xff, 0xd8, 0xea, 0x1b, 0x9f, 0x42, 0xc5, 0x56, 0xed, 0x78, 0x3d, 0x7a, 0xea, 0xe5, 0xaa, 0x9b, 0xec,
    0x96, 0xc8, 0x5a, 0xec, 0xb5, 0xf8, 0xce, 0xdc, 0x7f, 0xde, 0xad, 0x35, 0x25, 0xea, 0xa9, 0x76, 0xfb, 0x3c, 0x2b, 0x27,
    0xfb, 0x37, 0x76, 0x47, 0xb6, 0xfe, 0x5b, 0x1f, 0xa8, 0x4f, 0xb2, 0x94, 0x4b, 0x5f, 0x23, 0xcf, 0xcc, 0x16, 0xae, 0x2d,
    0x6d, 0x73, 0x2d, 0xa2, 0x39, 0xb4, 0x88, 0x0e, 0xc5, 0xce, 0x86, 0xe5, 0xc5, 0x3f, 0x3a, 0xe7, 0x6b, 0x5b, 0xbc, 0x3e,
    0x22, 0xcf, 0x8b, 0xbf, 0xa5, 0xf2, 0xc9, 0x8a, 0xff, 0x31, 0x1d, 0x4c, 0x5e, 0xfc, 0x23, 0x1a, 0x2e, 0x3d, 0x76, 0x4b,
    0x07, 0x75, 0x65, 0xfc, 0xb5, 0x8f, 0xd6, 0x4c, 0xfc, 0xfd, 0x2a, 0x1f, 0x7f, 0xfc, 0x8f, 0xe9, 0x60, 0xf2, 0xe2, 0x1f,
    0xd1, 0x70, 0x74, 0xc3, 0x2d, 0xaa, 0xbb, 0xbd, 0x47, 0xc6, 0x8e, 0xc6, 0xb0, 0x05, 0xe2, 0x5f, 0xe4, 0x18, 0x8f, 0xea,
    0x3f, 0x3d, 0xd7, 0x7f, 0x39, 0x4d, 0x07, 0x93, 0x7b, 0xff, 0xcf, 0x5a, 0x87, 0xb2, 0xa3, 0x3e, 0x2c, 0x01, 0xb5, 0x48,
    0x4f, 0x5e, 0x8b, 0x39, 0xbd, 0x43, 0x4e, 0xfc, 0x23, 0x7d, 0xcd, 0x9d, 0xe3, 0x8d, 0x7f, 0x09, 0xc4, 0x3f, 0x73, 0xec,
    0x76, 0xfc, 0x8b, 0xa1, 0x16, 0xd9, 0x3f, 0x27, 0x3b, 0xfe, 0x51, 0x55, 0x4b, 0x49, 0xec, 0x6b, 0x24, 0xc7, 0xdf, 0xaf,
    0x93, 0xc9, 0x1d, 0xbb, 0x1d, 0xff, 0xf8, 0xe8, 0xd6, 0x3f, 0xf5, 0x04, 0x0d, 0x3d, 0xe0, 0x38, 0x03, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0x2c, 0x46, 0x45, 0x2a, 0x5b, 0x65, 0x34, 0xaf, 0x16, 0xfa, 0x52, 0x50, 0x6c,
    0xeb, 0x27, 0x72, 0x9c, 0x7e, 0xf6, 0x6b, 0x77, 0x79, 0xdf, 0x47, 0xad, 0x56, 0x64, 0x6c, 0x67, 0xd7, 0x38, 0x9b, 0x53,
    0xf9, 0x58, 0xba, 0x17, 0xdf, 0x6f, 0x50, 0x95, 0x37, 0x4d, 0x15, 0x4e, 0x37, 0xde, 0xdf, 0xee, 0x5b, 0x5e, 0x15, 0xba,
    0x9f, 0x4c, 0x17, 0x8b, 0x21, 0xf7, 0xeb, 0x08, 0x8c, 0xad, 0x89, 0xa3, 0xaa, 0x8f, 0x1a, 0xfe, 0xa5, 0x74, 0xdc, 0xcb,
    0x61, 0xd6, 0x53, 0x49, 0x67, 0x0c, 0xd7, 0x5c, 0xb7, 0x77, 0x07, 0x74, 0x79, 0x8d, 0x6d, 0x8f, 0xb5, 0x4a, 0x7d, 0xcb,
    0x22, 0xab, 0x99, 0xf9, 0xbd, 0x6a, 0x86, 0xa8, 0x1a, 0x66, 0xe7, 0x8f, 0xd4, 0xd8, 0x54, 0xb5, 0xa4, 0x45, 0xf4, 0xd1,
    0xc2, 0xbf, 0x09, 0x1f, 0x3b, 0x75, 0xa4, 0x3c, 0x3d, 0x5b, 0x3b, 0xc0, 0xaa, 0xe4, 0xd6, 0x12, 0x6a, 0x95, 0xf8, 0xbd,
    0x6a, 0x2c, 0xe5, 0x81, 0xdd, 0x9b, 0xd7, 0x9b, 0x45, 0xef, 0x19, 0xdf, 0x9d, 0x21, 0xcb, 0x61, 0x66, 0xee, 0xce, 0x59,
    0x8c, 0x19, 0x2d, 0xee, 0x1d, 0x70, 0x6e, 0x25, 0x8f, 0xf3, 0x94, 0x07, 0xb3, 0xb3, 0xc8, 0xce, 0x2c, 0xcf, 0xc7, 0x7f,
    0x39, 0xe4, 0x09, 0x52, 0xc2, 0x5a, 0x19, 0xdf, 0x0e, 0x38, 0x3b, 0xfe, 0x67, 0x29, 0x0f, 0xb2, 0x1c, 0x38, 0xfa, 0x43,
    0xe3, 0xbf, 0xe7, 0x36, 0xe3, 0x8f, 0xa5, 0x5f, 0x31, 0xba, 0xdc, 0x72, 0x67, 0xc8, 0x3e, 0x67, 0x71, 0xff, 0x4f, 0xe6,
    0x19, 0xf1, 0x8f, 0x39, 0xd4, 0x14, 0xb7, 0x97, 0xd0, 0x5d, 0xf1, 0xf7, 0xd7, 0x91, 0x8a, 0x9d, 0x93, 0xaf, 0xbd, 0xbc,
    0x22, 0xfe, 0xf0, 0x3e, 0xce, 0x47, 0x0d, 0x7d, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x29, 0xff,
    0xc1, 0xa3, 0x5e, 0xb9, 0xbf, 0xa5, 0xee, 0x64, 0xb5, 0x4a, 0xb8, 0xa5, 0xa4, 0xf5, 0x69, 0x69, 0x8c, 0x8e, 0xd6, 0x3c,
    0xfb, 0xea, 0xbb, 0x84, 0xd5, 0x3f, 0xbf, 0x73, 0xd0, 0xeb, 0xbf, 0x35, 0x29, 0xb3, 0x9e, 0xdf, 0x72, 0xfe, 0xaf, 0xf9,
    0xcf, 0xf0, 0x1b, 0xb0, 0x1c, 0x22, 0xea, 0xb4, 0xb6, 0xa2, 0xc9, 0x9c, 0x6a, 0x97, 0x9e, 0x01, 0x2d, 0x90, 0x83, 0xb8,
    0xdf, 0x65, 0xa7, 0x39, 0xeb, 0x50, 0xd5, 0x0b, 0x3d, 0x36, 0xfa, 0x8e, 0x1e, 0xc6, 0xa7, 0xa1, 0xd1, 0x1e, 0x0a, 0x8b,
    0xeb, 0xb5, 0xaa, 0x26, 0x51, 0x79, 0xcb, 0xf8, 0x2f, 0x4e, 0x6d, 0x5f, 0x9f, 0xf0, 0xcb, 0xc8, 0xf2, 0xd8, 0x28, 0x01,
    0x85, 0x4f, 0x31, 0xea, 0x8f, 0xf9, 0xe2, 0xaf, 0xaa, 0xd5, 0xf9, 0xef, 0x8d, 0x57, 0xb8, 0x6c, 0xe4, 0x57, 0xb0, 0xc9,
    0x73, 0xf3, 0xc8, 0xf7, 0xd8, 0xb0, 0x32, 0xe5, 0x5a, 0x57, 0xe9, 0x8b, 0xbf, 0xd7, 0xdb, 0xe1, 0x8a, 0xf8, 0x47, 0x6b,
    0xdb, 0xe4, 0x3a, 0x73, 0x94, 0x87, 0x78, 0x6c, 0x78, 0x1d, 0x42, 0x8e, 0xdf, 0xff, 0xb3, 0xf5, 0x08, 0x79, 0x99, 0xea,
    0x6b, 0x7c, 0x36, 0x22, 0x3a, 0x9d, 0xb3, 0x32, 0xf3, 0xfe, 0xec, 0xbc, 0x47, 0x5b, 0xd9, 0xdf, 0x2a, 0xfe, 0x4f, 0xd6,
    0xf6, 0x3c, 0x89, 0x33, 0x6b, 0x9e, 0xa1, 0xfe, 0x79, 0xd7, 0x3d, 0xcd, 0x1a, 0xfc, 0x6c, 0x95, 0x17, 0x6b, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe7, 0x38, 0x00, 0x2d, 0xd2, 0xd3, 0x66, 0xbe, 0x87, 0x9a, 0xe6, 0x2f, 0xb4, 0x77,
    0x4e, 0x75, 0xd6, 0x25, 0x2b, 0x6e, 0x7d, 0xce, 0xb1, 0xda, 0x63, 0xbe, 0x95, 0x8e, 0xf4, 0x35, 0xb7, 0x5e, 0x33, 0xfa,
    0x2f, 0x4b, 0x45, 0xd1, 0xa6, 0x9e, 0xae, 0x0f, 0xe3, 0x79, 0x76, 0xfb, 0x9c, 0xc3, 0x87, 0xb3, 0x7a, 0x96, 0x7d, 0x8e,
    0xaa, 0x08, 0xa6, 0xfa, 0x2b, 0x9f, 0x2a, 0x89, 0xe6, 0xd2, 0xe7, 0xec, 0xbf, 0x93, 0xfa, 0x4d, 0x77, 0x73, 0x57, 0x04,
    0xb0, 0xab, 0x88, 0x95, 0xc3, 0x1e, 0x3e, 0x31, 0xe7, 0x94, 0x35, 0xbf, 0xd6, 0xa6, 0xde, 0xbf, 0x1a, 0x2e, 0x32, 0x4d,
    0xea, 0x5f, 0xb4, 0xf7, 0x8b, 0x75, 0x4e, 0x79, 0x65, 0xfd, 0xea, 0xe6, 0xf5, 0xb2, 0xad, 0xc2, 0x2a, 0xa6, 0x37, 0x8d,
    0xd6, 0x09, 0x95, 0x5d, 0x5f, 0xa3, 0xad, 0xb5, 0xe8, 0xc2, 0x53, 0xa8, 0x8b, 0x2b, 0x4d, 0x8d, 0x5b, 0x1d, 0xcf, 0x8d,
    0xbf, 0x76, 0x41, 0x1a, 0x93, 0x33, 0xff, 0xad, 0x20, 0x2c, 0x8e, 0x3b, 0xa5, 0xe5, 0x7e, 0x54, 0x0c, 0xcf, 0xa6, 0x2e,
    0xe3, 0xa9, 0xaf, 0xbd, 0x2e, 0x77, 0xa7, 0xb5, 0x2e, 0x7d, 0x77, 0xe7, 0xa8, 0x5c, 0x70, 0x71, 0xad, 0x91, 0xaa, 0x14,
    0x78, 0xcd, 0xf5, 0xaf, 0x34, 0x14, 0x7d, 0x5a, 0x75, 0x62, 0xed, 0xed, 0x3d, 0xc7, 0x24, 0xbf, 0xe2, 0x73, 0x8d, 0xc7,
    0x76, 0xfc, 0x6b, 0x9a, 0x1a, 0x60, 0x7c, 0xaf, 0x68, 0x0f, 0x7e, 0xb2, 0xce, 0xdf, 0xff, 0xd5, 0x27, 0x70, 0x99, 0xdc,
    0xb5, 0xc7, 0xe2, 0x5f, 0x4c, 0xcf, 0x96, 0x72, 0xf0, 0xfa, 0xb7, 0xd4, 0x9b, 0xb6, 0xcb, 0x9a, 0xff, 0xfa, 0xef, 0x52,
    0x6d, 0xf7, 0xec, 0xf8, 0xab, 0x71, 0xcf, 0xce, 0xe7, 0x58, 0xfc, 0x6d, 0x85, 0xd2, 0x6c, 0xaf, 0xf6, 0xdc, 0x86, 0xeb,
    0xbb, 0x97, 0xf5, 0xad, 0xac, 0x7c, 0xbf, 0xa6, 0x5e, 0xe0, 0x1b, 0x74, 0xc5, 0x3b, 0xdd, 0xad, 0x83, 0xfa, 0x70, 0xd7,
    0xa9, 0xd2, 0xca, 0x39, 0x6f, 0x8d, 0xbc, 0xa8, 0x9e, 0x6e, 0x4c, 0x7f, 0x37, 0x39, 0xaa, 0x2d, 0xca, 0x7a, 0xa7, 0x71,
    0xa2, 0x5a, 0xe9, 0xc9, 0x3a, 0xa8, 0x98, 0xcb, 0xde, 0x7b, 0xeb, 0xba, 0xd0, 0x8c, 0xcc, 0xc4, 0x32, 0xa6, 0x9a, 0x04,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xfa, 0xc7, 0xaa, 0x5c, 0x35, 0x77, 0xfe, 0xbc, 0x72, 0xa5, 0xc8,
    0x5e, 0xeb, 0x44, 0x05, 0xad, 0xe2, 0xd6, 0xbe, 0x54, 0xb7, 0xe6, 0xc9, 0x56, 0xe9, 0xe8, 0xe3, 0x79, 0xda, 0xa7, 0x88,
    0xea, 0x68, 0x09, 0x3f, 0xa3, 0x5e, 0xff, 0x34, 0xb3, 0x3e, 0x8f, 0xfd, 0xec, 0x71, 0x38, 0x54, 0x30, 0x5d, 0xd6, 0x7b,
    0x5a, 0xcf, 0x68, 0x32, 0x1f, 0x3c, 0x44, 0x46, 0xa8, 0x99, 0x39, 0x8c, 0x26, 0x8f, 0xff, 0x23, 0xa3, 0xfc, 0x21, 0xdd,
    0x7a, 0xb6, 0xcf, 0x1a, 0x9f, 0xc7, 0xbb, 0x6b, 0x6c, 0xc3, 0xac, 0xad, 0x36, 0x8c, 0x36, 0xa5, 0x08, 0xd0, 0x33, 0x9a,
    0x89, 0x7f, 0x39, 0x90, 0x37, 0x1d, 0x32, 0x4f, 0xbf, 0xad, 0xc4, 0xd2, 0x1e, 0x3a, 0x76, 0x9b, 0xd2, 0xc8, 0x2c, 0xa6,
    0x43, 0x96, 0xde, 0xb7, 0xde, 0x1d, 0xa3, 0x62, 0xd9, 0xa4, 0x5e, 0xc9, 0xd6, 0xbe, 0x54, 0x43, 0xe1, 0x60, 0xf9, 0x0c,
    0x79, 0x47, 0xfe, 0xa4, 0xf8, 0x77, 0xd3, 0xf7, 0x40, 0x6b, 0x48, 0xf6, 0x7c, 0x6e, 0xb4, 0xe2, 0xaa, 0x84, 0xee, 0xbe,
    0x39, 0x2d, 0xf6, 0x55, 0xde, 0x64, 0x86, 0xdb, 0x5a, 0x07, 0xfb, 0x53, 0x3c, 0xa2, 0x49, 0xe8, 0xa7, 0xc4, 0xbf, 0x06,
    0xf5, 0x56, 0x3e, 0xcf, 0x26, 0x3b, 0x8b, 0xa8, 0xfd, 0x9a, 0xae, 0x72, 0xae, 0x5b, 0x02, 0xb9, 0x4f, 0x4b, 0x4b, 0xb3,
    0x98, 0x15, 0xeb, 0xa2, 0x31, 0xec, 0x87, 0xe2, 0x7f, 0x44, 0xb9, 0xf2, 0xf7, 0x1d, 0xa3, 0x38, 0x73, 0xe7, 0x96, 0x8a,
    0x48, 0xaf, 0x56, 0xa4, 0xbe, 0xe3, 0x55, 0x2d, 0xd6, 0x3a, 0xd8, 0xfd, 0x1d, 0xd1, 0x25, 0xdd, 0xed, 0xa2, 0xf3, 0x75,
    0x8d, 0x77, 0xb7, 0x8b, 0x8e, 0xad, 0x15, 0xea, 0xb7, 0x3b, 0x57, 0xfa, 0xef, 0x19, 0x5d, 0x46, 0x59, 0x5f, 0x05, 0xfd,
    0xe0, 0x15, 0x7c, 0x7f, 0xfc, 0x63, 0xaa, 0x8f, 0x12, 0x50, 0x91, 0x5c, 0xeb, 0x69, 0xe8, 0x6f, 0xe9, 0xc6, 0x3a, 0x58,
    0xae, 0x51, 0x3f, 0x51, 0x49, 0x11, 0xaf, 0xd5, 0xf7, 0xcc, 0xf8, 0xef, 0x69, 0xf5, 0x2c, 0x2f, 0xd1, 0xfb, 0x9d, 0xd0,
    0x9e, 0xa4, 0x2f, 0xfa, 0x3f, 0xc6, 0xff, 0x1d, 0x15, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x64, 0x07,
    0x20, 0x5b, 0x6b, 0x52, 0x53, 0x74, 0x35, 0xfa, 0x68, 0x75, 0x7a, 0x12, 0x55, 0xf3, 0xac, 0x7b, 0xf5, 0x3e, 0xc5, 0x7c,
    0x3a, 0x7b, 0xfe, 0x98, 0xed, 0xe8, 0x7b, 0x15, 0x2f, 0x96, 0x16, 0xa2, 0xba, 0xde, 0xa5, 0x1a, 0xef, 0xf0, 0x21, 0x9e,
    0x74, 0xfa, 0x75, 0x38, 0xf7, 0xeb, 0x7d, 0x94, 0xa2, 0xa3, 0x1a, 0x1e, 0x2f, 0x99, 0x63, 0xb6, 0x15, 0x5c, 0x5e, 0xc5,
    0x8b, 0xa5, 0x36, 0xf0, 0xa9, 0x53, 0x9a, 0x68, 0xd1, 0xfd, 0xeb, 0x27, 0xdd, 0xcd, 0xf0, 0x0d, 0xba, 0x5b, 0xef, 0xa3,
    0x6b, 0x4e, 0x29, 0x1d, 0x48, 0x95, 0x3b, 0x60, 0x75, 0xb2, 0xaa, 0xae, 0x31, 0x2f, 0x01, 0xe5, 0x48, 0x44, 0xd7, 0xe2,
    0x75, 0x32, 0x53, 0xc7, 0x57, 0x0d, 0x9c, 0xf6, 0x24, 0xf2, 0x39, 0x0d, 0xdd, 0xaf, 0xf7, 0xe9, 0xa6, 0xcb, 0x54, 0x56,
    0xee, 0x20, 0xe2, 0x03, 0xb7, 0xe7, 0xcf, 0xe3, 0xab, 0xd5, 0xa7, 0x3c, 0x83, 0xbc, 0xc7, 0x17, 0xe9, 0xe3, 0x34, 0x8c,
    0xec, 0xf8, 0x13, 0x72, 0xf7, 0xbe, 0xac, 0xce, 0xaa, 0x7a, 0x18, 0x37, 0x66, 0x95, 0xb4, 0x72, 0x24, 0xd2, 0xb2, 0xec,
    0x54, 0x57, 0xcb, 0x3a, 0xfe, 0xdc, 0xdc, 0xbd, 0x37, 0xfe, 0xe3, 0xf6, 0xf8, 0xdb, 0x2a, 0x39, 0x5f, 0x0b, 0xf1, 0xf7,
    0xc6, 0xbf, 0x27, 0xde, 0xff, 0x63, 0xf1, 0xd7, 0x2a, 0x39, 0x7f, 0xcb, 0x15, 0xf1, 0x1f, 0x66, 0xe5, 0xbc, 0x77, 0x8b,
    0x7f, 0xb9, 0x59, 0x55, 0x90, 0x5b, 0xc5, 0xf3, 0xfc, 0xf8, 0xc7, 0x54, 0x1d, 0xe5, 0xe6, 0x16, 0xbf, 0x6e, 0xe3, 0x9a,
    0xf7, 0xcf, 0xaf, 0xe2, 0x79, 0xee, 0xf1, 0x68, 0xfc, 0xf3, 0xe7, 0x38, 0x52, 0x7c, 0xab, 0xda, 0x45, 0x71, 0x01, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb4, 0x3f, 0x35, 0x49, 0x99, 0x12, 0x75, 0xa8, 0xb9, 0xd7, 0x73, 0xc7, 0xf2, 0x17,
    0xd2, 0x2d, 0xd9, 0x33, 0xf2, 0x6a, 0xaa, 0x72, 0x7c, 0x80, 0x2c, 0xcd, 0x40, 0x95, 0x1a, 0x1c, 0x7f, 0x06, 0xdc, 0xd6,
    0x06, 0xb5, 0x80, 0x06, 0xa7, 0x1a, 0x1a, 0x9c, 0xe6, 0xf2, 0xdc, 0xe8, 0x86, 0xbf, 0x90, 0xe5, 0xac, 0x90, 0x39, 0x23,
    0x3d, 0xee, 0x26, 0x76, 0x45, 0x13, 0x7a, 0xaa, 0x9a, 0x74, 0xfd, 0x6b, 0x9d, 0x49, 0x34, 0x03, 0x1e, 0xd3, 0xe0, 0x34,
    0x97, 0x06, 0xc7, 0xaa, 0x1d, 0x55, 0x77, 0x6a, 0x73, 0xe9, 0x9c, 0x4a, 0xae, 0x8b, 0x90, 0x6f, 0xdc, 0x7a, 0x05, 0xe6,
    0xf5, 0x54, 0xd7, 0xfd, 0x16, 0xb6, 0x08, 0xa5, 0x5b, 0xe4, 0x0e, 0x1b, 0x69, 0xd1, 0x7e, 0x10, 0x56, 0xcd, 0xbe, 0x48,
    0xfd, 0xa2, 0xdc, 0x71, 0x5b, 0x75, 0xf8, 0x8a, 0xc3, 0xd9, 0x2a, 0x33, 0x6b, 0x16, 0x73, 0xaf, 0xd9, 0xae, 0x97, 0x93,
    0x5b, 0x07, 0x48, 0xb7, 0x14, 0xe9, 0x91, 0x52, 0xcc, 0x4a, 0x54, 0xdd, 0x5d, 0x05, 0x27, 0x5b, 0x3b, 0x54, 0x0c, 0x95,
    0xe0, 0xfc, 0x7d, 0x29, 0x33, 0x6b, 0x16, 0x73, 0xaf, 0x59, 0x8c, 0xd5, 0x3f, 0xbf, 0x65, 0x84, 0xaa, 0x4a, 0xd9, 0x99,
    0xb3, 0x7e, 0x89, 0x8b, 0x50, 0x37, 0xf4, 0x36, 0x77, 0xc4, 0x7f, 0x7f, 0xbd, 0xfc, 0x77, 0x86, 0x6b, 0xae, 0x23, 0xef,
    0x0e, 0x8c, 0x7a, 0x6e, 0x44, 0x94, 0x93, 0x96, 0xc7, 0x99, 0xcf, 0x61, 0xed, 0xec, 0xf8, 0x97, 0x9d, 0xfb, 0xbf, 0x76,
    0xf1, 0x1a, 0xb7, 0x6a, 0x30, 0xfc, 0xf7, 0xeb, 0x3c, 0xdf, 0xbb, 0x23, 0x2d, 0x76, 0x1d, 0xbe, 0xf3, 0xe2, 0x9f, 0xa9,
    0x26, 0xb9, 0x56, 0x67, 0x32, 0x92, 0x94, 0x4e, 0x4f, 0x98, 0x91, 0x77, 0xa7, 0xe5, 0xc5, 0xff, 0xa7, 0xa8, 0x49, 0x50,
    0xc7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xcf, 0xd5, 0xff, 0xf8, 0x3c, 0x78, 0x9e, 0xec, 0xb3, 0x93, 0xe7,
    0x40, 0x94, 0xad, 0xe2, 0x89, 0xa9, 0xa9, 0x96, 0x03, 0x95, 0xbd, 0xe6, 0xf5, 0x3f, 0x4d, 0xaa, 0x5b, 0x54, 0xed, 0xaa,
    0x7a, 0x81, 0x22, 0x26, 0xa2, 0xf1, 0x51, 0x47, 0xad, 0xdc, 0xcf, 0x35, 0x2a, 0x1e, 0xdd, 0xdb, 0xd8, 0xd1, 0x66, 0xb5,
    0x93, 0x9f, 0x58, 0x16, 0x63, 0xf6, 0x55, 0xee, 0x98, 0xf6, 0x48, 0x8d, 0x4f, 0x44, 0x5d, 0x91, 0xab, 0xe2, 0xd1, 0x2b,
    0xda, 0xa4, 0xc2, 0xc0, 0xae, 0xbf, 0x58, 0x4e, 0x7f, 0x2e, 0xae, 0xc7, 0xdb, 0x6f, 0x54, 0xf2, 0x44, 0xb4, 0x32, 0xdd,
    0x54, 0xf1, 0x74, 0x57, 0xc4, 0x22, 0x2d, 0x7b, 0xd9, 0xd4, 0x92, 0xa8, 0xa6, 0x3b, 0x37, 0xfe, 0x11, 0x85, 0xc5, 0x13,
    0x7c, 0x76, 0x8a, 0xe1, 0x72, 0xf2, 0x8e, 0xb5, 0x60, 0xee, 0x8a, 0xff, 0x7b, 0xae, 0x98, 0xed, 0x4a, 0xf1, 0x6e, 0x51,
    0x1e, 0x41, 0xc5, 0x4a, 0x4e, 0xfc, 0x9f, 0xbd, 0x2e, 0x79, 0x3e, 0x1b, 0xd7, 0x8c, 0x2c, 0xa6, 0x09, 0xbb, 0x22, 0x63,
    0x3d, 0x12, 0xaf, 0x98, 0xbb, 0x35, 0x3e, 0x11, 0x9f, 0x8d, 0xab, 0xd4, 0x47, 0x51, 0x9d, 0xc5, 0x3d, 0x55, 0x9d, 0x62,
    0x57, 0xcc, 0xdd, 0x1a, 0x9f, 0x27, 0xab, 0x78, 0xfc, 0x6a, 0x3a, 0xad, 0x58, 0x87, 0x77, 0x43, 0xc7, 0xb2, 0xb1, 0x3a,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x61, 0xd6, 0x3f,
    0xac, 0x03, 0xf1, 0x87, 0x1f, 0x1b, 0xff, 0x7f, 0x01 };

// Font glyphs rectangles data (on atlas)
static const Rectangle bluishFontRecs[189] = {
    { 4, 4, 5 , 10 },
    { 17, 4, 2 , 8 },
    { 27, 4, 4 , 3 },
    { 39, 4, 6 , 8 },
    { 53, 4, 5 , 10 },
    { 66, 4, 6 , 8 },
    { 80, 4, 5 , 10 },
    { 93, 4, 2 , 3 },
    { 103, 4, 3 , 8 },
    { 114, 4, 3 , 8 },
    { 125, 4, 6 , 6 },
    { 139, 4, 6 , 6 },
    { 153, 4, 2 , 3 },
    { 163, 4, 5 , 2 },
    { 176, 4, 2 , 2 },
    { 186, 4, 6 , 8 },
    { 200, 4, 5 , 8 },
    { 213, 4, 3 , 8 },
    { 224, 4, 5 , 8 },
    { 237, 4, 5 , 8 },
    { 4, 22, 5 , 8 },
    { 17, 22, 5 , 8 },
    { 30, 22, 5 , 8 },
    { 43, 22, 5 , 8 },
    { 56, 22, 5 , 8 },
    { 69, 22, 5 , 8 },
    { 82, 22, 2 , 8 },
    { 92, 22, 2 , 9 },
    { 102, 22, 4 , 6 },
    { 114, 22, 5 , 4 },
    { 127, 22, 4 , 6 },
    { 139, 22, 5 , 8 },
    { 152, 22, 6 , 8 },
    { 166, 22, 5 , 8 },
    { 179, 22, 5 , 8 },
    { 192, 22, 5 , 8 },
    { 205, 22, 5 , 8 },
    { 218, 22, 5 , 8 },
    { 231, 22, 5 , 8 },
    { 4, 40, 5 , 8 },
    { 17, 40, 5 , 8 },
    { 30, 40, 4 , 8 },
    { 42, 40, 5 , 8 },
    { 55, 40, 5 , 8 },
    { 68, 40, 5 , 8 },
    { 81, 40, 8 , 8 },
    { 97, 40, 5 , 8 },
    { 110, 40, 5 , 8 },
    { 123, 40, 5 , 8 },
    { 136, 40, 5 , 9 },
    { 149, 40, 5 , 8 },
    { 162, 40, 5 , 8 },
    { 175, 40, 6 , 8 },
    { 189, 40, 5 , 8 },
    { 202, 40, 5 , 8 },
    { 215, 40, 8 , 8 },
    { 231, 40, 5 , 8 },
    { 4, 58, 5 , 8 },
    { 17, 58, 5 , 8 },
    { 30, 58, 3 , 8 },
    { 41, 58, 6 , 8 },
    { 55, 58, 3 , 8 },
    { 66, 58, 6 , 4 },
    { 80, 58, 5 , 1 },
    { 93, 58, 2 , 3 },
    { 103, 58, 5 , 6 },
    { 116, 58, 5 , 8 },
    { 129, 58, 5 , 6 },
    { 142, 58, 5 , 8 },
    { 155, 58, 5 , 6 },
    { 168, 58, 5 , 8 },
    { 181, 58, 5 , 7 },
    { 194, 58, 5 , 8 },
    { 207, 58, 2 , 8 },
    { 217, 58, 3 , 9 },
    { 228, 58, 5 , 8 },
    { 241, 58, 2 , 8 },
    { 4, 76, 8 , 6 },
    { 20, 76, 5 , 6 },
    { 33, 76, 5 , 6 },
    { 46, 76, 5 , 7 },
    { 59, 76, 5 , 7 },
    { 72, 76, 5 , 6 },
    { 85, 76, 5 , 6 },
    { 98, 76, 5 , 8 },
    { 111, 76, 5 , 6 },
    { 124, 76, 5 , 6 },
    { 137, 76, 8 , 6 },
    { 153, 76, 5 , 6 },
    { 166, 76, 5 , 7 },
    { 179, 76, 5 , 6 },
    { 192, 76, 4 , 8 },
    { 204, 76, 2 , 10 },
    { 214, 76, 4 , 8 },
    { 226, 76, 6 , 4 },
    { 240, 76, 2 , 8 },
    { 4, 94, 5 , 8 },
    { 17, 94, 5 , 8 },
    { 30, 94, 0 , 0 },
    { 38, 94, 6 , 8 },
    { 52, 94, 5 , 10 },
    { 65, 94, 5 , 10 },
    { 78, 94, 5 , 9 },
    { 91, 94, 7 , 8 },
    { 106, 94, 4 , 6 },
    { 118, 94, 5 , 4 },
    { 131, 94, 5 , 3 },
    { 144, 94, 7 , 8 },
    { 159, 94, 5 , 2 },
    { 172, 94, 4 , 4 },
    { 184, 94, 6 , 8 },
    { 198, 94, 4 , 6 },
    { 210, 94, 4 , 6 },
    { 222, 94, 0 , 0 },
    { 230, 94, 5 , 9 },
    { 4, 112, 6 , 8 },
    { 18, 112, 2 , 2 },
    { 28, 112, 0 , 0 },
    { 36, 112, 3 , 6 },
    { 47, 112, 4 , 6 },
    { 59, 112, 5 , 4 },
    { 72, 112, 6 , 8 },
    { 86, 112, 6 , 6 },
    { 100, 112, 5 , 10 },
    { 113, 112, 5 , 8 },
    { 126, 112, 5 , 10 },
    { 139, 112, 5 , 10 },
    { 152, 112, 5 , 10 },
    { 165, 112, 5 , 10 },
    { 178, 112, 5 , 10 },
    { 191, 112, 5 , 10 },
    { 204, 112, 6 , 8 },
    { 218, 112, 5 , 9 },
    { 231, 112, 5 , 10 },
    { 4, 130, 5 , 10 },
    { 17, 130, 5 , 10 },
    { 30, 130, 5 , 10 },
    { 43, 130, 4 , 10 },
    { 55, 130, 4 , 10 },
    { 67, 130, 4 , 10 },
    { 79, 130, 4 , 10 },
    { 91, 130, 6 , 8 },
    { 105, 130, 5 , 10 },
    { 118, 130, 5 , 10 },
    { 131, 130, 5 , 10 },
    { 144, 130, 5 , 10 },
    { 157, 130, 5 , 10 },
    { 170, 130, 5 , 10 },
    { 183, 130, 4 , 4 },
    { 195, 130, 5 , 10 },
    { 208, 130, 5 , 10 },
    { 221, 130, 5 , 10 },
    { 234, 130, 5 , 10 },
    { 4, 148, 5 , 10 },
    { 17, 148, 5 , 10 },
    { 30, 148, 5 , 8 },
    { 43, 148, 5 , 8 },
    { 56, 148, 5 , 9 },
    { 69, 148, 5 , 9 },
    { 82, 148, 5 , 9 },
    { 95, 148, 5 , 9 },
    { 108, 148, 5 , 8 },
    { 121, 148, 5 , 10 },
    { 134, 148, 6 , 6 },
    { 148, 148, 5 , 7 },
    { 161, 148, 5 , 9 },
    { 174, 148, 5 , 9 },
    { 187, 148, 5 , 9 },
    { 200, 148, 5 , 8 },
    { 213, 148, 3 , 9 },
    { 224, 148, 3 , 9 },
    { 235, 148, 4 , 9 },
    { 4, 166, 4 , 8 },
    { 16, 166, 5 , 9 },
    { 29, 166, 5 , 9 },
    { 42, 166, 5 , 9 },
    { 55, 166, 5 , 9 },
    { 68, 166, 5 , 9 },
    { 81, 166, 5 , 9 },
    { 94, 166, 5 , 8 },
    { 107, 166, 4 , 6 },
    { 119, 166, 5 , 8 },
    { 132, 166, 5 , 9 },
    { 145, 166, 5 , 9 },
    { 158, 166, 5 , 9 },
    { 171, 166, 5 , 8 },
    { 184, 166, 5 , 10 },
    { 197, 166, 5 , 10 },
    { 210, 166, 5 , 9 },
};

// Font glyphs info data
// NOTE: No glyphs.image data provided
static const GlyphInfo bluishFontGlyphs[189] = {
    { 32, 0, 0, 5, { 0 }},
    { 33, 0, 1, 2, { 0 }},
    { 34, 0, 1, 4, { 0 }},
    { 35, 0, 1, 6, { 0 }},
    { 36, 0, 0, 5, { 0 }},
    { 37, 0, 1, 6, { 0 }},
    { 38, 0, 0, 5, { 0 }},
    { 39, 0, 1, 2, { 0 }},
    { 40, 0, 1, 3, { 0 }},
    { 41, 0, 1, 3, { 0 }},
    { 42, 0, 1, 6, { 0 }},
    { 43, 0, 2, 6, { 0 }},
    { 44, 0, 7, 2, { 0 }},
    { 45, 0, 4, 5, { 0 }},
    { 46, 0, 7, 2, { 0 }},
    { 47, 0, 1, 6, { 0 }},
    { 48, 0, 1, 5, { 0 }},
    { 49, 0, 1, 3, { 0 }},
    { 50, 0, 1, 5, { 0 }},
    { 51, 0, 1, 5, { 0 }},
    { 52, 0, 1, 5, { 0 }},
    { 53, 0, 1, 5, { 0 }},
    { 54, 0, 1, 5, { 0 }},
    { 55, 0, 1, 5, { 0 }},
    { 56, 0, 1, 5, { 0 }},
    { 57, 0, 1, 5, { 0 }},
    { 58, 0, 1, 2, { 0 }},
    { 59, 0, 1, 2, { 0 }},
    { 60, 0, 2, 4, { 0 }},
    { 61, 0, 3, 5, { 0 }},
    { 62, 0, 2, 4, { 0 }},
    { 63, 0, 1, 5, { 0 }},
    { 64, 0, 1, 6, { 0 }},
    { 65, 0, 1, 5, { 0 }},
    { 66, 0, 1, 5, { 0 }},
    { 67, 0, 1, 5, { 0 }},
    { 68, 0, 1, 5, { 0 }},
    { 69, 0, 1, 5, { 0 }},
    { 70, 0, 1, 5, { 0 }},
    { 71, 0, 1, 5, { 0 }},
    { 72, 0, 1, 5, { 0 }},
    { 73, 0, 1, 4, { 0 }},
    { 74, 0, 1, 5, { 0 }},
    { 75, 0, 1, 5, { 0 }},
    { 76, 0, 1, 5, { 0 }},
    { 77, 0, 1, 8, { 0 }},
    { 78, 0, 1, 5, { 0 }},
    { 79, 0, 1, 5, { 0 }},
    { 80, 0, 1, 5, { 0 }},
    { 81, 0, 1, 5, { 0 }},
    { 82, 0, 1, 5, { 0 }},
    { 83, 0, 1, 5, { 0 }},
    { 84, 0, 1, 6, { 0 }},
    { 85, 0, 1, 5, { 0 }},
    { 86, 0, 1, 5, { 0 }},
    { 87, 0, 1, 8, { 0 }},
    { 88, 0, 1, 5, { 0 }},
    { 89, 0, 1, 5, { 0 }},
    { 90, 0, 1, 5, { 0 }},
    { 91, 0, 1, 3, { 0 }},
    { 92, 0, 1, 6, { 0 }},
    { 93, 0, 1, 3, { 0 }},
    { 94, 0, 1, 6, { 0 }},
    { 95, 0, 9, 5, { 0 }},
    { 96, 0, 1, 2, { 0 }},
    { 97, 0, 3, 5, { 0 }},
    { 98, 0, 1, 5, { 0 }},
    { 99, 0, 3, 5, { 0 }},
    { 100, 0, 1, 5, { 0 }},
    { 101, 0, 3, 5, { 0 }},
    { 102, 0, 1, 5, { 0 }},
    { 103, 0, 3, 5, { 0 }},
    { 104, 0, 1, 5, { 0 }},
    { 105, 0, 1, 2, { 0 }},
    { 106, 0, 1, 3, { 0 }},
    { 107, 0, 1, 5, { 0 }},
    { 108, 0, 1, 2, { 0 }},
    { 109, 0, 3, 8, { 0 }},
    { 110, 0, 3, 5, { 0 }},
    { 111, 0, 3, 5, { 0 }},
    { 112, 0, 3, 5, { 0 }},
    { 113, 0, 3, 5, { 0 }},
    { 114, 0, 3, 5, { 0 }},
    { 115, 0, 3, 5, { 0 }},
    { 116, 0, 1, 5, { 0 }},
    { 117, 0, 3, 5, { 0 }},
    { 118, 0, 3, 5, { 0 }},
    { 119, 0, 3, 8, { 0 }},
    { 120, 0, 3, 5, { 0 }},
    { 121, 0, 3, 5, { 0 }},
    { 122, 0, 3, 5, { 0 }},
    { 123, 0, 1, 4, { 0 }},
    { 124, 0, 0, 2, { 0 }},
    { 125, 0, 1, 4, { 0 }},
    { 126, 0, 3, 6, { 0 }},
    { 161, 0, 1, 2, { 0 }},
    { 162, 0, 2, 5, { 0 }},
    { 163, 0, 1, 5, { 0 }},
    { 8364, 0, 0, 0, { 0 }},
    { 165, 0, 1, 6, { 0 }},
    { 352, 0, -1, 5, { 0 }},
    { 167, 0, 0, 5, { 0 }},
    { 353, 0, 0, 5, { 0 }},
    { 169, 0, 1, 7, { 0 }},
    { 170, 0, -1, 4, { 0 }},
    { 171, 0, 3, 5, { 0 }},
    { 172, 0, 4, 5, { 0 }},
    { 174, 0, 1, 7, { 0 }},
    { 175, 0, -1, 5, { 0 }},
    { 176, 0, -1, 4, { 0 }},
    { 177, 0, 1, 6, { 0 }},
    { 178, 0, -1, 4, { 0 }},
    { 179, 0, -1, 4, { 0 }},
    { 381, 0, 0, 0, { 0 }},
    { 181, 0, 1, 5, { 0 }},
    { 182, 0, 1, 6, { 0 }},
    { 183, 0, 4, 2, { 0 }},
    { 382, 0, 0, 0, { 0 }},
    { 185, 0, -1, 3, { 0 }},
    { 186, 0, -1, 4, { 0 }},
    { 187, 0, 3, 5, { 0 }},
    { 338, 0, 1, 6, { 0 }},
    { 339, 0, 3, 6, { 0 }},
    { 376, 0, -1, 5, { 0 }},
    { 191, 0, 1, 5, { 0 }},
    { 192, 0, -1, 5, { 0 }},
    { 193, 0, -1, 5, { 0 }},
    { 194, 0, -1, 5, { 0 }},
    { 195, 0, -1, 5, { 0 }},
    { 196, 0, -1, 5, { 0 }},
    { 197, 0, -1, 5, { 0 }},
    { 198, 0, 1, 6, { 0 }},
    { 199, 0, 1, 5, { 0 }},
    { 200, 0, -1, 5, { 0 }},
    { 201, 0, -1, 5, { 0 }},
    { 202, 0, -1, 5, { 0 }},
    { 203, 0, -1, 5, { 0 }},
    { 204, 0, -1, 4, { 0 }},
    { 205, 0, -1, 4, { 0 }},
    { 206, 0, -1, 4, { 0 }},
    { 207, 0, -1, 4, { 0 }},
    { 208, 0, 1, 6, { 0 }},
    { 209, 0, -1, 5, { 0 }},
    { 210, 0, -1, 5, { 0 }},
    { 211, 0, -1, 5, { 0 }},
    { 212, 0, -1, 5, { 0 }},
    { 213, 0, -1, 5, { 0 }},
    { 214, 0, -1, 5, { 0 }},
    { 215, 0, 3, 4, { 0 }},
    { 216, 0, 0, 5, { 0 }},
    { 217, 0, -1, 5, { 0 }},
    { 218, 0, -1, 5, { 0 }},
    { 219, 0, -1, 5, { 0 }},
    { 220, 0, -1, 5, { 0 }},
    { 221, 0, -1, 5, { 0 }},
    { 222, 0, 1, 5, { 0 }},
    { 223, 0, 1, 5, { 0 }},
    { 224, 0, 0, 5, { 0 }},
    { 225, 0, 0, 5, { 0 }},
    { 226, 0, 0, 5, { 0 }},
    { 227, 0, 0, 5, { 0 }},
    { 228, 0, 1, 5, { 0 }},
    { 229, 0, -1, 5, { 0 }},
    { 230, 0, 3, 6, { 0 }},
    { 231, 0, 3, 5, { 0 }},
    { 232, 0, 0, 5, { 0 }},
    { 233, 0, 0, 5, { 0 }},
    { 234, 0, 0, 5, { 0 }},
    { 235, 0, 1, 5, { 0 }},
    { 236, 0, 0, 3, { 0 }},
    { 237, 0, 0, 2, { 0 }},
    { 238, 0, 0, 3, { 0 }},
    { 239, 0, 1, 3, { 0 }},
    { 240, 0, 0, 5, { 0 }},
    { 241, 0, 0, 5, { 0 }},
    { 242, 0, 0, 5, { 0 }},
    { 243, 0, 0, 5, { 0 }},
    { 244, 0, 0, 5, { 0 }},
    { 245, 0, 0, 5, { 0 }},
    { 246, 0, 1, 5, { 0 }},
    { 247, 0, 2, 4, { 0 }},
    { 248, 0, 2, 5, { 0 }},
    { 249, 0, 0, 5, { 0 }},
    { 250, 0, 0, 5, { 0 }},
    { 251, 0, 0, 5, { 0 }},
    { 252, 0, 1, 5, { 0 }},
    { 253, 0, 0, 5, { 0 }},
    { 254, 0, 0, 5, { 0 }},
    { 255, 0, 1, 5, { 0 }},
};

// Style loading function: Bluish
static void GuiLoadStyleBluish(void)
{
    // Load style properties provided
    // NOTE: Default properties are propagated
    for (int i = 0; i < BLUISH_STYLE_PROPS_COUNT; i++)
    {
        GuiSetStyle(bluishStyleProps[i].controlId, bluishStyleProps[i].propertyId, bluishStyleProps[i].propertyValue);
    }

    // Custom font loading
    // NOTE: Compressed font image data (DEFLATE), it requires DecompressData() function
    int bluishFontDataSize = 0;
    unsigned char *data = DecompressData(bluishFontData, BLUISH_STYLE_FONT_ATLAS_COMP_SIZE, &bluishFontDataSize);
    Image imFont = { data, 256, 256, 1, 2 };

    Font font = { 0 };
    font.baseSize = 10;
    font.glyphCount = 189;

    // Load texture from image
    font.texture = LoadTextureFromImage(imFont);
    UnloadImage(imFont);  // Uncompressed image data can be unloaded from memory

    // Copy char recs data from global fontRecs
    // NOTE: Required to avoid issues if trying to free font
    font.recs = (Rectangle *)RAYGUI_MALLOC(font.glyphCount*sizeof(Rectangle));
    memcpy(font.recs, bluishFontRecs, font.glyphCount*sizeof(Rectangle));

    // Copy font char info data from global fontChars
    // NOTE: Required to avoid issues if trying to free font
    font.glyphs = (GlyphInfo *)RAYGUI_MALLOC(font.glyphCount*sizeof(GlyphInfo));
    memcpy(font.glyphs, bluishFontGlyphs, font.glyphCount*sizeof(GlyphInfo));

    GuiSetFont(font);

    // Setup a white rectangle on the font to be used on shapes drawing,
    // it makes possible to draw shapes and text (full UI) in a single draw call
    Rectangle fontWhiteRec = { 254, 254, 1, 1 };
    SetShapesTexture(font.texture, fontWhiteRec);

    //-----------------------------------------------------------------

    // TODO: Custom user style setup: Set specific properties here (if required)
    // i.e. Controls specific BORDER_WIDTH, TEXT_PADDING, TEXT_ALIGNMENT
}
