//////////////////////////////////////////////////////////////////////////////////
//                                                                              //
// StyleAsCode exporter v2.0 - Style data exported as a values array            //
//                                                                              //
// USAGE: On init call: GuiLoadStyleCandy();                                   //
//                                                                              //
// more info and bugs-report:  github.com/raysan5/raygui                        //
// feedback and support:       ray[at]raylibtech.com                            //
//                                                                              //
// Copyright (c) 2020-2025 raylib technologies (@raylibtech)                    //
//                                                                              //
//////////////////////////////////////////////////////////////////////////////////

#define CANDY_STYLE_PROPS_COUNT  17

// Custom style name: Candy
static const GuiStyleProp candyStyleProps[CANDY_STYLE_PROPS_COUNT] = {
    { 0, 0, (int)0xe58b68ff },    // DEFAULT_BORDER_COLOR_NORMAL 
    { 0, 1, (int)0xfeda96ff },    // DEFAULT_BASE_COLOR_NORMAL 
    { 0, 2, (int)0xe59b5fff },    // DEFAULT_TEXT_COLOR_NORMAL 
    { 0, 3, (int)0xee813fff },    // DEFAULT_BORDER_COLOR_FOCUSED 
    { 0, 4, (int)0xfcd85bff },    // DEFAULT_BASE_COLOR_FOCUSED 
    { 0, 5, (int)0xfc6955ff },    // DEFAULT_TEXT_COLOR_FOCUSED 
    { 0, 6, (int)0xb34848ff },    // DEFAULT_BORDER_COLOR_PRESSED 
    { 0, 7, (int)0xeb7272ff },    // DEFAULT_BASE_COLOR_PRESSED 
    { 0, 8, (int)0xbd4a4aff },    // DEFAULT_TEXT_COLOR_PRESSED 
    { 0, 9, (int)0x94795dff },    // DEFAULT_BORDER_COLOR_DISABLED 
    { 0, 10, (int)0xc2a37aff },    // DEFAULT_BASE_COLOR_DISABLED 
    { 0, 11, (int)0x9c8369ff },    // DEFAULT_TEXT_COLOR_DISABLED 
    { 0, 16, (int)0x0000000f },    // DEFAULT_TEXT_SIZE 
    { 0, 17, (int)0x00000000 },    // DEFAULT_TEXT_SPACING 
    { 0, 18, (int)0xd77575ff },    // DEFAULT_LINE_COLOR 
    { 0, 19, (int)0xfff5e1ff },    // DEFAULT_BACKGROUND_COLOR 
    { 0, 20, (int)0x00000016 },    // DEFAULT_TEXT_LINE_SPACING 
};

// WARNING: This style uses a custom font: "v5easter.ttf" (size: 15, spacing: 0)

#define CANDY_STYLE_FONT_ATLAS_COMP_SIZE 2110

// Font atlas image pixels data: DEFLATE compressed
static unsigned char candyFontData[CANDY_STYLE_FONT_ATLAS_COMP_SIZE] = { 0xed,
    0xdd, 0x5b, 0x76, 0xa4, 0x36, 0x10, 0x00, 0x50, 0xad, 0x2b, 0xfb, 0xdf, 0x97, 0x72, 0x92, 0x7c, 0xe4, 0xcc, 0x8c, 0x1b,
    0x54, 0xa5, 0x12, 0x08, 0xfa, 0xfa, 0xfe, 0x19, 0xbb, 0x1b, 0x10, 0xa5, 0x07, 0xa0, 0x52, 0x6f, 0x00, 0x00, 0x00, 0xc0,
    0x97, 0xfb, 0xe7, 0xe7, 0xcf, 0xdf, 0xb5, 0x1f, 0x7e, 0xfb, 0xff, 0xdf, 0xf6, 0x1f, 0xb7, 0x1e, 0x6d, 0xc9, 0xff, 0xe7,
    0xf1, 0x9e, 0x8c, 0x7d, 0x42, 0x3b, 0xd8, 0x72, 0xbe, 0xcf, 0xbf, 0xff, 0xae, 0x97, 0x7c, 0xfb, 0xa7, 0xcf, 0x39, 0xdb,
    0xa3, 0xcc, 0xb6, 0xa3, 0x4f, 0xed, 0x07, 0xc7, 0xd4, 0x06, 0xb6, 0xf4, 0xd4, 0xd1, 0xf5, 0xe9, 0x52, 0x8d, 0x95, 0xce,
    0xf9, 0xf1, 0xb7, 0xf0, 0x31, 0xb6, 0x05, 0xdb, 0xfa, 0x64, 0x19, 0xaf, 0x8c, 0xff, 0xdf, 0x7f, 0x2a, 0xe3, 0xff, 0xf8,
    0x33, 0x67, 0xae, 0x89, 0xff, 0x8f, 0xa6, 0x17, 0xc4, 0x7f, 0xbc, 0x16, 0x39, 0x3e, 0x82, 0xcf, 0x57, 0x71, 0x0b, 0xff,
    0xcf, 0x79, 0xfd, 0x5a, 0xf9, 0xa9, 0x2b, 0xb7, 0x8d, 0x45, 0xed, 0xfc, 0x75, 0x7e, 0xb6, 0x37, 0x73, 0x65, 0x78, 0xe5,
    0xb6, 0xda, 0xf8, 0x3f, 0xfb, 0xdb, 0x6c, 0xcd, 0x9e, 0xef, 0x1d, 0x8c, 0xb6, 0xe6, 0x3d, 0x74, 0xed, 0x9f, 0xb7, 0x62,
    0x35, 0x67, 0x38, 0x7a, 0xc4, 0xc7, 0x75, 0xc9, 0xd9, 0xd6, 0xf9, 0x36, 0x37, 0x72, 0x6d, 0xdc, 0x71, 0x15, 0x9f, 0x97,
    0x66, 0x45, 0xbb, 0xd4, 0x7f, 0x39, 0xdb, 0xe2, 0x7f, 0xf4, 0xaa, 0xed, 0x8b, 0x5b, 0xda, 0x16, 0x6e, 0x69, 0x73, 0x7d,
    0x96, 0xba, 0x33, 0x5c, 0x15, 0xff, 0x7d, 0x22, 0xfa, 0x5b, 0xa2, 0xc7, 0x79, 0x5c, 0x6b, 0x9f, 0xed, 0x7f, 0xf6, 0x2a,
    0xa9, 0xbd, 0x66, 0x67, 0xe3, 0xff, 0xb8, 0x3f, 0xdc, 0x0e, 0xeb, 0x9b, 0xeb, 0x7a, 0x5c, 0x3b, 0xc5, 0x7f, 0xb6, 0x87,
    0x3c, 0x3e, 0xba, 0xa9, 0x6b, 0xff, 0xd7, 0xc7, 0xff, 0x59, 0x44, 0xf6, 0xe0, 0x48, 0xb5, 0xb6, 0x35, 0x1e, 0x19, 0x4f,
    0x67, 0x6b, 0xf4, 0xf8, 0x18, 0xf7, 0xfa, 0xfe, 0xff, 0xf9, 0xb8, 0xb1, 0x2f, 0x1b, 0x39, 0xd5, 0x47, 0xd8, 0xbe, 0xfd,
    0xff, 0xb1, 0x7e, 0xc1, 0x9a, 0xfe, 0xff, 0xd9, 0xf8, 0xbf, 0x5d, 0xde, 0xfa, 0x9f, 0x45, 0x56, 0xbe, 0xf4, 0x7b, 0xaa,
    0x07, 0x34, 0x77, 0x57, 0x21, 0x57, 0x9e, 0x73, 0xf1, 0xbf, 0xa2, 0x0f, 0x10, 0x1d, 0xfd, 0xbd, 0xa3, 0xff, 0x9f, 0x39,
    0x83, 0xd9, 0xfb, 0xcc, 0x55, 0x47, 0x16, 0xbf, 0xcf, 0x7f, 0xdf, 0x19, 0xab, 0xab, 0xe7, 0x67, 0xcf, 0x60, 0xfd, 0xa7,
    0xe6, 0x7a, 0xd5, 0xd1, 0xab, 0xb8, 0xdf, 0xfa, 0x6c, 0xac, 0x3f, 0xe2, 0xce, 0xe9, 0x15, 0xed, 0xff, 0xd9, 0xfd, 0xff,
    0x99, 0xbb, 0x03, 0xb1, 0x27, 0x1b, 0x7d, 0xc3, 0x6b, 0x45, 0xfc, 0x3f, 0xa5, 0x15, 0xab, 0xea, 0x55, 0xbb, 0xff, 0x97,
    0x79, 0xa6, 0x5d, 0xd1, 0x9f, 0x7b, 0x4a, 0xfc, 0xf7, 0x81, 0xda, 0x74, 0x7c, 0x4b, 0xfe, 0x89, 0xfb, 0xaa, 0xb7, 0x0a,
    0xce, 0x9e, 0x36, 0x5e, 0xf7, 0x14, 0x7b, 0xc7, 0xf8, 0x7f, 0xc6, 0xf3, 0xff, 0x3d, 0xce, 0xe5, 0xda, 0x91, 0xdc, 0x8e,
    0xf1, 0x0f, 0xdf, 0xf1, 0x36, 0xe1, 0x75, 0x6f, 0x2d, 0x8a, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x9e, 0x3e, 0x3b, 0x27, 0x9f, 0x21, 0x32, 0x36, 0xe7, 0xa6, 0x2f, 0xc9, 0x8b, 0x94, 0x9b, 0x1b, 0x7d,
    0x6d, 0x0e, 0xe7, 0x6c, 0xd6, 0xec, 0xb9, 0x79, 0xe1, 0x9f, 0xf3, 0x09, 0xcd, 0x7c, 0xee, 0xf1, 0x5c, 0xe4, 0xc8, 0xbc,
    0xec, 0x6c, 0xae, 0xf3, 0x68, 0x4e, 0xa0, 0x4c, 0xee, 0xa4, 0xd9, 0xdc, 0xe9, 0xf1, 0x23, 0xce, 0xcc, 0x60, 0x9d, 0x9d,
    0xf3, 0x76, 0x55, 0xc6, 0xe6, 0x6c, 0x9c, 0x8e, 0x65, 0xbd, 0xed, 0xe1, 0x4c, 0x75, 0xbb, 0xe5, 0x69, 0xa8, 0xce, 0x9a,
    0xb1, 0x32, 0xfe, 0xdb, 0x50, 0x6e, 0xec, 0xb1, 0xf9, 0xce, 0xbd, 0x70, 0x46, 0xfb, 0x75, 0x39, 0xf7, 0xda, 0x74, 0x99,
    0x44, 0x5b, 0xaa, 0xf7, 0xc7, 0x7f, 0xf6, 0xd8, 0xcf, 0xce, 0x6a, 0xdf, 0x36, 0x8b, 0xfd, 0x9d, 0xf1, 0x9f, 0xed, 0xdb,
    0x1d, 0xb7, 0x7c, 0xf1, 0x8c, 0x07, 0xd7, 0x64, 0xb4, 0xe9, 0x1b, 0xc5, 0x7f, 0xfc, 0xdb, 0x56, 0xce, 0x61, 0x9f, 0x6b,
    0x7b, 0x7b, 0x59, 0xfc, 0xe7, 0xfb, 0x3e, 0xbb, 0xb5, 0xf1, 0xb5, 0x59, 0x73, 0xd6, 0xc5, 0x7f, 0x2b, 0xcf, 0xca, 0xb4,
    0x67, 0xfc, 0x8f, 0xb4, 0x0f, 0x99, 0xb1, 0x41, 0xfc, 0x3f, 0xb3, 0x35, 0x6e, 0xf4, 0xdb, 0x32, 0xed, 0xff, 0xf1, 0x51,
    0x3e, 0xb9, 0xfd, 0xdf, 0x25, 0xfe, 0xdb, 0x56, 0xfd, 0xff, 0xd9, 0xab, 0x31, 0x16, 0xe7, 0xf7, 0xe5, 0x66, 0xdb, 0x7d,
    0x25, 0xa3, 0xc8, 0x19, 0x9f, 0xcd, 0x8e, 0x9c, 0xbd, 0xef, 0x50, 0xb9, 0x62, 0xd3, 0xb3, 0xee, 0x71, 0xb5, 0xaf, 0x1c,
    0xff, 0xe7, 0xef, 0xfb, 0x8a, 0xff, 0xd9, 0xfe, 0x74, 0xbb, 0x21, 0xfe, 0x57, 0x9d, 0xbb, 0x27, 0xc7, 0xff, 0x4c, 0xcf,
    0xef, 0xaa, 0xf8, 0x6f, 0x1f, 0x57, 0xa1, 0x9a, 0x8d, 0xff, 0xfc, 0xda, 0x38, 0xd1, 0x38, 0xef, 0x37, 0x3e, 0xdf, 0x5a,
    0x51, 0x07, 0xe6, 0x9f, 0x37, 0x34, 0xf1, 0xff, 0xa8, 0xf8, 0xbf, 0xbf, 0xfd, 0x1f, 0x5d, 0x5b, 0xf1, 0xbb, 0xe3, 0xbf,
    0x4d, 0xdd, 0xe3, 0x5b, 0xf1, 0x7f, 0xbb, 0xf5, 0xff, 0xab, 0xeb, 0xce, 0x6b, 0xeb, 0xd3, 0x75, 0x7d, 0xdc, 0xdc, 0xfd,
    0xa4, 0xdc, 0x6a, 0x06, 0xb9, 0xac, 0xd9, 0x6b, 0xae, 0xa9, 0x96, 0x5e, 0xc3, 0xab, 0x85, 0x6b, 0x00, 0xf1, 0xff, 0xeb,
    0x96, 0x75, 0xab, 0x23, 0xc3, 0xea, 0x78, 0x7a, 0x56, 0xfc, 0xcf, 0xbd, 0x69, 0x50, 0xbf, 0xda, 0x60, 0xbf, 0xa1, 0xfd,
    0x87, 0xb5, 0x4f, 0xd9, 0xeb, 0xfe, 0x9e, 0x8a, 0x3e, 0x3d, 0xf0, 0xbd, 0xfd, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xe0, 0x8d, 0x73, 0x05, 0x3e, 0xcf, 0xf2, 0x3c, 0xce, 0x82, 0xd1, 0x92, 0x59, 0xb0, 0xdb, 0x40,
    0xe6, 0xe4, 0x9e, 0xfc, 0xbe, 0xc8, 0x2c, 0xe5, 0xdd, 0x72, 0x11, 0x44, 0xf3, 0x23, 0x46, 0x72, 0x63, 0xb7, 0x70, 0x9e,
    0xaf, 0x6c, 0x16, 0x9b, 0x36, 0x99, 0x73, 0x34, 0x3f, 0xff, 0x2e, 0x3b, 0x83, 0x7a, 0x2c, 0xa3, 0xdb, 0xd8, 0xf7, 0xf4,
    0xa1, 0x19, 0x7e, 0xb3, 0xa5, 0x50, 0x3f, 0x27, 0xb1, 0x5d, 0x9e, 0x75, 0xe3, 0xde, 0x6c, 0x4c, 0x4f, 0xca, 0xb7, 0x1d,
    0xc9, 0xc3, 0x7b, 0x9e, 0xcf, 0x63, 0x3e, 0xfe, 0x47, 0x73, 0x0a, 0xf4, 0xc9, 0xac, 0x9f, 0xd1, 0xba, 0xe2, 0xf8, 0xbc,
    0x1c, 0xcd, 0x4d, 0x8e, 0x45, 0x7f, 0x76, 0xfe, 0xcd, 0xf9, 0x3e, 0xac, 0x9b, 0x51, 0xfd, 0x1d, 0xf1, 0x1f, 0xaf, 0x41,
    0x9f, 0x90, 0x6f, 0xbb, 0x15, 0xfc, 0xb6, 0x72, 0xe6, 0x7b, 0x36, 0xa7, 0x48, 0x36, 0xfe, 0x23, 0xb1, 0xf5, 0xb9, 0x96,
    0x6b, 0x03, 0x19, 0xd4, 0xe6, 0xbf, 0x27, 0x13, 0xff, 0x3d, 0x9c, 0x6d, 0x25, 0xdb, 0xfe, 0xc7, 0x5a, 0x97, 0x3d, 0xe3,
    0x3f, 0xd3, 0xe3, 0xec, 0x17, 0xc6, 0xff, 0x5c, 0x8e, 0xaf, 0x76, 0x79, 0xfc, 0xd7, 0xae, 0x53, 0x31, 0x36, 0x92, 0xa9,
    0xe8, 0x69, 0xff, 0x34, 0x3a, 0x3c, 0x1a, 0x19, 0xd5, 0xc5, 0x7f, 0xff, 0xe1, 0x1b, 0x57, 0xb5, 0xff, 0x55, 0x19, 0x55,
    0xfb, 0xc1, 0xfe, 0xbe, 0x21, 0xfe, 0xdb, 0x26, 0xfd, 0xff, 0xfa, 0xb5, 0xd4, 0xf6, 0x8c, 0xff, 0x78, 0x8f, 0x2b, 0xde,
    0x7a, 0xc5, 0xfa, 0x0a, 0xe7, 0x23, 0x80, 0x5e, 0x50, 0x03, 0xf4, 0xdf, 0xd6, 0xa3, 0xaa, 0x1a, 0x85, 0xc7, 0x56, 0x12,
    0xcb, 0xb5, 0xff, 0xfd, 0xb5, 0xed, 0x7f, 0xed, 0xf8, 0x7f, 0x55, 0x2e, 0xc2, 0xda, 0xf5, 0xb6, 0xaa, 0x72, 0x6d, 0xe6,
    0xfa, 0x5a, 0xd9, 0xf6, 0xff, 0xac, 0x77, 0x30, 0x13, 0xff, 0x6d, 0x32, 0x2e, 0x63, 0xf5, 0x4c, 0x7f, 0x54, 0x06, 0x8e,
    0x91, 0x35, 0xf2, 0xea, 0xae, 0xf4, 0xd1, 0x08, 0x8a, 0x6c, 0x9d, 0xcd, 0xaa, 0x36, 0xfe, 0xa4, 0x61, 0xa4, 0xa6, 0xfe,
    0xfc, 0x94, 0x62, 0xe4, 0xac, 0x54, 0x8c, 0x01, 0x77, 0xed, 0xff, 0xdf, 0xd3, 0xfe, 0x8f, 0xb4, 0xfe, 0x35, 0x79, 0xc8,
    0x7a, 0x79, 0xfe, 0x9d, 0x5e, 0xb8, 0x77, 0x75, 0x2d, 0xe4, 0x1d, 0x4f, 0x22, 0x57, 0xec, 0xd1, 0x7e, 0x59, 0xd2, 0x7a,
    0xf2, 0xce, 0xf1, 0x5e, 0xfd, 0xff, 0xfc, 0xd8, 0x2a, 0x32, 0xaa, 0xaf, 0x7b, 0xfe, 0x57, 0xdd, 0x96, 0x3e, 0x2b, 0xfb,
    0x96, 0xf8, 0xdf, 0xbb, 0x0c, 0xf6, 0x8a, 0xff, 0xd1, 0x55, 0xcc, 0x7b, 0xf9, 0x93, 0xf8, 0x67, 0xd4, 0xe0, 0xcf, 0x7d,
    0xff, 0xe7, 0xfa, 0x95, 0x47, 0xef, 0x8e, 0xff, 0xdd, 0x6a, 0x80, 0xaa, 0x15, 0xaf, 0xdb, 0xe2, 0x37, 0x43, 0xee, 0x3f,
    0x6b, 0x2b, 0x56, 0x08, 0x86, 0xb7, 0xbc, 0xbf, 0xd9, 0x5f, 0xdf, 0x6f, 0x7a, 0x62, 0x4f, 0x1b, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xd5, 0xfc, 0xbf, 0x3e, 0x39, 0x37, 0x30, 0x97, 0x59, 0xa8, 0x9d, 0xce,
    0x30, 0xed, 0xe9, 0xbf, 0x89, 0x1c, 0x4b, 0x3e, 0x67, 0x45, 0x26, 0xe7, 0x76, 0x3b, 0xc9, 0x53, 0x53, 0x73, 0x6e, 0xae,
    0x39, 0xce, 0xf3, 0xdc, 0x7a, 0xb1, 0xeb, 0x22, 0x72, 0xa6, 0xce, 0x73, 0xa6, 0x5c, 0x77, 0x1e, 0xb2, 0xe5, 0xdd, 0x4f,
    0x66, 0x73, 0xf7, 0xc3, 0x4c, 0x35, 0x15, 0xb9, 0x54, 0xce, 0x3e, 0x3f, 0x9f, 0x79, 0xaf, 0x25, 0x32, 0xae, 0xf5, 0x3f,
    0x72, 0x39, 0xf5, 0xd4, 0xdf, 0x44, 0x4b, 0x3d, 0xb7, 0x6d, 0x24, 0xa7, 0x63, 0x5d, 0x9e, 0xe8, 0xcc, 0xb9, 0x59, 0x7f,
    0x9c, 0xf1, 0xeb, 0xa2, 0x17, 0x7d, 0xc3, 0x68, 0x1e, 0x92, 0xfd, 0xcb, 0xfb, 0x3c, 0x63, 0xec, 0x5c, 0x36, 0x85, 0xd5,
    0xf1, 0x1f, 0xcb, 0xb9, 0x1a, 0xc9, 0x2b, 0x56, 0x19, 0xff, 0x7b, 0xf5, 0xc7, 0xf2, 0xab, 0x41, 0x54, 0x65, 0xd8, 0x7f,
    0xc6, 0x2c, 0xdd, 0xfc, 0x4a, 0x04, 0xcf, 0x29, 0xef, 0xd5, 0xc7, 0x37, 0x52, 0x53, 0xce, 0xe5, 0x81, 0xb8, 0x2b, 0xfe,
    0xeb, 0xfa, 0xff, 0xd9, 0xfe, 0x74, 0x66, 0x0d, 0xa4, 0xd9, 0xdc, 0x89, 0x33, 0x2b, 0x89, 0x5c, 0x7d, 0x2c, 0x73, 0xa3,
    0x82, 0x91, 0x31, 0xeb, 0x0e, 0xe7, 0x61, 0xe6, 0x1c, 0xb5, 0xc9, 0x95, 0x16, 0xce, 0x23, 0xa0, 0x0f, 0x8c, 0x4f, 0xfa,
    0x64, 0x0d, 0x13, 0x2d, 0xd1, 0xf3, 0x73, 0x55, 0x5b, 0x2f, 0xe6, 0x3e, 0x6f, 0xd7, 0x6d, 0x7d, 0x62, 0x1c, 0x73, 0xef,
    0xca, 0x45, 0x35, 0xf1, 0x3f, 0xde, 0xab, 0xdd, 0xbd, 0x4c, 0xdb, 0xc0, 0x38, 0x79, 0xff, 0xf8, 0x8f, 0xc6, 0x61, 0x65,
    0x1f, 0x77, 0x36, 0x9b, 0xf4, 0x3d, 0xdb, 0xe6, 0x57, 0x26, 0xd9, 0xfd, 0xda, 0xbe, 0x3b, 0xfe, 0xd7, 0xac, 0xfe, 0x52,
    0x7d, 0x8e, 0xce, 0x46, 0x0d, 0x55, 0xed, 0xff, 0xd9, 0x08, 0xa4, 0x6f, 0x31, 0x2e, 0x1c, 0x8b, 0xed, 0xf8, 0xfd, 0xff,
    0xb9, 0x6b, 0x65, 0xc5, 0xb6, 0xf9, 0xeb, 0x76, 0xdf, 0x18, 0xdf, 0x25, 0xfe, 0x9f, 0x50, 0x47, 0xce, 0xb4, 0xda, 0xd1,
    0xf6, 0xbf, 0x5d, 0x18, 0xff, 0x35, 0x77, 0x2a, 0x7a, 0xe1, 0x8a, 0x76, 0x4f, 0xbf, 0x56, 0xe6, 0xef, 0xff, 0xad, 0x78,
    0x02, 0xb2, 0x73, 0xfb, 0x2f, 0xfe, 0x9f, 0x16, 0xff, 0xd9, 0x67, 0xfb, 0x33, 0xfd, 0x91, 0x67, 0x8e, 0xff, 0x6b, 0xef,
    0x43, 0x3d, 0xb5, 0xff, 0xff, 0xf4, 0x32, 0x9d, 0xeb, 0xb5, 0xcb, 0x90, 0xfc, 0x4d, 0x7d, 0x83, 0xd9, 0x3b, 0x9d, 0x6f,
    0x8b, 0xff, 0x77, 0x97, 0x69, 0xf5, 0x0a, 0xe9, 0x7c, 0x4b, 0xfc, 0xb7, 0x0b, 0xdb, 0xc4, 0xf8, 0xfb, 0x86, 0xdf, 0x17,
    0xff, 0xab, 0xde, 0x91, 0x10, 0xff, 0xcf, 0x8c, 0xff, 0xd5, 0x65, 0x7a, 0xed, 0x7b, 0x0e, 0x35, 0xef, 0xff, 0xad, 0x5a,
    0xf5, 0x65, 0x87, 0xe7, 0xff, 0xcf, 0x7d, 0xf7, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb8,
    0xfb, 0x3d, 0xf7, 0xd8, 0x96, 0xe3, 0xb9, 0x48, 0xb1, 0xec, 0x7b, 0xbb, 0x67, 0x63, 0x6e, 0xb2, 0x6f, 0x87, 0x4a, 0x7f,
    0xf4, 0x7c, 0xef, 0x54, 0xbe, 0x9f, 0x4b, 0xac, 0xdf, 0x5e, 0x66, 0xb1, 0x98, 0x8a, 0x1f, 0x67, 0xc5, 0xe7, 0xe4, 0xa3,
    0xff, 0xca, 0xac, 0xd4, 0xb2, 0x6f, 0xaf, 0xce, 0xbe, 0x1d, 0x39, 0xdf, 0xfb, 0x94, 0x6f, 0x7c, 0xbe, 0xd5, 0xb5, 0x65,
    0xb6, 0xd7, 0x6c, 0xbe, 0xaa, 0x19, 0x86, 0x7b, 0xcd, 0x54, 0xec, 0x13, 0x19, 0xd5, 0xbb, 0xec, 0xdb, 0x8f, 0xe8, 0xe7,
    0x56, 0xac, 0x8c, 0xf1, 0x9e, 0x98, 0xba, 0x7b, 0x86, 0xeb, 0x73, 0xb2, 0x31, 0x8f, 0xf5, 0x61, 0x72, 0xab, 0x25, 0xbd,
    0x27, 0xfb, 0xf6, 0x4f, 0xad, 0xdd, 0xb5, 0x33, 0x6a, 0xab, 0xca, 0xf7, 0x38, 0xc7, 0xee, 0xce, 0xd9, 0x1f, 0x9e, 0x17,
    0xff, 0xbb, 0x64, 0xa5, 0x6a, 0x27, 0x25, 0x9e, 0xbf, 0xae, 0xbe, 0x29, 0xfb, 0xee, 0x3b, 0x32, 0xa8, 0xf4, 0xad, 0xae,
    0xcd, 0x77, 0xc7, 0x7f, 0x26, 0x1e, 0x57, 0x6c, 0xab, 0xc9, 0x0c, 0xff, 0xed, 0xd9, 0x77, 0xdf, 0x13, 0xff, 0x4d, 0xfc,
    0xdf, 0xde, 0xff, 0xbf, 0x6e, 0xdb, 0x7c, 0xdf, 0x60, 0xc5, 0xfd, 0xff, 0xe7, 0x65, 0xdf, 0x7d, 0x53, 0xfb, 0xbf, 0x4b,
    0xc6, 0xc4, 0x68, 0x4c, 0xf5, 0x17, 0xc4, 0xff, 0x8e, 0xed, 0xa9, 0xec, 0x9b, 0xdf, 0x11, 0xff, 0x7d, 0xc3, 0xe3, 0xea,
    0x45, 0x75, 0xd7, 0x35, 0xd7, 0x57, 0xf4, 0x2e, 0xcb, 0x2e, 0x71, 0x51, 0x7d, 0x6f, 0x70, 0xfc, 0x09, 0xfb, 0x1b, 0xb3,
    0x6f, 0xbe, 0x35, 0xdb, 0xe6, 0xca, 0xfd, 0x6b, 0xe1, 0xb5, 0xf8, 0xf3, 0x4f, 0x68, 0x56, 0xd5, 0xa5, 0x15, 0x2b, 0x6f,
    0xef, 0x94, 0x8d, 0x51, 0xf6, 0xcd, 0x15, 0xcf, 0xa2, 0x9e, 0x9c, 0x6d, 0xf3, 0x3c, 0x56, 0xe3, 0xdb, 0xd6, 0xc7, 0xf4,
    0x55, 0x75, 0xe9, 0xfb, 0x72, 0x8f, 0xca, 0xa8, 0xca, 0x33, 0xde, 0xb7, 0xc9, 0xdd, 0xe7, 0xa8, 0xbd, 0xe6, 0x45, 0x0a,
    0xdc, 0xf5, 0x6e, 0x90, 0xb6, 0x8a, 0xdd, 0xfc, 0xe5, 0x1c, 0xe8, 0x7f, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xfa, 0xef, 0xc7,
    0x79, 0x00, 0xf1, 0x0f, 0x7c, 0x5d, 0xfc, 0xff, 0x0d };

// Font glyphs rectangles data (on atlas)
static const Rectangle candyFontRecs[189] = {
    { 4, 4, 3 , 15 },
    { 15, 4, 2 , 9 },
    { 25, 4, 3 , 2 },
    { 36, 4, 8 , 9 },
    { 52, 4, 6 , 11 },
    { 66, 4, 7 , 9 },
    { 81, 4, 7 , 9 },
    { 96, 4, 1 , 2 },
    { 105, 4, 3 , 11 },
    { 116, 4, 3 , 11 },
    { 127, 4, 7 , 7 },
    { 142, 4, 6 , 5 },
    { 156, 4, 2 , 3 },
    { 166, 4, 5 , 1 },
    { 179, 4, 2 , 2 },
    { 189, 4, 5 , 10 },
    { 202, 4, 6 , 9 },
    { 216, 4, 4 , 9 },
    { 228, 4, 6 , 9 },
    { 242, 4, 6 , 9 },
    { 256, 4, 7 , 9 },
    { 271, 4, 6 , 9 },
    { 285, 4, 6 , 9 },
    { 299, 4, 6 , 9 },
    { 313, 4, 6 , 9 },
    { 327, 4, 6 , 9 },
    { 341, 4, 2 , 6 },
    { 351, 4, 2 , 7 },
    { 361, 4, 4 , 6 },
    { 373, 4, 5 , 3 },
    { 386, 4, 4 , 6 },
    { 398, 4, 6 , 9 },
    { 412, 4, 8 , 7 },
    { 428, 4, 6 , 9 },
    { 442, 4, 6 , 9 },
    { 456, 4, 6 , 9 },
    { 470, 4, 6 , 9 },
    { 484, 4, 6 , 9 },
    { 4, 27, 6 , 9 },
    { 18, 27, 6 , 9 },
    { 32, 27, 6 , 9 },
    { 46, 27, 2 , 9 },
    { 56, 27, 6 , 9 },
    { 70, 27, 6 , 9 },
    { 84, 27, 6 , 9 },
    { 98, 27, 8 , 9 },
    { 114, 27, 6 , 9 },
    { 128, 27, 6 , 9 },
    { 142, 27, 6 , 9 },
    { 156, 27, 6 , 9 },
    { 170, 27, 6 , 9 },
    { 184, 27, 6 , 9 },
    { 198, 27, 6 , 9 },
    { 212, 27, 6 , 9 },
    { 226, 27, 6 , 9 },
    { 240, 27, 8 , 9 },
    { 256, 27, 6 , 9 },
    { 270, 27, 6 , 9 },
    { 284, 27, 6 , 9 },
    { 298, 27, 3 , 11 },
    { 309, 27, 5 , 10 },
    { 322, 27, 3 , 11 },
    { 333, 27, 6 , 4 },
    { 347, 27, 6 , 1 },
    { 361, 27, 3 , 2 },
    { 372, 27, 6 , 7 },
    { 386, 27, 6 , 10 },
    { 400, 27, 6 , 7 },
    { 414, 27, 6 , 10 },
    { 428, 27, 6 , 7 },
    { 442, 27, 5 , 10 },
    { 455, 27, 7 , 10 },
    { 470, 27, 6 , 10 },
    { 484, 27, 2 , 10 },
    { 494, 27, 2 , 12 },
    { 4, 50, 6 , 10 },
    { 18, 50, 3 , 10 },
    { 29, 50, 8 , 7 },
    { 45, 50, 6 , 7 },
    { 59, 50, 6 , 7 },
    { 73, 50, 6 , 10 },
    { 87, 50, 6 , 10 },
    { 101, 50, 6 , 7 },
    { 115, 50, 6 , 7 },
    { 129, 50, 3 , 10 },
    { 140, 50, 6 , 7 },
    { 154, 50, 6 , 7 },
    { 168, 50, 8 , 7 },
    { 184, 50, 6 , 7 },
    { 198, 50, 6 , 10 },
    { 212, 50, 6 , 7 },
    { 226, 50, 4 , 11 },
    { 238, 50, 1 , 11 },
    { 247, 50, 4 , 11 },
    { 259, 50, 6 , 2 },
    { 273, 50, 2 , 10 },
    { 283, 50, 6 , 11 },
    { 297, 50, 8 , 9 },
    { 313, 50, 7 , 9 },
    { 328, 50, 6 , 9 },
    { 342, 50, 0 , 0 },
    { 350, 50, 6 , 11 },
    { 364, 50, 0 , 0 },
    { 372, 50, 8 , 8 },
    { 388, 50, 5 , 7 },
    { 401, 50, 7 , 6 },
    { 416, 50, 0 , 0 },
    { 424, 50, 8 , 8 },
    { 440, 50, 6 , 1 },
    { 454, 50, 4 , 5 },
    { 466, 50, 6 , 7 },
    { 480, 50, 3 , 5 },
    { 491, 50, 3 , 5 },
    { 502, 50, 0 , 0 },
    { 4, 73, 6 , 9 },
    { 18, 73, 6 , 9 },
    { 32, 73, 4 , 4 },
    { 44, 73, 0 , 0 },
    { 52, 73, 2 , 5 },
    { 62, 73, 4 , 7 },
    { 74, 73, 7 , 6 },
    { 89, 73, 10 , 9 },
    { 107, 73, 10 , 7 },
    { 125, 73, 0 , 0 },
    { 133, 73, 6 , 9 },
    { 147, 73, 6 , 12 },
    { 161, 73, 6 , 12 },
    { 175, 73, 6 , 12 },
    { 189, 73, 6 , 12 },
    { 203, 73, 6 , 11 },
    { 217, 73, 6 , 12 },
    { 231, 73, 10 , 9 },
    { 249, 73, 6 , 12 },
    { 263, 73, 6 , 12 },
    { 277, 73, 6 , 12 },
    { 291, 73, 6 , 12 },
    { 305, 73, 6 , 11 },
    { 319, 73, 3 , 12 },
    { 330, 73, 3 , 12 },
    { 341, 73, 4 , 12 },
    { 353, 73, 4 , 11 },
    { 365, 73, 8 , 9 },
    { 381, 73, 6 , 12 },
    { 395, 73, 6 , 12 },
    { 409, 73, 6 , 12 },
    { 423, 73, 6 , 12 },
    { 437, 73, 6 , 12 },
    { 451, 73, 6 , 11 },
    { 465, 73, 5 , 5 },
    { 478, 73, 9 , 10 },
    { 495, 73, 6 , 12 },
    { 4, 96, 6 , 12 },
    { 18, 96, 6 , 12 },
    { 32, 96, 6 , 11 },
    { 46, 96, 6 , 12 },
    { 60, 96, 0 , 0 },
    { 68, 96, 6 , 10 },
    { 82, 96, 6 , 10 },
    { 96, 96, 6 , 10 },
    { 110, 96, 6 , 10 },
    { 124, 96, 6 , 10 },
    { 138, 96, 6 , 9 },
    { 152, 96, 6 , 11 },
    { 166, 96, 10 , 7 },
    { 184, 96, 6 , 10 },
    { 198, 96, 6 , 10 },
    { 212, 96, 6 , 10 },
    { 226, 96, 6 , 10 },
    { 240, 96, 6 , 9 },
    { 254, 96, 3 , 10 },
    { 265, 96, 3 , 10 },
    { 276, 96, 4 , 10 },
    { 288, 96, 4 , 9 },
    { 300, 96, 0 , 0 },
    { 308, 96, 6 , 13 },
    { 322, 96, 6 , 10 },
    { 336, 96, 6 , 10 },
    { 350, 96, 6 , 10 },
    { 364, 96, 6 , 10 },
    { 378, 96, 6 , 9 },
    { 392, 96, 0 , 0 },
    { 400, 96, 8 , 8 },
    { 416, 96, 6 , 10 },
    { 430, 96, 6 , 10 },
    { 444, 96, 6 , 10 },
    { 458, 96, 6 , 9 },
    { 472, 96, 6 , 13 },
    { 486, 96, 0 , 0 },
    { 494, 96, 6 , 12 },
};

// Font glyphs info data
// NOTE: No glyphs.image data provided
static const GlyphInfo candyFontGlyphs[189] = {
    { 32, 0, 0, 3, { 0 }},
    { 33, 0, 3, 3, { 0 }},
    { 34, 0, 2, 4, { 0 }},
    { 35, 0, 3, 9, { 0 }},
    { 36, 0, 2, 7, { 0 }},
    { 37, 0, 3, 8, { 0 }},
    { 38, 0, 3, 8, { 0 }},
    { 39, 0, 2, 2, { 0 }},
    { 40, 1, 2, 5, { 0 }},
    { 41, 1, 2, 5, { 0 }},
    { 42, 0, 4, 8, { 0 }},
    { 43, 0, 6, 7, { 0 }},
    { 44, 0, 10, 3, { 0 }},
    { 45, 0, 7, 6, { 0 }},
    { 46, 0, 10, 3, { 0 }},
    { 47, 1, 3, 7, { 0 }},
    { 48, 0, 3, 7, { 0 }},
    { 49, 0, 3, 5, { 0 }},
    { 50, 0, 3, 7, { 0 }},
    { 51, 0, 3, 7, { 0 }},
    { 52, 0, 3, 8, { 0 }},
    { 53, 0, 3, 7, { 0 }},
    { 54, 0, 3, 7, { 0 }},
    { 55, 0, 3, 7, { 0 }},
    { 56, 0, 3, 7, { 0 }},
    { 57, 0, 3, 7, { 0 }},
    { 58, 0, 6, 3, { 0 }},
    { 59, 0, 6, 3, { 0 }},
    { 60, 1, 5, 6, { 0 }},
    { 61, 1, 7, 7, { 0 }},
    { 62, 1, 5, 6, { 0 }},
    { 63, 0, 3, 7, { 0 }},
    { 64, 0, 4, 9, { 0 }},
    { 65, 0, 3, 7, { 0 }},
    { 66, 0, 3, 7, { 0 }},
    { 67, 0, 3, 7, { 0 }},
    { 68, 0, 3, 7, { 0 }},
    { 69, 0, 3, 7, { 0 }},
    { 70, 0, 3, 7, { 0 }},
    { 71, 0, 3, 7, { 0 }},
    { 72, 0, 3, 7, { 0 }},
    { 73, 0, 3, 3, { 0 }},
    { 74, 0, 3, 7, { 0 }},
    { 75, 0, 3, 7, { 0 }},
    { 76, 0, 3, 7, { 0 }},
    { 77, 0, 3, 9, { 0 }},
    { 78, 0, 3, 7, { 0 }},
    { 79, 0, 3, 7, { 0 }},
    { 80, 0, 3, 7, { 0 }},
    { 81, 0, 3, 7, { 0 }},
    { 82, 0, 3, 7, { 0 }},
    { 83, 0, 3, 7, { 0 }},
    { 84, 0, 3, 7, { 0 }},
    { 85, 0, 3, 7, { 0 }},
    { 86, 0, 3, 7, { 0 }},
    { 87, 0, 3, 9, { 0 }},
    { 88, 0, 3, 7, { 0 }},
    { 89, 0, 3, 7, { 0 }},
    { 90, 0, 3, 7, { 0 }},
    { 91, 1, 2, 5, { 0 }},
    { 92, 1, 3, 7, { 0 }},
    { 93, 1, 2, 5, { 0 }},
    { 94, 0, 3, 7, { 0 }},
    { 95, 0, 11, 7, { 0 }},
    { 96, 0, 0, 4, { 0 }},
    { 97, 0, 5, 7, { 0 }},
    { 98, 0, 2, 7, { 0 }},
    { 99, 0, 5, 7, { 0 }},
    { 100, 0, 2, 7, { 0 }},
    { 101, 0, 5, 7, { 0 }},
    { 102, 0, 2, 6, { 0 }},
    { 103, 0, 5, 7, { 0 }},
    { 104, 0, 2, 7, { 0 }},
    { 105, 0, 2, 3, { 0 }},
    { 106, 0, 2, 3, { 0 }},
    { 107, 0, 2, 7, { 0 }},
    { 108, 0, 2, 4, { 0 }},
    { 109, 0, 5, 9, { 0 }},
    { 110, 0, 5, 7, { 0 }},
    { 111, 0, 5, 7, { 0 }},
    { 112, 0, 5, 7, { 0 }},
    { 113, 0, 5, 7, { 0 }},
    { 114, 0, 5, 7, { 0 }},
    { 115, 0, 5, 7, { 0 }},
    { 116, 0, 2, 4, { 0 }},
    { 117, 0, 5, 7, { 0 }},
    { 118, 0, 5, 7, { 0 }},
    { 119, 0, 5, 9, { 0 }},
    { 120, 0, 5, 7, { 0 }},
    { 121, 0, 5, 7, { 0 }},
    { 122, 0, 5, 7, { 0 }},
    { 123, 1, 2, 6, { 0 }},
    { 124, 1, 2, 3, { 0 }},
    { 125, 1, 2, 6, { 0 }},
    { 126, 0, 0, 7, { 0 }},
    { 161, 0, 3, 3, { 0 }},
    { 162, 0, 2, 7, { 0 }},
    { 163, 0, 3, 9, { 0 }},
    { 8364, 0, 3, 8, { 0 }},
    { 165, 0, 3, 7, { 0 }},
    { 352, 0, 0, 0, { 0 }},
    { 167, 0, 2, 7, { 0 }},
    { 353, 0, 0, 0, { 0 }},
    { 169, 0, 0, 9, { 0 }},
    { 170, 0, 0, 6, { 0 }},
    { 171, 1, 5, 9, { 0 }},
    { 172, 0, 0, 0, { 0 }},
    { 174, 0, 0, 9, { 0 }},
    { 175, 0, 0, 7, { 0 }},
    { 176, 0, 0, 5, { 0 }},
    { 177, 0, 4, 7, { 0 }},
    { 178, 0, 0, 4, { 0 }},
    { 179, 0, 0, 4, { 0 }},
    { 381, 0, 0, 0, { 0 }},
    { 181, 0, 5, 7, { 0 }},
    { 182, 0, 3, 7, { 0 }},
    { 183, 0, 6, 5, { 0 }},
    { 382, 0, 0, 0, { 0 }},
    { 185, 0, 0, 3, { 0 }},
    { 186, 0, 0, 5, { 0 }},
    { 187, 1, 5, 9, { 0 }},
    { 338, 0, 3, 11, { 0 }},
    { 339, 0, 5, 11, { 0 }},
    { 376, 0, 0, 0, { 0 }},
    { 191, 0, 4, 7, { 0 }},
    { 192, 0, 0, 7, { 0 }},
    { 193, 0, 0, 7, { 0 }},
    { 194, 0, 0, 7, { 0 }},
    { 195, 0, 0, 7, { 0 }},
    { 196, 0, 1, 7, { 0 }},
    { 197, 0, 0, 7, { 0 }},
    { 198, 0, 3, 11, { 0 }},
    { 199, 0, 3, 7, { 0 }},
    { 200, 0, 0, 7, { 0 }},
    { 201, 0, 0, 7, { 0 }},
    { 202, 0, 0, 7, { 0 }},
    { 203, 0, 1, 7, { 0 }},
    { 204, -1, 0, 3, { 0 }},
    { 205, 0, 0, 3, { 0 }},
    { 206, -1, 0, 3, { 0 }},
    { 207, -1, 1, 3, { 0 }},
    { 208, 0, 3, 9, { 0 }},
    { 209, 0, 0, 7, { 0 }},
    { 210, 0, 0, 7, { 0 }},
    { 211, 0, 0, 7, { 0 }},
    { 212, 0, 0, 7, { 0 }},
    { 213, 0, 0, 7, { 0 }},
    { 214, 0, 1, 7, { 0 }},
    { 215, 0, 7, 6, { 0 }},
    { 216, 0, 3, 10, { 0 }},
    { 217, 0, 0, 7, { 0 }},
    { 218, 0, 0, 7, { 0 }},
    { 219, 0, 0, 7, { 0 }},
    { 220, 0, 1, 7, { 0 }},
    { 221, 0, 0, 7, { 0 }},
    { 222, 0, 0, 0, { 0 }},
    { 223, 0, 3, 7, { 0 }},
    { 224, 0, 2, 7, { 0 }},
    { 225, 0, 2, 7, { 0 }},
    { 226, 0, 2, 7, { 0 }},
    { 227, 0, 2, 7, { 0 }},
    { 228, 0, 3, 7, { 0 }},
    { 229, 0, 1, 7, { 0 }},
    { 230, 0, 5, 11, { 0 }},
    { 231, 0, 5, 7, { 0 }},
    { 232, 0, 2, 7, { 0 }},
    { 233, 0, 2, 7, { 0 }},
    { 234, 0, 2, 7, { 0 }},
    { 235, 0, 3, 7, { 0 }},
    { 236, 0, 2, 4, { 0 }},
    { 237, 0, 2, 4, { 0 }},
    { 238, 0, 2, 4, { 0 }},
    { 239, 0, 3, 4, { 0 }},
    { 240, 0, 0, 0, { 0 }},
    { 241, 0, 2, 7, { 0 }},
    { 242, 0, 2, 7, { 0 }},
    { 243, 0, 2, 7, { 0 }},
    { 244, 0, 2, 7, { 0 }},
    { 245, 0, 2, 7, { 0 }},
    { 246, 0, 3, 7, { 0 }},
    { 247, 0, 0, 0, { 0 }},
    { 248, 0, 5, 9, { 0 }},
    { 249, 0, 2, 7, { 0 }},
    { 250, 0, 2, 7, { 0 }},
    { 251, 0, 2, 7, { 0 }},
    { 252, 0, 3, 7, { 0 }},
    { 253, 0, 2, 7, { 0 }},
    { 254, 0, 0, 0, { 0 }},
    { 255, 0, 3, 7, { 0 }},
};

// Style loading function: Candy
static void GuiLoadStyleCandy(void)
{
    // Load style properties provided
    // NOTE: Default properties are propagated
    for (int i = 0; i < CANDY_STYLE_PROPS_COUNT; i++)
    {
        GuiSetStyle(candyStyleProps[i].controlId, candyStyleProps[i].propertyId, candyStyleProps[i].propertyValue);
    }

    // Custom font loading
    // NOTE: Compressed font image data (DEFLATE), it requires DecompressData() function
    int candyFontDataSize = 0;
    unsigned char *data = DecompressData(candyFontData, CANDY_STYLE_FONT_ATLAS_COMP_SIZE, &candyFontDataSize);
    Image imFont = { data, 512, 256, 1, 2 };

    Font font = { 0 };
    font.baseSize = 15;
    font.glyphCount = 189;

    // Load texture from image
    font.texture = LoadTextureFromImage(imFont);
    UnloadImage(imFont);  // Uncompressed image data can be unloaded from memory

    // Copy char recs data from global fontRecs
    // NOTE: Required to avoid issues if trying to free font
    font.recs = (Rectangle *)RAYGUI_MALLOC(font.glyphCount*sizeof(Rectangle));
    memcpy(font.recs, candyFontRecs, font.glyphCount*sizeof(Rectangle));

    // Copy font char info data from global fontChars
    // NOTE: Required to avoid issues if trying to free font
    font.glyphs = (GlyphInfo *)RAYGUI_MALLOC(font.glyphCount*sizeof(GlyphInfo));
    memcpy(font.glyphs, candyFontGlyphs, font.glyphCount*sizeof(GlyphInfo));

    GuiSetFont(font);

    // Setup a white rectangle on the font to be used on shapes drawing,
    // it makes possible to draw shapes and text (full UI) in a single draw call
    Rectangle fontWhiteRec = { 510, 254, 1, 1 };
    SetShapesTexture(font.texture, fontWhiteRec);

    //-----------------------------------------------------------------

    // TODO: Custom user style setup: Set specific properties here (if required)
    // i.e. Controls specific BORDER_WIDTH, TEXT_PADDING, TEXT_ALIGNMENT
}
