//////////////////////////////////////////////////////////////////////////////////
//                                                                              //
// StyleAsCode exporter v2.0 - Style data exported as a values array            //
//                                                                              //
// USAGE: On init call: GuiLoadStyleCyber();                                   //
//                                                                              //
// more info and bugs-report:  github.com/raysan5/raygui                        //
// feedback and support:       ray[at]raylibtech.com                            //
//                                                                              //
// Copyright (c) 2020-2025 raylib technologies (@raylibtech)                    //
//                                                                              //
//////////////////////////////////////////////////////////////////////////////////

#define CYBER_STYLE_PROPS_COUNT  17

// Custom style name: Cyber
static const GuiStyleProp cyberStyleProps[CYBER_STYLE_PROPS_COUNT] = {
    { 0, 0, (int)0x2f7486ff },    // DEFAULT_BORDER_COLOR_NORMAL 
    { 0, 1, (int)0x024658ff },    // DEFAULT_BASE_COLOR_NORMAL 
    { 0, 2, (int)0x51bfd3ff },    // DEFAULT_TEXT_COLOR_NORMAL 
    { 0, 3, (int)0x82cde0ff },    // DEFAULT_BORDER_COLOR_FOCUSED 
    { 0, 4, (int)0x3299b4ff },    // DEFAULT_BASE_COLOR_FOCUSED 
    { 0, 5, (int)0xb6e1eaff },    // DEFAULT_TEXT_COLOR_FOCUSED 
    { 0, 6, (int)0xeb7630ff },    // DEFAULT_BORDER_COLOR_PRESSED 
    { 0, 7, (int)0xffbc51ff },    // DEFAULT_BASE_COLOR_PRESSED 
    { 0, 8, (int)0xd86f36ff },    // DEFAULT_TEXT_COLOR_PRESSED 
    { 0, 9, (int)0x134b5aff },    // DEFAULT_BORDER_COLOR_DISABLED 
    { 0, 10, (int)0x02313dff },    // DEFAULT_BASE_COLOR_DISABLED 
    { 0, 11, (int)0x17505fff },    // DEFAULT_TEXT_COLOR_DISABLED 
    { 0, 16, (int)0x0000000e },    // DEFAULT_TEXT_SIZE 
    { 0, 17, (int)0x00000000 },    // DEFAULT_TEXT_SPACING 
    { 0, 18, (int)0x81c0d0ff },    // DEFAULT_LINE_COLOR 
    { 0, 19, (int)0x00222bff },    // DEFAULT_BACKGROUND_COLOR 
    { 0, 20, (int)0x00000015 },    // DEFAULT_TEXT_LINE_SPACING 
};

// WARNING: This style uses a custom font: "Kyrou7Wide.ttf" (size: 14, spacing: 0)

#define CYBER_STYLE_FONT_ATLAS_COMP_SIZE 2306

// Font atlas image pixels data: DEFLATE compressed
static unsigned char cyberFontData[CYBER_STYLE_FONT_ATLAS_COMP_SIZE] = { 0xed,
    0xdd, 0xdd, 0x72, 0xe3, 0x36, 0x12, 0x06, 0x50, 0x96, 0x6b, 0xdf, 0xff, 0x85, 0x1d, 0xec, 0xb7, 0xb5, 0x93, 0x4c, 0xe2,
    0xa9, 0x8c, 0x88, 0x7f, 0x8a, 0x92, 0xcf, 0x9c, 0xaa, 0xb9, 0x30, 0x2d, 0x89, 0x04, 0xd1, 0x40, 0x93, 0x34, 0x5a, 0x39,
    0x00, 0x00, 0x00, 0x00, 0x16, 0xcb, 0xc5, 0x9f, 0x96, 0xe6, 0x9f, 0xae, 0x3b, 0xa2, 0x9f, 0xff, 0x9e, 0x7b, 0xec, 0xfa,
    0x57, 0x7f, 0xbb, 0xe7, 0xe1, 0xb9, 0xd3, 0x9e, 0x5f, 0x7f, 0x92, 0xd3, 0xdf, 0xcd, 0x50, 0xeb, 0xa6, 0x7a, 0xc6, 0xce,
    0xcf, 0x4c, 0x5f, 0xbc, 0x3d, 0xde, 0x87, 0x74, 0xbf, 0x62, 0xe7, 0xc8, 0xf8, 0xf3, 0x5f, 0xe9, 0xea, 0xef, 0xe7, 0xbd,
    0xb8, 0xad, 0x97, 0xa7, 0xb2, 0x47, 0x69, 0xf8, 0x8d, 0xda, 0xeb, 0x8f, 0x89, 0xbd, 0x2f, 0x97, 0xce, 0x45, 0xa9, 0x8e,
    0x19, 0xc7, 0x86, 0xa3, 0xc9, 0xe4, 0xb9, 0xcc, 0xf4, 0x88, 0xd6, 0x1e, 0xff, 0xb5, 0x7e, 0x91, 0x7f, 0xfd, 0x7f, 0x0c,
    0x45, 0x5a, 0x36, 0xc6, 0xff, 0xd1, 0x35, 0xbe, 0xec, 0xcf, 0x8b, 0xd2, 0x10, 0xe9, 0xfd, 0xaf, 0x69, 0x3d, 0xda, 0xb1,
    0x11, 0x2f, 0xcd, 0xbf, 0x9b, 0xa1, 0x23, 0x5e, 0x75, 0x46, 0x7a, 0x47, 0xce, 0x5a, 0x6b, 0xec, 0x38, 0x9a, 0xaf, 0x3f,
    0xfb, 0x9c, 0x7c, 0x7d, 0xd9, 0x3e, 0x46, 0x96, 0x86, 0x96, 0x2a, 0xc3, 0x9f, 0x98, 0x81, 0x6c, 0x6e, 0xd5, 0xd9, 0xdf,
    0x9d, 0x17, 0x66, 0x38, 0x96, 0x32, 0x75, 0xf6, 0xce, 0x3f, 0x77, 0x74, 0xfe, 0xde, 0x3b, 0xe2, 0xf5, 0xe7, 0xfa, 0x59,
    0x34, 0x9a, 0x8f, 0x8d, 0x66, 0x3f, 0x5b, 0x2a, 0x1b, 0xe2, 0x77, 0xdd, 0x58, 0xbc, 0x32, 0x47, 0x9a, 0xc9, 0x3b, 0xcf,
    0xb6, 0x7d, 0xfe, 0xd0, 0xbe, 0x57, 0xaf, 0x32, 0xff, 0x67, 0xe2, 0xfc, 0x65, 0xa8, 0x9d, 0x6b, 0x39, 0x65, 0xeb, 0x11,
    0x9f, 0x7f, 0x7a, 0x19, 0x38, 0xe6, 0x8f, 0x94, 0xbf, 0x1d, 0x4b, 0x72, 0xda, 0x2c, 0x3c, 0x97, 0xe9, 0xbe, 0x56, 0xfa,
    0x33, 0x6e, 0xc7, 0x73, 0xe6, 0xe4, 0xbf, 0x3f, 0x94, 0xcd, 0xb9, 0xd8, 0x15, 0xf1, 0xff, 0xcf, 0x28, 0x96, 0x89, 0x88,
    0xcd, 0xe4, 0x0c, 0xb3, 0xf6, 0xfa, 0x7f, 0x5e, 0x99, 0x3a, 0x7f, 0x59, 0x7e, 0x55, 0xfb, 0x4f, 0xf4, 0x66, 0x28, 0x7f,
    0xc8, 0xb2, 0x51, 0xb6, 0x6c, 0xbc, 0x97, 0x9c, 0x4d, 0x59, 0xda, 0xa3, 0xf9, 0xff, 0xba, 0x6c, 0x67, 0xcf, 0xd5, 0x52,
    0xcf, 0xbd, 0xd3, 0xd1, 0xeb, 0xff, 0x34, 0x8e, 0x2e, 0xfb, 0xe2, 0xff, 0x7a, 0x7f, 0x4c, 0x9e, 0xbf, 0x5c, 0x7c, 0x7d,
    0xbe, 0xe6, 0x0a, 0x7d, 0x3c, 0xe3, 0xd9, 0x7b, 0xfd, 0x7f, 0xd5, 0x88, 0xb1, 0x23, 0xff, 0xcf, 0x8b, 0xe7, 0xff, 0x3d,
    0xf7, 0xff, 0xf3, 0x26, 0xf1, 0x9f, 0xe9, 0x27, 0x52, 0x59, 0x7e, 0x7f, 0xbe, 0x2d, 0xdb, 0x9d, 0x7b, 0xbe, 0x90, 0xa9,
    0x23, 0x5e, 0x75, 0x2f, 0x26, 0x8b, 0x7e, 0x37, 0x8d, 0xb3, 0xe2, 0xd8, 0xfd, 0xdd, 0xe7, 0xde, 0xff, 0xf7, 0xfc, 0x1f,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x9e, 0xd5, 0x9d, 0xb9, 0xe0, 0x75,
    0x23, 0xab, 0x68, 0x67, 0x56, 0xdd, 0xce, 0xac, 0xd9, 0x1d, 0x7d, 0x65, 0xbd, 0x0e, 0xd1, 0xf8, 0x3a, 0xe3, 0xf6, 0x55,
    0xce, 0x7d, 0xeb, 0x86, 0xe7, 0xaa, 0xa3, 0xa4, 0xba, 0x8e, 0xbe, 0xad, 0x1e, 0x41, 0xbd, 0x76, 0x6b, 0xad, 0x92, 0xd5,
    0xfe, 0xda, 0xaf, 0x3b, 0x6b, 0x53, 0x66, 0xb8, 0x05, 0x7b, 0x56, 0xbf, 0xa7, 0xab, 0x3e, 0xc1, 0xe8, 0x3a, 0xf4, 0xeb,
    0xaa, 0x02, 0xce, 0xaf, 0x90, 0x3f, 0x7f, 0xe7, 0xb2, 0xfd, 0x28, 0xda, 0xf7, 0x38, 0x0b, 0xce, 0xd9, 0x8e, 0xf8, 0xcf,
    0x69, 0x45, 0x80, 0x5c, 0x58, 0xdb, 0x75, 0x5f, 0x25, 0xdc, 0x7d, 0x95, 0x76, 0xea, 0xf1, 0xdf, 0x5e, 0xb3, 0x39, 0x8b,
    0xa3, 0x35, 0xc3, 0xd1, 0xb3, 0x6a, 0x04, 0x18, 0x19, 0xb7, 0x56, 0xc4, 0xff, 0x68, 0xee, 0xf0, 0xda, 0xf1, 0x3f, 0x5a,
    0x4f, 0x2c, 0x27, 0xe7, 0x3d, 0x8d, 0x7d, 0xfb, 0x0e, 0xdb, 0x8f, 0x9b, 0xc6, 0x7f, 0x3d, 0xa6, 0x32, 0x5d, 0xa5, 0x78,
    0x5d, 0x7f, 0x5a, 0xa7, 0x34, 0x45, 0xe9, 0x58, 0x4d, 0xcf, 0x32, 0x3c, 0xb2, 0xec, 0xca, 0xff, 0x53, 0xb9, 0xf2, 0x48,
    0x53, 0x2e, 0xbb, 0x76, 0x8c, 0x6d, 0x1d, 0xb5, 0x1e, 0x57, 0x14, 0xab, 0xd5, 0x2b, 0x7c, 0xfe, 0xfc, 0x3e, 0x57, 0x4f,
    0xf9, 0x9a, 0xf8, 0x9f, 0x8f, 0xc4, 0x3c, 0x65, 0xce, 0x5a, 0x73, 0x6f, 0x22, 0x83, 0xf3, 0xd6, 0x9e, 0xd7, 0x5e, 0x31,
    0xff, 0xe7, 0xa5, 0xe6, 0xff, 0x96, 0xeb, 0xff, 0x2c, 0xb8, 0x7a, 0x1d, 0x6b, 0xb5, 0xd2, 0x7c, 0x2e, 0x77, 0xe4, 0xff,
    0x2d, 0x33, 0xfb, 0xfc, 0xfc, 0x3f, 0xb3, 0x35, 0xcd, 0xb3, 0xf0, 0xf5, 0xf1, 0xdf, 0x76, 0x4c, 0xb9, 0xf4, 0xb5, 0xaf,
    0x17, 0xff, 0xb9, 0xc5, 0xfd, 0xbf, 0x6c, 0xac, 0xcd, 0x9c, 0x25, 0xa3, 0xdb, 0x9e, 0xf8, 0x6f, 0xab, 0x87, 0x3e, 0x73,
    0xfd, 0x3f, 0x17, 0xe1, 0xf5, 0x08, 0xf8, 0x43, 0xfc, 0x2f, 0xca, 0xff, 0x57, 0xbd, 0xba, 0xff, 0x5e, 0xc9, 0xcc, 0x0c,
    0xda, 0x7e, 0x4c, 0x59, 0x9e, 0x7f, 0xcf, 0xd6, 0xf6, 0xdd, 0x9d, 0xff, 0xaf, 0x7a, 0xfd, 0x31, 0x7c, 0xde, 0xeb, 0x5b,
    0xe6, 0x7a, 0xe5, 0xf1, 0x84, 0x6f, 0x73, 0xd8, 0xfd, 0x7c, 0xcf, 0x77, 0x94, 0xbe, 0xdf, 0x53, 0x6c, 0x6d, 0x70, 0xef,
    0xe7, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x5e, 0x65, 0x75, 0xbf,
    0x15, 0x53, 0x69, 0x58, 0x1f, 0xda, 0x52, 0x3f, 0xf3, 0xbc, 0xfa, 0xe6, 0xa3, 0x1a, 0x12, 0xa5, 0xa9, 0xf6, 0xe6, 0xaa,
    0xd6, 0x6c, 0xad, 0x83, 0x30, 0x5b, 0xa7, 0x73, 0xe4, 0xdd, 0x5b, 0x5a, 0xb9, 0xbe, 0xe6, 0x31, 0x95, 0x75, 0xc0, 0xc7,
    0xc2, 0x1e, 0x58, 0x5f, 0xf3, 0x9c, 0x89, 0x9a, 0x0b, 0x33, 0x55, 0x04, 0xb3, 0x71, 0x85, 0x69, 0x86, 0x5a, 0xa5, 0xbd,
    0x02, 0x47, 0xeb, 0xd6, 0x2c, 0xaa, 0xf2, 0xb0, 0xbb, 0x5f, 0xaf, 0xd8, 0xda, 0x5f, 0x47, 0xe1, 0x19, 0xf1, 0x7f, 0xde,
    0x43, 0xb2, 0xf8, 0x6c, 0xf7, 0xfd, 0xb4, 0x16, 0xfb, 0x8f, 0x6b, 0x2b, 0x7f, 0x34, 0xf6, 0x9b, 0x9e, 0xed, 0x99, 0x3e,
    0xcb, 0x99, 0xac, 0x84, 0x50, 0x3a, 0xe7, 0x9b, 0xf6, 0xe8, 0x9f, 0xeb, 0x79, 0xfb, 0x56, 0xc0, 0xbf, 0x53, 0xfc, 0x1f,
    0x83, 0x15, 0x0b, 0x77, 0xc7, 0xff, 0xd1, 0xb4, 0x4f, 0x59, 0x76, 0x44, 0xeb, 0xaa, 0x6f, 0x7f, 0x74, 0xe7, 0x58, 0x6b,
    0x6a, 0x59, 0xe5, 0xc2, 0x5a, 0x0f, 0xe9, 0xe8, 0x5d, 0xa3, 0x23, 0x40, 0x06, 0xe7, 0xff, 0xfe, 0x96, 0x5e, 0x95, 0x63,
    0xbc, 0x66, 0xfc, 0x8f, 0xb5, 0x66, 0x26, 0xce, 0xf0, 0xde, 0xf9, 0x7f, 0x65, 0xe5, 0xee, 0x91, 0xe8, 0x28, 0x0f, 0xde,
    0xa5, 0x0c, 0xcf, 0xce, 0xe3, 0x57, 0x07, 0x47, 0xd3, 0x77, 0x32, 0x94, 0xee, 0xd7, 0xe5, 0x97, 0xf8, 0xcc, 0x96, 0x6b,
    0xf4, 0x9c, 0xb4, 0xf0, 0x68, 0x35, 0xd2, 0xde, 0xf8, 0xcf, 0xa5, 0xf3, 0xff, 0xd1, 0xf8, 0xed, 0x19, 0xc7, 0xd0, 0xf9,
    0x3a, 0x06, 0xdf, 0x75, 0xfc, 0x95, 0xa9, 0xf6, 0xd8, 0x3d, 0xf5, 0x68, 0x57, 0x7e, 0x43, 0x47, 0x16, 0xf4, 0xdb, 0x54,
    0x3e, 0x21, 0x83, 0x39, 0x78, 0x6f, 0xe6, 0xdf, 0x33, 0xce, 0xa6, 0xe3, 0xce, 0x40, 0x4e, 0xc6, 0xc0, 0x6c, 0xca, 0xc1,
    0x57, 0xce, 0x83, 0x59, 0x9a, 0xaf, 0xed, 0xbb, 0xbb, 0xb8, 0x33, 0xa3, 0xbb, 0xe6, 0xdd, 0x9e, 0xd5, 0x26, 0x57, 0xce,
    0xff, 0xe9, 0xce, 0x76, 0x67, 0xe6, 0xff, 0x4c, 0xd7, 0xc9, 0xac, 0xe5, 0x7e, 0xc7, 0xed, 0xe6, 0xff, 0xb6, 0xd8, 0xcc,
    0xe5, 0xf9, 0xbf, 0xf8, 0xbf, 0xfa, 0x49, 0xcb, 0xf1, 0x12, 0xf1, 0xbf, 0xf7, 0xfa, 0x7f, 0xcd, 0x08, 0x32, 0x3a, 0xcb,
    0x1e, 0x9b, 0x9f, 0x11, 0x8c, 0xbf, 0x6a, 0x5f, 0xfc, 0x1f, 0xdf, 0xaa, 0x5a, 0xe3, 0xbb, 0xd5, 0xa6, 0x7c, 0x46, 0xfc,
    0xb7, 0xe4, 0xff, 0x19, 0xbc, 0xff, 0xdf, 0xfe, 0x0d, 0x5b, 0xe9, 0xca, 0x59, 0xda, 0xf3, 0x8e, 0xf7, 0xec, 0x11, 0xbc,
    0xf3, 0x88, 0x36, 0xf7, 0xfc, 0xff, 0x6e, 0x63, 0xf0, 0xdc, 0x77, 0xaa, 0x7c, 0xe7, 0xfe, 0xaf, 0xee, 0x32, 0xfe, 0x5a,
    0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xd9, 0xeb, 0x16, 0x72, 0xe9, 0x7a, 0xf9,
    0xd1, 0xba, 0x75, 0xfd, 0x2b, 0x56, 0xb3, 0xa8, 0x65, 0xb2, 0xe8, 0x6c, 0x95, 0x86, 0xd5, 0xf9, 0x99, 0x6c, 0xf7, 0x4c,
    0xff, 0x4e, 0x1a, 0x56, 0x84, 0x65, 0xe8, 0x0c, 0xdf, 0x6f, 0xdd, 0xea, 0xcc, 0xaa, 0xc1, 0x2c, 0x6d, 0xdd, 0x95, 0xe7,
    0x3b, 0xd5, 0x6a, 0xd8, 0x5f, 0x95, 0xc1, 0xea, 0x2b, 0x19, 0x5a, 0x31, 0x99, 0xe1, 0xda, 0x04, 0xbd, 0xe3, 0x5d, 0x3a,
    0xdb, 0xac, 0xf7, 0x5c, 0x7f, 0x6d, 0xe3, 0xd6, 0x2a, 0x33, 0x5f, 0xb7, 0x97, 0xc1, 0x33, 0xfe, 0x91, 0xcf, 0xa9, 0x7e,
    0x9f, 0xe1, 0x11, 0xfa, 0x58, 0x52, 0xd7, 0xbb, 0xa5, 0x1a, 0x47, 0x69, 0x58, 0x43, 0x9f, 0xe9, 0xda, 0x60, 0x19, 0x6e,
    0x87, 0x95, 0x3d, 0x6f, 0xee, 0xd3, 0x6a, 0x6b, 0xb5, 0x33, 0x31, 0x83, 0x66, 0xb0, 0xfe, 0x5d, 0x26, 0x2b, 0x43, 0xe4,
    0x64, 0x8d, 0x77, 0xb6, 0xad, 0x6f, 0x4f, 0x67, 0xf4, 0xb7, 0x1f, 0x6f, 0x9a, 0xdb, 0xb4, 0xad, 0x5e, 0xf5, 0xc7, 0xed,
    0xb3, 0xd2, 0x32, 0x34, 0xdb, 0x8c, 0xb5, 0xe9, 0xd5, 0xf9, 0xc6, 0xdd, 0x6b, 0x7b, 0xd4, 0xab, 0x8f, 0xed, 0xbf, 0x36,
    0x18, 0xa9, 0xc5, 0xb2, 0x2e, 0xfe, 0xd3, 0x5d, 0x51, 0xaa, 0x4c, 0x5d, 0x75, 0xf4, 0xc5, 0x7f, 0xdb, 0xfb, 0x66, 0x68,
    0xfe, 0xaf, 0xc5, 0xdf, 0xde, 0xed, 0xb3, 0xd5, 0xf6, 0x47, 0xe3, 0xbf, 0xbf, 0x0f, 0x64, 0x43, 0x8d, 0xd4, 0x5a, 0x56,
    0x32, 0xb2, 0x65, 0xfe, 0x1a, 0x7b, 0x5f, 0xfc, 0x9f, 0xb5, 0xde, 0x6c, 0xbe, 0xb1, 0x6a, 0xfe, 0xcf, 0x74, 0xfe, 0xdf,
    0xda, 0x57, 0xd3, 0xfc, 0xfd, 0x42, 0x2d, 0x39, 0x55, 0x1e, 0xc6, 0x7e, 0xc9, 0x67, 0xf5, 0x9b, 0x32, 0x8e, 0xc1, 0x6f,
    0xc3, 0xd8, 0xbd, 0xbd, 0x67, 0xdc, 0x5e, 0x53, 0xb9, 0xf3, 0xfa, 0xad, 0x2b, 0xc6, 0xbe, 0x7b, 0xc4, 0x7f, 0x36, 0x65,
    0x3a, 0x99, 0x6a, 0xd7, 0x74, 0xed, 0xfb, 0x35, 0x77, 0x97, 0x72, 0x59, 0x55, 0xd1, 0xff, 0xc7, 0xfe, 0xc7, 0x70, 0x4e,
    0xbc, 0x7f, 0x7b, 0xeb, 0x38, 0x58, 0x2e, 0x98, 0xff, 0x77, 0xde, 0x01, 0x1d, 0xaf, 0x0a, 0x7f, 0x4d, 0xfc, 0x3f, 0xeb,
    0xda, 0xe8, 0xd8, 0x32, 0x36, 0xf6, 0xc6, 0x7f, 0x2e, 0x3e, 0x8e, 0xeb, 0xe2, 0xbf, 0x9c, 0x5e, 0x03, 0xa4, 0x23, 0xaf,
    0xdd, 0xb3, 0x7d, 0xe5, 0xf8, 0x32, 0xfb, 0xbd, 0x3f, 0xcf, 0xc9, 0xff, 0x9f, 0x1f, 0xff, 0x77, 0xbe, 0x43, 0x91, 0x37,
    0xba, 0x43, 0x93, 0x5f, 0xee, 0xb2, 0x5c, 0xf3, 0x3c, 0xf6, 0x3f, 0x29, 0x3f, 0x7c, 0x3e, 0xf8, 0x1e, 0xad, 0x7b, 0xe7,
    0xff, 0xbd, 0xf1, 0x3f, 0x73, 0xff, 0xff, 0xfb, 0xe6, 0xff, 0x77, 0xfe, 0x9b, 0x05, 0x7f, 0xb7, 0xb1, 0xb3, 0x9d, 0xee,
    0x1f, 0xdf, 0xeb, 0x47, 0xe6, 0xf2, 0xe0, 0x7a, 0xe8, 0xfb, 0xe6, 0xff, 0xf7, 0xff, 0x8b, 0x25, 0xd5, 0x56, 0xaf, 0xb8,
    0x26, 0xb9, 0xe3, 0xfd, 0xbd, 0xd5, 0xfd, 0xbd, 0x9c, 0xdc, 0x0b, 0xdd, 0x95, 0xff, 0x1f, 0x37, 0xbf, 0xff, 0x0f, 0xaf,
    0x39, 0x3e, 0x01, 0xe2, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x7d, 0xff, 0x9a, 0x32, 0xc3,
    0xeb, 0x26, 0xf2, 0xa3, 0x96, 0xcc, 0xc7, 0xc4, 0x6a, 0xa4, 0x7d, 0x55, 0x64, 0xcf, 0x6b, 0x60, 0x7d, 0x4e, 0xfc, 0xfd,
    0xe8, 0xde, 0xe3, 0xca, 0xa2, 0xf5, 0xa3, 0xcf, 0x38, 0xb2, 0x0c, 0x9e, 0xab, 0xb9, 0xcf, 0xfc, 0x77, 0x55, 0xa4, 0x63,
    0xf9, 0x5a, 0xdf, 0xe3, 0xaf, 0xba, 0x49, 0xab, 0xcf, 0x48, 0xcf, 0xca, 0xc3, 0x7b, 0x55, 0x28, 0x2c, 0x3f, 0xda, 0x23,
    0xa7, 0x75, 0x24, 0xef, 0x5c, 0x45, 0xb6, 0x0c, 0x55, 0x97, 0xd9, 0x7f, 0x5c, 0x73, 0xf1, 0x90, 0x4a, 0x5d, 0xcf, 0xe7,
    0x54, 0xbb, 0xad, 0x9d, 0xab, 0xf3, 0x5a, 0xd8, 0xa5, 0x71, 0xbd, 0xfc, 0x79, 0x55, 0xe4, 0x4c, 0x8e, 0x7e, 0xf5, 0xe8,
    0xcf, 0xd0, 0xd1, 0xfd, 0xee, 0x8c, 0xa5, 0xf9, 0x13, 0xb2, 0xa8, 0x3a, 0xd7, 0x79, 0x6b, 0x94, 0x17, 0x5e, 0x29, 0x5c,
    0xba, 0xe2, 0x3f, 0x5f, 0x32, 0x84, 0xbc, 0xe0, 0xea, 0x96, 0xd6, 0xf1, 0xf8, 0xb5, 0x56, 0xce, 0xa4, 0x79, 0x45, 0xf8,
    0x4c, 0xc5, 0x1d, 0xeb, 0xa9, 0xda, 0x7b, 0x62, 0xbd, 0x9f, 0xde, 0xbb, 0x8a, 0xec, 0x67, 0xe5, 0xb8, 0xf2, 0xb2, 0xd5,
    0x6f, 0xda, 0x5a, 0x25, 0x03, 0xd9, 0xc1, 0xb3, 0xb6, 0x9e, 0x67, 0x71, 0xbf, 0x9b, 0xff, 0xc7, 0x32, 0x9b, 0x67, 0x1d,
    0x7b, 0xeb, 0xbe, 0x66, 0xcb, 0x95, 0x60, 0x4b, 0x4f, 0xc8, 0x69, 0xb6, 0xf5, 0x8a, 0x71, 0xd2, 0x92, 0x89, 0xde, 0x73,
    0xbf, 0xd3, 0xd8, 0x1b, 0x72, 0x92, 0x87, 0xdf, 0xb5, 0xee, 0xed, 0xcc, 0xa8, 0x94, 0x86, 0x2b, 0xfc, 0x96, 0xec, 0xa0,
    0x5c, 0xba, 0xf5, 0xae, 0xf1, 0xdf, 0x32, 0xff, 0xe7, 0x4d, 0xe3, 0xbf, 0xdc, 0x7c, 0xbf, 0xc7, 0xbf, 0xff, 0xac, 0x75,
    0xfe, 0xbf, 0xd7, 0xd6, 0x95, 0x19, 0xfc, 0xe3, 0xfb, 0x6d, 0xfb, 0x2a, 0x7d, 0xf6, 0xdf, 0x77, 0x7c, 0x8d, 0xf8, 0xbf,
    0xf3, 0x3c, 0x39, 0x1e, 0xff, 0x9f, 0x2f, 0xb0, 0xdf, 0x19, 0xba, 0xa3, 0x53, 0x8b, 0xff, 0x72, 0xcb, 0xad, 0x2b, 0x2b,
    0x5b, 0x8d, 0x3e, 0xab, 0xda, 0x59, 0xe9, 0xf3, 0xbe, 0xf1, 0xdf, 0x92, 0x2f, 0xbd, 0xea, 0x75, 0xf2, 0x31, 0x1d, 0x41,
    0x77, 0x8d, 0xff, 0xfa, 0x93, 0x87, 0xf1, 0x27, 0x64, 0xcf, 0xd8, 0x5a, 0x2e, 0xba, 0x83, 0xf7, 0xbc, 0x63, 0x7f, 0x5e,
    0xfc, 0xcf, 0x54, 0x28, 0x3c, 0xbf, 0xef, 0x72, 0x87, 0xeb, 0xe4, 0x1d, 0xf5, 0x10, 0xef, 0xb1, 0xdf, 0xd9, 0x34, 0x17,
    0xdd, 0xfb, 0x49, 0x8e, 0x3b, 0xf8, 0xf7, 0x7c, 0x6a, 0x30, 0xd6, 0x8f, 0x77, 0x6f, 0x7f, 0x56, 0x6f, 0xbc, 0x62, 0xbf,
    0x45, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x77, 0x5a, 0xc9, 0x93, 0xca, 0x2a,
    0xe0, 0xa3, 0xab, 0x76, 0xd1, 0xaf, 0x46, 0x6b, 0xa6, 0x66, 0x41, 0x95, 0xcc, 0x47, 0x6b, 0x6f, 0xca, 0xe5, 0x47, 0x73,
    0x4c, 0xbe, 0x33, 0x5c, 0xb5, 0x9a, 0xef, 0x77, 0xeb, 0xc5, 0x47, 0xfb, 0xfc, 0x68, 0xcd, 0xd4, 0xb9, 0x7a, 0xb1, 0xb5,
    0x95, 0xd2, 0x9f, 0x83, 0xe3, 0xd9, 0xae, 0x0a, 0xb0, 0x67, 0xef, 0x5c, 0xaf, 0xe7, 0x6b, 0x3d, 0x20, 0xf3, 0xd1, 0xff,
    0x1d, 0x7a, 0x50, 0xb6, 0xe5, 0x15, 0x3b, 0xf7, 0xf9, 0x43, 0x0f, 0xe5, 0x49, 0x39, 0x40, 0xdb, 0x5a, 0xf6, 0x72, 0xab,
    0xad, 0x8f, 0xf7, 0x39, 0x8d, 0x95, 0xfd, 0xee, 0xb5, 0x75, 0xa6, 0x9e, 0x2f, 0xb4, 0x5c, 0x11, 0xd7, 0xab, 0xa2, 0xbe,
    0xce, 0xd6, 0x96, 0xa3, 0x3d, 0xde, 0xe4, 0x58, 0xc5, 0x3f, 0xab, 0xe6, 0xfc, 0x77, 0xea, 0xf5, 0x99, 0x6a, 0x0b, 0xf1,
    0x8f, 0xf8, 0xff, 0x6e, 0xbd, 0x5e, 0xfc, 0xf3, 0x7d, 0xf3, 0xff, 0x32, 0x55, 0x2f, 0xfe, 0xb8, 0xd5, 0xd6, 0xf9, 0x6b,
    0xa1, 0xfb, 0x6c, 0xbd, 0x6b, 0x15, 0x44, 0xe0, 0x8a, 0x3b, 0xb0, 0x73, 0x4f, 0x70, 0x81, 0xd7, 0xc8, 0xc1, 0x46, 0xe2,
    0xda, 0xec, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x8b, 0x3f, 0xff, 0x69, 0x07, 0x10, 0xff, 0xc0,
    0xb7, 0x8b, 0xff, 0xff, 0x01 };

// Font glyphs rectangles data (on atlas)
static const Rectangle cyberFontRecs[189] = {
    { 4, 4, 4 , 14 },
    { 16, 4, 1 , 8 },
    { 25, 4, 4 , 3 },
    { 37, 4, 8 , 8 },
    { 53, 4, 8 , 9 },
    { 69, 4, 8 , 8 },
    { 85, 4, 8 , 8 },
    { 101, 4, 1 , 3 },
    { 110, 4, 4 , 9 },
    { 122, 4, 4 , 9 },
    { 134, 4, 5 , 6 },
    { 147, 4, 5 , 6 },
    { 160, 4, 2 , 2 },
    { 170, 4, 4 , 1 },
    { 182, 4, 1 , 1 },
    { 191, 4, 8 , 8 },
    { 207, 4, 8 , 8 },
    { 223, 4, 2 , 8 },
    { 233, 4, 8 , 8 },
    { 249, 4, 8 , 8 },
    { 265, 4, 8 , 8 },
    { 281, 4, 8 , 8 },
    { 297, 4, 8 , 8 },
    { 313, 4, 7 , 8 },
    { 328, 4, 8 , 8 },
    { 344, 4, 8 , 8 },
    { 360, 4, 1 , 4 },
    { 369, 4, 2 , 5 },
    { 379, 4, 4 , 8 },
    { 391, 4, 5 , 3 },
    { 404, 4, 4 , 8 },
    { 416, 4, 7 , 8 },
    { 431, 4, 8 , 8 },
    { 447, 4, 8 , 8 },
    { 463, 4, 8 , 8 },
    { 479, 4, 8 , 8 },
    { 495, 4, 8 , 8 },
    { 4, 26, 7 , 8 },
    { 19, 26, 7 , 8 },
    { 34, 26, 8 , 8 },
    { 50, 26, 8 , 8 },
    { 66, 26, 5 , 8 },
    { 79, 26, 7 , 8 },
    { 94, 26, 8 , 8 },
    { 110, 26, 7 , 8 },
    { 125, 26, 8 , 8 },
    { 141, 26, 8 , 8 },
    { 157, 26, 8 , 8 },
    { 173, 26, 8 , 8 },
    { 189, 26, 8 , 9 },
    { 205, 26, 8 , 8 },
    { 221, 26, 8 , 8 },
    { 237, 26, 8 , 8 },
    { 253, 26, 8 , 8 },
    { 269, 26, 8 , 8 },
    { 285, 26, 9 , 8 },
    { 302, 26, 8 , 8 },
    { 318, 26, 8 , 8 },
    { 334, 26, 8 , 8 },
    { 350, 26, 4 , 9 },
    { 362, 26, 8 , 8 },
    { 378, 26, 4 , 9 },
    { 390, 26, 4 , 3 },
    { 402, 26, 7 , 1 },
    { 417, 26, 2 , 3 },
    { 427, 26, 7 , 5 },
    { 442, 26, 7 , 8 },
    { 457, 26, 7 , 5 },
    { 472, 26, 7 , 8 },
    { 487, 26, 7 , 5 },
    { 4, 48, 4 , 8 },
    { 16, 48, 7 , 7 },
    { 31, 48, 7 , 8 },
    { 46, 48, 1 , 8 },
    { 55, 48, 3 , 10 },
    { 66, 48, 7 , 8 },
    { 81, 48, 4 , 8 },
    { 93, 48, 9 , 5 },
    { 110, 48, 7 , 5 },
    { 125, 48, 7 , 5 },
    { 140, 48, 7 , 7 },
    { 155, 48, 7 , 7 },
    { 170, 48, 5 , 5 },
    { 183, 48, 7 , 5 },
    { 198, 48, 5 , 8 },
    { 211, 48, 7 , 5 },
    { 226, 48, 7 , 5 },
    { 241, 48, 9 , 5 },
    { 258, 48, 7 , 5 },
    { 273, 48, 7 , 7 },
    { 288, 48, 7 , 5 },
    { 303, 48, 4 , 9 },
    { 315, 48, 1 , 9 },
    { 324, 48, 4 , 9 },
    { 336, 48, 8 , 2 },
    { 352, 48, 1 , 8 },
    { 361, 48, 7 , 8 },
    { 376, 48, 7 , 8 },
    { 391, 48, 8 , 9 },
    { 407, 48, 8 , 9 },
    { 423, 48, 8 , 10 },
    { 439, 48, 4 , 9 },
    { 451, 48, 7 , 8 },
    { 466, 48, 8 , 8 },
    { 482, 48, 7 , 6 },
    { 497, 48, 5 , 3 },
    { 4, 70, 5 , 3 },
    { 17, 70, 8 , 8 },
    { 33, 70, 0 , 0 },
    { 41, 70, 4 , 3 },
    { 53, 70, 8 , 6 },
    { 69, 70, 4 , 5 },
    { 81, 70, 4 , 5 },
    { 93, 70, 8 , 10 },
    { 109, 70, 7 , 7 },
    { 124, 70, 5 , 7 },
    { 137, 70, 1 , 1 },
    { 146, 70, 7 , 8 },
    { 161, 70, 2 , 5 },
    { 171, 70, 4 , 5 },
    { 183, 70, 5 , 3 },
    { 196, 70, 14 , 8 },
    { 218, 70, 13 , 5 },
    { 239, 70, 8 , 9 },
    { 255, 70, 7 , 8 },
    { 270, 70, 8 , 10 },
    { 286, 70, 8 , 10 },
    { 302, 70, 8 , 10 },
    { 318, 70, 8 , 10 },
    { 334, 70, 8 , 9 },
    { 350, 70, 8 , 12 },
    { 366, 70, 14 , 8 },
    { 388, 70, 8 , 10 },
    { 404, 70, 7 , 10 },
    { 419, 70, 7 , 10 },
    { 434, 70, 7 , 10 },
    { 449, 70, 7 , 9 },
    { 464, 70, 5 , 10 },
    { 477, 70, 5 , 10 },
    { 490, 70, 5 , 10 },
    { 4, 92, 5 , 9 },
    { 17, 92, 8 , 8 },
    { 33, 92, 8 , 10 },
    { 49, 92, 8 , 10 },
    { 65, 92, 8 , 10 },
    { 81, 92, 8 , 10 },
    { 97, 92, 8 , 10 },
    { 113, 92, 8 , 9 },
    { 129, 92, 4 , 4 },
    { 141, 92, 8 , 8 },
    { 157, 92, 8 , 10 },
    { 173, 92, 8 , 10 },
    { 189, 92, 8 , 10 },
    { 205, 92, 8 , 9 },
    { 221, 92, 8 , 10 },
    { 237, 92, 7 , 9 },
    { 252, 92, 7 , 9 },
    { 267, 92, 7 , 8 },
    { 282, 92, 7 , 8 },
    { 297, 92, 7 , 8 },
    { 312, 92, 7 , 8 },
    { 327, 92, 7 , 8 },
    { 342, 92, 7 , 9 },
    { 357, 92, 13 , 5 },
    { 378, 92, 7 , 7 },
    { 393, 92, 7 , 8 },
    { 408, 92, 7 , 8 },
    { 423, 92, 7 , 8 },
    { 438, 92, 7 , 8 },
    { 453, 92, 3 , 8 },
    { 464, 92, 2 , 8 },
    { 474, 92, 3 , 8 },
    { 485, 92, 3 , 8 },
    { 4, 114, 8 , 8 },
    { 20, 114, 7 , 8 },
    { 35, 114, 7 , 8 },
    { 50, 114, 7 , 8 },
    { 65, 114, 7 , 8 },
    { 80, 114, 7 , 8 },
    { 95, 114, 7 , 8 },
    { 110, 114, 5 , 6 },
    { 123, 114, 7 , 5 },
    { 138, 114, 7 , 8 },
    { 153, 114, 7 , 8 },
    { 168, 114, 7 , 8 },
    { 183, 114, 7 , 8 },
    { 198, 114, 7 , 10 },
    { 213, 114, 7 , 10 },
    { 228, 114, 7 , 10 },
};

// Font glyphs info data
// NOTE: No glyphs.image data provided
static const GlyphInfo cyberFontGlyphs[189] = {
    { 32, 0, 0, 4, { 0 }},
    { 33, 0, 3, 2, { 0 }},
    { 34, 0, 3, 4, { 0 }},
    { 35, 0, 3, 8, { 0 }},
    { 36, 0, 3, 8, { 0 }},
    { 37, 0, 3, 8, { 0 }},
    { 38, 0, 3, 8, { 0 }},
    { 39, 0, 3, 2, { 0 }},
    { 40, 0, 3, 4, { 0 }},
    { 41, 0, 3, 4, { 0 }},
    { 42, 0, 4, 6, { 0 }},
    { 43, 0, 4, 6, { 0 }},
    { 44, 0, 10, 3, { 0 }},
    { 45, 0, 7, 5, { 0 }},
    { 46, 0, 10, 2, { 0 }},
    { 47, 0, 3, 8, { 0 }},
    { 48, 0, 3, 8, { 0 }},
    { 49, 0, 3, 3, { 0 }},
    { 50, 0, 3, 8, { 0 }},
    { 51, 0, 3, 8, { 0 }},
    { 52, 0, 3, 8, { 0 }},
    { 53, 0, 3, 8, { 0 }},
    { 54, 0, 3, 8, { 0 }},
    { 55, 0, 3, 7, { 0 }},
    { 56, 0, 3, 8, { 0 }},
    { 57, 0, 3, 8, { 0 }},
    { 58, 0, 6, 2, { 0 }},
    { 59, 0, 6, 3, { 0 }},
    { 60, 0, 3, 5, { 0 }},
    { 61, 0, 6, 6, { 0 }},
    { 62, 0, 3, 5, { 0 }},
    { 63, 0, 3, 7, { 0 }},
    { 64, 0, 3, 8, { 0 }},
    { 65, 0, 3, 8, { 0 }},
    { 66, 0, 3, 8, { 0 }},
    { 67, 0, 3, 8, { 0 }},
    { 68, 0, 3, 8, { 0 }},
    { 69, 0, 3, 7, { 0 }},
    { 70, 0, 3, 7, { 0 }},
    { 71, 0, 3, 8, { 0 }},
    { 72, 0, 3, 8, { 0 }},
    { 73, 0, 3, 6, { 0 }},
    { 74, 0, 3, 7, { 0 }},
    { 75, 0, 3, 8, { 0 }},
    { 76, 0, 3, 7, { 0 }},
    { 77, 0, 3, 9, { 0 }},
    { 78, 0, 3, 8, { 0 }},
    { 79, 0, 3, 8, { 0 }},
    { 80, 0, 3, 8, { 0 }},
    { 81, 0, 3, 8, { 0 }},
    { 82, 0, 3, 8, { 0 }},
    { 83, 0, 3, 8, { 0 }},
    { 84, 0, 3, 8, { 0 }},
    { 85, 0, 3, 8, { 0 }},
    { 86, 0, 3, 8, { 0 }},
    { 87, 0, 3, 10, { 0 }},
    { 88, 0, 3, 8, { 0 }},
    { 89, 0, 3, 8, { 0 }},
    { 90, 0, 3, 8, { 0 }},
    { 91, 0, 3, 4, { 0 }},
    { 92, 0, 3, 8, { 0 }},
    { 93, 0, 3, 4, { 0 }},
    { 94, 0, 3, 4, { 0 }},
    { 95, 0, 11, 7, { 0 }},
    { 96, 0, 3, 3, { 0 }},
    { 97, 0, 6, 7, { 0 }},
    { 98, 0, 3, 7, { 0 }},
    { 99, 0, 6, 7, { 0 }},
    { 100, 0, 3, 7, { 0 }},
    { 101, 0, 6, 7, { 0 }},
    { 102, 0, 3, 5, { 0 }},
    { 103, 0, 6, 7, { 0 }},
    { 104, 0, 3, 7, { 0 }},
    { 105, 0, 3, 2, { 0 }},
    { 106, -2, 3, 2, { 0 }},
    { 107, 0, 3, 7, { 0 }},
    { 108, 0, 3, 4, { 0 }},
    { 109, 0, 6, 10, { 0 }},
    { 110, 0, 6, 7, { 0 }},
    { 111, 0, 6, 7, { 0 }},
    { 112, 0, 6, 7, { 0 }},
    { 113, 0, 6, 7, { 0 }},
    { 114, 0, 6, 6, { 0 }},
    { 115, 0, 6, 7, { 0 }},
    { 116, 0, 3, 6, { 0 }},
    { 117, 0, 6, 7, { 0 }},
    { 118, 0, 6, 7, { 0 }},
    { 119, 0, 6, 10, { 0 }},
    { 120, 0, 6, 7, { 0 }},
    { 121, 0, 6, 7, { 0 }},
    { 122, 0, 6, 7, { 0 }},
    { 123, 0, 3, 5, { 0 }},
    { 124, 0, 3, 2, { 0 }},
    { 125, 0, 3, 5, { 0 }},
    { 126, 0, 6, 8, { 0 }},
    { 161, 0, 3, 2, { 0 }},
    { 162, 0, 4, 7, { 0 }},
    { 163, 0, 3, 7, { 0 }},
    { 8364, 0, 3, 9, { 0 }},
    { 165, 0, 3, 8, { 0 }},
    { 352, 0, 1, 8, { 0 }},
    { 167, 0, 4, 5, { 0 }},
    { 353, 0, 3, 7, { 0 }},
    { 169, 0, 3, 9, { 0 }},
    { 170, 0, 3, 7, { 0 }},
    { 171, 0, 6, 6, { 0 }},
    { 172, 0, 7, 6, { 0 }},
    { 174, 0, 3, 9, { 0 }},
    { 175, 0, 0, 0, { 0 }},
    { 176, 0, 3, 4, { 0 }},
    { 177, 0, 6, 8, { 0 }},
    { 178, 0, 3, 4, { 0 }},
    { 179, 0, 3, 4, { 0 }},
    { 381, 0, 1, 8, { 0 }},
    { 181, 0, 6, 7, { 0 }},
    { 182, 0, 4, 6, { 0 }},
    { 183, 0, 7, 2, { 0 }},
    { 382, 0, 3, 7, { 0 }},
    { 185, 0, 3, 4, { 0 }},
    { 186, 0, 3, 5, { 0 }},
    { 187, 0, 6, 6, { 0 }},
    { 338, 0, 3, 14, { 0 }},
    { 339, 0, 6, 13, { 0 }},
    { 376, 0, 2, 8, { 0 }},
    { 191, 0, 3, 7, { 0 }},
    { 192, 0, 1, 8, { 0 }},
    { 193, 0, 1, 8, { 0 }},
    { 194, 0, 1, 8, { 0 }},
    { 195, 0, 1, 8, { 0 }},
    { 196, 0, 2, 8, { 0 }},
    { 197, 0, -1, 8, { 0 }},
    { 198, 0, 3, 14, { 0 }},
    { 199, 0, 3, 8, { 0 }},
    { 200, 0, 1, 7, { 0 }},
    { 201, 0, 1, 7, { 0 }},
    { 202, 0, 1, 7, { 0 }},
    { 203, 0, 2, 7, { 0 }},
    { 204, 0, 1, 6, { 0 }},
    { 205, 0, 1, 6, { 0 }},
    { 206, 0, 1, 6, { 0 }},
    { 207, 0, 2, 6, { 0 }},
    { 208, 0, 3, 9, { 0 }},
    { 209, 0, 1, 8, { 0 }},
    { 210, 0, 1, 8, { 0 }},
    { 211, 0, 1, 8, { 0 }},
    { 212, 0, 1, 8, { 0 }},
    { 213, 0, 1, 8, { 0 }},
    { 214, 0, 2, 8, { 0 }},
    { 215, 1, 6, 6, { 0 }},
    { 216, 0, 3, 8, { 0 }},
    { 217, 0, 1, 8, { 0 }},
    { 218, 0, 1, 8, { 0 }},
    { 219, 0, 1, 8, { 0 }},
    { 220, 0, 2, 8, { 0 }},
    { 221, 0, 1, 8, { 0 }},
    { 222, 0, 3, 7, { 0 }},
    { 223, 0, 3, 7, { 0 }},
    { 224, 0, 3, 7, { 0 }},
    { 225, 0, 3, 7, { 0 }},
    { 226, 0, 3, 7, { 0 }},
    { 227, 0, 3, 7, { 0 }},
    { 228, 0, 3, 7, { 0 }},
    { 229, 0, 2, 7, { 0 }},
    { 230, 0, 6, 13, { 0 }},
    { 231, 0, 6, 7, { 0 }},
    { 232, 0, 3, 7, { 0 }},
    { 233, 0, 3, 7, { 0 }},
    { 234, 0, 3, 7, { 0 }},
    { 235, 0, 3, 7, { 0 }},
    { 236, -1, 3, 2, { 0 }},
    { 237, 0, 3, 2, { 0 }},
    { 238, -1, 3, 2, { 0 }},
    { 239, -1, 3, 2, { 0 }},
    { 240, 0, 3, 8, { 0 }},
    { 241, 0, 3, 7, { 0 }},
    { 242, 0, 3, 7, { 0 }},
    { 243, 0, 3, 7, { 0 }},
    { 244, 0, 3, 7, { 0 }},
    { 245, 0, 3, 7, { 0 }},
    { 246, 0, 3, 7, { 0 }},
    { 247, 0, 4, 6, { 0 }},
    { 248, 0, 6, 7, { 0 }},
    { 249, 0, 3, 7, { 0 }},
    { 250, 0, 3, 7, { 0 }},
    { 251, 0, 3, 7, { 0 }},
    { 252, 0, 3, 7, { 0 }},
    { 253, 0, 3, 7, { 0 }},
    { 254, 0, 3, 7, { 0 }},
    { 255, 0, 3, 7, { 0 }},
};

// Style loading function: Cyber
static void GuiLoadStyleCyber(void)
{
    // Load style properties provided
    // NOTE: Default properties are propagated
    for (int i = 0; i < CYBER_STYLE_PROPS_COUNT; i++)
    {
        GuiSetStyle(cyberStyleProps[i].controlId, cyberStyleProps[i].propertyId, cyberStyleProps[i].propertyValue);
    }

    // Custom font loading
    // NOTE: Compressed font image data (DEFLATE), it requires DecompressData() function
    int cyberFontDataSize = 0;
    unsigned char *data = DecompressData(cyberFontData, CYBER_STYLE_FONT_ATLAS_COMP_SIZE, &cyberFontDataSize);
    Image imFont = { data, 512, 256, 1, 2 };

    Font font = { 0 };
    font.baseSize = 14;
    font.glyphCount = 189;

    // Load texture from image
    font.texture = LoadTextureFromImage(imFont);
    UnloadImage(imFont);  // Uncompressed image data can be unloaded from memory

    // Copy char recs data from global fontRecs
    // NOTE: Required to avoid issues if trying to free font
    font.recs = (Rectangle *)RAYGUI_MALLOC(font.glyphCount*sizeof(Rectangle));
    memcpy(font.recs, cyberFontRecs, font.glyphCount*sizeof(Rectangle));

    // Copy font char info data from global fontChars
    // NOTE: Required to avoid issues if trying to free font
    font.glyphs = (GlyphInfo *)RAYGUI_MALLOC(font.glyphCount*sizeof(GlyphInfo));
    memcpy(font.glyphs, cyberFontGlyphs, font.glyphCount*sizeof(GlyphInfo));

    GuiSetFont(font);

    // Setup a white rectangle on the font to be used on shapes drawing,
    // it makes possible to draw shapes and text (full UI) in a single draw call
    Rectangle fontWhiteRec = { 510, 254, 1, 1 };
    SetShapesTexture(font.texture, fontWhiteRec);

    //-----------------------------------------------------------------

    // TODO: Custom user style setup: Set specific properties here (if required)
    // i.e. Controls specific BORDER_WIDTH, TEXT_PADDING, TEXT_ALIGNMENT
}
