//////////////////////////////////////////////////////////////////////////////////
//                                                                              //
// StyleAsCode exporter v2.0 - Style data exported as a values array            //
//                                                                              //
// USAGE: On init call: GuiLoadStyleJungle();                                   //
//                                                                              //
// more info and bugs-report:  github.com/raysan5/raygui                        //
// feedback and support:       ray[at]raylibtech.com                            //
//                                                                              //
// Copyright (c) 2020-2025 raylib technologies (@raylibtech)                    //
//                                                                              //
//////////////////////////////////////////////////////////////////////////////////

#define JUNGLE_STYLE_PROPS_COUNT  17

// Custom style name: Jungle
static const GuiStyleProp jungleStyleProps[JUNGLE_STYLE_PROPS_COUNT] = {
    { 0, 0, (int)0x60827dff },    // DEFAULT_BORDER_COLOR_NORMAL 
    { 0, 1, (int)0x2c3334ff },    // DEFAULT_BASE_COLOR_NORMAL 
    { 0, 2, (int)0x82a29fff },    // DEFAULT_TEXT_COLOR_NORMAL 
    { 0, 3, (int)0x5f9aa8ff },    // DEFAULT_BORDER_COLOR_FOCUSED 
    { 0, 4, (int)0x334e57ff },    // DEFAULT_BASE_COLOR_FOCUSED 
    { 0, 5, (int)0x6aa9b8ff },    // DEFAULT_TEXT_COLOR_FOCUSED 
    { 0, 6, (int)0xa9cb8dff },    // DEFAULT_BORDER_COLOR_PRESSED 
    { 0, 7, (int)0x3b6357ff },    // DEFAULT_BASE_COLOR_PRESSED 
    { 0, 8, (int)0x97af81ff },    // DEFAULT_TEXT_COLOR_PRESSED 
    { 0, 9, (int)0x5b6462ff },    // DEFAULT_BORDER_COLOR_DISABLED 
    { 0, 10, (int)0x2c3334ff },    // DEFAULT_BASE_COLOR_DISABLED 
    { 0, 11, (int)0x666b69ff },    // DEFAULT_TEXT_COLOR_DISABLED 
    { 0, 16, (int)0x0000000c },    // DEFAULT_TEXT_SIZE 
    { 0, 17, (int)0x00000000 },    // DEFAULT_TEXT_SPACING 
    { 0, 18, (int)0x638465ff },    // DEFAULT_LINE_COLOR 
    { 0, 19, (int)0x2b3a3aff },    // DEFAULT_BACKGROUND_COLOR 
    { 0, 20, (int)0x00000012 },    // DEFAULT_TEXT_LINE_SPACING 
};

// WARNING: This style uses a custom font: "PixelIntv.otf" (size: 12, spacing: 0)

#define JUNGLE_STYLE_FONT_ATLAS_COMP_SIZE 2059

// Font atlas image pixels data: DEFLATE compressed
static unsigned char jungleFontData[JUNGLE_STYLE_FONT_ATLAS_COMP_SIZE] = { 0xed,
    0x9d, 0xbd, 0x8e, 0x1d, 0x35, 0x18, 0x86, 0x8d, 0x39, 0x1d, 0x25, 0xa2, 0x00, 0x09, 0x91, 0x06, 0x89, 0x86, 0x86, 0x28,
    0x12, 0x74, 0x7b, 0x01, 0xd4, 0x08, 0x51, 0x20, 0x2a, 0x1a, 0xe0, 0x1e, 0xc8, 0x95, 0xa5, 0xa1, 0xe7, 0x06, 0xb8, 0x0b,
    0x2e, 0xe0, 0x8b, 0x36, 0x9b, 0xdd, 0xec, 0xee, 0x99, 0xb1, 0xfd, 0xfd, 0xd8, 0x9e, 0x9f, 0x67, 0x1f, 0x25, 0x52, 0xc6,
    0x67, 0x66, 0x6c, 0xbf, 0xb6, 0x67, 0x36, 0xdf, 0x7b, 0x3e, 0x4b, 0x02, 0x00, 0x00, 0x00, 0xb8, 0xe2, 0xf6, 0x67, 0xf9,
    0xd8, 0x52, 0x49, 0x7a, 0x5f, 0xd2, 0x7e, 0xad, 0xfb, 0xe3, 0x77, 0x25, 0x79, 0xf5, 0x13, 0xcb, 0x57, 0xcc, 0x2b, 0x75,
    0x58, 0xab, 0xf5, 0x7a, 0xcd, 0x92, 0xaa, 0x64, 0xfd, 0xfa, 0xeb, 0xfd, 0x95, 0x14, 0x6d, 0x78, 0xfa, 0x93, 0x14, 0x6d,
    0x29, 0x9f, 0xd7, 0x5b, 0xff, 0x72, 0x1f, 0xac, 0x97, 0xdd, 0xfd, 0xb9, 0xed, 0x89, 0xac, 0xb8, 0xe6, 0xfa, 0xe7, 0x93,
    0x6a, 0x04, 0xea, 0x47, 0x86, 0xae, 0x77, 0x4b, 0x9f, 0xae, 0xb5, 0x41, 0x94, 0x35, 0xb8, 0x3f, 0xde, 0x53, 0xff, 0xf4,
    0x70, 0x8f, 0xf6, 0xf9, 0x5f, 0x53, 0x45, 0xe4, 0xb2, 0xd8, 0x13, 0xa9, 0xa8, 0x4d, 0x36, 0xdc, 0x29, 0x62, 0x34, 0xa7,
    0xa0, 0xde, 0xcd, 0xc5, 0x36, 0x88, 0x41, 0x7f, 0xdb, 0x08, 0x8d, 0xba, 0x8e, 0x6d, 0xfe, 0xdf, 0x72, 0x79, 0x37, 0x02,
    0xca, 0x57, 0xf5, 0xd7, 0x38, 0x6a, 0xfe, 0xa7, 0xae, 0xea, 0x7b, 0xf4, 0x1f, 0xb1, 0xfe, 0x97, 0x3f, 0x5f, 0xee, 0xb3,
    0xe5, 0xeb, 0xe5, 0xf7, 0xf3, 0x5f, 0xff, 0xf4, 0x8c, 0xd0, 0x5f, 0xff, 0xfc, 0xef, 0xab, 0x7e, 0xc4, 0xfa, 0xbf, 0xc5,
    0xf7, 0xc8, 0xda, 0x73, 0x7c, 0x79, 0xec, 0x48, 0xf7, 0xf9, 0x3f, 0x83, 0x92, 0xfa, 0xb5, 0xf7, 0x3f, 0x71, 0xac, 0xb3,
    0xbd, 0xe7, 0xbf, 0xe5, 0x5a, 0xf7, 0x3d, 0x21, 0x86, 0xf9, 0xb9, 0x57, 0xfd, 0x4b, 0xea, 0x43, 0xc4, 0x5a, 0xa3, 0x79,
    0xca, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x33, 0x62, 0x52, 0x8e, 0xbf, 0x47,
    0x46, 0x22, 0x7b, 0x95, 0xb5, 0xbb, 0x0d, 0x34, 0xce, 0x95, 0x6c, 0xe8, 0xb1, 0x59, 0xfd, 0xd2, 0xcb, 0xed, 0x97, 0xd4,
    0xde, 0x8c, 0x96, 0xda, 0x58, 0xef, 0xe7, 0xd1, 0x3f, 0x2b, 0x63, 0xaf, 0x65, 0x87, 0xde, 0x9a, 0x9f, 0x71, 0x3d, 0x72,
    0xed, 0x6d, 0x9f, 0xb6, 0x4c, 0xb7, 0x02, 0xa4, 0x21, 0xf3, 0xbf, 0xcd, 0xc3, 0xd4, 0xc7, 0xdd, 0xb8, 0xec, 0x33, 0x2b,
    0xd5, 0xf5, 0xa2, 0x76, 0x14, 0x7e, 0x88, 0x36, 0xf7, 0x1d, 0xdf, 0xd1, 0xae, 0x4f, 0xab, 0xa3, 0xc4, 0x32, 0x26, 0x2d,
    0x0e, 0xd6, 0x88, 0xf5, 0x3f, 0x66, 0xfe, 0x97, 0xc6, 0xa9, 0x3c, 0xfb, 0x13, 0xb3, 0x8e, 0xcf, 0xd2, 0xbf, 0xc7, 0x5a,
    0x9d, 0x1a, 0x56, 0x05, 0x6b, 0x5d, 0x6c, 0xcf, 0x7f, 0x8b, 0x53, 0xa7, 0xe4, 0x56, 0xb2, 0xbf, 0x4f, 0xcd, 0x98, 0xff,
    0x9e, 0x39, 0x6e, 0x5b, 0xff, 0xcb, 0xfa, 0xc7, 0xb9, 0xdb, 0x64, 0xca, 0xdb, 0x74, 0xcb, 0x1c, 0xdb, 0xd6, 0xf3, 0x1f,
    0x22, 0xfd, 0x8c, 0xf3, 0x7e, 0x9f, 0x42, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xe8, 0xeb, 0xc7, 0x1b, 0xe5, 0x29, 0x91, 0xc6, 0x2c, 0x3e, 0xeb, 0x7e, 0xad, 0x51, 0x6e, 0xbd, 0xf1, 0xfd, 0x1d, 0xed,
    0xfb, 0x88, 0x88, 0x49, 0x5b, 0x32, 0x98, 0xf9, 0xbd, 0x88, 0xb2, 0x09, 0x47, 0x5e, 0x8f, 0x7e, 0x9b, 0xa9, 0xbf, 0xa5,
    0x3e, 0x76, 0xfd, 0xc5, 0x98, 0x61, 0xb0, 0x96, 0x19, 0x66, 0x5b, 0xfa, 0x5b, 0x5c, 0x07, 0x1e, 0xfd, 0xeb, 0x6b, 0x55,
    0x2a, 0xe8, 0xa1, 0x5f, 0xe3, 0xad, 0xfa, 0x8b, 0x31, 0xef, 0x63, 0x9f, 0xa7, 0x58, 0x1f, 0xfd, 0x2d, 0xfd, 0x76, 0x94,
    0xf5, 0xbf, 0x7e, 0xcd, 0x6c, 0x5c, 0xff, 0xa5, 0xba, 0xaa, 0x48, 0xb8, 0x1b, 0x55, 0x3f, 0xa7, 0x5a, 0xfb, 0xe7, 0xbc,
    0xfa, 0xa7, 0x2e, 0xfa, 0xf7, 0xb9, 0xe3, 0x7e, 0x9e, 0xff, 0x96, 0xec, 0xd5, 0x33, 0x7c, 0x6e, 0x3e, 0x6f, 0x78, 0xad,
    0x74, 0x44, 0xcf, 0xf4, 0x5b, 0xff, 0x71, 0x01, 0xee, 0xc7, 0x25, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x30, 0x22, 0x46, 0x61, 0x8f, 0x9d, 0xf5, 0x88, 0x00, 0x5e, 0x1f, 0xcf, 0x0d, 0x31, 0xcc, 0xe7, 0xc7,
    0xf3, 0x8a, 0x63, 0x44, 0x94, 0x39, 0xff, 0x6c, 0xfb, 0xf1, 0xb6, 0xe6, 0x41, 0xb3, 0x3b, 0x08, 0x23, 0xe2, 0x80, 0xe3,
    0xf5, 0x4f, 0x4d, 0xf1, 0xd8, 0x6b, 0x25, 0xb3, 0xc1, 0x33, 0x94, 0x95, 0x19, 0x9f, 0x4a, 0x19, 0xa2, 0xf4, 0x6e, 0xa6,
    0x7a, 0x2f, 0x58, 0x72, 0xdd, 0xd5, 0xae, 0x66, 0xdb, 0xa1, 0xb8, 0xe4, 0x8e, 0xa9, 0x79, 0x59, 0xf4, 0x2d, 0xcf, 0xea,
    0xb6, 0xe5, 0x86, 0x35, 0xa0, 0xbf, 0x47, 0x3a, 0xa9, 0xe7, 0xa3, 0xcf, 0x77, 0xd7, 0x5f, 0xff, 0xd4, 0xe0, 0xf1, 0x8b,
    0x76, 0xa4, 0x48, 0x65, 0xf7, 0x5b, 0xcb, 0x08, 0xe8, 0xad, 0x7f, 0xad, 0xad, 0x76, 0x97, 0x50, 0x0a, 0x1d, 0x37, 0xd1,
    0xfa, 0xb7, 0x8c, 0xd3, 0xe8, 0x11, 0x6c, 0x19, 0x01, 0x63, 0xe6, 0xbf, 0xa8, 0xf5, 0x2f, 0xaf, 0x0d, 0xf1, 0xbd, 0x67,
    0x71, 0x01, 0xd9, 0x56, 0x14, 0xaf, 0x5b, 0xcd, 0xa2, 0x62, 0x36, 0xad, 0x1c, 0x23, 0xde, 0xa0, 0x6d, 0x7b, 0x55, 0x47,
    0x3b, 0x36, 0x6d, 0x3d, 0x31, 0x5e, 0x7f, 0x31, 0xef, 0xf8, 0x9d, 0x37, 0xb7, 0xfb, 0xb5, 0x6d, 0xd6, 0xd9, 0x1d, 0x7b,
    0xf1, 0xf3, 0x7f, 0x7b, 0xdf, 0x46, 0x1b, 0x71, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xc0, 0x39, 0x73, 0x14, 0xe8, 0x33, 0xd5, 0xd4, 0xcf, 0xb0, 0xee, 0x9d, 0x35, 0x72, 0xef, 0xdc, 0x5e, 0xfb, 0xdb, 0xd9,
    0xf3, 0x82, 0x49, 0x97, 0x1d, 0xe0, 0xe2, 0xe3, 0x66, 0xbe, 0x2c, 0x66, 0xb5, 0x1e, 0xb2, 0x66, 0xdc, 0xd2, 0x7a, 0x30,
    0x3c, 0xbe, 0x1e, 0xab, 0xe7, 0x23, 0xde, 0x87, 0x17, 0xe3, 0x6d, 0xb3, 0xcd, 0x7f, 0x9b, 0x2f, 0x64, 0x6b, 0xfa, 0xa7,
    0x41, 0xfe, 0x3c, 0x8f, 0xfe, 0xde, 0xdd, 0x9f, 0xed, 0x8e, 0x2c, 0x7d, 0xaf, 0x1e, 0x41, 0xff, 0x36, 0xf7, 0xae, 0xc5,
    0x47, 0x18, 0xed, 0xc3, 0x9b, 0xa5, 0xbf, 0x98, 0xf6, 0xce, 0xf5, 0xe8, 0xef, 0xf3, 0xcb, 0x8f, 0x9b, 0xff, 0xf6, 0x3b,
    0xa6, 0x2e, 0x3b, 0xa3, 0x7b, 0x67, 0xab, 0x2e, 0x53, 0xe3, 0x0c, 0xa7, 0x56, 0xbc, 0x5f, 0xae, 0x97, 0xb3, 0x6b, 0xae,
    0x7b, 0x31, 0xca, 0xbf, 0xea, 0xcd, 0xfe, 0x3d, 0x43, 0x7f, 0xbc, 0x63, 0xc7, 0x1e, 0xe5, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x67, 0x8b, 0xe3, 0xc4, 0xed, 0x47, 0xa5, 0xcd, 0xea, 0x26, 0x8b, 0x19, 0x3d,
    0xac, 0xb9, 0x63, 0xb4, 0xde, 0x0a, 0x4d, 0xec, 0x5c, 0x13, 0xbb, 0xcc, 0x8f, 0x3e, 0x7b, 0xed, 0x83, 0xf8, 0x5e, 0x5e,
    0x3c, 0xf0, 0x52, 0x3e, 0x5b, 0xcd, 0x72, 0xb2, 0xd4, 0x33, 0xb5, 0x73, 0xcb, 0x77, 0xb6, 0x38, 0x00, 0x74, 0xb9, 0xda,
    0x74, 0x47, 0xb3, 0xb2, 0x9e, 0x16, 0xd7, 0x85, 0x2f, 0x43, 0x9f, 0xf5, 0xb3, 0xf9, 0x89, 0x92, 0x4f, 0x79, 0xf5, 0xa4,
    0x77, 0x5f, 0x2e, 0xf6, 0x78, 0x5e, 0xc9, 0x75, 0x54, 0x3b, 0xb7, 0x7c, 0x67, 0xad, 0xfe, 0x59, 0x9d, 0xab, 0x4d, 0xaf,
    0x4e, 0x8c, 0xaf, 0xd0, 0x96, 0x15, 0xc7, 0xa2, 0x7f, 0x5b, 0xfd, 0x1f, 0xaf, 0xac, 0xcf, 0x4b, 0x5f, 0x14, 0xfe, 0x75,
    0x77, 0xf6, 0xe5, 0xe1, 0x6f, 0xfd, 0xb9, 0xa5, 0x3b, 0xeb, 0x9d, 0x3c, 0x36, 0x17, 0x97, 0x77, 0x04, 0x44, 0x66, 0x53,
    0x4c, 0xae, 0x0c, 0xad, 0x36, 0xc7, 0x83, 0x3c, 0xd9, 0x5b, 0x5e, 0xab, 0x61, 0x69, 0xfe, 0xb7, 0xe9, 0xbf, 0x76, 0xe7,
    0x64, 0xf4, 0xc7, 0xc9, 0x46, 0xe6, 0x7f, 0x8f, 0xac, 0x78, 0xa2, 0x9a, 0x27, 0xad, 0x6b, 0x85, 0x67, 0xfe, 0x97, 0x9e,
    0xff, 0xf1, 0xfa, 0x5b, 0x5d, 0x70, 0xa3, 0xf5, 0x4f, 0x66, 0x9f, 0xaa, 0xf5, 0xad, 0xd1, 0xbe, 0x02, 0x94, 0x9f, 0xc2,
    0x75, 0xfd, 0xd7, 0xa9, 0xeb, 0x6f, 0x79, 0xfe, 0xcb, 0x4e, 0xf4, 0x4f, 0x0e, 0x67, 0x6d, 0x94, 0x1f, 0xd5, 0xff, 0xfe,
    0xdf, 0x53, 0x7f, 0xfd, 0xfb, 0x7f, 0xac, 0xb3, 0xd2, 0x96, 0xd5, 0x71, 0x4f, 0xdf, 0x94, 0xf3, 0xb7, 0xe6, 0xd7, 0x47,
    0xbf, 0xc3, 0xbd, 0x92, 0x1f, 0x86, 0x9d, 0x0b, 0x31, 0x8e, 0x57, 0x3c, 0xaf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xb0, 0x75, 0xea, 0x5e, 0xb4, 0xcf, 0x17, 0xe3, 0x48, 0xb5, 0xf3, 0xbc, 0xe5, 0x5a, 0x97, 0xda, 0xd7,
    0xf2, 0xad, 0x7c, 0x79, 0x75, 0xf4, 0x8d, 0xbc, 0x91, 0xdf, 0xdc, 0x7d, 0x50, 0x2b, 0xbf, 0x8b, 0xb4, 0x2d, 0xc7, 0xdb,
    0x96, 0x7e, 0x2c, 0x9f, 0xd1, 0xc7, 0xb5, 0xdb, 0xa2, 0x7f, 0x35, 0x3f, 0xd9, 0x8f, 0x72, 0x23, 0x7f, 0x1a, 0xce, 0xf3,
    0x96, 0x6b, 0xf4, 0xff, 0x42, 0xfe, 0x93, 0x7f, 0xe5, 0xb5, 0x7c, 0xb5, 0x78, 0xd6, 0xdf, 0xee, 0x3e, 0xf0, 0xf8, 0xf5,
    0x34, 0x3b, 0x21, 0xc7, 0x45, 0x18, 0xdb, 0xa3, 0xff, 0xb5, 0x78, 0xf2, 0x2f, 0xf2, 0x91, 0xfc, 0xb4, 0xe0, 0x44, 0xab,
    0x9d, 0xe7, 0x2d, 0xd7, 0xe8, 0xff, 0x97, 0x88, 0xfc, 0x23, 0xbf, 0xcb, 0xc7, 0x57, 0x25, 0x37, 0x72, 0xd3, 0x70, 0x6d,
    0x7f, 0x5d, 0x2f, 0xef, 0xea, 0x75, 0x71, 0xee, 0x84, 0x1d, 0x39, 0xff, 0xa3, 0xfc, 0x04, 0x9f, 0xca, 0xcf, 0xf2, 0x5d,
    0x87, 0x3e, 0x8b, 0xd4, 0xff, 0x1b, 0xf9, 0x7f, 0x45, 0xff, 0x98, 0x3e, 0xf0, 0xf8, 0xf5, 0xae, 0xb5, 0x8d, 0x71, 0x16,
    0x48, 0x63, 0x26, 0x5d, 0x6f, 0xdb, 0x7b, 0xf5, 0x99, 0x45, 0xff, 0xf5, 0x36, 0x7d, 0x22, 0xaf, 0x27, 0xea, 0x5f, 0x7b,
    0xfe, 0x27, 0x45, 0xce, 0x58, 0x8d, 0x1b, 0x35, 0xc2, 0xa9, 0xb2, 0x27, 0xfd, 0x4b, 0xe5, 0x7f, 0x4c, 0xd4, 0x7f, 0x8c,
    0x6b, 0xa8, 0xfd, 0xba, 0xe8, 0xbf, 0x2d, 0xfd, 0x2d, 0xef, 0xf6, 0x9e, 0xf5, 0x50, 0x73, 0x2f, 0xab, 0x9f, 0xac, 0x76,
    0x9e, 0xb7, 0x5c, 0x8b, 0x47, 0xff, 0xd1, 0x75, 0xdd, 0x8f, 0x53, 0x11, 0xce, 0xed, 0x54, 0x05, 0xf4, 0x07, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x3d, 0x93, 0x2b, 0xb9, 0xdf, 0x72, 0xa1, 0xc4, 0xe2, 0x67, 0x68, 0xdb, 0x01,
    0x58, 0x8c, 0x39, 0x09, 0x73, 0x68, 0x3b, 0xeb, 0x6d, 0x19, 0x77, 0xbf, 0x52, 0xcb, 0x4b, 0x7a, 0xd4, 0xff, 0xbf, 0x38,
    0x17, 0x4a, 0xb2, 0x3a, 0x77, 0x9f, 0x6f, 0x07, 0x58, 0x9f, 0xb7, 0x21, 0x9b, 0x3c, 0x91, 0xa5, 0x76, 0x6e, 0xe7, 0x7e,
    0xe5, 0xb2, 0x3c, 0x24, 0xe7, 0xcb, 0xec, 0xb8, 0xc5, 0x99, 0x63, 0x1a, 0x52, 0x75, 0x41, 0x8f, 0xf3, 0x11, 0xf4, 0x2e,
    0xb3, 0xe6, 0xf9, 0xdc, 0x62, 0x5b, 0x22, 0xcb, 0xd6, 0xe7, 0xbf, 0x6d, 0x7e, 0xd8, 0xd7, 0x9b, 0xb1, 0x65, 0x1a, 0xdf,
    0xdb, 0xa8, 0xb2, 0xd1, 0xf7, 0x8c, 0xf2, 0x7c, 0x1d, 0x41, 0x7f, 0x4b, 0x86, 0xd0, 0xa3, 0xeb, 0x2f, 0xc1, 0x99, 0xf3,
    0x66, 0xae, 0x6f, 0xbe, 0x6b, 0xa7, 0x21, 0x65, 0x33, 0xf4, 0x6f, 0xd9, 0x23, 0x7e, 0xaf, 0xf3, 0x5f, 0x5b, 0xe7, 0xb3,
    0xcd, 0xff, 0xb6, 0xef, 0x47, 0x1c, 0x5d, 0x7f, 0x41, 0xff, 0x40, 0xcf, 0xd7, 0x1e, 0xe7, 0xff, 0x59, 0xdf, 0xff, 0xdb,
    0xc6, 0x21, 0x9e, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe8, 0xe7, 0x61, 0xb3, 0x7a, 0x03, 0xdb,
    0xbc, 0x6f, 0xdb, 0xf0, 0xfd, 0x65, 0xd3, 0x6e, 0x62, 0xe5, 0x36, 0xd8, 0xbc, 0x64, 0x7e, 0xdf, 0x57, 0xbc, 0x87, 0xcd,
    0xda, 0xaf, 0xf6, 0x1c, 0x59, 0xa3, 0x7d, 0x7f, 0xa5, 0x5d, 0x71, 0xad, 0xbb, 0x4d, 0xdb, 0xc6, 0xf0, 0x7a, 0x1b, 0xf6,
    0xec, 0x01, 0x5c, 0x3a, 0x9e, 0x77, 0xb0, 0xfb, 0xd6, 0xac, 0xd8, 0xd7, 0x11, 0x62, 0x66, 0xa9, 0x5a, 0x92, 0x37, 0xef,
    0x53, 0xaa, 0x97, 0x8d, 0xf5, 0xa7, 0x1c, 0xc5, 0xff, 0x75, 0xf4, 0xb2, 0xf1, 0x8e, 0x81, 0x7d, 0xc5, 0xff, 0xf7, 0xa4,
    0xb1, 0xcd, 0xbf, 0xcb, 0xfc, 0xf7, 0x3c, 0xa7, 0xb6, 0x36, 0x36, 0xb4, 0x1e, 0xad, 0xda, 0xb3, 0xc1, 0x52, 0x76, 0x16,
    0xff, 0xcf, 0x96, 0xe6, 0xf8, 0x96, 0xde, 0xc3, 0xd0, 0xbf, 0x5f, 0x3d, 0x8f, 0xf2, 0x3d, 0xa4, 0xbd, 0xf8, 0xdb, 0xb6,
    0xd4, 0x86, 0xb3, 0x7f, 0x0f, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf6, 0xc1, 0x98, 0x3c, 0x7e,
    0x5b, 0x77, 0xf3, 0x8d, 0xbd, 0x9f, 0x3d, 0x8b, 0x5f, 0x0e, 0xd8, 0xf1, 0x37, 0xca, 0xab, 0xd7, 0xe2, 0x75, 0xb4, 0x46,
    0x57, 0x8e, 0x9c, 0xc5, 0x2f, 0x15, 0x47, 0x46, 0xd9, 0xcd, 0x69, 0x1b, 0xa7, 0x33, 0x63, 0x4a, 0xa2, 0x8e, 0x92, 0x1f,
    0xdf, 0x6d, 0x1d, 0x1f, 0x01, 0x8b, 0xa8, 0x4d, 0x6c, 0x99, 0xcf, 0xcb, 0x34, 0xc3, 0x75, 0xa8, 0xcd, 0x36, 0x63, 0x2d,
    0x6b, 0x73, 0x01, 0xce, 0x71, 0x01, 0xc4, 0x94, 0xf9, 0x9e, 0xff, 0x5b, 0x8b, 0xe6, 0xf7, 0xc9, 0xe2, 0xa6, 0x2f, 0xed,
    0xe3, 0xaa, 0x98, 0xe5, 0x3b, 0x4b, 0xa6, 0xdd, 0xab, 0x67, 0x44, 0xf3, 0x8f, 0xaf, 0xff, 0x2c, 0xdf, 0xd9, 0x39, 0xb3,
    0x78, 0xb5, 0x8c, 0xc4, 0x19, 0xf3, 0x7f, 0xbe, 0x8f, 0x67, 0x7b, 0x8e, 0xa4, 0xf1, 0xbd, 0x53, 0xd6, 0x7f, 0xbc, 0x1a,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb0, 0x67, 0x07, 0x60, 0xb4, 0x37, 0xd0, 0xe2, 0x7d,
    0x89, 0xce, 0x80, 0xe7, 0xc9, 0xe2, 0x27, 0x06, 0x5f, 0xdb, 0x3e, 0xfd, 0x48, 0x3d, 0xf6, 0xf8, 0x5d, 0xef, 0xbb, 0x1c,
    0xee, 0xfb, 0x8c, 0xcf, 0xe2, 0x97, 0x4e, 0xa4, 0xff, 0x48, 0x4f, 0x59, 0x29, 0x8b, 0xdb, 0x5e, 0xda, 0x70, 0x1e, 0x37,
    0x62, 0x7c, 0xc4, 0xd9, 0x93, 0x1d, 0xaf, 0x47, 0x99, 0xe5, 0xcc, 0x1e, 0xbb, 0x30, 0xcf, 0xd5, 0xbf, 0x8f, 0xa3, 0xce,
    0x32, 0xda, 0x46, 0xea, 0x3f, 0xcf, 0xfb, 0x74, 0x06, 0xfd, 0xad, 0x35, 0x41, 0x7f, 0xf4, 0xdf, 0x8a, 0xfe, 0x72, 0x12,
    0xfd, 0xb7, 0xe1, 0xff, 0x9b, 0x97, 0x6d, 0x58, 0xcc, 0xdf, 0x50, 0xe0, 0x5d, 0xff, 0x38, 0x2b, 0xa0, 0xf6, 0x1b, 0x4a,
    0xe8, 0x7f, 0xdc, 0xdf, 0x53, 0xf9, 0xdd, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x90, 0xb9, 0x10, 0xfd, 0xd1, 0xff, 0xe4, 0xfa, 0xbf, 0x05 };

// Font glyphs rectangles data (on atlas)
static const Rectangle jungleFontRecs[189] = {
    { 4, 4, 5 , 12 },
    { 17, 4, 2 , 7 },
    { 27, 4, 5 , 3 },
    { 40, 4, 5 , 5 },
    { 53, 4, 6 , 7 },
    { 67, 4, 7 , 7 },
    { 82, 4, 5 , 7 },
    { 95, 4, 3 , 3 },
    { 106, 4, 4 , 8 },
    { 118, 4, 4 , 8 },
    { 130, 4, 5 , 5 },
    { 143, 4, 5 , 5 },
    { 156, 4, 2 , 3 },
    { 166, 4, 5 , 1 },
    { 179, 4, 2 , 2 },
    { 189, 4, 7 , 7 },
    { 204, 4, 7 , 6 },
    { 219, 4, 6 , 6 },
    { 233, 4, 6 , 6 },
    { 4, 24, 6 , 6 },
    { 18, 24, 6 , 6 },
    { 32, 24, 6 , 6 },
    { 46, 24, 6 , 6 },
    { 60, 24, 6 , 6 },
    { 74, 24, 6 , 6 },
    { 88, 24, 6 , 6 },
    { 102, 24, 2 , 5 },
    { 112, 24, 2 , 6 },
    { 122, 24, 3 , 5 },
    { 133, 24, 5 , 3 },
    { 146, 24, 3 , 5 },
    { 157, 24, 6 , 7 },
    { 171, 24, 7 , 7 },
    { 186, 24, 6 , 7 },
    { 200, 24, 6 , 7 },
    { 214, 24, 6 , 7 },
    { 228, 24, 6 , 7 },
    { 4, 44, 6 , 7 },
    { 18, 44, 6 , 7 },
    { 32, 44, 6 , 7 },
    { 46, 44, 6 , 7 },
    { 60, 44, 6 , 7 },
    { 74, 44, 6 , 7 },
    { 88, 44, 6 , 7 },
    { 102, 44, 6 , 7 },
    { 116, 44, 7 , 7 },
    { 131, 44, 6 , 7 },
    { 145, 44, 6 , 7 },
    { 159, 44, 6 , 7 },
    { 173, 44, 7 , 8 },
    { 188, 44, 6 , 7 },
    { 202, 44, 6 , 7 },
    { 216, 44, 6 , 7 },
    { 230, 44, 6 , 7 },
    { 4, 64, 6 , 7 },
    { 18, 64, 7 , 7 },
    { 33, 64, 6 , 7 },
    { 47, 64, 6 , 7 },
    { 61, 64, 6 , 7 },
    { 75, 64, 4 , 8 },
    { 87, 64, 7 , 7 },
    { 102, 64, 4 , 8 },
    { 114, 64, 4 , 2 },
    { 126, 64, 6 , 1 },
    { 140, 64, 2 , 2 },
    { 150, 64, 6 , 5 },
    { 164, 64, 6 , 7 },
    { 178, 64, 6 , 5 },
    { 192, 64, 6 , 7 },
    { 206, 64, 6 , 5 },
    { 220, 64, 6 , 7 },
    { 234, 64, 6 , 7 },
    { 4, 84, 6 , 7 },
    { 18, 84, 6 , 7 },
    { 32, 84, 5 , 8 },
    { 45, 84, 6 , 7 },
    { 59, 84, 6 , 7 },
    { 73, 84, 7 , 5 },
    { 88, 84, 6 , 5 },
    { 102, 84, 6 , 5 },
    { 116, 84, 6 , 7 },
    { 130, 84, 6 , 7 },
    { 144, 84, 6 , 5 },
    { 158, 84, 6 , 5 },
    { 172, 84, 6 , 6 },
    { 186, 84, 6 , 5 },
    { 200, 84, 6 , 5 },
    { 214, 84, 7 , 5 },
    { 229, 84, 6 , 5 },
    { 4, 104, 6 , 7 },
    { 18, 104, 6 , 5 },
    { 32, 104, 4 , 8 },
    { 44, 104, 2 , 8 },
    { 54, 104, 4 , 8 },
    { 66, 104, 5 , 2 },
    { 79, 104, 2 , 7 },
    { 89, 104, 6 , 6 },
    { 103, 104, 6 , 7 },
    { 117, 104, 6 , 7 },
    { 131, 104, 6 , 7 },
    { 145, 104, 0 , 0 },
    { 153, 104, 6 , 9 },
    { 167, 104, 0 , 0 },
    { 175, 104, 7 , 7 },
    { 190, 104, 8 , 8 },
    { 206, 104, 6 , 5 },
    { 220, 104, 8 , 8 },
    { 236, 104, 7 , 7 },
    { 4, 124, 8 , 8 },
    { 20, 124, 4 , 4 },
    { 32, 124, 8 , 8 },
    { 48, 124, 8 , 8 },
    { 64, 124, 8 , 8 },
    { 80, 124, 0 , 0 },
    { 88, 124, 6 , 7 },
    { 102, 124, 5 , 8 },
    { 115, 124, 3 , 3 },
    { 126, 124, 0 , 0 },
    { 134, 124, 8 , 8 },
    { 150, 124, 8 , 8 },
    { 166, 124, 6 , 5 },
    { 180, 124, 10 , 7 },
    { 198, 124, 10 , 5 },
    { 216, 124, 0 , 0 },
    { 224, 124, 6 , 7 },
    { 238, 124, 6 , 10 },
    { 4, 144, 6 , 10 },
    { 18, 144, 6 , 10 },
    { 32, 144, 6 , 10 },
    { 46, 144, 6 , 10 },
    { 60, 144, 6 , 10 },
    { 74, 144, 10 , 7 },
    { 92, 144, 6 , 9 },
    { 106, 144, 6 , 10 },
    { 120, 144, 6 , 10 },
    { 134, 144, 6 , 10 },
    { 148, 144, 6 , 10 },
    { 162, 144, 6 , 10 },
    { 176, 144, 6 , 10 },
    { 190, 144, 6 , 10 },
    { 204, 144, 6 , 10 },
    { 218, 144, 6 , 7 },
    { 232, 144, 6 , 10 },
    { 4, 164, 6 , 10 },
    { 18, 164, 6 , 10 },
    { 32, 164, 6 , 10 },
    { 46, 164, 6 , 10 },
    { 60, 164, 6 , 10 },
    { 74, 164, 6 , 5 },
    { 88, 164, 6 , 7 },
    { 102, 164, 6 , 10 },
    { 116, 164, 6 , 10 },
    { 130, 164, 6 , 10 },
    { 144, 164, 6 , 10 },
    { 158, 164, 6 , 10 },
    { 172, 164, 6 , 7 },
    { 186, 164, 6 , 7 },
    { 200, 164, 6 , 8 },
    { 214, 164, 6 , 8 },
    { 228, 164, 6 , 8 },
    { 4, 184, 6 , 8 },
    { 18, 184, 6 , 8 },
    { 32, 184, 6 , 8 },
    { 46, 184, 9 , 5 },
    { 63, 184, 6 , 7 },
    { 77, 184, 6 , 8 },
    { 91, 184, 6 , 8 },
    { 105, 184, 6 , 8 },
    { 119, 184, 6 , 8 },
    { 133, 184, 6 , 8 },
    { 147, 184, 6 , 8 },
    { 161, 184, 6 , 8 },
    { 175, 184, 6 , 8 },
    { 189, 184, 6 , 7 },
    { 203, 184, 6 , 8 },
    { 217, 184, 6 , 8 },
    { 231, 184, 6 , 8 },
    { 4, 204, 6 , 8 },
    { 18, 204, 6 , 8 },
    { 32, 204, 6 , 8 },
    { 46, 204, 5 , 5 },
    { 59, 204, 6 , 5 },
    { 73, 204, 6 , 8 },
    { 87, 204, 6 , 8 },
    { 101, 204, 6 , 8 },
    { 115, 204, 6 , 8 },
    { 129, 204, 6 , 10 },
    { 143, 204, 6 , 9 },
    { 157, 204, 6 , 10 },
};

// Font glyphs info data
// NOTE: No glyphs.image data provided
static const GlyphInfo jungleFontGlyphs[189] = {
    { 32, 0, 0, 5, { 0 }},
    { 33, 0, 2, 3, { 0 }},
    { 34, 0, 2, 6, { 0 }},
    { 35, 0, 3, 6, { 0 }},
    { 36, 0, 2, 7, { 0 }},
    { 37, 0, 2, 8, { 0 }},
    { 38, 0, 2, 6, { 0 }},
    { 39, 0, 2, 4, { 0 }},
    { 40, 0, 2, 5, { 0 }},
    { 41, 0, 2, 5, { 0 }},
    { 42, 0, 2, 6, { 0 }},
    { 43, 0, 3, 6, { 0 }},
    { 44, 0, 7, 3, { 0 }},
    { 45, 0, 5, 6, { 0 }},
    { 46, 0, 7, 3, { 0 }},
    { 47, 0, 2, 8, { 0 }},
    { 48, 0, 3, 8, { 0 }},
    { 49, 0, 3, 7, { 0 }},
    { 50, 0, 3, 7, { 0 }},
    { 51, 0, 3, 7, { 0 }},
    { 52, 0, 3, 7, { 0 }},
    { 53, 0, 3, 7, { 0 }},
    { 54, 0, 3, 7, { 0 }},
    { 55, 0, 3, 7, { 0 }},
    { 56, 0, 3, 7, { 0 }},
    { 57, 0, 3, 7, { 0 }},
    { 58, 0, 4, 3, { 0 }},
    { 59, 0, 4, 3, { 0 }},
    { 60, 0, 3, 4, { 0 }},
    { 61, 0, 4, 6, { 0 }},
    { 62, 0, 3, 4, { 0 }},
    { 63, 0, 2, 7, { 0 }},
    { 64, 0, 2, 8, { 0 }},
    { 65, 0, 2, 7, { 0 }},
    { 66, 0, 2, 7, { 0 }},
    { 67, 0, 2, 7, { 0 }},
    { 68, 0, 2, 7, { 0 }},
    { 69, 0, 2, 7, { 0 }},
    { 70, 0, 2, 7, { 0 }},
    { 71, 0, 2, 7, { 0 }},
    { 72, 0, 2, 7, { 0 }},
    { 73, 0, 2, 7, { 0 }},
    { 74, 0, 2, 7, { 0 }},
    { 75, 0, 2, 7, { 0 }},
    { 76, 0, 2, 7, { 0 }},
    { 77, 0, 2, 8, { 0 }},
    { 78, 0, 2, 7, { 0 }},
    { 79, 0, 2, 7, { 0 }},
    { 80, 0, 2, 7, { 0 }},
    { 81, 0, 2, 7, { 0 }},
    { 82, 0, 2, 7, { 0 }},
    { 83, 0, 2, 7, { 0 }},
    { 84, 0, 2, 7, { 0 }},
    { 85, 0, 2, 7, { 0 }},
    { 86, 0, 2, 7, { 0 }},
    { 87, 0, 2, 8, { 0 }},
    { 88, 0, 2, 7, { 0 }},
    { 89, 0, 2, 7, { 0 }},
    { 90, 0, 2, 7, { 0 }},
    { 91, 0, 2, 5, { 0 }},
    { 92, 0, 2, 8, { 0 }},
    { 93, 0, 2, 5, { 0 }},
    { 94, 0, -1, 5, { 0 }},
    { 95, 0, 10, 7, { 0 }},
    { 96, 0, -1, 3, { 0 }},
    { 97, 0, 4, 7, { 0 }},
    { 98, 0, 2, 7, { 0 }},
    { 99, 0, 4, 7, { 0 }},
    { 100, 0, 2, 7, { 0 }},
    { 101, 0, 4, 7, { 0 }},
    { 102, 0, 2, 7, { 0 }},
    { 103, 0, 4, 7, { 0 }},
    { 104, 0, 2, 7, { 0 }},
    { 105, 0, 2, 7, { 0 }},
    { 106, 0, 2, 6, { 0 }},
    { 107, 0, 2, 7, { 0 }},
    { 108, 0, 2, 7, { 0 }},
    { 109, 0, 4, 8, { 0 }},
    { 110, 0, 4, 7, { 0 }},
    { 111, 0, 4, 7, { 0 }},
    { 112, 0, 4, 7, { 0 }},
    { 113, 0, 4, 7, { 0 }},
    { 114, 0, 4, 7, { 0 }},
    { 115, 0, 4, 7, { 0 }},
    { 116, 0, 3, 7, { 0 }},
    { 117, 0, 4, 7, { 0 }},
    { 118, 0, 4, 7, { 0 }},
    { 119, 0, 4, 8, { 0 }},
    { 120, 0, 4, 7, { 0 }},
    { 121, 0, 4, 7, { 0 }},
    { 122, 0, 4, 7, { 0 }},
    { 123, 0, 2, 5, { 0 }},
    { 124, 0, 2, 3, { 0 }},
    { 125, 0, 2, 5, { 0 }},
    { 126, 0, -1, 6, { 0 }},
    { 161, 0, 2, 3, { 0 }},
    { 162, 0, 3, 7, { 0 }},
    { 163, 0, 2, 7, { 0 }},
    { 8364, 0, 2, 7, { 0 }},
    { 165, 0, 2, 7, { 0 }},
    { 352, 0, 0, 0, { 0 }},
    { 167, 0, 1, 7, { 0 }},
    { 353, 0, 0, 0, { 0 }},
    { 169, 0, 2, 8, { 0 }},
    { 170, 0, 1, 8, { 0 }},
    { 171, 0, 3, 7, { 0 }},
    { 172, 0, 1, 8, { 0 }},
    { 174, 0, 2, 8, { 0 }},
    { 175, 0, 1, 8, { 0 }},
    { 176, 0, 1, 2, { 0 }},
    { 177, 0, 1, 8, { 0 }},
    { 178, 0, 1, 8, { 0 }},
    { 179, 0, 1, 8, { 0 }},
    { 381, 0, 0, 0, { 0 }},
    { 181, 0, 4, 7, { 0 }},
    { 182, 0, 1, 4, { 0 }},
    { 183, 0, 4, 4, { 0 }},
    { 382, 0, 0, 0, { 0 }},
    { 185, 0, 1, 8, { 0 }},
    { 186, 0, 1, 8, { 0 }},
    { 187, 0, 3, 7, { 0 }},
    { 338, 0, 2, 11, { 0 }},
    { 339, 0, 4, 11, { 0 }},
    { 376, 0, 0, 0, { 0 }},
    { 191, 0, 2, 7, { 0 }},
    { 192, 0, -1, 7, { 0 }},
    { 193, 0, -1, 7, { 0 }},
    { 194, 0, -1, 7, { 0 }},
    { 195, 0, -1, 7, { 0 }},
    { 196, 0, -1, 7, { 0 }},
    { 197, 0, -1, 7, { 0 }},
    { 198, 0, 2, 11, { 0 }},
    { 199, 0, 2, 7, { 0 }},
    { 200, 0, -1, 7, { 0 }},
    { 201, 0, -1, 7, { 0 }},
    { 202, 0, -1, 7, { 0 }},
    { 203, 0, -1, 7, { 0 }},
    { 204, 0, -1, 7, { 0 }},
    { 205, 0, -1, 7, { 0 }},
    { 206, 0, -1, 7, { 0 }},
    { 207, 0, -1, 7, { 0 }},
    { 208, 0, 2, 7, { 0 }},
    { 209, 0, -1, 7, { 0 }},
    { 210, 0, -1, 7, { 0 }},
    { 211, 0, -1, 7, { 0 }},
    { 212, 0, -1, 7, { 0 }},
    { 213, 0, -1, 7, { 0 }},
    { 214, 0, -1, 7, { 0 }},
    { 215, 0, 3, 7, { 0 }},
    { 216, 0, 2, 7, { 0 }},
    { 217, 0, -1, 7, { 0 }},
    { 218, 0, -1, 7, { 0 }},
    { 219, 0, -1, 7, { 0 }},
    { 220, 0, -1, 7, { 0 }},
    { 221, 0, -1, 7, { 0 }},
    { 222, 0, 2, 7, { 0 }},
    { 223, 0, 2, 7, { 0 }},
    { 224, 0, 1, 7, { 0 }},
    { 225, 0, 1, 7, { 0 }},
    { 226, 0, 1, 7, { 0 }},
    { 227, 0, 1, 7, { 0 }},
    { 228, 0, 1, 7, { 0 }},
    { 229, 0, 1, 7, { 0 }},
    { 230, 0, 4, 10, { 0 }},
    { 231, 0, 4, 7, { 0 }},
    { 232, 0, 1, 7, { 0 }},
    { 233, 0, 1, 7, { 0 }},
    { 234, 0, 1, 7, { 0 }},
    { 235, 0, 1, 7, { 0 }},
    { 236, 0, 1, 7, { 0 }},
    { 237, 0, 1, 7, { 0 }},
    { 238, 0, 1, 7, { 0 }},
    { 239, 0, 1, 7, { 0 }},
    { 240, 0, 2, 7, { 0 }},
    { 241, 0, 1, 7, { 0 }},
    { 242, 0, 1, 7, { 0 }},
    { 243, 0, 1, 7, { 0 }},
    { 244, 0, 1, 7, { 0 }},
    { 245, 0, 1, 7, { 0 }},
    { 246, 0, 1, 7, { 0 }},
    { 247, 0, 3, 6, { 0 }},
    { 248, 0, 4, 7, { 0 }},
    { 249, 0, 1, 7, { 0 }},
    { 250, 0, 1, 7, { 0 }},
    { 251, 0, 1, 7, { 0 }},
    { 252, 0, 1, 7, { 0 }},
    { 253, 0, 1, 7, { 0 }},
    { 254, 0, 2, 7, { 0 }},
    { 255, 0, 1, 7, { 0 }},
};

// Style loading function: Jungle
static void GuiLoadStyleJungle(void)
{
    // Load style properties provided
    // NOTE: Default properties are propagated
    for (int i = 0; i < JUNGLE_STYLE_PROPS_COUNT; i++)
    {
        GuiSetStyle(jungleStyleProps[i].controlId, jungleStyleProps[i].propertyId, jungleStyleProps[i].propertyValue);
    }

    // Custom font loading
    // NOTE: Compressed font image data (DEFLATE), it requires DecompressData() function
    int jungleFontDataSize = 0;
    unsigned char *data = DecompressData(jungleFontData, JUNGLE_STYLE_FONT_ATLAS_COMP_SIZE, &jungleFontDataSize);
    Image imFont = { data, 256, 256, 1, 2 };

    Font font = { 0 };
    font.baseSize = 12;
    font.glyphCount = 189;

    // Load texture from image
    font.texture = LoadTextureFromImage(imFont);
    UnloadImage(imFont);  // Uncompressed image data can be unloaded from memory

    // Copy char recs data from global fontRecs
    // NOTE: Required to avoid issues if trying to free font
    font.recs = (Rectangle *)RAYGUI_MALLOC(font.glyphCount*sizeof(Rectangle));
    memcpy(font.recs, jungleFontRecs, font.glyphCount*sizeof(Rectangle));

    // Copy font char info data from global fontChars
    // NOTE: Required to avoid issues if trying to free font
    font.glyphs = (GlyphInfo *)RAYGUI_MALLOC(font.glyphCount*sizeof(GlyphInfo));
    memcpy(font.glyphs, jungleFontGlyphs, font.glyphCount*sizeof(GlyphInfo));

    GuiSetFont(font);

    // Setup a white rectangle on the font to be used on shapes drawing,
    // it makes possible to draw shapes and text (full UI) in a single draw call
    Rectangle fontWhiteRec = { 254, 254, 1, 1 };
    SetShapesTexture(font.texture, fontWhiteRec);

    //-----------------------------------------------------------------

    // TODO: Custom user style setup: Set specific properties here (if required)
    // i.e. Controls specific BORDER_WIDTH, TEXT_PADDING, TEXT_ALIGNMENT
}
