//////////////////////////////////////////////////////////////////////////////////
//                                                                              //
// StyleAsCode exporter v2.0 - Style data exported as a values array            //
//                                                                              //
// USAGE: On init call: GuiLoadStyleRLTech();                                   //
//                                                                              //
// more info and bugs-report:  github.com/raysan5/raygui                        //
// feedback and support:       ray[at]raylibtech.com                            //
//                                                                              //
// Copyright (c) 2020-2025 raylib technologies (@raylibtech)                    //
//                                                                              //
//////////////////////////////////////////////////////////////////////////////////

#define RLTECH_STYLE_PROPS_COUNT  15

// Custom style name: RLTech
static const GuiStyleProp rltechStyleProps[RLTECH_STYLE_PROPS_COUNT] = {
    { 0, 0, (int)0x000000ff },    // DEFAULT_BORDER_COLOR_NORMAL 
    { 0, 1, (int)0xf5f5f5ff },    // DEFAULT_BASE_COLOR_NORMAL 
    { 0, 2, (int)0x000000ff },    // DEFAULT_TEXT_COLOR_NORMAL 
    { 0, 3, (int)0xe10000ff },    // DEFAULT_BORDER_COLOR_FOCUSED 
    { 0, 4, (int)0xffffffff },    // DEFAULT_BASE_COLOR_FOCUSED 
    { 0, 5, (int)0xed0000ff },    // DEFAULT_TEXT_COLOR_FOCUSED 
    { 0, 6, (int)0xed0000ff },    // DEFAULT_BORDER_COLOR_PRESSED 
    { 0, 7, (int)0x0f0f0fff },    // DEFAULT_BASE_COLOR_PRESSED 
    { 0, 8, (int)0xff2323ff },    // DEFAULT_TEXT_COLOR_PRESSED 
    { 0, 9, (int)0xcacacaff },    // DEFAULT_BORDER_COLOR_DISABLED 
    { 0, 10, (int)0xe3e3e3ff },    // DEFAULT_BASE_COLOR_DISABLED 
    { 0, 11, (int)0xb3b3b3ff },    // DEFAULT_TEXT_COLOR_DISABLED 
    { 0, 16, (int)0x00000010 },    // DEFAULT_TEXT_SIZE 
    { 0, 18, (int)0x352c2cff },    // DEFAULT_LINE_COLOR 
    { 0, 20, (int)0x00000018 },    // DEFAULT_TEXT_LINE_SPACING 
};

// WARNING: This style uses a custom font: "2a03.ttf" (size: 16, spacing: 1)

#define RLTECH_STYLE_FONT_ATLAS_COMP_SIZE 1950

// Font atlas image pixels data: DEFLATE compressed
static unsigned char rltechFontData[RLTECH_STYLE_FONT_ATLAS_COMP_SIZE] = { 0xed,
    0xdd, 0xcb, 0x76, 0xc3, 0x2a, 0x12, 0x05, 0x50, 0xfe, 0xff, 0xa7, 0xab, 0x07, 0x77, 0xd0, 0x8f, 0xd5, 0xb1, 0xa0, 0x28,
    0x10, 0xd8, 0x3b, 0x7b, 0x16, 0xc7, 0xb6, 0x1e, 0x1c, 0x03, 0x8a, 0x29, 0x45, 0x03, 0x00, 0x00, 0x00, 0x88, 0xf8, 0xbf,
    0xbf, 0x89, 0x3f, 0xfe, 0x32, 0xba, 0x5f, 0xe5, 0x9f, 0xdf, 0xc6, 0x87, 0x67, 0xfd, 0xfb, 0xa7, 0xef, 0xf5, 0xa2, 0xf3,
    0x5d, 0xff, 0xfe, 0xfd, 0xdf, 0x5b, 0xd2, 0xbf, 0x6d, 0x15, 0xaf, 0x30, 0xfa, 0xd7, 0x9f, 0xb7, 0xa4, 0xea, 0xd5, 0x6a,
    0x1f, 0xd9, 0x77, 0xe4, 0x9f, 0xb7, 0x6e, 0xe7, 0xb1, 0x68, 0x9b, 0x8e, 0x6c, 0x0c, 0xb4, 0xfa, 0xb5, 0xf9, 0xff, 0xbc,
    0xad, 0xf1, 0x78, 0xee, 0x67, 0xb2, 0x9e, 0x7d, 0xcf, 0x8a, 0x23, 0xd7, 0xb7, 0xbd, 0x31, 0xf9, 0xd7, 0x77, 0x3e, 0x92,
    0x3d, 0x6a, 0xe3, 0x7f, 0xdf, 0x9b, 0x87, 0xda, 0x3d, 0x6e, 0xa5, 0xcf, 0x69, 0x8b, 0xdf, 0xa7, 0x22, 0xff, 0xcf, 0x29,
    0x1f, 0xef, 0xff, 0x33, 0x79, 0xea, 0x69, 0x11, 0xa3, 0x9f, 0xc3, 0xed, 0xf5, 0xfc, 0x67, 0x1e, 0xa9, 0x6d, 0x71, 0x6d,
    0x7b, 0xfe, 0xc7, 0x47, 0x85, 0xe3, 0xc7, 0x27, 0x3e, 0xb4, 0x41, 0xf9, 0x1f, 0x7b, 0x56, 0x66, 0x5e, 0x90, 0x1b, 0xa5,
    0xcf, 0x8d, 0xdc, 0x5b, 0xf2, 0x33, 0xa7, 0x32, 0xfd, 0xf2, 0xbf, 0xab, 0xff, 0xef, 0xe9, 0x31, 0xe4, 0x7f, 0xfe, 0x1c,
    0x64, 0xe6, 0x2a, 0x4f, 0xf9, 0x1f, 0xe9, 0x91, 0x6b, 0xc6, 0xf3, 0xa7, 0xe6, 0x3f, 0x3a, 0xe6, 0x8f, 0x6b, 0xe7, 0x95,
    0xad, 0xf4, 0x6a, 0xc2, 0x8a, 0x4f, 0x80, 0x78, 0x68, 0x9b, 0xe3, 0xfd, 0x7f, 0x66, 0x2e, 0x9f, 0xc9, 0xe5, 0xe8, 0x99,
    0xfd, 0xcf, 0x6d, 0x9f, 0xbd, 0x3e, 0xb2, 0xbe, 0xff, 0xcf, 0x5d, 0x1b, 0x1c, 0xed, 0x3d, 0x76, 0xf6, 0xe7, 0x6f, 0xe4,
    0x7f, 0xa6, 0xf5, 0xd7, 0xcc, 0x4a, 0x56, 0x3c, 0x67, 0xcf, 0x99, 0x8a, 0x87, 0x36, 0x79, 0x6f, 0xff, 0x1f, 0x17, 0x8c,
    0xff, 0xdb, 0xe3, 0x88, 0x7b, 0xf4, 0x4a, 0xe6, 0x5d, 0xf9, 0x5f, 0x77, 0x75, 0xf3, 0xde, 0xfc, 0xb7, 0x63, 0xf2, 0x3f,
    0x73, 0x25, 0xfd, 0x17, 0xf2, 0x5f, 0x71, 0xf4, 0x9f, 0xae, 0xd8, 0x44, 0xc1, 0xec, 0xf1, 0x37, 0xf2, 0xbf, 0x3a, 0xb1,
    0xbb, 0x5f, 0xed, 0xbc, 0xf3, 0x22, 0xff, 0x2b, 0x12, 0x14, 0x0f, 0xa3, 0x86, 0xf9, 0xd9, 0xe3, 0x7d, 0xf9, 0x1f, 0x99,
    0x45, 0x9e, 0x33, 0x63, 0xdf, 0x3b, 0xff, 0xdf, 0x73, 0x06, 0xce, 0xfd, 0xfe, 0x44, 0xe6, 0x6a, 0xdb, 0x69, 0xfd, 0xff,
    0x09, 0xbd, 0x2c, 0x20, 0xff, 0x80, 0xfc, 0x03, 0xbf, 0xb0, 0x52, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x7e, 0xe9, 0x3b, 0xf4, 0xb9, 0xd5, 0xc9, 0x77, 0xd6, 0xa6, 0x5f, 0x51, 0x11, 0xa6, 0xba, 0xb2, 0xf6,
    0xe7, 0xad, 0x1f, 0x59, 0x01, 0xdf, 0xb7, 0x6a, 0x2a, 0x06, 0xd7, 0xa9, 0xd7, 0xae, 0x6a, 0xcf, 0x54, 0x1f, 0x68, 0xa5,
    0xeb, 0xed, 0x67, 0x56, 0x9b, 0x44, 0x2a, 0x21, 0x2b, 0xaa, 0x37, 0xee, 0xca, 0x7f, 0x4f, 0xfb, 0x6d, 0x47, 0xd4, 0xa6,
    0xcf, 0xac, 0x26, 0x7c, 0x3f, 0xff, 0xa3, 0xad, 0x70, 0xbc, 0x2e, 0x76, 0xc5, 0xea, 0xcb, 0xf6, 0x6a, 0xf5, 0xe1, 0xfc,
    0x59, 0xac, 0x5c, 0x81, 0xba, 0xb7, 0x57, 0x98, 0xdd, 0x8f, 0xbf, 0x5e, 0x73, 0xae, 0xd6, 0xe9, 0x48, 0x15, 0x6e, 0xf9,
    0x7f, 0x3b, 0xff, 0xeb, 0x47, 0x94, 0xbb, 0xea, 0xdd, 0xc4, 0xf0, 0x1d, 0x41, 0x66, 0xee, 0x57, 0x14, 0x13, 0x7f, 0x7b,
    0x76, 0xfe, 0xb3, 0x6d, 0x2a, 0x1e, 0x3f, 0x55, 0xe4, 0xbf, 0x3d, 0xdc, 0x39, 0xa1, 0x0d, 0x56, 0x4e, 0xce, 0x56, 0x59,
    0xae, 0xcf, 0x7d, 0x65, 0x85, 0xaa, 0x48, 0x8e, 0xff, 0xab, 0xcf, 0x62, 0x55, 0x4f, 0x79, 0x53, 0xfe, 0xf3, 0x77, 0xd1,
    0xdb, 0x37, 0xe7, 0x7d, 0x7a, 0xce, 0xe8, 0x5c, 0x73, 0x6f, 0xfe, 0x2b, 0xef, 0x75, 0x73, 0x4e, 0xfe, 0x57, 0xce, 0x28,
    0xfb, 0xb6, 0x7f, 0x7f, 0xfe, 0xe3, 0x2b, 0xc7, 0xff, 0x71, 0x48, 0xfe, 0x2b, 0xdb, 0x5a, 0x4b, 0xe5, 0x71, 0x6f, 0xff,
    0xdf, 0x5e, 0xfc, 0xbd, 0xfc, 0x8f, 0xe7, 0x3f, 0xcc, 0xff, 0x5f, 0xcb, 0x7f, 0x5c, 0x9b, 0xff, 0x98, 0xd8, 0x92, 0xf9,
    0x47, 0xce, 0x1a, 0xff, 0x57, 0x3e, 0x27, 0x73, 0x47, 0xe0, 0x3b, 0xfa, 0xff, 0x6f, 0xb8, 0xfe, 0x5f, 0xff, 0x7e, 0x99,
    0x19, 0x74, 0x55, 0xfe, 0xfb, 0xe7, 0xf0, 0xbf, 0x92, 0xff, 0xcc, 0xc8, 0xa0, 0xf6, 0x39, 0xe3, 0xd7, 0x78, 0xf6, 0xcd,
    0xff, 0x77, 0x5d, 0x6b, 0x3d, 0xe3, 0xd3, 0x3a, 0x16, 0x5d, 0x83, 0xfd, 0xdf, 0x2b, 0xbd, 0x55, 0xfd, 0x46, 0xed, 0x7c,
    0x3c, 0xff, 0x5d, 0x88, 0x99, 0x3e, 0xec, 0xe4, 0xfc, 0x8f, 0xf7, 0x52, 0xb9, 0x9e, 0xed, 0x8d, 0xfc, 0xbf, 0x59, 0x87,
    0x52, 0xbd, 0x4b, 0x42, 0x9b, 0x59, 0xf2, 0x59, 0x72, 0xc3, 0x71, 0x93, 0x7f, 0xe4, 0x5f, 0xd6, 0xd0, 0x2e, 0xb5, 0x63,
    0xf9, 0xe7, 0x17, 0xdb, 0x65, 0xff, 0xc8, 0xf6, 0x84, 0x7b, 0xf3, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x50, 0xb5, 0xfe, 0x3f, 0x53, 0x6d, 0xe4, 0xf4, 0xfa, 0xb9, 0xa3, 0x2b, 0xf9, 0xfb, 0xd7, 0x74, 0x47, 0x41,
    0x55, 0xde, 0xe7, 0xaa, 0x85, 0x23, 0x35, 0x04, 0x62, 0xb8, 0x42, 0x7f, 0xcf, 0x73, 0x3e, 0xb7, 0x89, 0xbf, 0xf7, 0x36,
    0xd7, 0xc2, 0x9e, 0x1f, 0xef, 0x5f, 0xdb, 0x10, 0x43, 0xc7, 0x3c, 0x73, 0x8c, 0x3e, 0x9d, 0x8b, 0xb1, 0x7b, 0x28, 0xfc,
    0xfd, 0x2a, 0x63, 0x2d, 0x23, 0x3a, 0x57, 0x33, 0x55, 0x55, 0x6b, 0xbf, 0xb7, 0x7e, 0xf6, 0xfc, 0xef, 0x62, 0x7a, 0x15,
    0xfa, 0xf8, 0x31, 0xaf, 0xad, 0x21, 0xd4, 0xfb, 0x9c, 0xf1, 0xba, 0xc4, 0x63, 0x6d, 0x26, 0x26, 0x56, 0xdc, 0x45, 0x6a,
    0xbf, 0x63, 0xe2, 0x68, 0xf4, 0xf6, 0x3a, 0x23, 0x7b, 0x32, 0x5a, 0x51, 0x30, 0x77, 0xe4, 0xab, 0xf3, 0x9f, 0xa9, 0xbc,
    0x9e, 0xcf, 0x7f, 0x6d, 0xfd, 0xec, 0xb9, 0xfc, 0x8f, 0xb5, 0xed, 0x7c, 0x65, 0xe5, 0xf1, 0x4f, 0xba, 0x36, 0x38, 0x06,
    0xfa, 0x94, 0xaa, 0x4f, 0xf5, 0x96, 0xf2, 0xbd, 0x50, 0x0c, 0xbf, 0xdb, 0xf8, 0xda, 0xc6, 0x48, 0xf5, 0xf3, 0x51, 0x54,
    0xab, 0x2c, 0xb7, 0x27, 0xb3, 0xf9, 0x1f, 0xf9, 0xec, 0xad, 0xba, 0x5b, 0xd3, 0x29, 0xf5, 0xb3, 0x73, 0xa3, 0xef, 0x53,
    0xf3, 0xbf, 0xef, 0x6e, 0x66, 0x9f, 0x9e, 0x13, 0xcb, 0x7a, 0xa1, 0xbf, 0xdf, 0x2d, 0x0a, 0x57, 0xdc, 0xd7, 0x8c, 0x86,
    0x66, 0xee, 0x48, 0xb2, 0x62, 0x84, 0xb8, 0xbf, 0xff, 0x1f, 0xcf, 0xc6, 0x49, 0xfd, 0xff, 0x9a, 0x39, 0x41, 0x45, 0xfe,
    0x73, 0x33, 0x83, 0xf9, 0x2a, 0xed, 0xbd, 0xcf, 0x89, 0x8e, 0x54, 0xb4, 0x92, 0x4f, 0x80, 0xf8, 0xaf, 0xde, 0x77, 0x75,
    0xfe, 0xc7, 0xaf, 0x68, 0xe4, 0xae, 0x3a, 0x55, 0x54, 0x31, 0x3d, 0x61, 0xfe, 0x5f, 0x99, 0xff, 0x35, 0xf5, 0x73, 0xeb,
    0xaa, 0xc6, 0xaf, 0xc8, 0xff, 0x78, 0xca, 0x67, 0x7a, 0xf9, 0x3d, 0xf9, 0xaf, 0xbe, 0x2a, 0xbd, 0xa2, 0xff, 0xaf, 0xdf,
    0xc6, 0xb1, 0xeb, 0x7f, 0xb3, 0x2d, 0x67, 0xf7, 0xf5, 0xff, 0xca, 0xf1, 0xff, 0xde, 0xfa, 0xb9, 0x75, 0x79, 0x99, 0xad,
    0x9d, 0x5b, 0x73, 0xaf, 0x9e, 0xea, 0xfe, 0x3f, 0x77, 0x74, 0x32, 0xf3, 0xff, 0x53, 0xf2, 0x1f, 0x0b, 0xb6, 0x70, 0xbc,
    0x95, 0xc7, 0x82, 0xf4, 0xd7, 0xec, 0xd7, 0xda, 0x31, 0xd6, 0x39, 0x9f, 0xd1, 0xed, 0xf5, 0xfe, 0x3f, 0xf7, 0xd7, 0x95,
    0x23, 0x83, 0xcc, 0xbb, 0xc5, 0xd6, 0xb3, 0x1c, 0x07, 0xb7, 0xa9, 0x99, 0x2b, 0x09, 0x71, 0x6c, 0x8a, 0xa2, 0x74, 0x3c,
    0x21, 0xff, 0xad, 0xf8, 0xba, 0xfc, 0xf8, 0xf8, 0xa9, 0x25, 0xbf, 0x03, 0xd1, 0xba, 0xee, 0x5b, 0xbf, 0x6b, 0x54, 0x7a,
    0x62, 0xa5, 0xc2, 0xdc, 0x1d, 0xd5, 0x46, 0xae, 0xff, 0x9d, 0x9e, 0x94, 0x7b, 0xbf, 0xd5, 0xb4, 0x3b, 0xff, 0x77, 0x7d,
    0x06, 0x9e, 0x9a, 0xb8, 0x3b, 0x8e, 0x67, 0xbc, 0xda, 0x7a, 0x59, 0x33, 0xa7, 0xfb, 0xa5, 0xfc, 0xe3, 0x78, 0x3a, 0xb3,
    0xdf, 0x91, 0x7f, 0xbd, 0x88, 0xe3, 0x4a, 0xd5, 0xff, 0x74, 0x7c, 0xfe, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x70, 0xc6, 0x6a, 0x86, 0xde, 0x5a, 0xec, 0xa3, 0xd5, 0xaf, 0xf3, 0xab, 0xa5, 0xc7, 0x7e, 0x1f, 0xc3,
    0x95, 0xb9, 0x9f, 0xd6, 0xda, 0x57, 0xde, 0x01, 0x21, 0xbf, 0x5f, 0x99, 0x3a, 0x6b, 0x3d, 0xbf, 0x1b, 0xaf, 0x32, 0x10,
    0xa9, 0xf5, 0x50, 0xeb, 0xcf, 0x64, 0xee, 0x6e, 0x0f, 0x7b, 0xce, 0x53, 0x66, 0x15, 0x59, 0xfd, 0x56, 0x3f, 0x3f, 0xa3,
    0xbf, 0x5a, 0x5c, 0xbc, 0xb8, 0x92, 0xfa, 0x73, 0xcb, 0x88, 0xc4, 0xfb, 0xc7, 0xd4, 0x31, 0x59, 0xbd, 0x5f, 0xb3, 0x6b,
    0x95, 0xb2, 0x55, 0xa7, 0x62, 0xf0, 0x08, 0xdf, 0x79, 0x26, 0xf7, 0x9c, 0xa7, 0x7c, 0x0d, 0xb9, 0xd8, 0x50, 0x7f, 0xa0,
    0x22, 0xff, 0x31, 0xb9, 0x9f, 0xef, 0xac, 0xd6, 0x8c, 0xd4, 0x3d, 0x75, 0xf6, 0xee, 0xd3, 0xba, 0xb5, 0xa6, 0x91, 0x6c,
    0x0d, 0xa7, 0xae, 0xbb, 0x7d, 0x77, 0x7f, 0x6a, 0xef, 0xc2, 0xb0, 0xf3, 0x2c, 0x8c, 0xe4, 0x3f, 0xb7, 0xbd, 0x51, 0x98,
    0xcb, 0xda, 0x5a, 0xf7, 0xb9, 0xcf, 0xb3, 0xb6, 0xa0, 0xb6, 0xe6, 0x78, 0x0d, 0xd6, 0xb6, 0xa4, 0x82, 0x69, 0xed, 0x1d,
    0xd5, 0x76, 0x9d, 0xc9, 0xa7, 0xfe, 0x7f, 0x7d, 0xbb, 0xd8, 0xf7, 0x48, 0xbe, 0xda, 0x63, 0x5f, 0xba, 0x2b, 0x46, 0x08,
    0xcf, 0x33, 0xec, 0x5b, 0x8e, 0x72, 0xdd, 0x7d, 0xba, 0xaa, 0x1f, 0x59, 0x91, 0xff, 0xa7, 0xfa, 0xbe, 0x37, 0xe6, 0xe5,
    0xe9, 0xbe, 0x8c, 0xe7, 0x6e, 0x75, 0x94, 0xb7, 0x98, 0x56, 0x9c, 0xee, 0xfe, 0x7d, 0xbc, 0x2d, 0xff, 0xa7, 0xa4, 0xfc,
    0xac, 0xfe, 0xff, 0xd4, 0x24, 0x7d, 0x1e, 0x63, 0xdf, 0xf9, 0xa9, 0xb5, 0xa2, 0xc5, 0x64, 0xd3, 0x9d, 0xbf, 0x1a, 0x7e,
    0x42, 0xfe, 0xf7, 0xce, 0xff, 0xab, 0x1f, 0x99, 0xbb, 0x57, 0x71, 0xf5, 0xf8, 0xff, 0xcc, 0x91, 0x74, 0xbb, 0xb4, 0x97,
    0xd9, 0x73, 0x5f, 0x8b, 0xfa, 0x2b, 0x17, 0x35, 0xed, 0xe9, 0xbb, 0xe7, 0xff, 0x55, 0x8f, 0xdc, 0x30, 0xff, 0x97, 0xff,
    0x99, 0x94, 0xb7, 0xd7, 0x8e, 0x4e, 0xef, 0x7f, 0xf7, 0x67, 0xf2, 0xbf, 0x27, 0x97, 0xab, 0x1e, 0x59, 0x31, 0xe2, 0x39,
    0x7b, 0xfc, 0x7f, 0xe3, 0xf9, 0xaa, 0xbd, 0xc6, 0x5e, 0xbf, 0x6d, 0x99, 0xff, 0xe3, 0xd5, 0x6d, 0xf5, 0xae, 0xff, 0xce,
    0x54, 0x8d, 0x3b, 0x4e, 0x6e, 0x4f, 0x6b, 0xfe, 0x3b, 0x7b, 0x4e, 0xfe, 0xbf, 0xf9, 0x7c, 0x9d, 0x96, 0xff, 0xb6, 0xe9,
    0xbf, 0x4b, 0xf2, 0xbf, 0xa2, 0x3d, 0xc5, 0xd6, 0xf9, 0x7f, 0xc8, 0x7f, 0x71, 0x0b, 0xdf, 0xb9, 0x6d, 0xb1, 0x38, 0x4b,
    0x77, 0x7e, 0xef, 0xf8, 0xdc, 0xbe, 0x61, 0xff, 0xf7, 0x8d, 0x6a, 0xee, 0x56, 0xb4, 0xf2, 0xfb, 0x57, 0xef, 0x5f, 0xc9,
    0xb9, 0xf5, 0x3c, 0xa9, 0x18, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xac, 0x5b, 0xbb,
    0xa7, 0xa6, 0x7e, 0x2b, 0xaa, 0xa9, 0x3f, 0xfe, 0x48, 0xed, 0xfe, 0x46, 0xa2, 0x3a, 0x78, 0x14, 0xac, 0x48, 0x5c, 0x71,
    0x96, 0xc6, 0xce, 0x4a, 0xdf, 0xab, 0xfd, 0x7a, 0xfa, 0xd7, 0x57, 0x62, 0xef, 0x5f, 0xc3, 0x57, 0xb5, 0x7a, 0xf6, 0x94,
    0x9a, 0xfa, 0x2d, 0x75, 0x7c, 0xdf, 0xae, 0xa8, 0x3f, 0x7e, 0xfe, 0xda, 0x05, 0x15, 0xf5, 0x79, 0x6b, 0xed, 0xe4, 0x6c,
    0xfe, 0x77, 0x6c, 0xfd, 0xba, 0x71, 0xd4, 0x6d, 0x15, 0xf5, 0x9f, 0xea, 0xe6, 0xc4, 0xa1, 0x15, 0xf5, 0x2b, 0x5f, 0x4d,
    0x96, 0xa3, 0xb0, 0x0a, 0x71, 0xcf, 0xf8, 0x7f, 0xcf, 0x5a, 0xed, 0x18, 0x1a, 0x41, 0x56, 0xd5, 0xd4, 0x78, 0xb3, 0x02,
    0x62, 0xe5, 0x7d, 0x26, 0xce, 0xae, 0xa8, 0x7d, 0xc2, 0x1d, 0x35, 0xbe, 0xeb, 0x1a, 0x40, 0x2b, 0xcb, 0xff, 0xfc, 0xab,
    0xad, 0xaf, 0x15, 0xb2, 0xae, 0xa6, 0xfe, 0x7d, 0x15, 0xf5, 0x3e, 0xdd, 0x05, 0xf0, 0xfb, 0x2a, 0x6a, 0xcb, 0xff, 0xea,
    0x9e, 0xeb, 0x9c, 0xfc, 0xef, 0xac, 0xa9, 0xa5, 0xa2, 0xae, 0xfc, 0x7f, 0xdb, 0xf8, 0xbf, 0xe2, 0x9e, 0x3a, 0xef, 0x8f,
    0x7a, 0x9b, 0xfc, 0xa7, 0xf2, 0x7f, 0x77, 0x45, 0x67, 0x89, 0x3f, 0xf9, 0x38, 0x7f, 0x5f, 0x4d, 0xdd, 0xdf, 0x49, 0x85,
    0xfc, 0xff, 0x4e, 0xfe, 0xd7, 0x54, 0x6f, 0xfc, 0xc6, 0x9a, 0xba, 0x67, 0xf7, 0x97, 0x37, 0x56, 0xd4, 0x7d, 0x7f, 0x4f,
    0x5d, 0xff, 0xbf, 0x61, 0x8e, 0x72, 0x7a, 0x4d, 0x5d, 0x15, 0x75, 0x73, 0xdb, 0xb6, 0xe6, 0x3f, 0x56, 0xc0, 0xdd, 0x57,
    0xac, 0x63, 0xe2, 0x2a, 0x37, 0xf0, 0xad, 0xf9, 0x37, 0xfe, 0x87, 0xef, 0x9f, 0xb1, 0x3a, 0x3a, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x37, 0xf8, 0xe7, 0xc7,
    0x71, 0x00, 0xf9, 0x07, 0x7e, 0x2e, 0xff, 0xff, 0x02 };

// Font glyphs rectangles data (on atlas)
static const Rectangle rltechFontRecs[189] = {
    { 4, 4, 5 , 16 },
    { 17, 4, 1 , 9 },
    { 26, 4, 3 , 3 },
    { 37, 4, 5 , 7 },
    { 50, 4, 5 , 9 },
    { 63, 4, 7 , 9 },
    { 78, 4, 6 , 9 },
    { 92, 4, 1 , 3 },
    { 101, 4, 2 , 13 },
    { 111, 4, 2 , 13 },
    { 121, 4, 5 , 5 },
    { 134, 4, 5 , 5 },
    { 147, 4, 1 , 2 },
    { 156, 4, 5 , 1 },
    { 169, 4, 1 , 1 },
    { 178, 4, 3 , 9 },
    { 189, 4, 5 , 9 },
    { 202, 4, 2 , 9 },
    { 212, 4, 5 , 9 },
    { 225, 4, 5 , 9 },
    { 238, 4, 5 , 9 },
    { 251, 4, 5 , 9 },
    { 264, 4, 5 , 9 },
    { 277, 4, 5 , 9 },
    { 290, 4, 5 , 9 },
    { 303, 4, 5 , 9 },
    { 316, 4, 1 , 6 },
    { 325, 4, 1 , 7 },
    { 334, 4, 3 , 5 },
    { 345, 4, 5 , 3 },
    { 358, 4, 3 , 5 },
    { 369, 4, 5 , 9 },
    { 382, 4, 8 , 9 },
    { 398, 4, 5 , 9 },
    { 411, 4, 5 , 9 },
    { 424, 4, 5 , 9 },
    { 437, 4, 5 , 9 },
    { 450, 4, 5 , 9 },
    { 463, 4, 5 , 9 },
    { 476, 4, 5 , 9 },
    { 489, 4, 5 , 9 },
    { 502, 4, 1 , 9 },
    { 4, 28, 5 , 9 },
    { 17, 28, 5 , 9 },
    { 30, 28, 5 , 9 },
    { 43, 28, 9 , 9 },
    { 60, 28, 5 , 9 },
    { 73, 28, 5 , 9 },
    { 86, 28, 5 , 9 },
    { 99, 28, 5 , 9 },
    { 112, 28, 5 , 9 },
    { 125, 28, 5 , 9 },
    { 138, 28, 5 , 9 },
    { 151, 28, 5 , 9 },
    { 164, 28, 5 , 9 },
    { 177, 28, 9 , 9 },
    { 194, 28, 5 , 9 },
    { 207, 28, 5 , 9 },
    { 220, 28, 5 , 9 },
    { 233, 28, 3 , 13 },
    { 244, 28, 3 , 9 },
    { 255, 28, 3 , 13 },
    { 266, 28, 3 , 2 },
    { 277, 28, 6 , 1 },
    { 291, 28, 2 , 2 },
    { 301, 28, 5 , 7 },
    { 314, 28, 5 , 9 },
    { 327, 28, 5 , 7 },
    { 340, 28, 5 , 9 },
    { 353, 28, 5 , 7 },
    { 366, 28, 4 , 9 },
    { 378, 28, 5 , 10 },
    { 391, 28, 5 , 9 },
    { 404, 28, 1 , 9 },
    { 413, 28, 1 , 12 },
    { 422, 28, 5 , 9 },
    { 435, 28, 1 , 9 },
    { 444, 28, 9 , 7 },
    { 461, 28, 5 , 7 },
    { 474, 28, 5 , 7 },
    { 487, 28, 5 , 10 },
    { 4, 52, 5 , 10 },
    { 17, 52, 5 , 7 },
    { 30, 52, 5 , 7 },
    { 43, 52, 4 , 9 },
    { 55, 52, 5 , 7 },
    { 68, 52, 5 , 7 },
    { 81, 52, 9 , 7 },
    { 98, 52, 5 , 7 },
    { 111, 52, 5 , 10 },
    { 124, 52, 5 , 7 },
    { 137, 52, 3 , 13 },
    { 148, 52, 1 , 13 },
    { 157, 52, 3 , 13 },
    { 168, 52, 4 , 2 },
    { 180, 52, 1 , 9 },
    { 189, 52, 5 , 7 },
    { 202, 52, 5 , 9 },
    { 215, 52, 5 , 9 },
    { 228, 52, 5 , 9 },
    { 241, 52, 5 , 12 },
    { 254, 52, 5 , 9 },
    { 267, 52, 5 , 10 },
    { 280, 52, 8 , 9 },
    { 296, 52, 4 , 7 },
    { 308, 52, 6 , 5 },
    { 322, 52, 5 , 3 },
    { 335, 52, 8 , 9 },
    { 351, 52, 6 , 1 },
    { 365, 52, 3 , 3 },
    { 376, 52, 5 , 7 },
    { 389, 52, 4 , 5 },
    { 401, 52, 4 , 5 },
    { 413, 52, 5 , 12 },
    { 426, 52, 5 , 10 },
    { 439, 52, 6 , 9 },
    { 453, 52, 1 , 1 },
    { 462, 52, 5 , 10 },
    { 475, 52, 2 , 5 },
    { 485, 52, 4 , 7 },
    { 497, 52, 6 , 5 },
    { 4, 76, 9 , 9 },
    { 21, 76, 9 , 7 },
    { 38, 76, 5 , 11 },
    { 51, 76, 5 , 9 },
    { 64, 76, 5 , 12 },
    { 77, 76, 5 , 12 },
    { 90, 76, 5 , 12 },
    { 103, 76, 5 , 12 },
    { 116, 76, 5 , 11 },
    { 129, 76, 5 , 11 },
    { 142, 76, 9 , 9 },
    { 159, 76, 5 , 11 },
    { 172, 76, 5 , 12 },
    { 185, 76, 5 , 12 },
    { 198, 76, 5 , 12 },
    { 211, 76, 5 , 11 },
    { 224, 76, 2 , 12 },
    { 234, 76, 2 , 12 },
    { 244, 76, 3 , 12 },
    { 255, 76, 3 , 11 },
    { 266, 76, 6 , 9 },
    { 280, 76, 5 , 12 },
    { 293, 76, 5 , 12 },
    { 306, 76, 5 , 12 },
    { 319, 76, 5 , 12 },
    { 332, 76, 5 , 12 },
    { 345, 76, 5 , 11 },
    { 358, 76, 5 , 5 },
    { 371, 76, 5 , 9 },
    { 384, 76, 5 , 12 },
    { 397, 76, 5 , 12 },
    { 410, 76, 5 , 12 },
    { 423, 76, 5 , 11 },
    { 436, 76, 5 , 12 },
    { 449, 76, 5 , 9 },
    { 462, 76, 5 , 11 },
    { 475, 76, 5 , 10 },
    { 488, 76, 5 , 10 },
    { 4, 100, 5 , 10 },
    { 17, 100, 5 , 10 },
    { 30, 100, 5 , 9 },
    { 43, 100, 5 , 9 },
    { 56, 100, 9 , 7 },
    { 73, 100, 5 , 9 },
    { 86, 100, 5 , 10 },
    { 99, 100, 5 , 10 },
    { 112, 100, 5 , 10 },
    { 125, 100, 5 , 9 },
    { 138, 100, 2 , 10 },
    { 148, 100, 2 , 10 },
    { 158, 100, 3 , 10 },
    { 169, 100, 3 , 9 },
    { 180, 100, 5 , 9 },
    { 193, 100, 5 , 10 },
    { 206, 100, 5 , 10 },
    { 219, 100, 5 , 10 },
    { 232, 100, 5 , 10 },
    { 245, 100, 5 , 10 },
    { 258, 100, 5 , 9 },
    { 271, 100, 5 , 5 },
    { 284, 100, 5 , 7 },
    { 297, 100, 5 , 10 },
    { 310, 100, 5 , 10 },
    { 323, 100, 5 , 10 },
    { 336, 100, 5 , 9 },
    { 349, 100, 5 , 13 },
    { 362, 100, 5 , 13 },
    { 375, 100, 5 , 12 },
};

// Font glyphs info data
// NOTE: No glyphs.image data provided
static const GlyphInfo rltechFontGlyphs[189] = {
    { 32, 0, 0, 5, { 0 }},
    { 33, 0, 3, 2, { 0 }},
    { 34, 0, 3, 4, { 0 }},
    { 35, 0, 3, 6, { 0 }},
    { 36, 0, 3, 6, { 0 }},
    { 37, 0, 3, 8, { 0 }},
    { 38, 0, 3, 7, { 0 }},
    { 39, 0, 3, 2, { 0 }},
    { 40, 0, 1, 2, { 0 }},
    { 41, -1, 1, 2, { 0 }},
    { 42, 0, 3, 6, { 0 }},
    { 43, 0, 5, 6, { 0 }},
    { 44, 0, 10, 2, { 0 }},
    { 45, 0, 8, 6, { 0 }},
    { 46, 0, 11, 2, { 0 }},
    { 47, 0, 3, 4, { 0 }},
    { 48, 0, 3, 6, { 0 }},
    { 49, 0, 3, 3, { 0 }},
    { 50, 0, 3, 6, { 0 }},
    { 51, 0, 3, 6, { 0 }},
    { 52, 0, 3, 6, { 0 }},
    { 53, 0, 3, 6, { 0 }},
    { 54, 0, 3, 6, { 0 }},
    { 55, 0, 3, 6, { 0 }},
    { 56, 0, 3, 6, { 0 }},
    { 57, 0, 3, 6, { 0 }},
    { 58, 0, 4, 2, { 0 }},
    { 59, 0, 4, 2, { 0 }},
    { 60, 0, 5, 4, { 0 }},
    { 61, 0, 6, 6, { 0 }},
    { 62, 0, 5, 4, { 0 }},
    { 63, 0, 3, 6, { 0 }},
    { 64, 0, 3, 9, { 0 }},
    { 65, 0, 3, 6, { 0 }},
    { 66, 0, 3, 6, { 0 }},
    { 67, 0, 3, 6, { 0 }},
    { 68, 0, 3, 6, { 0 }},
    { 69, 0, 3, 6, { 0 }},
    { 70, 0, 3, 6, { 0 }},
    { 71, 0, 3, 6, { 0 }},
    { 72, 0, 3, 6, { 0 }},
    { 73, 0, 3, 2, { 0 }},
    { 74, 0, 3, 6, { 0 }},
    { 75, 0, 3, 6, { 0 }},
    { 76, 0, 3, 6, { 0 }},
    { 77, 0, 3, 10, { 0 }},
    { 78, 0, 3, 6, { 0 }},
    { 79, 0, 3, 6, { 0 }},
    { 80, 0, 3, 6, { 0 }},
    { 81, 0, 3, 6, { 0 }},
    { 82, 0, 3, 6, { 0 }},
    { 83, 0, 3, 6, { 0 }},
    { 84, 0, 3, 6, { 0 }},
    { 85, 0, 3, 6, { 0 }},
    { 86, 0, 3, 6, { 0 }},
    { 87, 0, 3, 10, { 0 }},
    { 88, 0, 3, 6, { 0 }},
    { 89, 0, 3, 6, { 0 }},
    { 90, 0, 3, 6, { 0 }},
    { 91, 0, 1, 2, { 0 }},
    { 92, 0, 3, 4, { 0 }},
    { 93, -2, 1, 2, { 0 }},
    { 94, 0, 3, 4, { 0 }},
    { 95, 0, 12, 7, { 0 }},
    { 96, 0, 3, 3, { 0 }},
    { 97, 0, 5, 6, { 0 }},
    { 98, 0, 3, 6, { 0 }},
    { 99, 0, 5, 6, { 0 }},
    { 100, 0, 3, 6, { 0 }},
    { 101, 0, 5, 6, { 0 }},
    { 102, 0, 3, 5, { 0 }},
    { 103, 0, 5, 6, { 0 }},
    { 104, 0, 3, 6, { 0 }},
    { 105, 0, 3, 2, { 0 }},
    { 106, 0, 3, 2, { 0 }},
    { 107, 0, 3, 6, { 0 }},
    { 108, 0, 3, 2, { 0 }},
    { 109, 0, 5, 10, { 0 }},
    { 110, 0, 5, 6, { 0 }},
    { 111, 0, 5, 6, { 0 }},
    { 112, 0, 5, 6, { 0 }},
    { 113, 0, 5, 6, { 0 }},
    { 114, 0, 5, 6, { 0 }},
    { 115, 0, 5, 6, { 0 }},
    { 116, 0, 3, 5, { 0 }},
    { 117, 0, 5, 6, { 0 }},
    { 118, 0, 5, 6, { 0 }},
    { 119, 0, 5, 10, { 0 }},
    { 120, 0, 5, 6, { 0 }},
    { 121, 0, 5, 6, { 0 }},
    { 122, 0, 5, 6, { 0 }},
    { 123, 0, 1, 3, { 0 }},
    { 124, 0, 1, 2, { 0 }},
    { 125, -1, 1, 3, { 0 }},
    { 126, 0, 3, 5, { 0 }},
    { 161, 0, 6, 2, { 0 }},
    { 162, 0, 4, 6, { 0 }},
    { 163, 0, 3, 6, { 0 }},
    { 8364, 0, 3, 6, { 0 }},
    { 165, 0, 3, 6, { 0 }},
    { 352, 0, 0, 6, { 0 }},
    { 167, 0, 3, 6, { 0 }},
    { 353, 0, 2, 6, { 0 }},
    { 169, 0, 3, 9, { 0 }},
    { 170, 0, 3, 5, { 0 }},
    { 171, 0, 5, 7, { 0 }},
    { 172, 0, 6, 6, { 0 }},
    { 174, 0, 3, 9, { 0 }},
    { 175, 0, 2, 7, { 0 }},
    { 176, 0, 3, 4, { 0 }},
    { 177, 0, 4, 6, { 0 }},
    { 178, 0, 3, 5, { 0 }},
    { 179, 0, 3, 5, { 0 }},
    { 381, 0, 0, 6, { 0 }},
    { 181, 0, 5, 6, { 0 }},
    { 182, 0, 3, 7, { 0 }},
    { 183, 0, 7, 2, { 0 }},
    { 382, 0, 2, 6, { 0 }},
    { 185, 0, 3, 3, { 0 }},
    { 186, 0, 3, 5, { 0 }},
    { 187, 0, 5, 7, { 0 }},
    { 338, 0, 3, 10, { 0 }},
    { 339, 0, 5, 10, { 0 }},
    { 376, 0, 1, 6, { 0 }},
    { 191, 0, 6, 6, { 0 }},
    { 192, 0, 0, 6, { 0 }},
    { 193, 0, 0, 6, { 0 }},
    { 194, 0, 0, 6, { 0 }},
    { 195, 0, 0, 6, { 0 }},
    { 196, 0, 1, 6, { 0 }},
    { 197, 0, 1, 6, { 0 }},
    { 198, 0, 3, 10, { 0 }},
    { 199, 0, 3, 6, { 0 }},
    { 200, 0, 0, 6, { 0 }},
    { 201, 0, 0, 6, { 0 }},
    { 202, 0, 0, 6, { 0 }},
    { 203, 0, 1, 6, { 0 }},
    { 204, -1, 0, 2, { 0 }},
    { 205, 0, 0, 2, { 0 }},
    { 206, -1, 0, 2, { 0 }},
    { 207, -1, 1, 2, { 0 }},
    { 208, -1, 3, 6, { 0 }},
    { 209, 0, 0, 6, { 0 }},
    { 210, 0, 0, 6, { 0 }},
    { 211, 0, 0, 6, { 0 }},
    { 212, 0, 0, 6, { 0 }},
    { 213, 0, 0, 6, { 0 }},
    { 214, 0, 1, 6, { 0 }},
    { 215, 0, 5, 6, { 0 }},
    { 216, 0, 3, 6, { 0 }},
    { 217, 0, 0, 6, { 0 }},
    { 218, 0, 0, 6, { 0 }},
    { 219, 0, 0, 6, { 0 }},
    { 220, 0, 1, 6, { 0 }},
    { 221, 0, 0, 6, { 0 }},
    { 222, 0, 3, 6, { 0 }},
    { 223, 0, 3, 6, { 0 }},
    { 224, 0, 2, 6, { 0 }},
    { 225, 0, 2, 6, { 0 }},
    { 226, 0, 2, 6, { 0 }},
    { 227, 0, 2, 6, { 0 }},
    { 228, 0, 3, 6, { 0 }},
    { 229, 0, 3, 6, { 0 }},
    { 230, 0, 5, 10, { 0 }},
    { 231, 0, 5, 6, { 0 }},
    { 232, 0, 2, 6, { 0 }},
    { 233, 0, 2, 6, { 0 }},
    { 234, 0, 2, 6, { 0 }},
    { 235, 0, 3, 6, { 0 }},
    { 236, -1, 2, 2, { 0 }},
    { 237, 0, 2, 2, { 0 }},
    { 238, -1, 2, 2, { 0 }},
    { 239, -1, 3, 2, { 0 }},
    { 240, 0, 3, 6, { 0 }},
    { 241, 0, 2, 6, { 0 }},
    { 242, 0, 2, 6, { 0 }},
    { 243, 0, 2, 6, { 0 }},
    { 244, 0, 2, 6, { 0 }},
    { 245, 0, 2, 6, { 0 }},
    { 246, 0, 3, 6, { 0 }},
    { 247, 0, 5, 6, { 0 }},
    { 248, 0, 5, 6, { 0 }},
    { 249, 0, 2, 6, { 0 }},
    { 250, 0, 2, 6, { 0 }},
    { 251, 0, 2, 6, { 0 }},
    { 252, 0, 3, 6, { 0 }},
    { 253, 0, 2, 6, { 0 }},
    { 254, 0, 2, 6, { 0 }},
    { 255, 0, 3, 6, { 0 }},
};

// Style loading function: RLTech
static void GuiLoadStyleRLTech(void)
{
    // Load style properties provided
    // NOTE: Default properties are propagated
    for (int i = 0; i < RLTECH_STYLE_PROPS_COUNT; i++)
    {
        GuiSetStyle(rltechStyleProps[i].controlId, rltechStyleProps[i].propertyId, rltechStyleProps[i].propertyValue);
    }

    // Custom font loading
    // NOTE: Compressed font image data (DEFLATE), it requires DecompressData() function
    int rltechFontDataSize = 0;
    unsigned char *data = DecompressData(rltechFontData, RLTECH_STYLE_FONT_ATLAS_COMP_SIZE, &rltechFontDataSize);
    Image imFont = { data, 512, 256, 1, 2 };

    Font font = { 0 };
    font.baseSize = 16;
    font.glyphCount = 189;

    // Load texture from image
    font.texture = LoadTextureFromImage(imFont);
    UnloadImage(imFont);  // Uncompressed image data can be unloaded from memory

    // Copy char recs data from global fontRecs
    // NOTE: Required to avoid issues if trying to free font
    font.recs = (Rectangle *)RAYGUI_MALLOC(font.glyphCount*sizeof(Rectangle));
    memcpy(font.recs, rltechFontRecs, font.glyphCount*sizeof(Rectangle));

    // Copy font char info data from global fontChars
    // NOTE: Required to avoid issues if trying to free font
    font.glyphs = (GlyphInfo *)RAYGUI_MALLOC(font.glyphCount*sizeof(GlyphInfo));
    memcpy(font.glyphs, rltechFontGlyphs, font.glyphCount*sizeof(GlyphInfo));

    GuiSetFont(font);

    // Setup a white rectangle on the font to be used on shapes drawing,
    // it makes possible to draw shapes and text (full UI) in a single draw call
    Rectangle fontWhiteRec = { 510, 254, 1, 1 };
    SetShapesTexture(font.texture, fontWhiteRec);

    //-----------------------------------------------------------------

    // TODO: Custom user style setup: Set specific properties here (if required)
    // i.e. Controls specific BORDER_WIDTH, TEXT_PADDING, TEXT_ALIGNMENT
}
