//////////////////////////////////////////////////////////////////////////////////
//                                                                              //
// StyleAsCode exporter v2.0 - Style data exported as a values array            //
//                                                                              //
// USAGE: On init call: GuiLoadStyleSunny();                                   //
//                                                                              //
// more info and bugs-report:  github.com/raysan5/raygui                        //
// feedback and support:       ray[at]raylibtech.com                            //
//                                                                              //
// Copyright (c) 2020-2025 raylib technologies (@raylibtech)                    //
//                                                                              //
//////////////////////////////////////////////////////////////////////////////////

#define SUNNY_STYLE_PROPS_COUNT  33

// Custom style name: Sunny
static const GuiStyleProp sunnyStyleProps[SUNNY_STYLE_PROPS_COUNT] = {
    { 0, 0, (int)0x9c760aff },    // DEFAULT_BORDER_COLOR_NORMAL 
    { 0, 1, (int)0x594006ff },    // DEFAULT_BASE_COLOR_NORMAL 
    { 0, 2, (int)0xf6d519ff },    // DEFAULT_TEXT_COLOR_NORMAL 
    { 0, 3, (int)0xf6ee89ff },    // DEFAULT_BORDER_COLOR_FOCUSED 
    { 0, 4, (int)0xf5f3d1ff },    // DEFAULT_BASE_COLOR_FOCUSED 
    { 0, 5, (int)0xf4cd19ff },    // DEFAULT_TEXT_COLOR_FOCUSED 
    { 0, 6, (int)0xf7e580ff },    // DEFAULT_BORDER_COLOR_PRESSED 
    { 0, 7, (int)0xf7f2c1ff },    // DEFAULT_BASE_COLOR_PRESSED 
    { 0, 8, (int)0x52470aff },    // DEFAULT_TEXT_COLOR_PRESSED 
    { 0, 9, (int)0xc0be92ff },    // DEFAULT_BORDER_COLOR_DISABLED 
    { 0, 10, (int)0xd3d3a1ff },    // DEFAULT_BASE_COLOR_DISABLED 
    { 0, 11, (int)0xbcbc89ff },    // DEFAULT_TEXT_COLOR_DISABLED 
    { 0, 16, (int)0x00000010 },    // DEFAULT_TEXT_SIZE 
    { 0, 17, (int)0x00000000 },    // DEFAULT_TEXT_SPACING 
    { 0, 18, (int)0x725706ff },    // DEFAULT_LINE_COLOR 
    { 0, 19, (int)0xf0be4bff },    // DEFAULT_BACKGROUND_COLOR 
    { 0, 20, (int)0x00000018 },    // DEFAULT_TEXT_LINE_SPACING 
    { 1, 2, (int)0x504506ff },    // LABEL_TEXT_COLOR_NORMAL 
    { 1, 5, (int)0xfdeb9bff },    // LABEL_TEXT_COLOR_FOCUSED 
    { 1, 8, (int)0xf5e8a4ff },    // LABEL_TEXT_COLOR_PRESSED 
    { 2, 2, (int)0xebc21fff },    // BUTTON_TEXT_COLOR_NORMAL 
    { 3, 2, (int)0xebc21fff },    // TOGGLE_TEXT_COLOR_NORMAL 
    { 4, 2, (int)0x81700fff },    // SLIDER_TEXT_COLOR_NORMAL 
    { 4, 5, (int)0xf4e49aff },    // SLIDER_TEXT_COLOR_FOCUSED 
    { 7, 2, (int)0xebc21fff },    // COMBOBOX_TEXT_COLOR_NORMAL 
    { 8, 2, (int)0xefd87bff },    // DROPDOWNBOX_TEXT_COLOR_NORMAL 
    { 8, 5, (int)0xd4b219ff },    // DROPDOWNBOX_TEXT_COLOR_FOCUSED 
    { 9, 2, (int)0x7a680bff },    // TEXTBOX_TEXT_COLOR_NORMAL 
    { 9, 5, (int)0xad931fff },    // TEXTBOX_TEXT_COLOR_FOCUSED 
    { 10, 2, (int)0x62570eff },    // VALUEBOX_TEXT_COLOR_NORMAL 
    { 10, 5, (int)0xf2df88ff },    // VALUEBOX_TEXT_COLOR_FOCUSED 
    { 12, 2, (int)0xf4e798ff },    // LISTVIEW_TEXT_COLOR_NORMAL 
    { 15, 2, (int)0xebc21fff },    // STATUSBAR_TEXT_COLOR_NORMAL 
};

// WARNING: This style uses a custom font: "GMSN.ttf" (size: 16, spacing: 0)

#define SUNNY_STYLE_FONT_ATLAS_COMP_SIZE 2434

// Font atlas image pixels data: DEFLATE compressed
static unsigned char sunnyFontData[SUNNY_STYLE_FONT_ATLAS_COMP_SIZE] = { 0xed,
    0xdd, 0x5b, 0x6e, 0xe4, 0x36, 0x10, 0x05, 0x50, 0xee, 0x7f, 0xa1, 0xd9, 0x06, 0x83, 0x20, 0x18, 0x24, 0xe3, 0xb1, 0x45,
    0xb2, 0xaa, 0xa8, 0x57, 0x9f, 0x1c, 0xe4, 0xc7, 0x1a, 0xb7, 0xd5, 0x94, 0xae, 0x44, 0x3d, 0x58, 0xec, 0x0d, 0x00, 0x00,
    0x00, 0xf8, 0x78, 0xff, 0xfc, 0xf7, 0xfd, 0xcf, 0xbe, 0x5b, 0x72, 0xbc, 0xec, 0xd7, 0xbf, 0x18, 0x2d, 0xe9, 0x3f, 0xae,
    0x49, 0x3f, 0x58, 0x36, 0xf7, 0xb7, 0x62, 0xeb, 0xd5, 0x97, 0xda, 0xa6, 0x1f, 0xb4, 0x5a, 0x4b, 0xff, 0xbc, 0x1d, 0xb6,
    0x7d, 0x0f, 0xb4, 0x5e, 0x3b, 0x5c, 0xe7, 0x9f, 0x7f, 0x73, 0xbc, 0xa4, 0x72, 0x3d, 0x57, 0xda, 0xb4, 0x72, 0xfb, 0xac,
    0xb4, 0x60, 0x5b, 0x5e, 0x7a, 0xdc, 0x52, 0x6d, 0xaa, 0x1d, 0xc7, 0x9f, 0xdc, 0x6f, 0x92, 0xff, 0xe3, 0x6f, 0xf3, 0x2b,
    0x83, 0x47, 0x5b, 0x7f, 0x7e, 0xdf, 0x68, 0xd3, 0xc7, 0x84, 0xff, 0xfe, 0x76, 0x5d, 0x42, 0xb3, 0x9f, 0xd2, 0x87, 0x47,
    0xc2, 0x95, 0x16, 0x3a, 0x6e, 0xbd, 0x16, 0xca, 0xc4, 0xe8, 0x33, 0x23, 0xeb, 0x32, 0xb3, 0x6c, 0x6e, 0xfd, 0x62, 0xfb,
    0xfc, 0xf8, 0xf3, 0x8e, 0xf7, 0xb4, 0xa3, 0x2d, 0x3c, 0xda, 0x73, 0x8f, 0xbf, 0xdf, 0xfa, 0x56, 0xcd, 0xa4, 0x7e, 0x4f,
    0xfe, 0xfb, 0xff, 0x72, 0xd6, 0x83, 0x19, 0xcc, 0x9f, 0x1b, 0xd6, 0xcf, 0x0a, 0xc7, 0xc7, 0xac, 0x7d, 0x2d, 0x7c, 0xd4,
    0x4e, 0x3d, 0xb0, 0x0f, 0xaf, 0x6f, 0xb3, 0xe8, 0xdf, 0xd9, 0x91, 0xff, 0x8a, 0x14, 0xb7, 0x89, 0x33, 0x62, 0xa4, 0x4f,
    0x71, 0xdc, 0xe3, 0xcc, 0x27, 0x7c, 0xb4, 0x2e, 0x91, 0xfe, 0x4c, 0xbe, 0x2d, 0x57, 0xfb, 0x1c, 0xfb, 0xf2, 0x5f, 0x71,
    0xbe, 0x5d, 0x3f, 0x97, 0xec, 0x6b, 0xdf, 0x99, 0xf3, 0xf5, 0xfd, 0xf3, 0xbf, 0xfe, 0xdd, 0x2a, 0xf2, 0x5f, 0xb3, 0x55,
    0xd6, 0xf3, 0xdf, 0xe5, 0x7f, 0xfa, 0xfc, 0xff, 0x73, 0xab, 0xf7, 0xe0, 0xf5, 0x57, 0xfe, 0xaa, 0xbd, 0xaa, 0x9f, 0x7f,
    0x6d, 0xfe, 0x47, 0xd7, 0x83, 0x6d, 0x39, 0xff, 0xb1, 0xab, 0xcf, 0xc8, 0xd5, 0x46, 0x55, 0xff, 0x7f, 0x6f, 0xef, 0xe1,
    0xf8, 0xea, 0x31, 0x92, 0xf0, 0xb5, 0x7b, 0x1e, 0x35, 0x9f, 0x7c, 0x45, 0xfe, 0xdb, 0xc4, 0xda, 0xf4, 0xe1, 0xf5, 0xff,
    0xec, 0x11, 0x7e, 0x2d, 0xff, 0x75, 0xe7, 0x8e, 0x2b, 0xf3, 0xdf, 0x83, 0x77, 0xc4, 0xaa, 0xaf, 0xe3, 0xe3, 0xdf, 0x6d,
    0xed, 0xfe, 0xdc, 0x79, 0xd7, 0xff, 0xa3, 0x7e, 0x60, 0x26, 0xff, 0x9f, 0xd2, 0xff, 0x9f, 0xe9, 0x69, 0x8f, 0x5a, 0x71,
    0xfe, 0x78, 0x76, 0xc5, 0xd9, 0xfc, 0xda, 0xfc, 0xf7, 0xa9, 0x7b, 0xd8, 0xf7, 0xce, 0x7f, 0x5b, 0xbe, 0xca, 0xab, 0xdc,
    0x77, 0xa3, 0x7b, 0xd4, 0x68, 0xcf, 0x9d, 0x39, 0xaa, 0xdd, 0x33, 0xff, 0xb1, 0xfd, 0xb9, 0x0f, 0x7b, 0xf9, 0x3d, 0x91,
    0xff, 0xf6, 0x9a, 0xfc, 0xf7, 0xe0, 0xdd, 0x8e, 0x9f, 0xfb, 0x7b, 0xb1, 0xfb, 0x71, 0x91, 0x9e, 0x7c, 0xa6, 0x8f, 0x52,
    0x95, 0xff, 0x7b, 0x6c, 0x49, 0xe7, 0xff, 0x8a, 0xfb, 0xff, 0xed, 0xb0, 0x87, 0xff, 0x59, 0xf9, 0x3f, 0x7e, 0xfe, 0xd7,
    0x6e, 0xff, 0xac, 0x2e, 0x9a, 0xff, 0x9a, 0xfb, 0xff, 0xe7, 0x1f, 0xad, 0x67, 0xae, 0x5c, 0x73, 0xf9, 0xbf, 0xd3, 0xf3,
    0xbf, 0xbd, 0xf9, 0x1f, 0x3d, 0xf5, 0x7e, 0x53, 0xff, 0xbf, 0xf2, 0x3e, 0x7e, 0xfc, 0x9d, 0x9b, 0x7d, 0xef, 0x14, 0xb5,
    0xd0, 0x9b, 0x5c, 0xf7, 0x4c, 0x7f, 0xf4, 0x39, 0x50, 0xee, 0x2e, 0xdd, 0xd5, 0xef, 0xff, 0xd4, 0xb7, 0xe0, 0x79, 0xeb,
    0xd3, 0x6f, 0xdc, 0x67, 0xe4, 0x5d, 0x6f, 0xc9, 0xda, 0xbb, 0xce, 0x7c, 0x3e, 0x1b, 0xff, 0x5b, 0xb6, 0x0f, 0x3b, 0xcf,
    0x6c, 0x5a, 0xe2, 0x19, 0xf7, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xc9, 0xe3,
    0x17, 0x22, 0x63, 0x0d, 0xa3, 0x75, 0x08, 0x6a, 0xeb, 0x21, 0xf4, 0x2f, 0x75, 0x58, 0x57, 0x3f, 0x7b, 0x76, 0xac, 0x65,
    0x66, 0x9c, 0x66, 0xed, 0xef, 0x56, 0x55, 0x96, 0xa8, 0x1d, 0x79, 0x3e, 0xae, 0x77, 0xb3, 0x5a, 0xad, 0x39, 0x56, 0x05,
    0x6d, 0xbd, 0xa6, 0x79, 0xa6, 0x0e, 0x5f, 0xf5, 0xd8, 0xea, 0x9a, 0xfa, 0x68, 0xf3, 0x63, 0xde, 0x6b, 0x2a, 0x8d, 0xd4,
    0xe5, 0x7f, 0x7d, 0x3b, 0xf4, 0x2f, 0xeb, 0xd1, 0x2f, 0xa8, 0xc4, 0x50, 0xbf, 0x74, 0xee, 0xe7, 0x77, 0xca, 0xff, 0xec,
    0x31, 0x38, 0xbb, 0xf7, 0xc6, 0x47, 0xdc, 0x8d, 0xaa, 0x4f, 0x5c, 0x5f, 0x5b, 0xa5, 0x15, 0xd5, 0x47, 0xad, 0xcf, 0x7f,
    0x3b, 0xe9, 0xfc, 0x1f, 0xcd, 0x7f, 0x1f, 0xce, 0x66, 0x73, 0xdf, 0xfc, 0xaf, 0xd7, 0x9d, 0xc8, 0xfe, 0xd5, 0xdc, 0x4c,
    0x0e, 0xf1, 0x5a, 0xe3, 0xf9, 0xfc, 0xe7, 0x2a, 0x05, 0x9d, 0x7b, 0x6e, 0xbd, 0x3e, 0xff, 0xd1, 0x16, 0xb9, 0x2a, 0xff,
    0xf1, 0xbd, 0xa4, 0x0f, 0xab, 0x59, 0xdf, 0x31, 0xff, 0xfd, 0xe3, 0xf3, 0x5f, 0x5f, 0xcb, 0x37, 0x9a, 0x80, 0x48, 0x1d,
    0xf4, 0x99, 0xeb, 0xea, 0xd5, 0x2b, 0xbb, 0xf8, 0x75, 0x57, 0xf4, 0xfc, 0x3f, 0xfa, 0xfd, 0x99, 0x6f, 0x72, 0x75, 0xfe,
    0xdb, 0x30, 0xe1, 0x3d, 0x91, 0xd2, 0xf8, 0x1d, 0x90, 0x4c, 0xcd, 0xab, 0x6b, 0xf2, 0xdf, 0x42, 0x33, 0x06, 0xc6, 0xcf,
    0xf3, 0x77, 0xcf, 0x7f, 0xf5, 0xb5, 0x41, 0xf4, 0x8e, 0x41, 0xf5, 0x3a, 0xde, 0xef, 0xfa, 0xbf, 0x17, 0xf4, 0x12, 0x77,
    0xe4, 0x3f, 0xdb, 0x3e, 0xd1, 0x34, 0xc5, 0xf2, 0x3f, 0x7f, 0x76, 0x8f, 0xcd, 0x26, 0x10, 0x5b, 0xf6, 0xde, 0xfc, 0xd7,
    0xd6, 0x4f, 0x5d, 0xbf, 0x57, 0xfc, 0xa6, 0xfc, 0x47, 0xaf, 0xff, 0xe7, 0xaf, 0xb8, 0xee, 0x95, 0xff, 0x36, 0x31, 0x3f,
    0xcf, 0xd9, 0xf9, 0x1f, 0x55, 0x5b, 0x7d, 0x5b, 0xfe, 0xa3, 0xd9, 0x8a, 0xce, 0x67, 0xd4, 0xc2, 0x67, 0xba, 0xb7, 0x9f,
    0xff, 0xdb, 0x4b, 0xf3, 0x1f, 0x9f, 0x5f, 0xe6, 0x59, 0xf9, 0xaf, 0xee, 0x35, 0x5c, 0x5f, 0x57, 0x2f, 0x7a, 0xb7, 0x31,
    0x7e, 0x97, 0xf2, 0xdd, 0xfd, 0xff, 0xbe, 0xa1, 0x17, 0x9e, 0x7d, 0xfe, 0x7f, 0x55, 0xfe, 0x77, 0x3d, 0xff, 0x6b, 0xd3,
    0x73, 0xfe, 0xed, 0x5a, 0x2b, 0xf9, 0xaf, 0xce, 0x7f, 0xe5, 0xdc, 0x89, 0x6b, 0xff, 0xa2, 0xfa, 0xfd, 0x9f, 0xfa, 0x3b,
    0x69, 0xfb, 0xdf, 0xff, 0xd9, 0xd3, 0x3e, 0x6d, 0x6a, 0xc6, 0xb4, 0xf5, 0xbf, 0xda, 0x26, 0x67, 0x35, 0x8e, 0xad, 0x73,
    0xfd, 0xdb, 0x37, 0x77, 0xcf, 0x7f, 0xec, 0x6d, 0x83, 0xe8, 0x6f, 0xc6, 0x7f, 0xe3, 0x3e, 0x73, 0x81, 0x7d, 0xe6, 0x5b,
    0x94, 0x5a, 0xa1, 0xba, 0x85, 0xb4, 0x2a, 0x8e, 0x00, 0xef, 0x7a, 0xcf, 0x7c, 0xd7, 0xbf, 0x07, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xbc, 0xd1, 0x2b, 0xb3, 0x35, 0xb7, 0xff, 0xfc, 0x69, 0x0f, 0x8d, 0x77,
    0xed, 0xc9, 0xdf, 0xeb, 0xcb, 0x75, 0x30, 0xd6, 0xc6, 0x9d, 0x56, 0xd4, 0x60, 0xa8, 0xae, 0x23, 0x35, 0x6e, 0x97, 0xd9,
    0x2d, 0x3d, 0x1e, 0x49, 0xbc, 0xba, 0x87, 0x44, 0xc6, 0xf5, 0x64, 0x2a, 0xea, 0x64, 0xe6, 0x12, 0x88, 0x57, 0x42, 0x6c,
    0x8b, 0x9f, 0x1a, 0xdb, 0x6a, 0x91, 0xf1, 0xe1, 0x3b, 0xf3, 0x1f, 0xab, 0x2d, 0x79, 0x45, 0xa5, 0xb5, 0xf8, 0xde, 0x54,
    0xbb, 0x86, 0xf5, 0xad, 0x32, 0xb7, 0xb6, 0xb9, 0x9f, 0x67, 0xc6, 0xf4, 0xe7, 0x6a, 0x0f, 0xac, 0xb6, 0x44, 0x9f, 0xaa,
    0x96, 0xb2, 0xfa, 0x9b, 0x3f, 0xff, 0xde, 0xf1, 0xb2, 0x3e, 0x55, 0x39, 0x62, 0xed, 0x53, 0xbf, 0xff, 0xb7, 0xfb, 0x2a,
    0x27, 0xbc, 0x23, 0xff, 0x2d, 0x70, 0x94, 0x3d, 0x37, 0xff, 0xf1, 0xe3, 0x54, 0x2b, 0xac, 0xd2, 0xb3, 0x3e, 0x37, 0x46,
    0x64, 0xe4, 0x6e, 0xbe, 0x46, 0xd0, 0x19, 0x15, 0x35, 0xfe, 0xcc, 0xd7, 0xca, 0x56, 0x9b, 0x4b, 0xff, 0xf7, 0xc7, 0xb8,
    0x76, 0xd0, 0xdb, 0x9a, 0xcd, 0x7f, 0x0f, 0xd4, 0x1e, 0xa9, 0xa9, 0xc8, 0xf7, 0x9c, 0xfc, 0xcf, 0x5c, 0x6d, 0x9c, 0x97,
    0xff, 0xf1, 0xcf, 0xeb, 0xaa, 0x6a, 0x57, 0xd6, 0xda, 0x19, 0xd5, 0x5a, 0x6e, 0xa1, 0x2d, 0xd2, 0x83, 0xc7, 0x95, 0x5e,
    0x5c, 0xcf, 0xbc, 0x7f, 0xf9, 0x7f, 0xf6, 0x4c, 0x3d, 0x9b, 0xff, 0xd5, 0xbf, 0x78, 0x4d, 0xff, 0x7f, 0x65, 0x7f, 0x79,
    0x52, 0xfe, 0xdb, 0x54, 0x2d, 0xb2, 0x7b, 0x9f, 0xff, 0x2b, 0x6b, 0x6a, 0xd5, 0xe7, 0x3f, 0x96, 0xf0, 0xc8, 0xfe, 0x3e,
    0x3f, 0xe3, 0xc1, 0xda, 0x76, 0x1b, 0xf7, 0xf2, 0x7b, 0xa2, 0xff, 0x9f, 0xcf, 0x7f, 0x5d, 0x9f, 0x67, 0xed, 0xea, 0xf9,
    0x8a, 0xfc, 0xf7, 0x44, 0x65, 0xf4, 0xfd, 0xd7, 0xff, 0xa3, 0x7e, 0x62, 0xb4, 0x55, 0xea, 0xe7, 0xa6, 0xaa, 0xac, 0xb6,
    0xbd, 0x9a, 0xff, 0xcc, 0xf9, 0x3f, 0x7a, 0x1f, 0x22, 0xd3, 0x43, 0x5c, 0xbb, 0x1e, 0xcf, 0x1f, 0x01, 0xd6, 0xfa, 0xff,
    0x67, 0xdc, 0xff, 0xef, 0xa7, 0x5d, 0xff, 0xb7, 0xd4, 0x2c, 0x46, 0x95, 0xfd, 0xff, 0x96, 0xe8, 0x65, 0x66, 0x8e, 0x36,
    0x91, 0xd6, 0x5e, 0x6f, 0xb3, 0x2b, 0xcf, 0xff, 0xb9, 0xd9, 0xe6, 0xda, 0xb6, 0x7a, 0xa7, 0x91, 0xfe, 0xff, 0x9e, 0x14,
    0x56, 0xfc, 0xc5, 0xca, 0xeb, 0xff, 0xeb, 0xe7, 0x66, 0xc8, 0xe4, 0xff, 0xac, 0xde, 0xd3, 0xfe, 0x6f, 0x5e, 0x5b, 0x47,
    0xfa, 0x0e, 0xd7, 0xff, 0x91, 0xfb, 0xff, 0xd1, 0x9a, 0xc7, 0xe3, 0xb3, 0x71, 0xff, 0xf1, 0x0a, 0xff, 0xcc, 0xb3, 0xf1,
    0xf9, 0x47, 0x9c, 0xda, 0xeb, 0x7f, 0xf9, 0xdf, 0xf3, 0xdd, 0x2b, 0x6b, 0xe7, 0xee, 0xce, 0xff, 0x5c, 0xcf, 0x2a, 0x36,
    0x23, 0x62, 0x6e, 0xc6, 0xe4, 0xe8, 0x35, 0x5d, 0x3b, 0x75, 0x4f, 0x6f, 0x17, 0xf4, 0xfe, 0xab, 0x67, 0xe4, 0x79, 0xe7,
    0xfb, 0x50, 0xef, 0xf8, 0x06, 0x67, 0x1c, 0xcf, 0x7b, 0x61, 0xcf, 0x34, 0x7f, 0xff, 0x2f, 0x7e, 0xb4, 0x6a, 0x17, 0xd4,
    0x20, 0x3e, 0xfb, 0x2f, 0xc6, 0x9f, 0x56, 0x20, 0xff, 0x6b, 0xf9, 0xdf, 0xdf, 0x4b, 0xaa, 0x7a, 0x87, 0xe1, 0xd3, 0xf6,
    0x14, 0x2d, 0xf3, 0x29, 0xdb, 0x75, 0xfd, 0x4e, 0xef, 0x5b, 0x5a, 0xc2, 0x3e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xbc, 0x6b, 0xf4, 0x4f, 0xac, 0x9a, 0xc2, 0x6c, 0x2d, 0xab, 0xbe, 0x30, 0x3a, 0xb3, 0x0d,
    0xeb, 0x33, 0x67, 0x3f, 0xe7, 0xeb, 0xcc, 0x05, 0x7d, 0xf0, 0x2f, 0x5a, 0x60, 0x4d, 0x7b, 0x78, 0xac, 0xf1, 0xfa, 0x3c,
    0x0c, 0x5f, 0xd7, 0xb8, 0x25, 0x5a, 0x64, 0x3c, 0x92, 0x77, 0x7d, 0xc6, 0x86, 0xbd, 0xdf, 0xb9, 0xa6, 0x22, 0x7a, 0xa4,
    0xb6, 0xdf, 0x6c, 0x85, 0x92, 0xb3, 0x5b, 0x25, 0x33, 0x62, 0xbb, 0x05, 0x8e, 0x0d, 0xa3, 0x7a, 0x42, 0x2b, 0xb5, 0xba,
    0xd6, 0x8e, 0x4f, 0x73, 0x55, 0xf8, 0xd6, 0xc7, 0xa5, 0xcf, 0xd5, 0xf0, 0x6c, 0x1b, 0xeb, 0x5e, 0xaf, 0xef, 0xed, 0xf1,
    0xa4, 0xe4, 0x96, 0xce, 0x8d, 0xc7, 0xdf, 0xf1, 0x9d, 0xe3, 0x35, 0x6b, 0xe7, 0x3f, 0x27, 0x73, 0xf6, 0x1b, 0xa7, 0x74,
    0x4f, 0xab, 0xc4, 0xd2, 0x9f, 0xa9, 0x08, 0xb3, 0x9e, 0xff, 0x9a, 0xf5, 0x1e, 0xcf, 0x89, 0x10, 0x9b, 0x65, 0x63, 0xa6,
    0x86, 0xf7, 0xfb, 0xaa, 0x07, 0xe4, 0xf3, 0xff, 0xa9, 0x35, 0x17, 0x9e, 0xd4, 0x02, 0x7d, 0x31, 0x61, 0x33, 0xbd, 0xf8,
    0x9a, 0xfc, 0x8f, 0xe7, 0x4a, 0x3a, 0x3f, 0xff, 0x3d, 0xf4, 0x09, 0xf1, 0x9e, 0xdb, 0x1d, 0x97, 0xe6, 0xf2, 0x3f, 0xde,
    0x83, 0xf6, 0x2c, 0xad, 0x9a, 0x29, 0x29, 0x57, 0x87, 0xbc, 0x05, 0xaf, 0x1e, 0x32, 0x4b, 0x23, 0xb5, 0x11, 0x7a, 0xe8,
    0x6a, 0x64, 0xcf, 0xf9, 0x3f, 0x7f, 0xfd, 0x3f, 0xdf, 0x6f, 0x8b, 0xdf, 0x3f, 0xc8, 0xec, 0x4b, 0x3b, 0xfa, 0xe1, 0x67,
    0x2c, 0x8d, 0xd4, 0x86, 0xbb, 0x6a, 0xe9, 0xee, 0xfc, 0xf7, 0xdf, 0xe6, 0x4a, 0x3c, 0x4a, 0xd4, 0xfa, 0xd1, 0x21, 0x77,
    0x64, 0xd9, 0xdb, 0xd7, 0x59, 0xbd, 0xff, 0xb7, 0xba, 0x96, 0x75, 0x73, 0x99, 0x45, 0xab, 0x52, 0x7e, 0xfd, 0xfd, 0xba,
    0xf3, 0xff, 0xbe, 0xad, 0xbe, 0x77, 0x69, 0xe6, 0xee, 0xde, 0x5b, 0xf3, 0x3f, 0xd7, 0x6e, 0xef, 0xc8, 0xff, 0xb8, 0x7e,
    0x6b, 0x2f, 0xba, 0x4f, 0x71, 0xc6, 0x37, 0x9a, 0xad, 0xc0, 0x9f, 0x9b, 0x63, 0xf6, 0x4d, 0xf9, 0x6f, 0x45, 0xfd, 0xff,
    0x33, 0x97, 0xde, 0xa3, 0xff, 0xdf, 0x5f, 0x90, 0xff, 0xec, 0x73, 0x9d, 0x8a, 0x19, 0x8e, 0xcf, 0xce, 0x7f, 0xf6, 0x98,
    0x78, 0xaf, 0x6b, 0xe1, 0xec, 0xd2, 0x6c, 0xfe, 0x3f, 0xf5, 0xfc, 0xff, 0x86, 0xfc, 0xe7, 0x9f, 0x65, 0xaf, 0xdc, 0xff,
    0x3b, 0xef, 0x1d, 0x88, 0xbe, 0x31, 0xff, 0xed, 0x43, 0xcf, 0xff, 0x35, 0xf3, 0xca, 0x3f, 0x2d, 0xff, 0x33, 0x77, 0x99,
    0x9e, 0x9a, 0xff, 0x8a, 0x8c, 0x54, 0xdd, 0xff, 0xaf, 0x7f, 0x0b, 0x6a, 0x67, 0x75, 0xfa, 0xe7, 0x25, 0x7c, 0x9c, 0xff,
    0xc8, 0xfb, 0x3f, 0xef, 0xce, 0xff, 0xdc, 0xbb, 0x31, 0xcf, 0xce, 0x7f, 0x4f, 0xce, 0x4a, 0xf3, 0xce, 0xe7, 0xc3, 0xb1,
    0x39, 0xa6, 0x9f, 0x97, 0xff, 0xfc, 0x3b, 0x65, 0x6f, 0x7d, 0xfe, 0x97, 0x7b, 0x3b, 0xe0, 0x9a, 0xe7, 0x7f, 0x77, 0x7a,
    0xaf, 0x84, 0xb7, 0xbf, 0x55, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x66, 0xec,
    0xeb, 0xea, 0x88, 0x9d, 0xb9, 0x71, 0x62, 0xd7, 0x54, 0xbe, 0x8f, 0xd4, 0x29, 0x98, 0x59, 0x9f, 0x78, 0xf5, 0x83, 0x48,
    0xad, 0xfd, 0xa3, 0x6d, 0x13, 0xad, 0x38, 0x9e, 0xa9, 0x64, 0xb4, 0xeb, 0x3b, 0xae, 0xd7, 0x84, 0x9f, 0xff, 0x0b, 0x73,
    0x95, 0x1f, 0x63, 0xb9, 0xb8, 0xfb, 0xb6, 0x9e, 0x1b, 0xa5, 0xb9, 0xb3, 0x4e, 0x7c, 0x4f, 0xd6, 0x34, 0xaf, 0x5f, 0xab,
    0x6c, 0x95, 0xfe, 0xd8, 0x3a, 0x47, 0x5a, 0xb8, 0x27, 0xe6, 0x61, 0x69, 0x13, 0x7b, 0x52, 0x75, 0x75, 0x9f, 0xcc, 0xbc,
    0x1c, 0xf3, 0x47, 0xe4, 0xca, 0x8a, 0xfd, 0x2d, 0x51, 0xad, 0xff, 0x2e, 0xdb, 0xfa, 0xda, 0xf1, 0xb4, 0xe3, 0x75, 0x7e,
    0xce, 0x78, 0xdf, 0xb9, 0xd1, 0xe3, 0xcf, 0xf8, 0x36, 0x33, 0xc7, 0xb2, 0xf5, 0xea, 0x3c, 0xef, 0xac, 0xd9, 0xf0, 0xd9,
    0x63, 0x95, 0xb3, 0x95, 0x05, 0x46, 0xc7, 0xba, 0xe7, 0x54, 0xaf, 0xca, 0xd5, 0xbd, 0x9a, 0x69, 0xc5, 0xb3, 0x96, 0x1d,
    0xf9, 0x2b, 0x30, 0x0f, 0xdb, 0x95, 0xdf, 0x71, 0x7f, 0xc5, 0x8e, 0xe3, 0x5a, 0x22, 0xf7, 0xde, 0xd6, 0xd9, 0x1a, 0x59,
    0xd9, 0x4a, 0x30, 0xd1, 0xf3, 0xff, 0x53, 0xf3, 0x3f, 0x9a, 0x8b, 0xe0, 0xe7, 0x59, 0xc9, 0xce, 0x5b, 0x56, 0x31, 0x93,
    0xc1, 0xea, 0x15, 0xd0, 0x8e, 0x65, 0x57, 0x56, 0xec, 0x3a, 0xfb, 0xbb, 0xc6, 0xdb, 0xa8, 0xaa, 0x9f, 0x18, 0x9d, 0xb3,
    0x64, 0xb4, 0xec, 0xd3, 0xce, 0xff, 0xfd, 0xf2, 0x65, 0xf3, 0x47, 0xb1, 0xbb, 0xef, 0xdb, 0xfb, 0x67, 0xec, 0x78, 0x42,
    0xc6, 0x33, 0xb3, 0x4b, 0xed, 0xcc, 0xff, 0x3d, 0xeb, 0x1d, 0xf7, 0xd4, 0xb9, 0x31, 0x5b, 0xab, 0xef, 0x3e, 0xb9, 0xc9,
    0xcc, 0x64, 0x1c, 0x9b, 0xbf, 0xb9, 0x7a, 0x99, 0xfc, 0xdf, 0x3b, 0xff, 0x73, 0xf7, 0x56, 0xee, 0x57, 0xbd, 0x32, 0x3b,
    0x4b, 0xef, 0xfb, 0xfb, 0x8b, 0x7d, 0xc3, 0xd3, 0x9a, 0xba, 0xe7, 0x89, 0xf2, 0x7f, 0x97, 0xfe, 0xbf, 0xfc, 0xbf, 0x6f,
    0x7f, 0xe9, 0xa9, 0x4a, 0xe6, 0xfa, 0xff, 0xf2, 0xff, 0xe6, 0xfc, 0xf7, 0x47, 0x5c, 0xff, 0xef, 0xda, 0x5f, 0xde, 0x76,
    0xff, 0x3f, 0xfa, 0xb4, 0xf7, 0x29, 0xcf, 0x7a, 0xce, 0x78, 0xfe, 0xb7, 0xe7, 0x93, 0x77, 0x56, 0x43, 0x7f, 0xff, 0xf3,
    0xde, 0xa7, 0xd4, 0x83, 0xe7, 0xed, 0xfb, 0xa1, 0x36, 0x00, 0xf9, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x76, 0xbe, 0xa9, 0x7f, 0x66, 0xc5, 0xf7, 0xc8, 0xa8, 0xcf, 0xb9, 0xcf, 0x04, 0x62, 0x23, 0x75, 0xce,
    0xac, 0xf8, 0x9e, 0x1f, 0x9d, 0x6f, 0x5b, 0xc2, 0xfb, 0xc6, 0x8a, 0xcb, 0x36, 0xec, 0x49, 0x55, 0x7f, 0x48, 0x15, 0xa4,
    0x77, 0xcc, 0xcd, 0x01, 0xf2, 0xff, 0x94, 0x0a, 0x69, 0x20, 0xff, 0xf2, 0x0f, 0xf2, 0x2f, 0xff, 0x20, 0xff, 0xf2, 0x0f,
    0x6f, 0xbf, 0xff, 0x7f, 0xa7, 0x99, 0x6b, 0xf6, 0xd5, 0x29, 0x06, 0xcf, 0xfe, 0x63, 0x47, 0x87, 0xea, 0x65, 0x6d, 0x78,
    0xdc, 0xf0, 0x8c, 0x10, 0xce, 0xca, 0xff, 0x35, 0xcf, 0xf8, 0x57, 0xf3, 0xaf, 0xff, 0x0f, 0x6f, 0xba, 0x1a, 0x89, 0xbc,
    0xff, 0x27, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x70, 0x95, 0x7f, 0xff, 0xd3, 0x0e, 0x20, 0xff, 0xc0, 0xc7, 0xe5, 0xff, 0x6f };

// Font glyphs rectangles data (on atlas)
static const Rectangle sunnyFontRecs[189] = {
    { 4, 4, 4 , 16 },
    { 16, 4, 2 , 10 },
    { 26, 4, 5 , 3 },
    { 39, 4, 7 , 10 },
    { 54, 4, 7 , 13 },
    { 69, 4, 7 , 10 },
    { 84, 4, 7 , 10 },
    { 99, 4, 2 , 3 },
    { 109, 4, 3 , 12 },
    { 120, 4, 3 , 12 },
    { 131, 4, 5 , 6 },
    { 144, 4, 6 , 5 },
    { 158, 4, 2 , 4 },
    { 168, 4, 5 , 1 },
    { 181, 4, 2 , 2 },
    { 191, 4, 4 , 10 },
    { 203, 4, 6 , 10 },
    { 217, 4, 4 , 10 },
    { 229, 4, 6 , 10 },
    { 243, 4, 6 , 10 },
    { 257, 4, 6 , 10 },
    { 271, 4, 6 , 10 },
    { 285, 4, 6 , 10 },
    { 299, 4, 6 , 10 },
    { 313, 4, 6 , 10 },
    { 327, 4, 6 , 10 },
    { 341, 4, 2 , 6 },
    { 351, 4, 2 , 8 },
    { 361, 4, 7 , 7 },
    { 376, 4, 5 , 3 },
    { 389, 4, 7 , 7 },
    { 404, 4, 6 , 10 },
    { 418, 4, 7 , 12 },
    { 433, 4, 7 , 10 },
    { 448, 4, 7 , 10 },
    { 463, 4, 7 , 10 },
    { 478, 4, 7 , 10 },
    { 493, 4, 7 , 10 },
    { 4, 28, 7 , 10 },
    { 19, 28, 7 , 10 },
    { 34, 28, 7 , 10 },
    { 49, 28, 2 , 10 },
    { 59, 28, 5 , 10 },
    { 72, 28, 7 , 10 },
    { 87, 28, 6 , 10 },
    { 101, 28, 9 , 10 },
    { 118, 28, 7 , 10 },
    { 133, 28, 7 , 10 },
    { 148, 28, 7 , 10 },
    { 163, 28, 7 , 12 },
    { 178, 28, 7 , 10 },
    { 193, 28, 7 , 10 },
    { 208, 28, 6 , 10 },
    { 222, 28, 7 , 10 },
    { 237, 28, 7 , 10 },
    { 252, 28, 8 , 10 },
    { 268, 28, 7 , 10 },
    { 283, 28, 6 , 10 },
    { 297, 28, 7 , 10 },
    { 312, 28, 4 , 12 },
    { 324, 28, 4 , 10 },
    { 336, 28, 4 , 12 },
    { 348, 28, 6 , 3 },
    { 362, 28, 7 , 1 },
    { 377, 28, 4 , 3 },
    { 389, 28, 6 , 7 },
    { 403, 28, 6 , 10 },
    { 417, 28, 6 , 7 },
    { 431, 28, 6 , 10 },
    { 445, 28, 6 , 7 },
    { 459, 28, 4 , 10 },
    { 471, 28, 6 , 9 },
    { 485, 28, 6 , 10 },
    { 499, 28, 2 , 10 },
    { 4, 52, 5 , 12 },
    { 17, 52, 6 , 10 },
    { 31, 52, 3 , 10 },
    { 42, 52, 8 , 7 },
    { 58, 52, 6 , 7 },
    { 72, 52, 6 , 7 },
    { 86, 52, 6 , 9 },
    { 100, 52, 6 , 9 },
    { 114, 52, 5 , 7 },
    { 127, 52, 6 , 7 },
    { 141, 52, 4 , 10 },
    { 153, 52, 6 , 7 },
    { 167, 52, 6 , 7 },
    { 181, 52, 8 , 7 },
    { 197, 52, 6 , 7 },
    { 211, 52, 6 , 9 },
    { 225, 52, 6 , 7 },
    { 239, 52, 5 , 12 },
    { 252, 52, 2 , 12 },
    { 262, 52, 5 , 12 },
    { 275, 52, 7 , 3 },
    { 290, 52, 2 , 9 },
    { 300, 52, 6 , 11 },
    { 314, 52, 7 , 10 },
    { 329, 52, 7 , 9 },
    { 344, 52, 6 , 10 },
    { 358, 52, 7 , 11 },
    { 373, 52, 6 , 12 },
    { 387, 52, 6 , 10 },
    { 401, 52, 7 , 10 },
    { 416, 52, 5 , 5 },
    { 429, 52, 7 , 6 },
    { 444, 52, 6 , 3 },
    { 458, 52, 7 , 10 },
    { 473, 52, 0 , 0 },
    { 481, 52, 4 , 4 },
    { 493, 52, 6 , 7 },
    { 4, 76, 4 , 5 },
    { 16, 76, 4 , 5 },
    { 28, 76, 7 , 11 },
    { 43, 76, 6 , 9 },
    { 57, 76, 7 , 12 },
    { 72, 76, 2 , 2 },
    { 82, 76, 6 , 10 },
    { 96, 76, 3 , 5 },
    { 107, 76, 4 , 5 },
    { 119, 76, 7 , 6 },
    { 134, 76, 9 , 10 },
    { 151, 76, 8 , 7 },
    { 167, 76, 6 , 11 },
    { 181, 76, 6 , 11 },
    { 195, 76, 7 , 11 },
    { 210, 76, 7 , 11 },
    { 225, 76, 7 , 11 },
    { 240, 76, 7 , 11 },
    { 255, 76, 7 , 11 },
    { 270, 76, 7 , 11 },
    { 285, 76, 9 , 10 },
    { 302, 76, 7 , 12 },
    { 317, 76, 7 , 11 },
    { 332, 76, 7 , 11 },
    { 347, 76, 7 , 11 },
    { 362, 76, 7 , 11 },
    { 377, 76, 3 , 11 },
    { 388, 76, 3 , 11 },
    { 399, 76, 5 , 11 },
    { 412, 76, 5 , 11 },
    { 425, 76, 8 , 10 },
    { 441, 76, 7 , 11 },
    { 456, 76, 7 , 11 },
    { 471, 76, 7 , 11 },
    { 486, 76, 7 , 11 },
    { 4, 100, 7 , 11 },
    { 19, 100, 7 , 11 },
    { 34, 100, 7 , 7 },
    { 49, 100, 7 , 13 },
    { 64, 100, 7 , 11 },
    { 79, 100, 7 , 11 },
    { 94, 100, 7 , 11 },
    { 109, 100, 7 , 11 },
    { 124, 100, 6 , 11 },
    { 138, 100, 7 , 10 },
    { 153, 100, 7 , 10 },
    { 168, 100, 6 , 10 },
    { 182, 100, 6 , 10 },
    { 196, 100, 6 , 10 },
    { 210, 100, 6 , 10 },
    { 224, 100, 6 , 10 },
    { 238, 100, 6 , 11 },
    { 252, 100, 8 , 7 },
    { 268, 100, 6 , 9 },
    { 282, 100, 6 , 10 },
    { 296, 100, 6 , 10 },
    { 310, 100, 6 , 10 },
    { 324, 100, 6 , 10 },
    { 338, 100, 3 , 10 },
    { 349, 100, 3 , 10 },
    { 360, 100, 5 , 10 },
    { 373, 100, 5 , 10 },
    { 386, 100, 6 , 10 },
    { 400, 100, 6 , 10 },
    { 414, 100, 6 , 10 },
    { 428, 100, 6 , 10 },
    { 442, 100, 6 , 10 },
    { 456, 100, 6 , 10 },
    { 470, 100, 6 , 10 },
    { 484, 100, 6 , 7 },
    { 4, 124, 7 , 11 },
    { 19, 124, 6 , 10 },
    { 33, 124, 6 , 10 },
    { 47, 124, 6 , 10 },
    { 61, 124, 6 , 10 },
    { 75, 124, 6 , 12 },
    { 89, 124, 6 , 12 },
    { 103, 124, 6 , 12 },
};

// Font glyphs info data
// NOTE: No glyphs.image data provided
static const GlyphInfo sunnyFontGlyphs[189] = {
    { 32, 0, 0, 4, { 0 }},
    { 33, 0, 2, 3, { 0 }},
    { 34, 0, 2, 6, { 0 }},
    { 35, 0, 2, 8, { 0 }},
    { 36, 0, 1, 8, { 0 }},
    { 37, 0, 2, 8, { 0 }},
    { 38, 0, 2, 8, { 0 }},
    { 39, 0, 2, 3, { 0 }},
    { 40, 0, 2, 4, { 0 }},
    { 41, 0, 2, 4, { 0 }},
    { 42, 0, 4, 6, { 0 }},
    { 43, 0, 6, 7, { 0 }},
    { 44, 0, 10, 3, { 0 }},
    { 45, 0, 8, 6, { 0 }},
    { 46, 0, 10, 3, { 0 }},
    { 47, 0, 2, 5, { 0 }},
    { 48, 0, 2, 7, { 0 }},
    { 49, 0, 2, 7, { 0 }},
    { 50, 0, 2, 7, { 0 }},
    { 51, 0, 2, 7, { 0 }},
    { 52, 0, 2, 7, { 0 }},
    { 53, 0, 2, 7, { 0 }},
    { 54, 0, 2, 7, { 0 }},
    { 55, 0, 2, 7, { 0 }},
    { 56, 0, 2, 7, { 0 }},
    { 57, 0, 2, 7, { 0 }},
    { 58, 0, 4, 3, { 0 }},
    { 59, 0, 4, 3, { 0 }},
    { 60, 0, 4, 8, { 0 }},
    { 61, 0, 6, 6, { 0 }},
    { 62, 0, 4, 8, { 0 }},
    { 63, 0, 2, 7, { 0 }},
    { 64, 0, 2, 8, { 0 }},
    { 65, 0, 2, 8, { 0 }},
    { 66, 0, 2, 8, { 0 }},
    { 67, 0, 2, 8, { 0 }},
    { 68, 0, 2, 8, { 0 }},
    { 69, 0, 2, 8, { 0 }},
    { 70, 0, 2, 8, { 0 }},
    { 71, 0, 2, 8, { 0 }},
    { 72, 0, 2, 8, { 0 }},
    { 73, 0, 2, 3, { 0 }},
    { 74, 0, 2, 6, { 0 }},
    { 75, 0, 2, 8, { 0 }},
    { 76, 0, 2, 7, { 0 }},
    { 77, 0, 2, 10, { 0 }},
    { 78, 0, 2, 8, { 0 }},
    { 79, 0, 2, 8, { 0 }},
    { 80, 0, 2, 8, { 0 }},
    { 81, 0, 2, 8, { 0 }},
    { 82, 0, 2, 8, { 0 }},
    { 83, 0, 2, 8, { 0 }},
    { 84, 0, 2, 7, { 0 }},
    { 85, 0, 2, 8, { 0 }},
    { 86, 0, 2, 8, { 0 }},
    { 87, 0, 2, 9, { 0 }},
    { 88, 0, 2, 8, { 0 }},
    { 89, 0, 2, 7, { 0 }},
    { 90, 0, 2, 8, { 0 }},
    { 91, 0, 2, 5, { 0 }},
    { 92, 0, 2, 5, { 0 }},
    { 93, 0, 2, 5, { 0 }},
    { 94, 0, 2, 7, { 0 }},
    { 95, 0, 14, 8, { 0 }},
    { 96, 0, 2, 5, { 0 }},
    { 97, 0, 5, 7, { 0 }},
    { 98, 0, 2, 7, { 0 }},
    { 99, 0, 5, 7, { 0 }},
    { 100, 0, 2, 7, { 0 }},
    { 101, 0, 5, 7, { 0 }},
    { 102, 0, 2, 5, { 0 }},
    { 103, 0, 5, 7, { 0 }},
    { 104, 0, 2, 7, { 0 }},
    { 105, 0, 2, 3, { 0 }},
    { 106, 0, 2, 6, { 0 }},
    { 107, 0, 2, 7, { 0 }},
    { 108, 0, 2, 4, { 0 }},
    { 109, 0, 5, 9, { 0 }},
    { 110, 0, 5, 7, { 0 }},
    { 111, 0, 5, 7, { 0 }},
    { 112, 0, 5, 7, { 0 }},
    { 113, 0, 5, 7, { 0 }},
    { 114, 0, 5, 6, { 0 }},
    { 115, 0, 5, 7, { 0 }},
    { 116, 0, 2, 5, { 0 }},
    { 117, 0, 5, 7, { 0 }},
    { 118, 0, 5, 7, { 0 }},
    { 119, 0, 5, 9, { 0 }},
    { 120, 0, 5, 7, { 0 }},
    { 121, 0, 5, 7, { 0 }},
    { 122, 0, 5, 7, { 0 }},
    { 123, 0, 2, 6, { 0 }},
    { 124, 0, 2, 3, { 0 }},
    { 125, 0, 2, 6, { 0 }},
    { 126, 0, 6, 8, { 0 }},
    { 161, 0, 5, 3, { 0 }},
    { 162, 0, 3, 7, { 0 }},
    { 163, 0, 2, 8, { 0 }},
    { 8364, 0, 3, 8, { 0 }},
    { 165, 0, 2, 7, { 0 }},
    { 352, 0, 1, 8, { 0 }},
    { 167, 0, 2, 7, { 0 }},
    { 353, 0, 2, 7, { 0 }},
    { 169, 0, 2, 8, { 0 }},
    { 170, 0, 2, 6, { 0 }},
    { 171, 0, 6, 8, { 0 }},
    { 172, 0, 7, 7, { 0 }},
    { 174, 0, 2, 8, { 0 }},
    { 175, 0, 0, 0, { 0 }},
    { 176, 0, 2, 5, { 0 }},
    { 177, 0, 4, 7, { 0 }},
    { 178, 0, 2, 5, { 0 }},
    { 179, 0, 2, 5, { 0 }},
    { 381, 0, 1, 8, { 0 }},
    { 181, 0, 5, 7, { 0 }},
    { 182, 0, 2, 8, { 0 }},
    { 183, 0, 6, 3, { 0 }},
    { 382, 0, 2, 7, { 0 }},
    { 185, 0, 2, 4, { 0 }},
    { 186, 0, 2, 5, { 0 }},
    { 187, 0, 6, 8, { 0 }},
    { 338, 0, 2, 10, { 0 }},
    { 339, 0, 5, 9, { 0 }},
    { 376, 0, 1, 7, { 0 }},
    { 191, 0, 3, 7, { 0 }},
    { 192, 0, 1, 8, { 0 }},
    { 193, 0, 1, 8, { 0 }},
    { 194, 0, 1, 8, { 0 }},
    { 195, 0, 1, 8, { 0 }},
    { 196, 0, 1, 8, { 0 }},
    { 197, 0, 1, 8, { 0 }},
    { 198, 0, 2, 10, { 0 }},
    { 199, 0, 2, 8, { 0 }},
    { 200, 0, 1, 8, { 0 }},
    { 201, 0, 1, 8, { 0 }},
    { 202, 0, 1, 8, { 0 }},
    { 203, 0, 1, 8, { 0 }},
    { 204, 0, 1, 4, { 0 }},
    { 205, 0, 1, 4, { 0 }},
    { 206, 0, 1, 6, { 0 }},
    { 207, 0, 1, 6, { 0 }},
    { 208, 0, 2, 9, { 0 }},
    { 209, 0, 1, 8, { 0 }},
    { 210, 0, 1, 8, { 0 }},
    { 211, 0, 1, 8, { 0 }},
    { 212, 0, 1, 8, { 0 }},
    { 213, 0, 1, 8, { 0 }},
    { 214, 0, 1, 8, { 0 }},
    { 215, 0, 5, 8, { 0 }},
    { 216, 0, 1, 8, { 0 }},
    { 217, 0, 1, 8, { 0 }},
    { 218, 0, 1, 8, { 0 }},
    { 219, 0, 1, 8, { 0 }},
    { 220, 0, 1, 8, { 0 }},
    { 221, 0, 1, 7, { 0 }},
    { 222, 0, 2, 8, { 0 }},
    { 223, 0, 2, 8, { 0 }},
    { 224, 0, 2, 7, { 0 }},
    { 225, 0, 2, 7, { 0 }},
    { 226, 0, 2, 7, { 0 }},
    { 227, 0, 2, 7, { 0 }},
    { 228, 0, 2, 7, { 0 }},
    { 229, 0, 1, 7, { 0 }},
    { 230, 0, 5, 9, { 0 }},
    { 231, 0, 5, 7, { 0 }},
    { 232, 0, 2, 7, { 0 }},
    { 233, 0, 2, 7, { 0 }},
    { 234, 0, 2, 7, { 0 }},
    { 235, 0, 2, 7, { 0 }},
    { 236, 0, 2, 4, { 0 }},
    { 237, 0, 2, 4, { 0 }},
    { 238, 0, 2, 6, { 0 }},
    { 239, 0, 2, 6, { 0 }},
    { 240, 0, 2, 7, { 0 }},
    { 241, 0, 2, 7, { 0 }},
    { 242, 0, 2, 7, { 0 }},
    { 243, 0, 2, 7, { 0 }},
    { 244, 0, 2, 7, { 0 }},
    { 245, 0, 2, 7, { 0 }},
    { 246, 0, 2, 7, { 0 }},
    { 247, 0, 4, 7, { 0 }},
    { 248, 0, 3, 8, { 0 }},
    { 249, 0, 2, 7, { 0 }},
    { 250, 0, 2, 7, { 0 }},
    { 251, 0, 2, 7, { 0 }},
    { 252, 0, 2, 7, { 0 }},
    { 253, 0, 2, 7, { 0 }},
    { 254, 0, 2, 7, { 0 }},
    { 255, 0, 2, 7, { 0 }},
};

// Style loading function: Sunny
static void GuiLoadStyleSunny(void)
{
    // Load style properties provided
    // NOTE: Default properties are propagated
    for (int i = 0; i < SUNNY_STYLE_PROPS_COUNT; i++)
    {
        GuiSetStyle(sunnyStyleProps[i].controlId, sunnyStyleProps[i].propertyId, sunnyStyleProps[i].propertyValue);
    }

    // Custom font loading
    // NOTE: Compressed font image data (DEFLATE), it requires DecompressData() function
    int sunnyFontDataSize = 0;
    unsigned char *data = DecompressData(sunnyFontData, SUNNY_STYLE_FONT_ATLAS_COMP_SIZE, &sunnyFontDataSize);
    Image imFont = { data, 512, 256, 1, 2 };

    Font font = { 0 };
    font.baseSize = 16;
    font.glyphCount = 189;

    // Load texture from image
    font.texture = LoadTextureFromImage(imFont);
    UnloadImage(imFont);  // Uncompressed image data can be unloaded from memory

    // Copy char recs data from global fontRecs
    // NOTE: Required to avoid issues if trying to free font
    font.recs = (Rectangle *)RAYGUI_MALLOC(font.glyphCount*sizeof(Rectangle));
    memcpy(font.recs, sunnyFontRecs, font.glyphCount*sizeof(Rectangle));

    // Copy font char info data from global fontChars
    // NOTE: Required to avoid issues if trying to free font
    font.glyphs = (GlyphInfo *)RAYGUI_MALLOC(font.glyphCount*sizeof(GlyphInfo));
    memcpy(font.glyphs, sunnyFontGlyphs, font.glyphCount*sizeof(GlyphInfo));

    GuiSetFont(font);

    // Setup a white rectangle on the font to be used on shapes drawing,
    // it makes possible to draw shapes and text (full UI) in a single draw call
    Rectangle fontWhiteRec = { 510, 254, 1, 1 };
    SetShapesTexture(font.texture, fontWhiteRec);

    //-----------------------------------------------------------------

    // TODO: Custom user style setup: Set specific properties here (if required)
    // i.e. Controls specific BORDER_WIDTH, TEXT_PADDING, TEXT_ALIGNMENT
}
