{- hake: make tool. ruby : rake = haskell : hake
Copyright (C) 2008-2008 Yoshikuni Jujo <PAF01143@nifty.ne.jp>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
-}

module Main where

import System.Environment           (getArgs)
import System.Exit                  (ExitCode(ExitSuccess))
import Development.Hake.HiddenTools (runHake, defaultTrgtStr)
import Paths_hake                   (version)
import Data.Version                 (showVersion)

main :: IO ExitCode
main = do
  args <- getArgs
  case args of
       [ "--version" ] ->
	 putStrLn ("hake " ++ showVersion version) >> return ExitSuccess
       _               ->
	 runHake "Hakefile" "hake" [] (if null args then [defaultTrgtStr] else args)
