#!/bin/sh

# Add user
useradd -m -d /home/hannahci -s /bin/false hannahci

# Give user non-sudo access to docker
gpasswd -a hannahci docker
service docker restart

SCRIPT=$(readlink -f "$0")
SCRIPTPATH=$(dirname "$SCRIPT")

# Add SSH Keys
SSHPATH="/home/hannahci/.ssh"
sudo -u hannahci ssh-keygen
sudo -u hannahci cat "$SSHPATH/id_rsa.pub"
echo "Add the previous line to the list of SSH keys for your git host account."

# Set correct permissions on SSH 
sudo -u hannahci chmod 600 "$SSHPATH/id_rsa" "$SSHPATH/id_rsa.pub"

# Create empty configuration file
touch /etc/hannahci.yaml

# Setup either Upstart or SystemD
command -v lsb_release >/dev/null 2>&1
if [ "$?" = "0" ] && [ $(lsb_release -is) = "Ubuntu" ] && [ $(lsb_release -cs) = "trusty" ]
then
    cp "$SCRIPTPATH/hannahci.conf" /etc/init/hannahci.conf
elif [ -d "/etc/systemd/system" ]
then
    cp "$SCRIPTPATH/hannahci.service" /etc/systemd/system/hannahci.service 
elif [ -d "/run/systemd/system" ]
then
    cp "$SCRIPTPATH/hannahci.service" /run/systemd/system/hannahci.service 
elif [ -d "/usr/lib/systemd/system" ] 
then
    cp "$SCRIPTPATH/hannahci.service" /usr/lib/systemd/system/hannahci.service 
else 
    echo "If you want to run hannahci as a daemon, you must configure it manually!" > /dev/stderr
fi

