-- with gracious thanks to mightybyte:
-- http://softwaresimply.blogspot.com/2008_02_01_archive.html

module Main where
import HAppS.Server
import HAppS.State
import Controller
import Misc
import System.Environment
import Control.Concurrent
import StateVersions.AppState1
import System.Time
import HAppS.Server.Helpers
import Text.StringTemplate.Helpers 

main = do
  args <- getArgs
  case args of
    [port, dynamicTemplateReload', allowStressTests'] -> do
       p <- safeRead port
       allowStressTests <- safeRead allowStressTests'
       dynamicTemplateReload <- safeRead dynamicTemplateReload'
       tDirGroups <- getTemplateGroups
       smartserver (Conf p Nothing) "happs-tutorial"
                                    (controller tDirGroups dynamicTemplateReload allowStressTests)
                                    stateProxy
    otherwise -> putStrLn "usage example: happs-tutorial 5001 True True (starts the app on port 5001, \
                      \templates reload dynamically on every request, allows stress tests)"

runInGhci = do
    putStrLn $ "happs tutorial running in ghci. \n" ++
             "exit :q ghci completely and reenter ghci, before restarting."
    tDirGroups <- getTemplateGroups
    smartserver (Conf 5001 Nothing) "happs-tutorial" (controller tDirGroups True True) stateProxy

stateProxy :: Proxy AppState
stateProxy = Proxy



