<h3>Cookies</h3>

<p>Cookies don't work quite right in HAppS out of the box. The most common problem
   is that google analytics and HAppS session cookies are mutually incompatible.
   (There is a thread about what went wrong in the initial implementation in the happs googlegroup.)

<p>Hopefully the underlying problems will be fixed in the next HAppS hackathon.

<p>Meanwhile, there is a workaround in the HAppSHelpers package on hackage, which is used by happstutorial.
   So cookies do work in happstutorial: I use google analytics to track visitors, 
   along with normal HAppS session cookies.
   And if you use happstutorial as your template for happs apps you should be fine.

<p>The cookie fix is just a couple lines of code in Controller.hs: 

<p>import HAppS.Server.CookieFixer
<br>controller allowStressTests = map cookieFixer \$ ..... 



<p>Besides the cookies used by google analytics, which are obfuscated by javascript, happstutorial
   uses cookies to track session state -- the data that corresponds to the current user's session in
<br>
<br>data AppState = AppState {
<br>  appsessions :: Sessions SessionData,  
<br>  appdatastore :: Users
<br>} deriving (Show,Read,Typeable,Data)


<p>When you log in, a cookie is created that expires in an hour 
   (3600 seconds). And every time a happs handler needs to check if a user is logged in (for example, 
   when it needs to decide whether to show the logged-in-user menubar) a check is made to see if a cookie
   has been set. 

<p>The cookie code is in <a href=/projectroot/src/Misc.hs>ControllerMisc.hs</a>: 

<br>
<br>startsess' getLandingpage (RenderGlobals origRq ts _) user = do
<br>  let sd = SessionData user
<br>  key <- update \$ NewSession sd
<br>  addCookie (3600) (mkCookie "sid" (show key))
<br>  .....
<br>
<br>getMbSessKey rq = runReaderT (readCookieValue "sid") (rqInputs rq,rqCookies rq)

