<h3>Macid migration</h3>

<p>What happens when your data model changes?

<p>People who have been following this tutorial for a while may have noticed that every time I come out with 
   a new version, the existing users and jobs disappear and we start out with a blank slate again.

<p>That's because changing the data schema of a happs-with-macid web app (aka migrating) is a chore.
  
<p>It's a chore with traditional web apps too. But it's probably more difficult with macid, especially
   given the sparse documentation.

<p>This isn't a problem for happstutorial.com, because typically there are only a 
   few dozen users and jobs, plus whatever dummy data I've entered myself. Who cares?
   So far, rather than migrating, I've just wiped the slate clean.

<p>However, that isn't going to work  for your latest facebook-killer.

<p>The good news is, there is a way to migrate HAppS state through various iterations, it's sufficiently
   documented if you know where to look, and it's not too painful once you've gotten used to it.

<p>The main challenge is finding documentation. 

<p>The best documentation I have found is two threads in the happs googlegroup, along with the migration example
   that was produced by eelco lempsink during the thread. I have taken this migration example example and
   included it in the happstutorial distribution, with some improvements of my own.

<p>The googlegroup migration threads are 
   <a href="http://groups.google.com/group/HAppS/browse_thread/thread/c23101b258d337d0/261e3a871853b0e8?">here</a>
   and follow-up <a href="http://groups.google.com/group/HAppS/browse_thread/thread/98e129e6349e4b0b/0e174e9c36edbd72">here</a>.

<p>The migration example I've included with the tutorial is at <a href="/src/migrationexample">migrationexample</a>.

<p>My advice is to try the demo in <a href="/projectroot/src/migrationexample">migrationexample</a> first, 
   following the directions in the <a href ="/projectroot/src/migrationexample/README">README</a> file,  
   read through the source files to understand how the demo works,
   and then refer to the googlegroups thread if necessary.

<p>Possibly this is sufficient documentation for you to start doing migrations yourself. If so, great,
   ignore what follows.

<p>If you feel like you could use more guidance, read on for some notes I put together on my own
   migration experience.

<hr>

<p>Though I haven't started migration for the toy job board in happs-tutorial, I am using it for my 
   commercial project that is under development. This will be the basis of the notes that follow.

<p>I almost didn't include these notes, because I wanted to provide an
   easy step by step example that referenced the toy job board as I have done for other tutorial topics.
   However, doing this will be quite a bit of work, I haven't gotten around to doing this after many weeks.
   I want to get the information out, so I decided to just share what I have. 

<p>I apologize in advance if some of this seems confusing or fragmentary. I did my best, and I will 
   try to clean things up and integrate the example into the tutorial rather than snipping from an external app.

<hr>

<p>Ok... General migration notes:

<p> Old state module names should not change, nor be shifted around in
  directory structure (which is really just another kind of name
  change). Therefore it's a good idea to start out with a sane
  directory hierarchy for schema versions before you start doing
  migrations. I recommend keeping App state in one monolithic file, in
  a directory devoted to state versions. It makes schema migrations
  much easier, as all references to the old state can then be handle
  via import Qualified StateLast.hs as Old, then referenced via
  Old.whatever, when bits of logic that remain consistent between the
  old monolithic state file and the new monolithic state file. Resist
  the temptation to split state into multiple files. Bear in mind that due to template haskell the order of
  data structures declarations becomes significant, which is usually not
  the case with haskell. (I seem to reall this annoyance was part of the
  reason why I started splitting things into multiple files to begin
  with, which I later regretted because it made migration that much harder.)  

<p> Don't call HAppS State "State", as this conflicts with the
  State datatype in Control.Monad.State. I usually call my state
  datatype AppState.

<p> There will be code duplication, for the functions that get
  transformed to state modifiers in template haskell. This is a bad
  code smell, but I think it's unavoidable for the mkMethods directive with 
  all the methods template haskell needs.
  
<p> In the old state file (being migrated from), make sure it exports
  everything via module OldState ( ... everything gets exported here
  ...) where.... My way to do this is load the state module, :browse
  in ghci, copy the output, and clean it up using emacs regexen. In
  emacs, dired-mark-files-regexp and dired-do-query-replace-regexp are
  your friends.

<p> Then, (my way), cd StateVersions, cp AppState1.hs AppState2.hs (or whatever version number we're on.)

<p> Seems almost too obvious to say, but if you have live customer
  you're not going to want to migrate this without having tested the
  migration in a sandbox first. Create your sandbox, which should
  include a snapshot of live customer data. Good way to create a
  snapshot is tar -czvf _local on your live data. Test thoroughly on this 
  snapshot before doing the live migration. And even if you think you've tested enough, 
  tar snapshot your live data before the migration again, just in case.

<hr>

Notes for doing a step by step migration:

<p>Make a live data snapshot and copy it to your migration sandbox: _local.tar.gz. (If there is an unwieldy large 
  amount of data, create a smaller data set by setting up a server identical with the live server and doing some 
  actions manually.)

<p> cd StateVersions; cp AppState1.hs AppState2.hs (or whatever version we're on)
    For now, we just want a placeholder that will have AppState2 behaving exactly like AppState1.
  change references from AppState1.hs to AppState2.hs in app code.
  try running server, the result should be that it compiles, runs, but all data is all lost. (because we haven't written migration yet.)
  
<p>roll back from backup taken earlier: rm -rf _local and tar -xzvf _local.tar.gz (an explicit reminder to 
    rollback the live data tar may be omitted from future steps, but basically you keep rolling back until 
    you get a successful migration.)

<p> modify AppState (or whatever your main State datastructure is), say, adding a field. Don't write a Migrate instance 
    yet. Try running. You'll probably get an error like "Exception: Non-exhaustive patterns in case."
    Kind of a crappy error message if you ask me, but ok. What's happening is the pre-existing data in the 
    _local directory isn't compatible with your modified AppState. If you rm -rf _local and try running again, it should 
    work now. But of course you have lost all your data, and need to rollback the live data again for the next step. 
   
<p> Now make necessary changes in code for migration.   
    See eelco's and my uploads to happs google group (tk happs tutorial). Summary is:
    modify the version instance for AppState and add a migrate instance, allong the following lines. First, 

<p> import qualified StateVersions.AppState1 as Old
<br>    ...
<br>    -- we'll say 2 because this is StateVersions/AppState2.hs
<br>    -- I don't think it matters what number you use as long as it's higher than the last version, 
<br>    -- but I'd like to have a core dev confirm that intuition.
<br>    -- I wonder too what happens if you screw up this version number somehow. EG, what if you specify a version number
<br>    -- identical to the version you're migrating from?
<br>    instance Version AppState where
<br>        mode = extension 2 (Proxy :: Proxy Old.AppState) 

<p>    This won't compile, you'll get an error about a missing (Migrate Old.AppState AppState) 
    instance arising from use of extension. So we supply the instance

<p>	instance Migrate Old.AppState AppState where
<br>	    migrate (Old.AppState s d) = AppState (migrates s) (migrated d)
<br>	migrates s  = undefined
<br>	migrated (us, aus, rs, rus) = undefined

<p>    We use undefined just to get it to compile and have something to darcs commit, and then write sensible code later.
    
<br>*Main> :! grep -irn AppState1 *.hs
<br>Controller.hs:27:import StateVersions.AppState1
<br>ControllerAppMigration.hs:18:import StateVersions.AppState1
<br>......
<br>View.hs:29:import StateVersions.AppState1

<p>These are the places in the code that need to be switched to use AppState2 instead.

<br>Let's test this by adding an emails field to UserInfos
<br>Actually, first let's try adding an email field to Macid1 and see if we get an error.
<br>We do get an error, and it's a weird error:
<br>  *** Exception: src/Macid1/Repos.hs:45:2-24: Non-exhaustive patterns in case
<br>  at \$(deriveSerialize ''Repos) 

<p>Is non-exhaustive pattern because somewhere behind the scenes there has been a macid version bump 
  when it detected that the schema changed?

<p>Dunno, but let's try now by switching state to AppState2.hs
<p>Let's also note the latest checkpoint in the _local directory. It is: ...
<br> ls -lth _local/patch-shack_state/ | head -n2
<br>... checkpoints-0000000014

<p>and back it up: 
<br>  tar -czvf _loacl.beforemigration.tar.gz _local

<p>Step1, cd StateVersions; cp AppState1.hs AppState2.hs. Ok, that works. (Haven't actually used migration machinery yet.)

<p>Now, let's try using the migration machinery, but the migrate is actually just id (so no data structure actually changes).

<p>The following is a snip from a working migration instance, where one field in an interior data structure
has been added. (Specifically, UserProfile has gone from a 3 argument constructor to a 4 argument constructor).

<p>You might think this looks like a lot of boilerplate for adding a single field, and I would agree. The good news
is that your migration code will look similar if you are making more than just that one change, and the problem
is still tractable.

<p>And of course, migrations with a database back-end are no picnic either.

<hr>
<p>Migrate instance example (add a field to UserProfile):

<font color=orange>
<p>instance Migrate Old.AppState AppState where
<br>    migrate (Old.AppState s d) = AppState (migrates s) (migrated d)
<br>
<br>-- Nothing changed in sessions -- it's the second arg to appstate (AppDatastore users) that had a field added
<br>-- We could have avoided writing migrates by using type synonyms to exactly copy the types from AppState1, 
<br>-- as is done in eelco's example.
<br>-- I prefer to write out the migration explicitly rather than use type synonyms, because then after a successful 
<br>-- migration the Migrate instance and the old state code can be removed, and you wind up with just a monolithic
<br>-- state file evolving over time rather than a sequence of states each with a module dependency on the previous state
<br>-- . (I think this is the case -- still have to prove this works.)
<br>migrates :: Old.Sessions Old.SessionData -> Sessions SessionData
<br>migrates (Old.Sessions s)  = Sessions . M.map f \$ s
<br>  where f :: Old.SessionData -> SessionData
<br>        f (Old.UserSession (Old.UserName u) ) = UserSession (UserName u)
<br>        f (Old.AdminSession (Old.AdminUserName u) ) = AdminSession (AdminUserName u)
<br>
<br>migrated (Old.Users us, Old.AdminUsers aus, Old.Repos rs, Old.RepoUsers rus) = 
<br>  ( (Users . M.map ui . M.mapKeys uk \$ us), 
<br>    (AdminUsers . M.map auv . M.mapKeys auk \$ aus),
<br>    (Repos . M.map rv . M.mapKeys rk \$ rs), 
<br>    (RepoUsers . IXS.fromSet . S.map ru . IXS.toSet \$ rus  ) 
<br>   )
<br>  where ui (Old.UserInfos p (Old.UserProfile c bl av ) ) = UserInfos p (UserProfile S.empty c bl av)
<br>        uk (Old.UserName u) = UserName u
<br>        auk (Old.AdminUserName u) = AdminUserName u
<br>        auv (Old.AdminUserInfos p) = AdminUserInfos p
<br>        rv (Old.Repo (Old.UserName u) bud blu isp) = Repo (UserName u) bud blu isp
<br>        rk (Old.RepoName n) = RepoName n
<br>        ru (Old.RepoUser (Old.RepoName n) (Old.UserName u) ) = RepoUser (RepoName n) (UserName u)
</font> 