This is a Haskell library for working with OpenTimestamps. OpenTimestamps is a protocol for creating and verifying timestamps for digital files, which can be used to prove that a file existed at a certain point in time.

The library provides functionality for:

*   **Stamping:** Creating new timestamps for files by submitting their hashes to a network of calendar servers.
*   **Information:** Extracting information from timestamp files.
*   **Pruning:** Pruning existing timestamps.
*   **Upgrading:** Upgrade remote calendar timestamps to be locally verifiable.
*   **Verification:** Verifying the integrity and validity of existing timestamps.

The project has a number of dependencies, including `cryptonite` for cryptographic operations, `http-client` for making requests to calendar servers and `haskoin-code` and `bitcoin-rpc` to make RPC-calls to a locally running 'blocksonly' pruned Bitcoin node, which is required for **Verification**.

Also you will need to have a `libsecp256k1` package (Debian: `libsecp256k1-dev`) installed on your Linux distribution (beware: it needs to be < 0.7.x because of deprecated functions in `0.7.x`).

Notes on tests:
* At least one of the tests requires a running local bitcoin node (pruned node is fine).
