{- | Type definitions for OpenTimestamps.

This module provides type aliases used throughout the OpenTimestamps
library for strict and lazy ByteStrings, ensuring consistent
naming and usage across all modules.
-}
module OpenTimestamps.Types
  ( OTsBytes
  , OTsByteStream
  ) where

import qualified Data.ByteString as BS
import qualified Data.ByteString.Lazy.Char8 as BSL

-- | Strict ByteString used for OpenTimestamps operations.
type OTsBytes = BS.ByteString

-- | Lazy ByteString used for OpenTimestamps streaming operations.
type OTsByteStream = BSL.ByteString
