This is a Haskell client for OpenTimestamps, providing a command-line utility to interact with the OpenTimestamps network. It's on Hackage here: [haskell-opentimestamps-client](https://hackage.haskell.org/package/haskell-opentimestamps-client). The client program allows users to:
*   **Info:** Display information about a timestamp file.
*   **Stamp:** Create OpenTimestamps for files.
*   **Prune:** Prune a timestamp file.
*   **Upgrade:** Upgrade remote calendar timestamps to be locally verifiable.
*   **Verify:** Verify existing OpenTimestamps files.

The client uses the `haskell-opentimestamps` library for core OpenTimestamps stuff.

The project has a number of dependencies, including `cryptonite` for cryptographic operations, `http-client` for making requests to calendar servers and `haskoin-code` and `bitcoin-rpc` to make RPC-calls to a locally running 'blocksonly' pruned Bitcoin node, which is required for **Verification**.

Also you will need to have a `libsecp256k1` package (Debian: `libsecp256k1-dev`) installed on your Linux distribution (beware: it needs to be < 0.7.x because of deprecated functions in `0.7.x`).

To build an executable:

```sh
make release
```

Updating version (development reminder):
- `version: #.#.#.#` in `package.yaml`
- run `hpack` to regenerate the `.cabal` file
- Add the version to `CHANGELOG.md`
- Commit the new version.
- `git tag -a #.#.#.#` to add a git tag
- `git push yourorigin #.#.#.#` to push the git tag

**Work In Progress**...

There is also a Haskell library for working with OpenTimestamps. It's on Hackage here: [haskell-opentimestamps](https://hackage.haskell.org/package/haskell-opentimestamps).
