module Sharing.ByUnit.Encoders.ArraySpec (spec) where

import Hasql.Connection qualified as Connection
import Hasql.Decoders qualified as Decoders
import Hasql.Encoders qualified as Encoders
import Hasql.Session qualified as Session
import Hasql.Statement qualified as Statement
import Helpers.Scripts qualified as Scripts
import Test.Hspec
import Test.QuickCheck
import Test.QuickCheck.Instances ()
import Test.QuickCheck.Monadic (assert, monadicIO, pre, run)
import Prelude hiding (assert)

spec :: SpecWith (Text, Word16)
spec = do
  describe "Array Encoders" do
    describe "1D arrays" do
      it "roundtrips 1D arrays" \config -> property $ \(values :: [Int64]) -> monadicIO $ do
        let statement =
              Statement.preparable
                "select $1"
                (Encoders.param (Encoders.nonNullable (Encoders.array (Encoders.dimension foldl' (Encoders.element (Encoders.nonNullable Encoders.int8))))))
                (Decoders.singleRow (Decoders.column (Decoders.nonNullable (Decoders.array (Decoders.dimension replicateM (Decoders.element (Decoders.nonNullable Decoders.int8)))))))
        result <- run $ Scripts.onPreparableConnection config \connection ->
          Connection.use connection (Session.statement values statement)
        assert $ result == Right values

    describe "2D arrays" do
      it "roundtrips 2D arrays" \config -> property $ \(values :: [Int64]) -> monadicIO $ do
        pre (not (null values))
        let input = replicate 3 values
        let statement =
              Statement.preparable
                "select $1"
                (Encoders.param (Encoders.nonNullable (Encoders.array (Encoders.dimension foldl' (Encoders.dimension foldl' (Encoders.element (Encoders.nonNullable Encoders.int8)))))))
                (Decoders.singleRow (Decoders.column (Decoders.nonNullable (Decoders.array (Decoders.dimension replicateM (Decoders.dimension replicateM (Decoders.element (Decoders.nonNullable Decoders.int8))))))))
        result <- run $ Scripts.onPreparableConnection config \connection ->
          Connection.use connection (Session.statement input statement)
        assert $ result == Right input
