module Hasql.Postgres.PTI where

import Hasql.Postgres.Prelude hiding (bool)
import Database.PostgreSQL.LibPQ (Oid(..))


-- | A Postgresql type info
data PTI = PTI { oidOf :: Oid, arrayOIDOf :: Maybe Oid }

abstime         = PTI (Oid 702)  (Just (Oid 1023))
aclitem         = PTI (Oid 1033) (Just (Oid 1034))
bit             = PTI (Oid 1560) (Just (Oid 1561))
bool            = PTI (Oid 16)   (Just (Oid 1000))
box             = PTI (Oid 603)  (Just (Oid 1020))
bpchar          = PTI (Oid 1042) (Just (Oid 1014))
bytea           = PTI (Oid 17)   (Just (Oid 1001))
char            = PTI (Oid 18)   (Just (Oid 1002))
cid             = PTI (Oid 29)   (Just (Oid 1012))
cidr            = PTI (Oid 650)  (Just (Oid 651))
circle          = PTI (Oid 718)  (Just (Oid 719))
cstring         = PTI (Oid 2275) (Just (Oid 1263))
date            = PTI (Oid 1082) (Just (Oid 1182))
daterange       = PTI (Oid 3912) (Just (Oid 3913))
float4          = PTI (Oid 700)  (Just (Oid 1021))
float8          = PTI (Oid 701)  (Just (Oid 1022))
gtsvector       = PTI (Oid 3642) (Just (Oid 3644))
inet            = PTI (Oid 869)  (Just (Oid 1041))
int2            = PTI (Oid 21)   (Just (Oid 1005))
int2vector      = PTI (Oid 22)   (Just (Oid 1006))
int4            = PTI (Oid 23)   (Just (Oid 1007))
int4range       = PTI (Oid 3904) (Just (Oid 3905))
int8            = PTI (Oid 20)   (Just (Oid 1016))
int8range       = PTI (Oid 3926) (Just (Oid 3927))
interval        = PTI (Oid 1186) (Just (Oid 1187))
json            = PTI (Oid 114)  (Just (Oid 199))
line            = PTI (Oid 628)  (Just (Oid 629))
lseg            = PTI (Oid 601)  (Just (Oid 1018))
macaddr         = PTI (Oid 829)  (Just (Oid 1040))
money           = PTI (Oid 790)  (Just (Oid 791))
name            = PTI (Oid 19)   (Just (Oid 1003))
numeric         = PTI (Oid 1700) (Just (Oid 1231))
numrange        = PTI (Oid 3906) (Just (Oid 3907))
oid             = PTI (Oid 26)   (Just (Oid 1028))
oidvector       = PTI (Oid 30)   (Just (Oid 1013))
path            = PTI (Oid 602)  (Just (Oid 1019))
point           = PTI (Oid 600)  (Just (Oid 1017))
polygon         = PTI (Oid 604)  (Just (Oid 1027))
record          = PTI (Oid 2249) (Just (Oid 2287))
refcursor       = PTI (Oid 1790) (Just (Oid 2201))
regclass        = PTI (Oid 2205) (Just (Oid 2210))
regconfig       = PTI (Oid 3734) (Just (Oid 3735))
regdictionary   = PTI (Oid 3769) (Just (Oid 3770))
regoper         = PTI (Oid 2203) (Just (Oid 2208))
regoperator     = PTI (Oid 2204) (Just (Oid 2209))
regproc         = PTI (Oid 24)   (Just (Oid 1008))
regprocedure    = PTI (Oid 2202) (Just (Oid 2207))
regtype         = PTI (Oid 2206) (Just (Oid 2211))
reltime         = PTI (Oid 703)  (Just (Oid 1024))
text            = PTI (Oid 25)   (Just (Oid 1009))
tid             = PTI (Oid 27)   (Just (Oid 1010))
time            = PTI (Oid 1083) (Just (Oid 1183))
timestamp       = PTI (Oid 1114) (Just (Oid 1115))
timestamptz     = PTI (Oid 1184) (Just (Oid 1185))
timetz          = PTI (Oid 1266) (Just (Oid 1270))
tinterval       = PTI (Oid 704)  (Just (Oid 1025))
tsquery         = PTI (Oid 3615) (Just (Oid 3645))
tsrange         = PTI (Oid 3908) (Just (Oid 3909))
tstzrange       = PTI (Oid 3910) (Just (Oid 3911))
tsvector        = PTI (Oid 3614) (Just (Oid 3643))
txid_snapshot   = PTI (Oid 2970) (Just (Oid 2949))
unknown         = PTI (Oid 705)  Nothing
uuid            = PTI (Oid 2950) (Just (Oid 2951))
varbit          = PTI (Oid 1562) (Just (Oid 1563))
varchar         = PTI (Oid 1043) (Just (Oid 1015))
void            = PTI (Oid 2278) Nothing
xid             = PTI (Oid 28)   (Just (Oid 1011))
xml             = PTI (Oid 142)  (Just (Oid 143))

