module Main (main) where

import System.Environment
import Language.Haskell.Pretty
import System.FilePath
import Language.Haskell.Pretty
import HESQL.Parser (hesqlModule)
import HESQL.Translator
import Control.Monad(when)
import Text.Parsec.String (parseFromFile)
import System.Exit

outputFile file = replaceExtension file ".hs"

main =  do
    putStrLn "hesql 0.0"
    [file, db] <- getArgs
    when (outputFile file == file) $
         error (file ++ "has a wrong extension")
    inp <- readFile file
    mod <- parseFromFile hesqlModule file
    case mod of
      Left err -> do
          print err
          exitWith $ ExitFailure 1
      Right mod' -> do
         outp <- generateCode file db mod'
         writeFile (outputFile file) $
           prettyPrint $
           outp 
         

    

