{-# OPTIONS_GHC -fno-warn-missing-fields #-}
module Params

where 

import System.Console.CmdArgs

defaultParams :: Annotate Ann
defaultParams = record Params{}
             [ numinst       := 1 += name "#" += help "Number of Instances to Generate"
             , numclauses    := 5 += name "c" += name "num-clauses" += help "Number of Clauses to Generate per Instance"
             , csize         := "[0,0,1]" += name "clause-size" += help "Size of a Clause (ie [1,1,1] means same chance for length 1,2 or 3). Default: [0,0,1]"
             , mods          := 1  += help "Number of Modalities"
             , gdepth        := 6  += name "global-depth" += help "Global (maximum) depth"
             , forceDepths   := False += name "force-depths" += help "Force global max depth (ignore max depth per operator)"
             , mdepth        := 2  += name "modal-depth"         += help "Modal Depth"
             , atdepth       := 2  += name "at-depth"            += help "@ Depth"
             , dwdepth       := 0  += name "down-arrow-depth"    += help "Downarrow Depth"
             , umdepth       := 0  += name "univ-mod-depth"      += help "Universal Modality Depth"
             , dumdepth      := 0  += name "diff-univ-mod-depth" += help "Difference Universal Modality Depth"
             , invdepth      := 0  += name "inv-mod-depth"       += help "Inverse Modality Depth"
             , pvars         := 5  += name "prop-vars"   += help "Number of prop vars"
             , nomvars       := 5  += name "nom-vars"    += help "Number of nominals"
             , stvars        := 0  += name "state-vars"  += help "Number of state variables"
             , pmod          := 1  += name "proba-mod"   += help "Probability of a modal operator"
             , pat           := 1  += name "proba-at"    += help "Probability of an @ operator"
             , pdown         := 0  += name "proba-down"  += help "Probability of a downarrow operator"
             , puniv         := 0  += name "proba-univ"  += help "Probability of an univ. modality"
             , pduniv        := 0  += name "proba-diff-univ" += help "Probability of an diff. univ. modality"
             , pinv          := 0  += name "proba-inv"   += help "Probability of an inv. modality"
             , pprop         := 1  += name "proba-prop"  += help "Probability of a proposition"
             , pnom          := 1  += name "proba-nom"   += help "Probability of a nominal"
             , psvar         := 0  += name "proba-state" += help "Probability of a state variable"
             , pneg          := 50 += name "proba-neg"   += help "Probability of a negation"
             , pop           := 50 += name "proba-op"    += help "Probability of an operator"
             , hidesummary   := False += name "H" += name "hide-summary" += help "Hide summary of parameters used"
             , gendefaults   := False += name "gen-defaults" += help "Generate deftab formula (normal default)"
             ]


data Params = Params{
       numinst       ::Int, -- Number of Instances to Generate.
       numclauses    ::Int, -- Number of Clauses to Generate per Instance.
       csize         ::String, -- Size of a Clause. (ie [1,1,1] means same chance for length 1,2 or 3)
       mods          ::Int, -- Number of Modalities.
       gdepth        ::Int, -- Global (maximum) Depth
       forceDepths   ::Bool, -- whether or not to impose strict maximum depths per operator
       mdepth        ::Int, -- Modal Depth.
       atdepth       ::Int, -- @ Depth.
       dwdepth       ::Int, -- Downarrow Depth.
       umdepth       ::Int, -- Universal Modality Depth.
       dumdepth      ::Int, -- Difference Universal Modality Depth.
       invdepth      ::Int, -- Inverse Modality Depth.
       pvars         ::Int, -- Number of prop vars.
       nomvars       ::Int, -- Number of nominals.
       stvars        ::Int, -- Number of state variables.
       pmod          ::Int, -- Probability of a modal operator.
       pat           ::Int, -- Probability of an @ operator
       pdown         ::Int, -- Probability of a downarrow operator
       puniv         ::Int, -- Probability of an universal modality
       pduniv        ::Int, -- Probability of an diff. univ. modality
       pinv          ::Int, -- Probability of an inverse modality
       pprop         ::Int, -- Probability of a proposition
       pnom          ::Int, -- Probability of a nominal
       psvar         ::Int, -- Probability of a state variable
       pneg          ::Int, -- Probability of a negation
       pop           ::Int,  -- Probability of an operator
       hidesummary   ::Bool,  -- Wether to hide or not the summary of parameters used
       gendefaults   ::Bool
   } deriving (Show, Data, Typeable)

