{-# LANGUAGE DataKinds #-}
module Language.Cimple.Analysis.BuiltinMap
    ( builtinMap
    ) where

import           Data.Map.Strict                           (Map)
import qualified Data.Map.Strict                           as Map
import           Data.Text                                 (Text)
import           Language.Cimple.Analysis.Builtins         (builtins)
import           Language.Cimple.Analysis.TypeSystem       (descrToTypeInfo,
                                                            toLocal)
import           Language.Cimple.Analysis.TypeSystem.Types (Phase (..),
                                                            TypeInfo)

builtinMap :: Map Text (TypeInfo 'Local)
builtinMap = Map.map (toLocal 0 Nothing . descrToTypeInfo) builtins
