{-# LANGUAGE StrictData #-}
module Language.Cimple.Hic.Context
    ( Context (..)
    , emptyContext
    ) where

import           Data.Map.Strict                     (Map)
import qualified Data.Map.Strict                     as Map
import           Data.Text                           (Text)
import qualified Language.Cimple                     as C
import           Language.Cimple.Analysis.TypeSystem (TypeSystem)
import           Language.Cimple.Hic.Ast             (HicNode, Node)

data Context = Context
    { ctxEnums         :: Map Text [Text]
    , ctxUnions        :: Map Text [Text]
    , ctxTypedefs      :: Map Text (C.Node (C.Lexeme Text))
    -- | Registry of inferred TaggedUnions.
    -- This is populated by the TaggedUnion feature.
    , ctxTaggedUnions  :: Map Text (HicNode (C.Lexeme Text) (Node (C.Lexeme Text)))
    , ctxTypeSystem    :: TypeSystem
    } deriving (Eq, Show)


emptyContext :: Context
emptyContext = Context Map.empty Map.empty Map.empty Map.empty Map.empty
