{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE StrictData          #-}
module Language.Cimple.Hic.Program.Types
    ( Program (..)
    ) where

import           Data.Bifunctor          (bimap)
import           Data.Fix                (Fix (..), hoistFix)
import           Data.Map.Strict         (Map)
import qualified Data.Map.Strict         as Map
import           Data.Text               (Text)
import qualified Language.Cimple         as C
import           Language.Cimple.Hic.Ast (Node, NodeF (..))

data Program lexeme = Program
    { progAsts        :: Map FilePath [Node lexeme]
    , progDiagnostics :: [Text]
    }

instance Functor Program where
    fmap (f :: a -> b) p = p { progAsts = Map.map (map (hoistFix (bimap f id))) (progAsts p) }
