{-# LANGUAGE OverloadedStrings #-}
module Language.Cimple.Analysis.ErrorMessageSpec (spec) where

import qualified Data.Map.Strict                                   as Map
import           Data.Text                                         (Text)
import qualified Data.Text                                         as T
import           GHC.Stack                                         (HasCallStack)
import           Language.Cimple.Analysis.ArrayUsageAnalysis       (runArrayUsageAnalysis)
import           Language.Cimple.Analysis.CallGraphAnalysis        (CallGraphResult (..),
                                                                    runCallGraphAnalysis)
import           Language.Cimple.Analysis.ConstraintGeneration     (runConstraintGeneration)
import           Language.Cimple.Analysis.Errors                   (ErrorInfo (..))
import           Language.Cimple.Analysis.GlobalStructuralAnalysis (GlobalAnalysisResult (..),
                                                                    runGlobalStructuralAnalysis)
import           Language.Cimple.Analysis.NullabilityAnalysis      (runNullabilityAnalysis)
import           Language.Cimple.Analysis.OrderedSolver            (OrderedSolverResult (..),
                                                                    runOrderedSolver)
import           Language.Cimple.Analysis.Pretty                   (ppErrorInfo,
                                                                    renderPlain)
import qualified Language.Cimple.Analysis.TypeSystem               as TS
import           Language.Cimple.Hic.InferenceSpec                 (mustParse)
import           Test.Hspec

spec :: Spec

spec = describe "Error Message Improvement" $ do
    it "reproducibility of the toxcore memory error" $ do
        prog <- mustParse
            [ "typedef void tox_memory_dealloc_cb(void *_Nonnull self, void *_Owned _Nullable ptr);"
            , "struct Tox_Memory_Funcs {"
            , "    tox_memory_dealloc_cb *_Nonnull dealloc_callback;"
            , "};"
            , "struct Tox_Memory {"
            , "    const struct Tox_Memory_Funcs *_Nonnull funcs;"
            , "    void *_Nullable user_data;"
            , "};"
            , "void tox_memory_dealloc(const struct Tox_Memory *_Nonnull mem, void *_Owned _Nullable ptr)"
            , "{"
            , "    mem->funcs->dealloc_callback(mem->user_data, ptr);"
            , "}"
            , "void tox_memory_free(struct Tox_Memory *_Nullable mem)"
            , "{"
            , "    if (mem == nullptr) {"
            , "        return;"
            , "    }"
            , "    tox_memory_dealloc(mem, mem);"
            , "}"
            ]
        let gar = runGlobalStructuralAnalysis prog
            ts = garTypeSystem gar
            cgr = runCallGraphAnalysis prog
            aua = runArrayUsageAnalysis ts prog
            na = runNullabilityAnalysis prog
            cg = runConstraintGeneration ts aua na prog
            osr = runOrderedSolver ts (cgrSccs cgr) cg
            errors = osrErrors osr
        length errors `shouldSatisfy` (> 0)
