{-# LANGUAGE OverloadedStrings #-}
module Language.Cimple.Hic.Inference.RaiseSpec (spec) where

import           Language.Cimple.Hic.InferenceSpec (checkInference)
import           Test.Hspec                        (Spec, describe)

spec :: Spec
spec = describe "Raise inference" $ do
    checkInference
        [ "int f(int *error) {"
        , "    if (error) {"
        , "        *error = 1;"
        , "        return -1;"
        , "    }"
        , "    return 0;"
        , "}"
        ]
        [ "int f(int* error) {"
        , "  if (error) {"
        , "    raise(*error, 1) return -1;"
        , "  }"
        , ""
        , "  return 0;"
        , "}"
        ]
