{-# LANGUAGE RecordWildCards #-}

module HIndent.Ast.Declaration.Data.Constructor.Field
  ( ConstructorField
  , mkConstructorField
  ) where

import HIndent.Ast.NodeComments
import HIndent.Ast.Type
import HIndent.Ast.WithComments
import qualified HIndent.GhcLibParserWrapper.GHC.Hs as GHC
import {-# SOURCE #-} HIndent.Pretty
import HIndent.Pretty.NodeComments

newtype ConstructorField = ConstructorField
  { ty :: WithComments Type
  }

instance CommentExtraction ConstructorField where
  nodeComments ConstructorField {} = NodeComments [] [] []

instance Pretty ConstructorField where
  pretty' ConstructorField {..} = pretty ty

mkConstructorField ::
     GHC.HsScaled GHC.GhcPs (GHC.LBangType GHC.GhcPs) -> ConstructorField
mkConstructorField (GHC.HsScaled _ bangTy) =
  ConstructorField {ty = mkType <$> fromGenLocated bangTy}
