module HIndent.Ast.Declaration.Data.Deriving.Strategy
  ( DerivingStrategy
  , mkDerivingStrategy
  , isViaStrategy
  ) where

import HIndent.Ast.NodeComments
import HIndent.Ast.Type (Type, mkTypeFromHsSigType)
import HIndent.Ast.WithComments (WithComments, flattenComments, fromGenLocated)
import qualified HIndent.GhcLibParserWrapper.GHC.Hs as GHC
import {-# SOURCE #-} HIndent.Pretty
import HIndent.Pretty.Combinators
import HIndent.Pretty.NodeComments

data DerivingStrategy
  = Stock
  | Anyclass
  | Newtype
  | Via (WithComments Type)

instance CommentExtraction DerivingStrategy where
  nodeComments Stock {} = NodeComments [] [] []
  nodeComments Anyclass {} = NodeComments [] [] []
  nodeComments Newtype {} = NodeComments [] [] []
  nodeComments Via {} = NodeComments [] [] []

instance Pretty DerivingStrategy where
  pretty' Stock = string "stock"
  pretty' Anyclass = string "anyclass"
  pretty' Newtype = string "newtype"
  pretty' (Via x) = string "via " >> pretty x

mkDerivingStrategy :: GHC.DerivStrategy GHC.GhcPs -> DerivingStrategy
mkDerivingStrategy GHC.StockStrategy {} = Stock
mkDerivingStrategy GHC.AnyclassStrategy {} = Anyclass
mkDerivingStrategy GHC.NewtypeStrategy {} = Newtype
mkDerivingStrategy (GHC.ViaStrategy (GHC.XViaStrategyPs _ x)) =
  Via $ flattenComments $ mkTypeFromHsSigType <$> fromGenLocated x

isViaStrategy :: DerivingStrategy -> Bool
isViaStrategy Via {} = True
isViaStrategy _ = False
