import Control.Monad
import qualified Sound.Analysis.Meapsoft as M
import System.Environment
import System.IO

readMaybe :: Read a => String -> Maybe a
readMaybe s = case reads s of
                [(x, "")] -> Just x
                _         -> Nothing

readDef :: (Read a) => a -> String -> a
readDef x s = maybe x id (readMaybe s)

browse :: M.MEAP -> IO ()
browse m = do
  putStr "feature> "
  i <- fmap (readDef 0) getLine
  putStr "frame> "
  j <- fmap (readDef 0) getLine
  let f = M.features m !! i
      l = M.feature_column f
      r = l + M.feature_degree f - 1
  putStrLn (show ( "feature", f))
  putStrLn (show ("chunk", map (\c -> M.position m (j, c)) [l..r]))

main :: IO ()
main = do
  hSetBuffering stdout NoBuffering
  a <- getArgs
  unless (length a == 1) (error "feature-file")
  let [f] = a
  (Right m) <- M.read_meap f
  putStrLn (show ("nframes", M.n_frames m,
                  "nfeatures", length (M.features m)))
  forever (browse m)
