-- Use hmatrix GSL bindings to do basic statistical analysis.

import Control.Monad
import qualified Data.Array.Unboxed as A
import Data.List
import qualified Data.Packed.Matrix as G
import qualified Numeric.Container as G
import qualified Sound.Analysis.Meapsoft as M
import System.Environment

fromArray :: A.UArray (Int, Int) Double -> G.Matrix Double
fromArray m = (r G.>< c) (A.elems m)
    where ((r0,c0),(r1,c1)) = A.bounds m
          r = r1-r0+1
          c = c1-c0+1

main :: IO ()
main =
    do a <- getArgs
       unless (length a == 1)
              (error "feature-file")
       let [fn] = a
       (Right mp) <- M.read_meap fn
       let nf = fromIntegral (M.n_frames mp)
           uf = filter ((== 1) . M.feature_degree) (M.features mp)
           ar = M.uarray_data mp
           m = fromArray ar
           ufc = map M.feature_column uf
           vs = G.toRows (G.extractRows ufc (G.trans m))
           r = zip5 (map M.feature_name uf)
                    (zip (map G.minElement vs)
                         (map G.minIndex vs))
                    (zip (map G.maxElement vs)
                         (map G.maxIndex vs))
                    (zip (map G.absSum vs)
                         (map G.norm2 vs))
                    (map ((/ nf) . G.absSum) vs)
       mapM_ (putStrLn . show) r
