#!/bin/sh

if test $# != 3
then
    echo "extract.sh MEAPsoft.jar audio-file threshold"
    exit 0
fi

if test -f $1
then
  echo "MEAPsoft.jar: " $1
else
  echo "non-existant MEAPsoft.jar: " $1
  exit 1
fi

echo "file to analyse: " $2 $2.seg $2.feat
echo "threshold: " $3

# -t = threshold (0.0 -> 3.0), lower values are more sensitive
# -s = smoothing window (seconds)
# -d = event detector (not beat detector)

if test -f $2.seg
then
    echo "$2.seg exists"
else
    java \
        -cp $1 \
        com.meapsoft.Segmenter \
        -o $2.seg \
        $2 \
        -t $3 \
        -s 0.1 \
        -d
fi

# -Xms = initial heap size
# -Xmx = maximum heap size

java \
    -Xms128m \
    -Xmx512m \
    -cp $1 \
    com.meapsoft.FeatExtractor \
    -f AvgChroma \
    -f AvgChromaScalar \
    -f AvgChunkPower \
    -f AvgFreqSimple \
    -f AvgMelSpec \
    -f AvgMFCC \
    -f AvgPitch \
    -f AvgSpec \
    -f AvgSpecCentroid \
    -f AvgSpecFlatness \
    -f AvgTonalCentroid \
    -f ChunkLength \
    -f ChunkStartTime \
    -f Entropy \
    -f RMSAmplitude \
    -f SpectralStability \
    $2.seg \
    -o $2.feat
