# Revision history for hpc-codecov

## 0.6.3.0 -- 2025-07-25

- Modify the version range of ``time`` package to support 1.14, which
  is shipped with ghc 9.12.

## 0.6.2.0 -- 2024-07-09

- Support searching under the build directory made by
  ``cabal-install`` 3.12.1.0.

## 0.6.1.0 -- 2024-05-29

- Suppress warning messages when compiling with ghc 9.10.

- Modify version range of filepath to support 1.5.x.

## 0.6.0.0 -- 2024-04-26

- Add "--expr-only" option. This option will ignore other constructor
  than 'ExpBox' in 'Trace.Hpc.Mix.BoxLabel' data type when collecting
  'Trace.Hpc.Mix.MixEntry' info.

- Add "--ignore-dittos" option. This option will remove the coverage
  info of repeated occurance of entries with identical start and end
  position.

  As of mix data format generated by ghc 9.4/9.6/9.8, this option
  removes mix entries of record field declarations, type class member
  functions in derived instances (when the member function is more
  than two), and codes generated via TemplateHaskell.

## 0.5.0.0 -- 2023-11-01

- Add Cobertura XML format for the generated report with
  "--format=cobertura" option.

- Modify "readMix'" to fill in the field of Mix values with the
  timestamp in a .mix file instead of a dummy value.

- Drop support for GHC < 8.10.

- Slightly tidy up the help message.

## 0.4.2.0 -- 2023-10-18

- Support GHC 9.8.1.

- Update package dependency version bound for the ``bytestring``
  package.

## 0.4.1.0 -- 2023-09-17

- Update package dependency version bound for the ``hpc`` and
  ``tasty`` packages.

## 0.4.0.0 -- 2023-07-10

Add "--format" option to select the output report format. Add LCOV
tracefile format for generated report.

Modify the generated report to preserve line hit counts.

Add simple ``ByteString`` based parsers for reading ``.mix`` and
``.tix`` files to improve performance.

Remove ``Paths_hpc_codecov`` from exported modules.

## 0.3.0.0 -- 2021-04-02

Modify command-line argument to support TOOL:TEST_SUITE style target,
support searching .tix and .mix files made by cabal-install and
stack. Add options to customize the search for .mix and .tix files
with temporary directories made with cabal-install and stack.

Add new module ``Trace.Hpc.Codecov.Discover``. Rename module
``Trace.Hpc.Codecov.Error`` to ``Trace.Hpc.Codecov.Exception``.
Rename function ``main`` to ``defaultMain`` in
``Trace.Hpc.Codecov.Main``.

## 0.2.0.2 -- 2021-03-25

Minor modification to support GHC 9.0.1.

CI configuration update to manage git repository.

## 0.2.0.1 -- 2021-01-02

Minor package dependency updates.

## 0.1.0.0 -- 2020-02-08

Initial release.
