# Low-level bindings for tree-sitter

This package implements low-level bindings for [tree-sitter](https://tree-sitter.github.io/tree-sitter/),
a widely-supported parser generator tool and an incremental parsing library.

> ⚠️ WARNING:
> You probably don't want to use this package directly, but instead use the high-level bindings implemented by [hs-tree-sitter](https://hackage.haskell.org/package/hs-tree-sitter).

This package is compiled against [tree-sitter](https://github.com/tree-sitter/tree-sitter) version [0.24.3](https://github.com/tree-sitter/tree-sitter/releases/tag/v0.24.3) (2024-10-09).
It is feature complete for version 14 of the tree-sitter ABI and is backwards compatible down to version 13.

All tree-sitter versions up to version [0.25.8](https://github.com/tree-sitter/tree-sitter/releases/tag/v0.25.8) (2025-07-13) are backwards compatible down to version 13, so this package should work with all grammars generated by any version of tree-sitter after [0.19.0](https://github.com/tree-sitter/tree-sitter/releases/tag/v0.19.0) (2021-03-01), though this is untested.
