module Sound.SC3.Plot.Histogram where

import qualified Data.Vector as V {- vector -}
import qualified Statistics.Sample.Histogram as H {- statistics -}

data Histogram x = Histogram [x] [x]

-- | Calculate 'Histogram' for number of bins /n/ and sample data /x/.
histogram :: Int -> [Double] -> Histogram Double
histogram n x =
    let v = V.fromList x
        (l,h) = H.histogram n v
    in Histogram (V.toList l) (V.toList h)
