# hsinstall


## Synopsis

Pack a haskell project into a deployable directory structure


## Description

### OVERVIEW

hsinstall is a tool for installing a Haskell software project into a directory
structure for deployment. It builds upon the `stack install` command and adds
these features:

- Copies the `LICENSE` file into `<PREFIX>/share/<PROJECT-NAME>/doc`
- Copies the contents of a static directory stucture in your project (named
  `hsinstall`) into the destination prefix directory. This can contain
  additional binaries or scripts, resources, documentation, etc. (more on this
  later in TEMPLATE DIRECTORY)
- Optionally builds an AppDir directory structure for the project and produces
  an [AppImage](https://appimage.org/) binary

To use hsinstall, it will be necessary to have the Haskell stack tool on your PATH:
https://docs.haskellstack.org/en/stable/README/

If the AppImage features are desired, you must have these tools on your PATH:
linuxdeploy: https://github.com/linuxdeploy/linuxdeploy/releases,
linuxdeploy-plugin-appimage: https://github.com/linuxdeploy/linuxdeploy-plugin-appimage/releases

Running hsinstall on a project for the first time and with no arguments will produce this in . :

    AppDir/
      usr/
        bin/  <-- All binaries in the project
        share/
          <PROJECT-NAME>/
            doc/
              LICENSE

The -p,--prefix switch allows you to set a prefix other than `AppDir/usr`. This
could be anywhere, like `myproject-2.3` or `/usr/local` or `/opt`

In addition, if an `hsinstall` directory exists, its contents will be copied
into the prefix before build and install. See TEMPLATE DIRECTORY below for more
info on this.

### APPIMAGE CREATION

The -i,--mk-appimage switch will change the default prefix to `EXE.AppDir/usr`
and only the specified EXE will be installed into `<PREFIX>/bin`, AppImages are
intended to be made for exactly one binary.

If .desktop and .svg files are not found in the hsinstall directory, defaults
will be created for you and placed in the correct subdirs. Check these files
into source control for future builds.

The default `.desktop` file Categories will be populated with 'Utility;'. We
recommend adjusting this using the XDG list of registered categories:
https://specifications.freedesktop.org/menu-spec/latest/apa.html

If your application is a command-line program, append a line containing this to
the end of the default `.desktop` file: 'Terminal=true'

If your application isn't a command-line program, we recommend using a proper
icon instead of the hsinstall default, which is a command shell icon.

For more info on AppImage: https://appimage.org/

### TEMPLATE DIRECTORY

If present, hsinstall will copy the contents of the `hsinstall` template
directory into `<PREFIX>`. Here's an explanation of the hsinstall directory
contents:

    hsinstall/
      bin/  <-- Put additional binaries and scripts to be deployed here
      share/
        applications/  <-- Only for AppImage
          <EXE>.desktop  <-- Will be generated by first-time AppImage creation attempt
        <PROJECT-NAME>/  <-- Only needed if you have resources
          resources/  <-- Put data files your software will need at runtime here
        icons/  <-- Only for AppImage
          hicolor/
            scalable/
              apps/
                <EXE>.svg  <-- Will be generated by first-time AppImage creation attempt

In order to locate data files at runtime, including resources, the hsinstall
project includes a library to construct the share path relative to the
executable. See [this source code](https://github.com/dino-/hsinstall/blob/master/src/lib/HSInstall/Paths.hs)
for help with integrating this into your app.


## Development

Browse [the source](https://github.com/dino-/hsinstall)

Get source with git and build

    $ git clone https://github.com/dino-/hsinstall.git
    $ cd hsinstall
    $ stack build
    $ stack haddock --no-haddock-deps hsinstall

If you have the abovementioned `linuxdeploy-*` programs on your path, we can do
something *really* cool. Use this freshly-built hsinstall to package itself
into an AppImage:

    $ stack exec hsinstall -- --mk-appimage hsinstall

And you should see an `hsinstall-y.z-x86_64.AppImage` binary in `.`

Tip: Use `git clean -df` to blow away untracked things like the AppDir and
AppImage artifacts.


## Contact

### Authors

Dino Morelli <dino@ui3.info>
