#ifndef HASKELL_MODEL_H
#define HASKELL_MODEL_H

#include "interface.h"

#include <QtCore/QAbstractTableModel>

#include <vector>

struct HaskellModelDelegate {
  HaskellModelCallbacks* callbacks;
  QHash<int,QByteArray> roles;
};

class HaskellModel : public QAbstractTableModel {
    Q_OBJECT
    Q_PROPERTY(int delegate READ delegate WRITE setDelegate)
  public:
    HaskellModel(QObject* parent = 0);
    ~HaskellModel();

    int rowCount(const QModelIndex &) const;
    int columnCount(const QModelIndex &) const;
    QVariant data(const QModelIndex &, int) const; 
    QVariant headerData(int, Qt::Orientation, int);

    int delegate() const;
    void setDelegate(int);
    int instance();

    QHash<int,QByteArray> roleNames() const;

    Q_INVOKABLE QModelIndex refresh() {
      emit dataChanged(index(0,0), index(rowCount(QModelIndex())-1, columnCount(QModelIndex())-1));
    };

  private:
    int32_t delegateHandle;

 /* static */
  public:
    static HaskellModelDelegateHandle registerDelegate();
    static void unregisterDelegate(HaskellModelDelegateHandle);
    static void setCallbacks(HaskellModelDelegateHandle, HaskellModelCallbacks*);
    static void addRole(HaskellModelDelegateHandle, int, char*);

  private:
    static std::vector<HaskellModelDelegate> delegates;
};

#endif

