#include "interface.h"
#include "HaskellModel.h"

#include <cstdio>

#include <QtQml/QtQml>
#include <string>
#include <sstream>

void registerHaskellModel() {
  qmlRegisterType<HaskellModel> ("HsQML.HaskellModel", 1, 0, "HaskellModel");
} 

HaskellModelDelegateHandle registerHaskellModelDelegate() {
  return HaskellModel::registerDelegate();
}

void unregisterHaskellModelDelegate(HaskellModelDelegateHandle hndl) {
  HaskellModel::unregisterDelegate(hndl);
}

void setHaskellModelCallbacks(HaskellModelDelegateHandle hndl, HaskellModelCallbacks* cbs) {
  HaskellModel::setCallbacks(hndl, cbs);
}

void addHaskellModelRole(HaskellModelDelegateHandle hndl, int key, char* value) {
  HaskellModel::addRole(hndl, key, value);
}

QtVariant newQtInt(int v) {
  return reinterpret_cast<QtVariant>(new QVariant(v));
}

QtVariant newQtDouble(double v) {
  return reinterpret_cast<QtVariant>(new QVariant(v));
} 

QtVariant newQtText(char* v) {
  return reinterpret_cast<QtVariant>(new QVariant(v));
} 

QtVariant newQtBool(int v) {
  return reinterpret_cast<QtVariant>(new QVariant((bool)v));
}

QtVariant newQtNull() {
  return reinterpret_cast<QtVariant>(new QVariant());
}

