#ifndef HASKELL_MODEL_INTERFACE_H
#define HASKELL_MODEL_INTERFACE_H

#include <stdint.h>

#include <QtCore/QHash>

#include "types.h"

#ifdef __cplusplus
extern "C" {
#endif

void registerHaskellModel();

HaskellModelDelegateHandle registerHaskellModelDelegate();
void unregisterHaskellModelDelegate(HaskellModelDelegateHandle);

void setHaskellModelCallbacks(HaskellModelDelegateHandle, HaskellModelCallbacks*);
void addHaskellModelRole(HaskellModelDelegateHandle, int, char*);

QtVariant newQtInt(int);
QtVariant newQtDouble(double);
QtVariant newQtText(char*);
QtVariant newQtBool(int);
QtVariant newQtNull();

#ifdef __cplusplus
}
#endif

#endif // HASKELL_MODEL_INTERFACE_H
