module Graphics.QML.DataModel.Internal.Types where

import qualified Graphics.QML.DataModel.Internal.FFI.Types as FFI

import Control.Concurrent.MVar
import Foreign.Ptr

-- |A data model handle.
data DataModel a = DataModel
  { callbacks :: MVar (Ptr FFI.HmCallbacks) -- ^Pointer to a C structure storing the callbacks.
  , delegate  :: FFI.HmDelegateHandle       -- ^Identifier of the handle.
  }

-- |Used by QML to query the number of rows in a model.
type RowCountCallback    = IO Int
-- |Used by QML to query the number of columns in a model.
type ColumnCountCallback = IO Int
-- |Used by QML to obtain a row at the given index.
type DataCallback a      = Int -> IO a
-- |Used by QML to obtain the name of the column at the given index.
type HeaderDataCallback  = Int -> IO String

