{-# LANGUAGE TemplateHaskell #-}

module Graphics.QML.DataModel.TH 
 ( dataModelInstances
 , module Graphics.QML.DataModel.Generic
 ) where

import Language.Haskell.TH
import Graphics.QML.DataModel.Generic

dataModelInstances :: Name -> DecsQ
{-^ 
A shorthand to declare all instances necessary for setting up the HaskellModel.

@dataModelInstances T@ is equivalent to

@
 instance QtTable      T
 instance Mock         T
 instance CountFields  T
 instance SetupColumns T
@

-}
dataModelInstances name = 
   [d| instance QtTable      $t; 
       instance Mock         $t;
       instance CountFields  $t;
       instance SetupColumns $t;
   |] 
 where t = conT name

