module Data.HttpSpec.EncodingHelper (encodingName, xmlEncoding, encodingFromContentType) where

import Data.String.Utils (strip)
import Text.XML.HXT.Helper (xmlEncoding)
import Data.Encoding (DynEncoding, encodingFromStringExplicit)

encodingName :: Show enc => enc -> String
encodingName enc =
    case show enc of
      "UTF8" -> "UTF-8"
      "UTF16" -> "UTF-16"
      "UTF32" -> "UTF-32"
      "ISO88591" -> "ISO-8859-1"
      "ISO88592" -> "ISO-8859-2"
      "ISO88593" -> "ISO-8859-3"
      "ISO88594" -> "ISO-8859-4"
      "ISO88595" -> "ISO-8859-5"
      "ISO88596" -> "ISO-8859-6"
      "ISO88597" -> "ISO-8859-7"
      "ISO88598" -> "ISO-8859-8"
      "ISO88599" -> "ISO-8859-9"
      "ISO885910" -> "ISO-8859-10"
      "ISO885911" -> "ISO-8859-11"
      "ISO885913" -> "ISO-8859-13"
      "ISO885914" -> "ISO-8859-14"
      "ISO885915" -> "ISO-8859-15"
      "ISO885916" -> "ISO-8859-16"
      "CP1250" -> "WINDOWS-1250"
      "CP1251" -> "WINDOWS-1251"
      "CP1252" -> "WINDOWS-1252"
      "CP1253" -> "WINDOWS-1253"
      "CP1254" -> "WINDOWS-1254"
      "CP1255" -> "WINDOWS-1255"
      "CP1256" -> "WINDOWS-1256"
      "CP1257" -> "WINDOWS-1257"
      "CP1258" -> "WINDOWS-1258"
      _ -> "unknown"

encodingFromContentType :: String -> Maybe DynEncoding
encodingFromContentType s =
    let enc = (drop 1 . dropWhile (/='=') . strip . drop 1 . dropWhile (/= ';')) s
    in encodingFromStringExplicit enc
