-- | Module    :  Data.Vector.InfBackpropExtra
-- Copyright   :  (C) 2025 Alexey Tochin
-- License     :  BSD3 (see the file LICENSE)
-- Maintainer  :  Alexey Tochin <Alexey.Tochin@gmail.com>
--
-- | Module providing all functionality of the library.
-- It re-exports all important types and functions from submodules.
-- See the documentation of individual submodules for details.
module Numeric.InfBackprop
  ( -- * Common

    -- ** Base
    Tangent,
    Dual,
    Cotangent,
    CT,
    RevDiff (MkRevDiff, value, backprop),
    RevDiff',
    DifferentiableFunc,
    initDiff,
    call,
    derivativeOp,
    constDiff,
    scalarArg,
    scalarVal,
    autoArg,
    autoVal,
    stopDiff,
    simpleDifferentiableFunc,

    -- ** Relation to lens and profunctors
    toLensOps,
    toLens,
    fromLens,
    fromProfunctors,
    toProfunctors,
    fromVanLaarhoven,
    toVanLaarhoven,

    -- ** Derivative operators
    scalarArgDerivative,
    customArgDerivative,
    customValDerivative,
    scalarValDerivative,
    simpleDerivative,
    simpleValueAndDerivative,
    customArgValDerivative,

    -- * Differentiable types

    -- ** Tuple
    twoArgsDerivative,
    twoArgsDerivativeOverX,
    twoArgsDerivativeOverY,
    tupleDerivativeOverX,
    tupleDerivativeOverY,
    mkTupleArg,
    tupleArg,
    tupleArgDerivative,
    mkTupleVal,
    tupleVal,
    tupleValDerivative,

    -- ** Triple
    threeArgsToTriple,
    threeArgsDerivative,
    derivative3ArgsOverX,
    derivative3ArgsOverY,
    derivative3ArgsOverZ,
    tripleDerivativeOverX,
    tripleDerivativeOverY,
    tripleDerivativeOverZ,
    mkTripleArg,
    tripleArg,
    tripleArgDerivative,
    mkTripleVal,
    tripleVal,
    tripleValDerivative,

    -- ** Boxed Vector
    mkBoxedVectorArg,
    boxedVectorArg,
    boxedVectorArgDerivative,
    mkBoxedVectorVal,
    boxedVectorVal,
    boxedVectorValDerivative,

    -- ** Stream
    mkStreamArg,
    streamArg,
    streamArgDerivative,
    mkStreamVal,
    streamVal,
    streamValDerivative,

    -- ** FiniteSupportStream
    mkFiniteSupportStreamArg,
    finiteSupportStreamArg,
    finiteSupportStreamArgDerivative,
    mkFiniteSupportStreamVal,
    finiteSupportStreamVal,
    finiteSupportStreamValDerivative,

    -- ** Maybe
    maybeArg,
    mkMaybeArg,
    maybeArgDerivative,
    maybeVal,
    mkMaybeVal,
    maybeValDerivative,
  )
where

import Numeric.InfBackprop.Core
  ( CT,
    Cotangent,
    DifferentiableFunc,
    Dual,
    RevDiff (MkRevDiff, backprop, value),
    RevDiff',
    Tangent,
    autoArg,
    autoVal,
    boxedVectorArg,
    boxedVectorArgDerivative,
    boxedVectorVal,
    boxedVectorValDerivative,
    call,
    constDiff,
    customArgDerivative,
    customArgValDerivative,
    customValDerivative,
    derivative3ArgsOverX,
    derivative3ArgsOverY,
    derivative3ArgsOverZ,
    derivativeOp,
    finiteSupportStreamArg,
    finiteSupportStreamArgDerivative,
    finiteSupportStreamVal,
    finiteSupportStreamValDerivative,
    fromLens,
    fromProfunctors,
    fromVanLaarhoven,
    initDiff,
    maybeArg,
    maybeArgDerivative,
    maybeVal,
    maybeValDerivative,
    mkBoxedVectorArg,
    mkBoxedVectorVal,
    mkFiniteSupportStreamArg,
    mkFiniteSupportStreamVal,
    mkMaybeArg,
    mkMaybeVal,
    mkStreamArg,
    mkStreamVal,
    mkTripleArg,
    mkTripleVal,
    mkTupleArg,
    mkTupleVal,
    scalarArg,
    scalarArgDerivative,
    scalarVal,
    scalarValDerivative,
    simpleDerivative,
    simpleDifferentiableFunc,
    simpleValueAndDerivative,
    stopDiff,
    streamArg,
    streamArgDerivative,
    streamVal,
    streamValDerivative,
    threeArgsDerivative,
    threeArgsToTriple,
    toLens,
    toLensOps,
    toProfunctors,
    toVanLaarhoven,
    tripleArg,
    tripleArgDerivative,
    tripleDerivativeOverX,
    tripleDerivativeOverY,
    tripleDerivativeOverZ,
    tripleVal,
    tripleValDerivative,
    tupleArg,
    tupleArgDerivative,
    tupleDerivativeOverX,
    tupleDerivativeOverY,
    tupleVal,
    tupleValDerivative,
    twoArgsDerivative,
    twoArgsDerivativeOverX,
    twoArgsDerivativeOverY,
  )
