{-# LANGUAGE TemplateHaskell, QuasiQuotes, TypeFamilies, ViewPatterns, OverloadedStrings #-}

module Web.Informative.Data where

import Data.Text
import Yesod

data Informative = Informative { getSegment :: Text, getPrefix :: Text }

mkYesodSubData "Informative" [parseRoutes|
 /article/#Text ArticleR GET
 /articleid/#Text ArticleIdR GET
 /edit/#Text EditR GET POST
 /insert/#Text InsertR GET POST
 /prepend/#Text PrependR GET POST
 /down/#Text DownR POST
 /up/#Text UpR POST
 /delete/#Text DeleteR POST
 /create/#Text CreateR GET POST
|]

data TextFormat = Markdown | MediaWiki | ReStructuredText | LaTeX | Textile | Source Text Int | Plain deriving (Eq,Ord,Show,Read)
derivePersistField "TextFormat"

data TextKind = Article | Table | Mapping | Hint | Error deriving (Eq, Ord, Show, Read, Enum, Bounded)
derivePersistField "TextKind"
