module Integer
  ( -- ** Types
    Integer,
    Natural,
    Positive,
    Signed (Zero, NonZero, Minus, Plus),
    Sign (MinusSign, PlusSign),

    -- ** Addition
    Increase (increase),
    StrictlyIncrease (strictlyIncrease),

    -- ** Subtraction
    Subtraction (subtractInteger, subtractSigned),
    Subtraction' (subtract),

    -- ** Conversion
    IntegerNarrow (narrow),
    IntegerConvert (convert),
    IntegerEquiv,
    yolo,
    ConvertWithFinite (toInt, fromInt, toWord, fromWord),
    Finite (..),

    -- ** Lower bound
    BoundedBelow (minBound),
  )
where

import Integer.BoundedBelow (BoundedBelow (minBound))
import Integer.Conversion
  ( IntegerConvert (convert),
    IntegerEquiv,
    IntegerNarrow (narrow),
    yolo,
  )
import Integer.Finite
  ( ConvertWithFinite (fromInt, fromWord, toInt, toWord),
    Finite (..),
  )
import Integer.Increase (Increase (increase))
import Integer.Integer (Integer)
import Integer.Natural (Natural)
import Integer.Positive (Positive)
import Integer.Sign (Sign (MinusSign, PlusSign))
import Integer.Signed (Signed (Minus, NonZero, Plus, Zero))
import Integer.StrictlyIncrease (StrictlyIncrease (strictlyIncrease))
import Integer.Subtraction
  ( Subtraction (subtractInteger, subtractSigned),
    Subtraction' (subtract),
  )
