# Revision history for interval-patterns

## 0.3.0.0 - 2022-06-08

* new pattern synonym `(:---:) :: (Ord x) => Levitated x -> Levitated x -> Interval x`
  * only works as a pattern; cannot be used as an expression
  * disregards the open/closedness of the boundary
* fix `openclosed` and `closedopen`
* rename `imapS -> imapLev` and `itraverseS -> itraverseLev` following `Suspension -> Levitated`
* `(...)` as a value-level analogue to `interval`
* `Data.Interval.isSubsetOf`
* `Data.Interval.Borel.isSubsetOf`
* `Data.Interval.Layers.difference`
* `Data.Interval.Layers.clip`
* `Data.Interval.Layers.toStepFunction`
* `Data.Calendar.happeningAt`

## 0.2.0.1 - 2022-05-30

* export `clip` from `Data.Interval.Borel`

## 0.2.0.0 - 2022-05-30

* generalize `Layers` to arbitrary `Num` types and `Calendar` to arbitrary `Real` types

## 0.1.0.0 - 2022-05-19

* constructors behave more intuitively
  * if the endpoints are equal, it becomes a closed interval
  * when endpoints are reversed, using a smart constructor preserves the declared endpoint boundaries
    (e.g. `6 :|>: 4` becomes `4 :<|: 6`)
* tests

## 0.0.11.0 - 2022-03-08

* drop `Data.Suspension` entirely in favour of `Algebra.Lattice.Levitated`
* rename `Data.Interval.{Set => Borel}` and add Lattice/Ring/Heyting instances
* explicit exports for `Data.OneOrTwo`

## 0.0.10.2 -- 2022-02-22

* fix `Enum` for `Suspension`

## 0.0.10.1 -- 2022-02-15

* add `Layers.remove` and `Layers.baseline`

## 0.0.10.0 -- 2022-02-15

* add dependency `group-theory`
* `instance Monoid Suspension` now lifts monoids only
* add `instance Group x => Group (Suspension x)`
* `Data.Interval.unions` now sorts the list first; add `unionsAsc`
* `Covering.unionsSet` uses `from/toAscList` and `unionsAsc`
* `instance Group y => Group (Layers x y)`
* `instance Functor Layers`
* `nesting` now sorts the list first; add `nestingAsc`
* `Semigroup Layers` uses `nestingAsc`

## 0.0.9.0 -- 2022-02-15

* `Layers` is now a two-parameter type, and `nestings` supports arbitrary
  semigroups instead of the previous restriction to `Int`.
* drop `multiset` dependency as a result
* `type Event = Layers UTCTime (Sum Int)`

## 0.0.8.0 -- 2022-02-15

* switch definitions of `lower` and `lowerBound`, `upper` and `upperBound`
* universal `Bounded` and lifted `Enum` for Suspension
* `(Data.Interval.\\)`
* change names from `IntervalSet -> Covering` and `IntervalLayer -> Layers`
* rename `Covering.intervals` to `Covering.covering` ("smart constructor")

## 0.0.7.1 -- 2022-02-13

* `imapS` and `itraverseS`

## 0.0.7.0 -- 2022-02-13

* introduce strictness annotations for `Suspension`, `Interval`, and `Adjacency`

## 0.0.6.1 -- 2022-02-13

* fix `Num` instance for `Suspension`

## 0.0.6.0 -- 2022-02-13

* remove `AdjacencyRepr` (don't need a type parameter you're just gonna hide)
* amalgamate `split` into `adjacency`
* no need for weird import chain, define everything in `Data.Interval`

## 0.0.5.0 -- 2022-02-12

* `Data.Interval.Layered` provides a monoid like `IntervalSet`, but
  that will keep track of the number of times a particular interval
  has been added to the structure. This is useful for determining, e.g.,
  how many clones you need to attend all today's meetings on time.

## 0.0.4.0 -- 2022-02-12

* Rename project

# Revision history for timeframes

## 0.0.3.0 -- 2022-02-12

* Drop `orient`, putting `Ord` constraints on the constructors of `Interval`
  and leaving the ordering to the smart constructors
* Rewrite `intersection`, `union`, and `difference` using `split`
* Settle on changelog format
* move `withBounds` to `Data.Interval`

## 0.0.2.0 -- 2022-02-12

* Drop `UpToThree` in favour of a more dependently-typed model of adjacency
* `Overlap` is changed to `Adjacency` where it occurs
* `split` now returns `SomeAdjacency`, which can be pattern-matched to yield
  the exact (one, two, or three) intervals into which the two have been cleaved
* `Interval` moved into `Data.Interval.Types` to avoid a cyclic dependency
  between `Data.Interval` and `Data.Interval.Adjacency`

## 0.0.1.0 -- 2022-02-08

Types and functions for working with intervals and their monoid under union.

* `Data.Suspension` provides the two-point extension of a type,
  used for marking the endpoints of intervals.
* `Data.Interval` defines the `Interval` type, along with type- and value-level
  structures for working with closed and open endpoints.
* `overlap` calculates the relationship between intervals
  according to Allen`s interval algebra.
* `split` separates two intervals into one, two, or three parts,
  depending on their overlap.
