{-# LANGUAGE OverloadedStrings #-}
{-# LANGUAGE QuasiQuotes #-}

module Metrics1024
  ( encodedMetrics1024
  , byteStringMetrics1024
  ) where

import Data.ByteString (ByteString)
import Data.ByteString.Short (ShortByteString, toShort)
import Data.Primitive (ByteArray)
import Data.Text.Encoding (encodeUtf8)
import NeatInterpolation (text)

import qualified Data.ByteString.Short.Internal as BSS
import qualified Data.Primitive as PM

shortByteStringToByteArray :: ShortByteString -> ByteArray
shortByteStringToByteArray (BSS.SBS x) = PM.ByteArray x

encodedMetrics1024 :: ByteArray
encodedMetrics1024 =
  shortByteStringToByteArray (toShort byteStringMetrics1024)

byteStringMetrics1024 :: ByteString
byteStringMetrics1024 =
  encodeUtf8
    [text|
    [ {"@id":"1E7nJ7Ki1ei1mSOuy","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.43","host.ip":"192.0.2.43","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT4215"}
    , {"@id":"1E7nJ7SponsUYpH9l","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.43","host.ip":"192.0.2.43","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT4215"}
    , {"@id":"1E7nJ7VyTvxK5KDVi","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.43","host.ip":"192.0.2.43","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT4215"}
    , {"@id":"1E7nJ7UY8jQQ4ekbH","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.43","host.ip":"192.0.2.43","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT4215"}
    , {"@id":"1F6PYPiHQPtis7k6O","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.43","host.ip":"192.0.2.43","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan1","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4215"}
    , {"@id":"1F6PYPqPDZ4BeUcLB","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.43","host.ip":"192.0.2.43","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4215"}
    , {"@id":"1F6PYPtXsh91AzYh8","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.43","host.ip":"192.0.2.43","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":25912,"host.interface.egress.bits_per_second":279,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":25633,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether1","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT4215"}
    , {"@id":"1F6PYPs7XUc7AK5mh","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.43","host.ip":"192.0.2.43","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4215"}
    , {"@id":"1F6PYPs6L6e1jC3J2","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"5","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.43","host.ip":"192.0.2.43","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether3","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4215"}
    , {"@id":"1F6PYPsIykHqbaGN3","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"6","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.43","host.ip":"192.0.2.43","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether4","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4215"}
    , {"@id":"1F6PYPhSck6OFqusQ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"7","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.43","host.ip":"192.0.2.43","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether5","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4215"}
    , {"@id":"1F6PYPsTDyanDtINP","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"8","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.43","host.ip":"192.0.2.43","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":17945,"host.interface.egress.bits_per_second":243,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":17701,"host.interface.ingress.errors_per_second":0,"host.interface.name":"bridge","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT4215"}
    , {"@id":"1F6PYPiDLZSF2zpm0","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"9","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.43","host.ip":"192.0.2.43","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1521,"host.interface.egress.bits_per_second":239,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan801-mgmt","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT4215"}
    , {"@id":"1F6PYPzpH393PPCXh","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"10","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.43","host.ip":"192.0.2.43","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":14900,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":14900,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan802-inet","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT4215"}
    , {"@id":"OqfkPg30OpRItoN2","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"65536","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.43","host.ip":"192.0.2.43","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.memory.utilization":21,"component.name":"main memory","storage.bytes":58650624,"storage.name":"main memory","storage.type":"ram","storage.utilization":21,"host.hostname":"NYC-S75-APT4215"}
    , {"@id":"OqfkPSgRxJr8251N","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"131072","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.43","host.ip":"192.0.2.43","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","storage.bytes":39981056,"storage.name":"system disk","storage.type":"fixedDisk","storage.utilization":29,"host.hostname":"NYC-S75-APT4215"}
    , {"@id":"hnKbjUEfr0WWIVy7","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","component.name":"unknown","host.address":"192.0.2.43","host.ip":"192.0.2.43","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4215"}
    , {"@id":"NhMhMLtBS4ISALZ2","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.241","host.ip":"172.28.2.241","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3209"}
    , {"@id":"Y2ukaYQmBqm8UEmO","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.241","host.ip":"172.28.2.241","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3209"}
    , {"@id":"FIB4gtGYv740SCC8","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.241","host.ip":"172.28.2.241","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3209"}
    , {"@id":"mDNGVZ4FfRdQpMLg","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.241","host.ip":"172.28.2.241","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3209"}
    , {"@id":"FA53G6sUZHFfXoie","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.241","host.ip":"172.28.2.241","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3209"}
    , {"@id":"ucT45CEI2GxG2G0m","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.241","host.ip":"172.28.2.241","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3209"}
    , {"@id":"ztQ33kFR2HvIIsxk","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.241","host.ip":"172.28.2.241","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3209"}
    , {"@id":"17Mxg1IfiKR5gGcPQ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.241","host.ip":"172.28.2.241","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3209"}
    , {"@id":"1E7nJ7aMnpwbdeDE9","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.241","host.ip":"172.28.2.241","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT3209"}
    , {"@id":"1E7nJ7N5llVqsHBJq","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.241","host.ip":"172.28.2.241","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT3209"}
    , {"@id":"1E7nJ7TwyCYr6uIRv","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.241","host.ip":"172.28.2.241","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT3209"}
    , {"@id":"1E7nJ7KG1iNiIdJXw","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.241","host.ip":"172.28.2.241","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT3209"}
    , {"@id":"1F6PYPxwCb8IjJYPZ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.241","host.ip":"172.28.2.241","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan1","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3209"}
    , {"@id":"1F6PYPkfAWhXxwWVG","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.241","host.ip":"172.28.2.241","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3209"}
    , {"@id":"1F6PYPrWMxkYCZddL","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.241","host.ip":"172.28.2.241","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":25930,"host.interface.egress.bits_per_second":279,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":25650,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether1","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3209"}
    , {"@id":"1F6PYPhpQTZPOIejM","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.241","host.ip":"172.28.2.241","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3209"}
    , {"@id":"1F6PYPxygcpPy7Vwr","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"5","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.241","host.ip":"172.28.2.241","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether3","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3209"}
    , {"@id":"1F6PYPmhlIYKuKZ54","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"6","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.241","host.ip":"172.28.2.241","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether4","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3209"}
    , {"@id":"1F6PYPh1rIEC57kL9","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"7","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.241","host.ip":"172.28.2.241","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether5","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3209"}
    , {"@id":"1F6PYPsxIK1uf8G2a","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"8","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.241","host.ip":"172.28.2.241","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":18141,"host.interface.egress.bits_per_second":350,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":17790,"host.interface.ingress.errors_per_second":0,"host.interface.name":"bridge","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3209"}
    , {"@id":"1F6PYPvHNhiDKuzvt","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"9","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.241","host.ip":"172.28.2.241","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1664,"host.interface.egress.bits_per_second":345,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1319,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan801-mgmt","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3209"}
    , {"@id":"1F6PYPo40S1uIyA4w","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"10","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.241","host.ip":"172.28.2.241","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":14945,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":14945,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan802-inet","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3209"}
    , {"@id":"OqfkPMQbd3xjRJZR","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"65536","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.241","host.ip":"172.28.2.241","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.memory.utilization":22,"component.name":"main memory","storage.bytes":59523072,"storage.name":"main memory","storage.type":"ram","storage.utilization":22,"host.hostname":"NYC-S75-APT3209"}
    , {"@id":"OqfkPXkOSgfMNil8","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"131072","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.241","host.ip":"172.28.2.241","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","storage.bytes":40808448,"storage.name":"system disk","storage.type":"fixedDisk","storage.utilization":30,"host.hostname":"NYC-S75-APT3209"}
    , {"@id":"hnKbjALLDt8WQCYa","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","component.name":"unknown","host.address":"172.28.2.241","host.ip":"172.28.2.241","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3209"}
    , {"@id":"NhMhMfm5fI8kPKMR","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.25","host.ip":"192.0.2.25","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4115"}
    , {"@id":"Y2ukasJgP4cQjDZn","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.25","host.ip":"192.0.2.25","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4115"}
    , {"@id":"FIB4hD9T8KuIhAzX","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.25","host.ip":"192.0.2.25","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4115"}
    , {"@id":"mDNGVsx9sfTj4L95","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.25","host.ip":"192.0.2.25","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4115"}
    , {"@id":"FA53GQlOmV5xmnW3","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.25","host.ip":"192.0.2.25","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4115"}
    , {"@id":"ucT45W7CFUnYHEoB","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.25","host.ip":"192.0.2.25","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4115"}
    , {"@id":"ztQ3448LFVlaXrl9","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.25","host.ip":"192.0.2.25","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4115"}
    , {"@id":"17Mxg1cYcXevyVbCp","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.25","host.ip":"192.0.2.25","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4115"}
    , {"@id":"1E7nJ7KhsbLD104w0","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.25","host.ip":"192.0.2.25","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT4115"}
    , {"@id":"1E7nJ7SqEcJ8KBiQ1","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.25","host.ip":"192.0.2.25","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT4115"}
    , {"@id":"1E7nJ7Vy3UoLiTvBS","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.25","host.ip":"192.0.2.25","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT4115"}
    , {"@id":"1E7nJ7UYHo2fVK2IN","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.25","host.ip":"192.0.2.25","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT4115"}
    , {"@id":"1F6PYPiHHMWu6fQ7Q","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.25","host.ip":"192.0.2.25","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan1","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4115"}
    , {"@id":"1F6PYPqPdNUpPr3bR","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.25","host.ip":"192.0.2.25","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4115"}
    , {"@id":"1F6PYPtXSG02o9GMs","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.25","host.ip":"192.0.2.25","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":26014,"host.interface.egress.bits_per_second":298,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":25716,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether1","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT4115"}
    , {"@id":"1F6PYPs7gZEMazNTn","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.25","host.ip":"192.0.2.25","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4115"}
    , {"@id":"1F6PYPs6lXn062LdI","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"5","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.25","host.ip":"192.0.2.25","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether3","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4115"}
    , {"@id":"1F6PYPsIpnABAAkwj","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"6","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.25","host.ip":"192.0.2.25","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether4","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4115"}
    , {"@id":"1F6PYPhSl9VRkcQ5G","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"7","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.25","host.ip":"192.0.2.25","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether5","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4115"}
    , {"@id":"1F6PYPsSnYhFWFxlH","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"8","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.25","host.ip":"192.0.2.25","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":18024,"host.interface.egress.bits_per_second":266,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":17758,"host.interface.ingress.errors_per_second":0,"host.interface.name":"bridge","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT4115"}
    , {"@id":"1F6PYPiDCW5QHXVn2","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"9","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.25","host.ip":"192.0.2.25","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1554,"host.interface.egress.bits_per_second":261,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1292,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan801-mgmt","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT4115"}
    , {"@id":"1F6PYPzpgrZhAldnx","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"10","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.25","host.ip":"192.0.2.25","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":14942,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":14942,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan802-inet","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT4115"}
    , {"@id":"OqfkPg2rzQNo8JAC","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"65536","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.25","host.ip":"192.0.2.25","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.memory.utilization":21,"component.name":"main memory","storage.bytes":58683392,"storage.name":"main memory","storage.type":"ram","storage.utilization":21,"host.hostname":"NYC-S75-APT4115"}
    , {"@id":"OqfkPSgsPiGA5L3l","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"131072","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.25","host.ip":"192.0.2.25","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","storage.bytes":39989248,"storage.name":"system disk","storage.type":"fixedDisk","storage.utilization":29,"host.hostname":"NYC-S75-APT4115"}
    , {"@id":"hnKbjUEFR6yofBLz","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","component.name":"unknown","host.address":"192.0.2.25","host.ip":"192.0.2.25","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4115"}
    , {"@id":"NhMhMLtFykhptVYW","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.234","host.ip":"172.28.2.234","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3202"}
    , {"@id":"Y2ukaYQqiXBWDOls","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.234","host.ip":"172.28.2.234","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3202"}
    , {"@id":"FIB4gtGdRnTOBMBc","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.234","host.ip":"172.28.2.234","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3202"}
    , {"@id":"mDNGVZ4KC82oYWLA","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.234","host.ip":"172.28.2.234","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3202"}
    , {"@id":"FA53G6sZ5xf3Gyi8","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.234","host.ip":"172.28.2.234","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3202"}
    , {"@id":"ucT45CEMYxMdlQ0G","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.234","host.ip":"172.28.2.234","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3202"}
    , {"@id":"ztQ33kFVYyKg22xE","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.234","host.ip":"172.28.2.234","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3202"}
    , {"@id":"17Mxg1Ifmr7V3zmOu","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.234","host.ip":"172.28.2.234","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3202"}
    , {"@id":"1E7nJ7aMRwjTJk2bV","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.234","host.ip":"172.28.2.234","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT3202"}
    , {"@id":"1E7nJ7N5YHhm38Vu2","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.234","host.ip":"172.28.2.234","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT3202"}
    , {"@id":"1E7nJ7TxTAOErTklf","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.234","host.ip":"172.28.2.234","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT3202"}
    , {"@id":"1E7nJ7KFWkYKY3rEC","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.234","host.ip":"172.28.2.234","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT3202"}
    , {"@id":"1F6PYPxvqhvAPPNmv","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.234","host.ip":"172.28.2.234","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan1","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3202"}
    , {"@id":"1F6PYPkex2tT8nr5S","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.234","host.ip":"172.28.2.234","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3202"}
    , {"@id":"1F6PYPrWrvZvx95x5","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.234","host.ip":"172.28.2.234","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":25947,"host.interface.egress.bits_per_second":281,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":25666,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether1","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3202"}
    , {"@id":"1F6PYPhovVk1djCPc","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.234","host.ip":"172.28.2.234","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3202"}
    , {"@id":"1F6PYPxyuE84mVxdR","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"5","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.234","host.ip":"172.28.2.234","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether3","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3202"}
    , {"@id":"1F6PYPmi7EGKYef7y","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"6","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.234","host.ip":"172.28.2.234","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether4","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3202"}
    , {"@id":"1F6PYPh1mlXmhOaLf","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"7","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.234","host.ip":"172.28.2.234","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether5","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3202"}
    , {"@id":"1F6PYPsxMqiK2rQ24","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"8","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.234","host.ip":"172.28.2.234","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":17810,"host.interface.egress.bits_per_second":132,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":17678,"host.interface.ingress.errors_per_second":0,"host.interface.name":"bridge","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3202"}
    , {"@id":"1F6PYPvH1oV510pJF","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"9","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.234","host.ip":"172.28.2.234","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1374,"host.interface.egress.bits_per_second":129,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1244,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan801-mgmt","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3202"}
    , {"@id":"1F6PYPo3moEOA9my6","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"10","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.234","host.ip":"172.28.2.234","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":14915,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":14915,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan802-inet","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3202"}
    , {"@id":"OqfkPMQFjqpPX8wn","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"65536","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.234","host.ip":"172.28.2.234","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.memory.utilization":22,"component.name":"main memory","storage.bytes":60280832,"storage.name":"main memory","storage.type":"ram","storage.utilization":22,"host.hostname":"NYC-S75-APT3202"}
    , {"@id":"OqfkPXkBcqLnvs7S","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"131072","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.234","host.ip":"172.28.2.234","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","storage.bytes":39870464,"storage.name":"system disk","storage.type":"fixedDisk","storage.utilization":29,"host.hostname":"NYC-S75-APT3202"}
    , {"@id":"hnKbjALPkZXu9MY4","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","component.name":"unknown","host.address":"172.28.2.234","host.ip":"172.28.2.234","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3202"}
    , {"@id":"NhMhMfljkpZlIC1f","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.94","host.ip":"192.0.2.94","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT5214"}
    , {"@id":"Y2ukasJKUc3Rc5F1","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.94","host.ip":"192.0.2.94","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT5214"}
    , {"@id":"FIB4hD97DsLJa2el","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.94","host.ip":"192.0.2.94","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT5214"}
    , {"@id":"mDNGVswnyCujxCoJ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.94","host.ip":"192.0.2.94","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT5214"}
    , {"@id":"FA53GQl2s2WyffBH","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.94","host.ip":"192.0.2.94","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT5214"}
    , {"@id":"ucT45W6qL2EZA6TP","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.94","host.ip":"192.0.2.94","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT5214"}
    , {"@id":"ztQ3447zL3CbQjQN","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.94","host.ip":"192.0.2.94","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT5214"}
    , {"@id":"17Mxg1cYGdCMzOSs3","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.94","host.ip":"192.0.2.94","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT5214"}
    , {"@id":"1E7nJ7Kh6thQvjT36","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.94","host.ip":"192.0.2.94","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT5214"}
    , {"@id":"1E7nJ7SqjYt5PYD1d","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.94","host.ip":"192.0.2.94","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT5214"}
    , {"@id":"1E7nJ7VygtIDd1qQA","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.94","host.ip":"192.0.2.94","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT5214"}
    , {"@id":"1E7nJ7UZ49eCrHSxP","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.94","host.ip":"192.0.2.94","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT5214"}
    , {"@id":"1F6PYPiGVet81OoEW","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.94","host.ip":"192.0.2.94","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan1","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT5214"}
    , {"@id":"1F6PYPqQ8K4mVDYD3","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.94","host.ip":"192.0.2.94","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT5214"}
    , {"@id":"1F6PYPtY5eTuihBba","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.94","host.ip":"192.0.2.94","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":25947,"host.interface.egress.bits_per_second":279,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":25668,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether1","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT5214"}
    , {"@id":"1F6PYPs8Suptwwo8p","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.94","host.ip":"192.0.2.94","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT5214"}
    , {"@id":"1F6PYPs5zCBSk4uyG","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"5","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.94","host.ip":"192.0.2.94","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether3","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT5214"}
    , {"@id":"1F6PYPsICOgJFcpi1","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"6","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.94","host.ip":"192.0.2.94","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether4","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT5214"}
    , {"@id":"1F6PYPhTP6xMH1JFa","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"7","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.94","host.ip":"192.0.2.94","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether5","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT5214"}
    , {"@id":"1F6PYPsSReEgX8pQV","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"8","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.94","host.ip":"192.0.2.94","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":17946,"host.interface.egress.bits_per_second":250,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":17695,"host.interface.ingress.errors_per_second":0,"host.interface.name":"bridge","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT5214"}
    , {"@id":"1F6PYPiDYQXzGee7o","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"9","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.94","host.ip":"192.0.2.94","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1521,"host.interface.egress.bits_per_second":246,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1275,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan801-mgmt","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT5214"}
    , {"@id":"1F6PYPzp3Y5Xv3ZPl","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"10","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.94","host.ip":"192.0.2.94","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":14902,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":14902,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan802-inet","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT5214"}
    , {"@id":"OqfkPg3DtswnFRUy","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"65536","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.94","host.ip":"192.0.2.94","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.memory.utilization":22,"component.name":"main memory","storage.bytes":60841984,"storage.name":"main memory","storage.type":"ram","storage.utilization":22,"host.hostname":"NYC-S75-APT5214"}
    , {"@id":"OqfkPShMiKRyl0tF","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"131072","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.94","host.ip":"192.0.2.94","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","storage.bytes":40259584,"storage.name":"system disk","storage.type":"fixedDisk","storage.utilization":29,"host.hostname":"NYC-S75-APT5214"}
    , {"@id":"hnKbjUDtWePpY31D","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","component.name":"unknown","host.address":"192.0.2.94","host.ip":"192.0.2.94","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT5214"}
    , {"@id":"NhMhMecMyia6SEcb","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.1","host.ip":"192.0.2.1","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3307"}
    , {"@id":"Y2ukar9xiV3mm7px","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.1","host.ip":"192.0.2.1","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3307"}
    , {"@id":"FIB4hBzkRlLek5Fh","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.1","host.ip":"192.0.2.1","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3307"}
    , {"@id":"mDNGVrnRC5v57FPF","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.1","host.ip":"192.0.2.1","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3307"}
    , {"@id":"FA53GPbg5vXJphmD","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.1","host.ip":"192.0.2.1","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3307"}
    , {"@id":"ucT45UxTYvEuK94L","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.1","host.ip":"192.0.2.1","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3307"}
    , {"@id":"ztQ342ycYwCwam1J","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.1","host.ip":"192.0.2.1","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3307"}
    , {"@id":"17Mxg1bOtr5NKYVSz","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.1","host.ip":"192.0.2.1","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3307"}
    , {"@id":"1E7nJ7d6qxaZIf4hc","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.1","host.ip":"192.0.2.1","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT3307"}
    , {"@id":"1E7nJ7YaSSxYBXfKR","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.1","host.ip":"192.0.2.1","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT3307"}
    , {"@id":"1E7nJ7ZTv0haEIMnG","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.1","host.ip":"192.0.2.1","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT3307"}
    , {"@id":"1E7nJ7QnvvjFBARvx","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.1","host.ip":"192.0.2.1","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":1,"component.name":"","host.hostname":"NYC-S75-APT3307"}
    , {"@id":"1F6PYQ0gFimGOKPt2","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.1","host.ip":"192.0.2.1","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan1","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3307"}
    , {"@id":"1F6PYPw9rE9FHD0Vr","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.1","host.ip":"192.0.2.1","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3307"}
    , {"@id":"1F6PYPx3JltHJxhyg","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.1","host.ip":"192.0.2.1","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":27839,"host.interface.egress.bits_per_second":281,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":27558,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether1","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3307"}
    , {"@id":"1F6PYPoNKguwGpn7N","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.1","host.ip":"192.0.2.1","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3307"}
    , {"@id":"1F6PYPxbe4vXi7xdk","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"5","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.1","host.ip":"192.0.2.1","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether3","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3307"}
    , {"@id":"1F6PYPuFSscwszBAh","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"6","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.1","host.ip":"192.0.2.1","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether4","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3307"}
    , {"@id":"1F6PYPoSimlu3ycOw","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"7","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.1","host.ip":"192.0.2.1","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether5","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3307"}
    , {"@id":"1F6PYPtLAbaUKAuLR","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"8","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.1","host.ip":"192.0.2.1","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":17971,"host.interface.egress.bits_per_second":252,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":17719,"host.interface.ingress.errors_per_second":0,"host.interface.name":"bridge","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3307"}
    , {"@id":"1F6PYPixbTdVJyuZM","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"9","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.1","host.ip":"192.0.2.1","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1529,"host.interface.egress.bits_per_second":248,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan801-mgmt","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3307"}
    , {"@id":"1F6PYPwVKyqAOWsLP","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"10","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.1","host.ip":"192.0.2.1","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":14917,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":14917,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan802-inet","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3307"}
    , {"@id":"OqfkPWm4JLYc17T6","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"65536","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.1","host.ip":"192.0.2.1","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.memory.utilization":22,"component.name":"main memory","storage.bytes":59334656,"storage.name":"main memory","storage.type":"ram","storage.utilization":22,"host.hostname":"NYC-S75-APT3307"}
    , {"@id":"OqfkPdrECZEa6W47","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"131072","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.1","host.ip":"192.0.2.1","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","storage.bytes":40804352,"storage.name":"system disk","storage.type":"fixedDisk","storage.utilization":30,"host.hostname":"NYC-S75-APT3307"}
    , {"@id":"hnKbjT4WkXQAi5c9","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","component.name":"unknown","host.address":"192.0.2.1","host.ip":"192.0.2.1","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3307"}
    , {"@id":"NhMhMMdmmIHTg4xH","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.176","host.ip":"172.28.2.176","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2201"}
    , {"@id":"Y2ukaZBNW4l9zyAd","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.176","host.ip":"172.28.2.176","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2201"}
    , {"@id":"FIB4gu1AFL31xvaN","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.176","host.ip":"172.28.2.176","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2201"}
    , {"@id":"mDNGVZoqzfcSL5jv","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.176","host.ip":"172.28.2.176","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2201"}
    , {"@id":"FA53G7d5tVEh3Y6t","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.176","host.ip":"172.28.2.176","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2201"}
    , {"@id":"ucT45CytMUwHXzP1","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.176","host.ip":"172.28.2.176","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2201"}
    , {"@id":"ztQ33l02MVuJocLz","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.176","host.ip":"172.28.2.176","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2201"}
    , {"@id":"17Mxg1JQJef4hmLnf","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.176","host.ip":"172.28.2.176","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2201"}
    , {"@id":"1E7nJ7ZZfH1SGV9zG","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.176","host.ip":"172.28.2.176","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT2201"}
    , {"@id":"1E7nJ7Ktv36Uio8rJ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.176","host.ip":"172.28.2.176","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT2201"}
    , {"@id":"1E7nJ7W6qMpdSg6ts","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.176","host.ip":"172.28.2.176","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT2201"}
    , {"@id":"1E7nJ7L1lBBDfxpfD","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.176","host.ip":"172.28.2.176","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT2201"}
    , {"@id":"1F6PYPx942D9MAVAg","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.176","host.ip":"172.28.2.176","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan1","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT2201"}
    , {"@id":"1F6PYPiTJoIBoTU2j","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.176","host.ip":"172.28.2.176","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT2201"}
    , {"@id":"1F6PYPtgF81KYLS5I","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.176","host.ip":"172.28.2.176","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":26096,"host.interface.egress.bits_per_second":281,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":25815,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether1","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT2201"}
    , {"@id":"1F6PYPib9wMuldAqd","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.176","host.ip":"172.28.2.176","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT2201"}
    , {"@id":"1F6PYPxCfnVBebzCQ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"5","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.176","host.ip":"172.28.2.176","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether3","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT2201"}
    , {"@id":"1F6PYPkYB8m2lQa2P","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"6","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.176","host.ip":"172.28.2.176","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether4","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT2201"}
    , {"@id":"1F6PYPjKmHb7wWMdY","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"7","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.176","host.ip":"172.28.2.176","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether5","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT2201"}
    , {"@id":"1F6PYPthteFtgdzQp","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"8","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.176","host.ip":"172.28.2.176","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":17895,"host.interface.egress.bits_per_second":252,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":17643,"host.interface.ingress.errors_per_second":0,"host.interface.name":"bridge","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT2201"}
    , {"@id":"1F6PYPuWVAwwgtxbW","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"9","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.176","host.ip":"172.28.2.176","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1459,"host.interface.egress.bits_per_second":247,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1211,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan801-mgmt","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT2201"}
    , {"@id":"1F6PYPllMpBhNkYPh","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"10","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.176","host.ip":"172.28.2.176","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":14917,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":14917,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan802-inet","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT2201"}
    , {"@id":"OqfkPLfiSKvojSSw","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"65536","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.176","host.ip":"172.28.2.176","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.memory.utilization":22,"component.name":"main memory","storage.bytes":61194240,"storage.name":"main memory","storage.type":"ram","storage.utilization":22,"host.hostname":"NYC-S75-APT2201"}
    , {"@id":"OqfkPVPUxg11hnsP","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"131072","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.176","host.ip":"172.28.2.176","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","storage.bytes":39985152,"storage.name":"system disk","storage.type":"fixedDisk","storage.utilization":29,"host.hostname":"NYC-S75-APT2201"}
    , {"@id":"hnKbjB5wY77Xvvwp","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","component.name":"unknown","host.address":"172.28.2.176","host.ip":"172.28.2.176","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2201"}
    , {"@id":"NhMhMMdZnhxGlUKh","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.107","host.ip":"172.28.2.107","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT1108"}
    , {"@id":"Y2ukaZBAXUQx5NY3","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.107","host.ip":"172.28.2.107","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT1108"}
    , {"@id":"FIB4gu0xGkip3Kxn","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.107","host.ip":"172.28.2.107","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT1108"}
    , {"@id":"mDNGVZoe15IFQV7L","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.107","host.ip":"172.28.2.107","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT1108"}
    , {"@id":"FA53G7csuuuU8xUJ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.107","host.ip":"172.28.2.107","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT1108"}
    , {"@id":"ucT45CygNuc4dOmR","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.107","host.ip":"172.28.2.107","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT1108"}
    , {"@id":"ztQ33kzpNva6u1jP","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.107","host.ip":"172.28.2.107","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT1108"}
    , {"@id":"17Mxg1JQ6g4kUrlB5","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.107","host.ip":"172.28.2.107","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT1108"}
    , {"@id":"1E7nJ7Za9Zde5Apok","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.107","host.ip":"172.28.2.107","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":1,"component.name":"","host.hostname":"NYC-S75-APT1108"}
    , {"@id":"1E7nJ7KtQ6WXdReFh","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.107","host.ip":"172.28.2.107","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT1108"}
    , {"@id":"1E7nJ7W73LPxfahWS","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.107","host.ip":"172.28.2.107","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT1108"}
    , {"@id":"1E7nJ7L275dmf4xzz","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.107","host.ip":"172.28.2.107","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT1108"}
    , {"@id":"1F6PYPx9YKpLAqB0A","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.107","host.ip":"172.28.2.107","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan1","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT1108"}
    , {"@id":"1F6PYPiSoriEj6zR7","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.107","host.ip":"172.28.2.107","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT1108"}
    , {"@id":"1F6PYPtgS6belG2hs","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.107","host.ip":"172.28.2.107","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1661355,"host.interface.egress.bits_per_second":281,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1661074,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether1","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT1108"}
    , {"@id":"1F6PYPibVqpTkkJBP","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.107","host.ip":"172.28.2.107","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT1108"}
    , {"@id":"1F6PYPxCbI4Cw5mv4","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"5","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.107","host.ip":"172.28.2.107","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether3","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT1108"}
    , {"@id":"1F6PYPkYFeD1TwmJl","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"6","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.107","host.ip":"172.28.2.107","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether4","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT1108"}
    , {"@id":"1F6PYPjKQN8YxPEIm","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"7","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.107","host.ip":"172.28.2.107","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether5","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT1108"}
    , {"@id":"1F6PYPthgffZTjOoF","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"8","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.107","host.ip":"172.28.2.107","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":18208,"host.interface.egress.bits_per_second":418,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":17789,"host.interface.ingress.errors_per_second":0,"host.interface.name":"bridge","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT1108"}
    , {"@id":"1F6PYPuWzTZ8VZdR0","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"9","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.107","host.ip":"172.28.2.107","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1609,"host.interface.egress.bits_per_second":313,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1295,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan801-mgmt","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT1108"}
    , {"@id":"1F6PYPlksWZVZ4saD","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"10","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.107","host.ip":"172.28.2.107","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":14968,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":14968,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan802-inet","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT1108"}
    , {"@id":"OqfkPLgDOusu5x4Y","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"65536","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.107","host.ip":"172.28.2.107","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.memory.utilization":22,"component.name":"main memory","storage.bytes":59797504,"storage.name":"main memory","storage.type":"ram","storage.utilization":22,"host.hostname":"NYC-S75-APT1108"}
    , {"@id":"OqfkPVP0f3pD282v","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"131072","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.107","host.ip":"172.28.2.107","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","storage.bytes":40013824,"storage.name":"system disk","storage.type":"fixedDisk","storage.utilization":29,"host.hostname":"NYC-S75-APT1108"}
    , {"@id":"hnKbjB5jZWnL1LKF","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","component.name":"unknown","host.address":"172.28.2.107","host.ip":"172.28.2.107","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT1108"}
    , {"@id":"NhMhMfMBn2EI25jF","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"Y2ukartmWohyLywb","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"FIB4hCjZG4zqJwML","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"mDNGVsXG0PZGh6Vt","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"FA53GQLUuFBVPYsr","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"ucT45VhINEt5u0Az","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"ztQ343iRNFr8Ad7x","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"17Mxg1c8ifP1W8MZd","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"1E7nJ7cN26m3mfIAi","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":3,"component.name":"","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"1F6PYPzwQrxksKdM8","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":14160716,"host.interface.egress.bits_per_second":5270180,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":8890536,"host.interface.ingress.errors_per_second":0,"host.interface.name":"sfp-sfpplus1","host.interface.oper_status":"up","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"1F6PYPwtgivW3tbot","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":27493975,"host.interface.egress.bits_per_second":15546463,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":11947512,"host.interface.ingress.errors_per_second":0,"host.interface.name":"sfp-sfpplus2","host.interface.oper_status":"up","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"1F6PYPwO1JNPtZMes","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"sfp-sfpplus3","host.interface.oper_status":"notPresent","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"1F6PYPp2d9QnhE8RB","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"sfp-sfpplus4","host.interface.oper_status":"notPresent","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"1F6PYPwpYaUFWjGqS","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"5","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"sfp-sfpplus5","host.interface.oper_status":"notPresent","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"1F6PYPuzIKuMLFr3T","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"6","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"sfp-sfpplus6","host.interface.oper_status":"notPresent","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"1F6PYPnitySFsOlII","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"7","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":2630809,"host.interface.egress.bits_per_second":1187232,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1443577,"host.interface.ingress.errors_per_second":0,"host.interface.name":"sfp-sfpplus7","host.interface.oper_status":"up","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"1F6PYPu9VoCmbMCfB","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"8","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"sfp-sfpplus8","host.interface.oper_status":"notPresent","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"1F6PYPiDlyrEXIJGK","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"9","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"sfp-sfpplus9","host.interface.oper_status":"notPresent","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"1F6PYPxAe5Jn5c2RL","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"10","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"sfp-sfpplus10","host.interface.oper_status":"notPresent","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"1F6PYPjcBBASG0I2w","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"11","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":11030713,"host.interface.egress.bits_per_second":10555569,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":475144,"host.interface.ingress.errors_per_second":0,"host.interface.name":"sfp-sfpplus11","host.interface.oper_status":"up","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"1F6PYPkM70XeG4FTx","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"12","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":2832396,"host.interface.egress.bits_per_second":2541180,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":291215,"host.interface.ingress.errors_per_second":0,"host.interface.name":"sfp-sfpplus12","host.interface.oper_status":"up","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"1F6PYPjnghAZ0MTHo","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"13","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":902705,"host.interface.egress.bits_per_second":841473,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":61231,"host.interface.ingress.errors_per_second":0,"host.interface.name":"sfp-sfpplus13","host.interface.oper_status":"up","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"1F6PYPnoNhMk7LuqB","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"14","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":43562,"host.interface.egress.bits_per_second":31333,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":12229,"host.interface.ingress.errors_per_second":0,"host.interface.name":"sfp-sfpplus14","host.interface.oper_status":"up","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"1F6PYPll73bWhQuHK","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"15","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":4615436,"host.interface.egress.bits_per_second":4523125,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":92311,"host.interface.ingress.errors_per_second":0,"host.interface.name":"sfp-sfpplus15","host.interface.oper_status":"up","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"1F6PYPmwk0vT8BTTl","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"16","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":32081,"host.interface.egress.bits_per_second":26958,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":5123,"host.interface.ingress.errors_per_second":0,"host.interface.name":"sfp-sfpplus16","host.interface.oper_status":"up","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"1F6PYPt4Jfys7nCBc","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"17","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":38044,"host.interface.egress.bits_per_second":28647,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":9397,"host.interface.ingress.errors_per_second":0,"host.interface.name":"sfp-sfpplus17","host.interface.oper_status":"up","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"1F6PYPjkv5VLfTAo3","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"18","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":31972,"host.interface.egress.bits_per_second":26914,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":5057,"host.interface.ingress.errors_per_second":0,"host.interface.name":"sfp-sfpplus18","host.interface.oper_status":"up","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"1F6PYPiCgMcK2XNEE","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"19","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":32037,"host.interface.egress.bits_per_second":26947,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":5089,"host.interface.ingress.errors_per_second":0,"host.interface.name":"sfp-sfpplus19","host.interface.oper_status":"up","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"1F6PYPpZmc0h9xTc5","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"20","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":42531,"host.interface.egress.bits_per_second":31217,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":11314,"host.interface.ingress.errors_per_second":0,"host.interface.name":"sfp-sfpplus20","host.interface.oper_status":"up","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"1F6PYQ0iskxYrTN7c","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"21","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"sfp-sfpplus21","host.interface.oper_status":"notPresent","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"1F6PYPlwaviNUHJD9","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"22","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"sfp-sfpplus22","host.interface.oper_status":"notPresent","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"1F6PYPoEJGNTCEUKQ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"23","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"sfp-sfpplus23","host.interface.oper_status":"notPresent","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"1F6PYPhplOCOLRDS5","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"24","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":20780041,"host.interface.egress.bits_per_second":1387287,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":19392754,"host.interface.ingress.errors_per_second":0,"host.interface.name":"sfp-sfpplus24","host.interface.oper_status":"up","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"1F6PYPxRQfBz4CPR2","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"25","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"qsfpplus1-1","host.interface.oper_status":"notPresent","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"1F6PYPtlpMAlveLzD","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"26","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"qsfpplus1-2","host.interface.oper_status":"notPresent","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"1F6PYPsLdhZshDV8w","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"27","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"qsfpplus1-3","host.interface.oper_status":"notPresent","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"1F6PYPkl4AiRJNL4f","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"28","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"qsfpplus1-4","host.interface.oper_status":"notPresent","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"1F6PYPscx6oP7hgEW","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"29","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"qsfpplus2-1","host.interface.oper_status":"notPresent","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"1F6PYPh7sUQ7dhAfj","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"30","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"qsfpplus2-2","host.interface.oper_status":"notPresent","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"1F6PYPmDx95lvaoja","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"31","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"qsfpplus2-3","host.interface.oper_status":"notPresent","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"1F6PYPvo3ddmZmjdB","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"32","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"qsfpplus2-4","host.interface.oper_status":"notPresent","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"1F6PYPuH97VvhJ8um","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"33","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether1","host.interface.oper_status":"down","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"1F6PYPydqq1lLvTbj","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"34","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":3246,"host.interface.egress.bits_per_second":1356,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1890,"host.interface.ingress.errors_per_second":0,"host.interface.name":"bridge","host.interface.oper_status":"up","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"1F6PYPifddZIvaK5W","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"35","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":3101,"host.interface.egress.bits_per_second":1335,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1766,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan801-mgmt","host.interface.oper_status":"up","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"1F6PYPmMx4RdHRoPr","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"38","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":41554803,"host.interface.egress.bits_per_second":20716755,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":20838048,"host.interface.ingress.errors_per_second":0,"host.interface.name":"siteRtr","host.interface.oper_status":"up","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"OqfkPW2FSX361KwC","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"65536","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.memory.utilization":74,"component.name":"main memory","storage.bytes":49926144,"storage.name":"main memory","storage.type":"ram","storage.utilization":74,"host.hostname":"NYC-S75-AGG01"}
    , {"@id":"OqfkPeWWf560UrNv","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"131072","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","storage.bytes":13844480,"storage.name":"system disk","storage.type":"fixedDisk","storage.utilization":82,"host.hostname":"NYC-S75-AGG01"}
    , {"@id":"hnKbjToLYr4MHwin","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","component.name":"unknown","host.address":"172.28.2.4","host.ip":"172.28.2.4","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-AGG01"}
    , {"@id":"NhMhMMeD8RXBgWR1","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.198","host.ip":"172.28.2.198","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2303"}
    , {"@id":"Y2ukaZBnsE0s0PeN","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.198","host.ip":"172.28.2.198","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2303"}
    , {"@id":"FIB4gu1abUIjyN47","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.198","host.ip":"172.28.2.198","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2303"}
    , {"@id":"mDNGVZpHLosALXDf","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.198","host.ip":"172.28.2.198","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2303"}
    , {"@id":"FA53G7dWFeUP3zad","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.198","host.ip":"172.28.2.198","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2303"}
    , {"@id":"ucT45CzJieBzYQsl","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.198","host.ip":"172.28.2.198","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2303"}
    , {"@id":"ztQ33l0SifA1p3pj","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.198","host.ip":"172.28.2.198","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2303"}
    , {"@id":"17Mxg1JQk0oKPmnHP","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.198","host.ip":"172.28.2.198","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2303"}
    , {"@id":"1E7nJ7ZaeXT1pkI8U","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.198","host.ip":"172.28.2.198","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":1,"component.name":"","host.hostname":"NYC-S75-APT2303"}
    , {"@id":"1E7nJ7Ku3SVYDZe49","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.198","host.ip":"172.28.2.198","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT2303"}
    , {"@id":"1E7nJ7W7YFV3QXGho","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.198","host.ip":"172.28.2.198","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT2303"}
    , {"@id":"1E7nJ7L2kSsDuPvWZ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.198","host.ip":"172.28.2.198","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT2303"}
    , {"@id":"1F6PYPxA3IeivPdJu","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.198","host.ip":"172.28.2.198","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan1","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT2303"}
    , {"@id":"1F6PYPiTSDhFJEzFZ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.198","host.ip":"172.28.2.198","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT2303"}
    , {"@id":"1F6PYPtgx0gkWCbtE","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.198","host.ip":"172.28.2.198","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":33532,"host.interface.egress.bits_per_second":281,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":33251,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether1","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT2303"}
    , {"@id":"1F6PYPic9E3v05Ghz","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.198","host.ip":"172.28.2.198","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT2303"}
    , {"@id":"1F6PYPxD6DOjMFJoY","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"5","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.198","host.ip":"172.28.2.198","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether3","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT2303"}
    , {"@id":"1F6PYPkXkmcn3Q8Yf","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"6","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.198","host.ip":"172.28.2.198","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether4","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT2303"}
    , {"@id":"1F6PYPjKufkkm4u8G","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"7","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.198","host.ip":"172.28.2.198","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether5","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT2303"}
    , {"@id":"1F6PYPtiK0P9OeQuZ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"8","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.198","host.ip":"172.28.2.198","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":17895,"host.interface.egress.bits_per_second":252,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":17643,"host.interface.ingress.errors_per_second":0,"host.interface.name":"bridge","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT2303"}
    , {"@id":"1F6PYPuWM6KhGEfuQ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"9","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.198","host.ip":"172.28.2.198","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1462,"host.interface.egress.bits_per_second":247,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1214,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan801-mgmt","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT2303"}
    , {"@id":"1F6PYPlkNXUh9ISYL","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"10","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.198","host.ip":"172.28.2.198","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":14914,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":14914,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan802-inet","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT2303"}
    , {"@id":"OqfkPLfa1gRekzXy","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"65536","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.198","host.ip":"172.28.2.198","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.memory.utilization":22,"component.name":"main memory","storage.bytes":60084224,"storage.name":"main memory","storage.type":"ram","storage.utilization":22,"host.hostname":"NYC-S75-APT2303"}
    , {"@id":"OqfkPVPe12pnA7rN","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"131072","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.198","host.ip":"172.28.2.198","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","storage.bytes":40394752,"storage.name":"system disk","storage.type":"fixedDisk","storage.utilization":30,"host.hostname":"NYC-S75-APT2303"}
    , {"@id":"hnKbjB6MuGNFwNQZ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","component.name":"unknown","host.address":"172.28.2.198","host.ip":"172.28.2.198","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2303"}
    , {"@id":"NhMhMLtP4vk64UtH","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.213","host.ip":"172.28.2.213","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2318"}
    , {"@id":"Y2ukaYQzoiDmOO6d","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.213","host.ip":"172.28.2.213","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2318"}
    , {"@id":"FIB4gtGmXyVeMLWN","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.213","host.ip":"172.28.2.213","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2318"}
    , {"@id":"mDNGVZ4TIJ54jVfv","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.213","host.ip":"172.28.2.213","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2318"}
    , {"@id":"FA53G6siC8hJRy2t","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.213","host.ip":"172.28.2.213","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2318"}
    , {"@id":"ucT45CEVf8OtwPL1","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.213","host.ip":"172.28.2.213","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2318"}
    , {"@id":"ztQ33kFef9MwD2Hz","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.213","host.ip":"172.28.2.213","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2318"}
    , {"@id":"17Mxg1IfvxIXKAljf","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.213","host.ip":"172.28.2.213","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2318"}
    , {"@id":"1E7nJ7aMar2vGQsg2","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.213","host.ip":"172.28.2.213","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":1,"component.name":"","host.hostname":"NYC-S75-APT2318"}
    , {"@id":"1E7nJ7N5Psc4ifkcj","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.213","host.ip":"172.28.2.213","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT2318"}
    , {"@id":"1E7nJ7TxK5SdGVj92","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.213","host.ip":"172.28.2.213","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT2318"}
    , {"@id":"1E7nJ7KFfoEVTov8h","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.213","host.ip":"172.28.2.213","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT2318"}
    , {"@id":"1F6PYPxvzcEcM6DrS","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.213","host.ip":"172.28.2.213","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan1","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT2318"}
    , {"@id":"1F6PYPkeodnloL5o9","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.213","host.ip":"172.28.2.213","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT2318"}
    , {"@id":"1F6PYPrWiqeKMB4KS","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.213","host.ip":"172.28.2.213","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":33721,"host.interface.egress.bits_per_second":281,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":33439,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether1","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT2318"}
    , {"@id":"1F6PYPhp4ZQCZUGK7","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.213","host.ip":"172.28.2.213","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT2318"}
    , {"@id":"1F6PYPxz2WycmvuM6","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"5","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.213","host.ip":"172.28.2.213","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether3","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT2318"}
    , {"@id":"1F6PYPmhywfDDRg7R","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"6","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.213","host.ip":"172.28.2.213","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether4","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT2318"}
    , {"@id":"1F6PYPh1eS4WMN9lw","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"7","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.213","host.ip":"172.28.2.213","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether5","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT2318"}
    , {"@id":"1F6PYPsxVIvb2Laah","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"8","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.213","host.ip":"172.28.2.213","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":18077,"host.interface.egress.bits_per_second":283,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":17793,"host.interface.ingress.errors_per_second":0,"host.interface.name":"bridge","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT2318"}
    , {"@id":"1F6PYPvHAsnyHNN4o","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"9","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.213","host.ip":"172.28.2.213","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1596,"host.interface.egress.bits_per_second":279,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1317,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan801-mgmt","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT2318"}
    , {"@id":"1F6PYPo3eP8gph1gn","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"10","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.213","host.ip":"172.28.2.213","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":14949,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":14949,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan802-inet","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT2318"}
    , {"@id":"OqfkPMQOABxPCrwE","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"65536","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.213","host.ip":"172.28.2.213","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.memory.utilization":22,"component.name":"main memory","storage.bytes":59191296,"storage.name":"main memory","storage.type":"ram","storage.utilization":22,"host.hostname":"NYC-S75-APT2318"}
    , {"@id":"OqfkPXk2ZmtCmI41","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"131072","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.213","host.ip":"172.28.2.213","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","storage.bytes":40161280,"storage.name":"system disk","storage.type":"fixedDisk","storage.utilization":29,"host.hostname":"NYC-S75-APT2318"}
    , {"@id":"hnKbjALYqkaAKLsp","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","component.name":"unknown","host.address":"172.28.2.213","host.ip":"172.28.2.213","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2318"}
    , {"@id":"NhMhMMdRQnl6PuY7","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.129","host.ip":"172.28.2.129","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT1212"}
    , {"@id":"Y2ukaZB2AaEmjnlT","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.129","host.ip":"172.28.2.129","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT1212"}
    , {"@id":"FIB4gu0otqWehlBD","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.129","host.ip":"172.28.2.129","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT1212"}
    , {"@id":"mDNGVZoVeB654vKl","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.129","host.ip":"172.28.2.129","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT1212"}
    , {"@id":"FA53G7ckY0iJnNhj","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.129","host.ip":"172.28.2.129","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT1212"}
    , {"@id":"ucT45CyY10PuHozr","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.129","host.ip":"172.28.2.129","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT1212"}
    , {"@id":"ztQ33kzh11NwYRwp","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.129","host.ip":"172.28.2.129","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT1212"}
    , {"@id":"17Mxg1JPyJAYKWBOV","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.129","host.ip":"172.28.2.129","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT1212"}
    , {"@id":"1E7nJ7Za0cVydlKOQ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.129","host.ip":"172.28.2.129","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT1212"}
    , {"@id":"1E7nJ7KtZCODjJtev","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.129","host.ip":"172.28.2.129","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT1212"}
    , {"@id":"1E7nJ7W7CL2URQ8N2","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.129","host.ip":"172.28.2.129","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT1212"}
    , {"@id":"1E7nJ7L1y7GgYSUrX","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.129","host.ip":"172.28.2.129","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT1212"}
    , {"@id":"1F6PYPx9PNhfjQfZq","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.129","host.ip":"172.28.2.129","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan1","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT1212"}
    , {"@id":"1F6PYPiSxxZuozEqL","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.129","host.ip":"172.28.2.129","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT1212"}
    , {"@id":"1F6PYPtgb6EBX5TYS","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.129","host.ip":"172.28.2.129","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":30461,"host.interface.egress.bits_per_second":281,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":30180,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether1","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT1212"}
    , {"@id":"1F6PYPibMsSNe7q2x","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.129","host.ip":"172.28.2.129","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT1212"}
    , {"@id":"1F6PYPxCSrPim7K06","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"5","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.129","host.ip":"172.28.2.129","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether3","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT1212"}
    , {"@id":"1F6PYPkYO3c4yiHWb","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"6","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.129","host.ip":"172.28.2.129","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether4","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT1212"}
    , {"@id":"1F6PYPjKYlIBmxlnU","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"7","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.129","host.ip":"172.28.2.129","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether5","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT1212"}
    , {"@id":"1F6PYPthXenc2h0FX","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"8","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.129","host.ip":"172.28.2.129","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":18093,"host.interface.egress.bits_per_second":351,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":17741,"host.interface.ingress.errors_per_second":0,"host.interface.name":"bridge","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT1212"}
    , {"@id":"1F6PYPuWr5PVg15wI","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"9","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.129","host.ip":"172.28.2.129","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1500,"host.interface.egress.bits_per_second":247,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1252,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan801-mgmt","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT1212"}
    , {"@id":"1F6PYPll0tThjQSMn","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"10","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.129","host.ip":"172.28.2.129","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":14966,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":14966,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan802-inet","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT1212"}
    , {"@id":"OqfkPLg4MnUnqani","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"65536","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.129","host.ip":"172.28.2.129","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.memory.utilization":22,"component.name":"main memory","storage.bytes":59191296,"storage.name":"main memory","storage.type":"ram","storage.utilization":22,"host.hostname":"NYC-S75-APT1212"}
    , {"@id":"OqfkPVP96xk2DYg1","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"131072","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.129","host.ip":"172.28.2.129","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","storage.bytes":40038400,"storage.name":"system disk","storage.type":"fixedDisk","storage.utilization":29,"host.hostname":"NYC-S75-APT1212"}
    , {"@id":"hnKbjB5bCcbAflXf","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","component.name":"unknown","host.address":"172.28.2.129","host.ip":"172.28.2.129","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT1212"}
    , {"@id":"NhMhMfmW4sKHjv32","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.42","host.ip":"192.0.2.42","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4214"}
    , {"@id":"Y2ukasK6oeny3oGO","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.42","host.ip":"192.0.2.42","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4214"}
    , {"@id":"FIB4hD9tXv5q1lg8","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.42","host.ip":"192.0.2.42","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4214"}
    , {"@id":"mDNGVsxaIFfGOvpg","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.42","host.ip":"192.0.2.42","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4214"}
    , {"@id":"FA53GQlpC5HV7OCe","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.42","host.ip":"192.0.2.42","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4214"}
    , {"@id":"ucT45W7cf4z5bpUm","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.42","host.ip":"192.0.2.42","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4214"}
    , {"@id":"ztQ3448lf5x7sSRk","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.42","host.ip":"192.0.2.42","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4214"}
    , {"@id":"17Mxg1cZ2xF7VqBtQ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.42","host.ip":"192.0.2.42","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4214"}
    , {"@id":"1E7nJ7Ki1f1Nwl8qV","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.42","host.ip":"192.0.2.42","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT4214"}
    , {"@id":"1E7nJ7SponZ8OWXEE","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.42","host.ip":"192.0.2.42","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT4214"}
    , {"@id":"1E7nJ7VyTwGgFcxRF","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.42","host.ip":"192.0.2.42","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT4214"}
    , {"@id":"1E7nJ7UY8j73uM0fk","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.42","host.ip":"192.0.2.42","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT4214"}
    , {"@id":"1F6PYPiHQQD52QU1v","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.42","host.ip":"192.0.2.42","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan1","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4214"}
    , {"@id":"1F6PYPqPDYkpUBsPe","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.42","host.ip":"192.0.2.42","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4214"}
    , {"@id":"1F6PYPtXshSNLIIcf","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.42","host.ip":"192.0.2.42","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":25929,"host.interface.egress.bits_per_second":279,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":25650,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether1","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT4214"}
    , {"@id":"1F6PYPs7XUIl01LrA","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.42","host.ip":"192.0.2.42","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4214"}
    , {"@id":"1F6PYPs6L6xNtUnEZ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"5","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.42","host.ip":"192.0.2.42","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether3","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4214"}
    , {"@id":"1F6PYPsIyjyURHWRW","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"6","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.42","host.ip":"192.0.2.42","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether4","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4214"}
    , {"@id":"1F6PYPhSckPkQ9enx","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"7","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.42","host.ip":"192.0.2.42","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether5","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4214"}
    , {"@id":"1F6PYPsTDyHR3aYRs","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"8","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.42","host.ip":"192.0.2.42","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":17907,"host.interface.egress.bits_per_second":214,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":17692,"host.interface.ingress.errors_per_second":0,"host.interface.name":"bridge","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT4214"}
    , {"@id":"1F6PYPiDLZlbDIZhX","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"9","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.42","host.ip":"192.0.2.42","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1484,"host.interface.egress.bits_per_second":211,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1272,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan801-mgmt","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT4214"}
    , {"@id":"1F6PYPzpH2phF6ScA","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"10","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.42","host.ip":"192.0.2.42","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":14900,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":14900,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan802-inet","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT4214"}
    , {"@id":"OqfkPg30P8nTCYIZ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"65536","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.42","host.ip":"192.0.2.42","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.memory.utilization":22,"component.name":"main memory","storage.bytes":61014016,"storage.name":"main memory","storage.type":"ram","storage.utilization":22,"host.hostname":"NYC-S75-APT4214"}
    , {"@id":"OqfkPSgRx0UxjL5q","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"131072","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.42","host.ip":"192.0.2.42","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","storage.bytes":40009728,"storage.name":"system disk","storage.type":"fixedDisk","storage.utilization":29,"host.hostname":"NYC-S75-APT4214"}
    , {"@id":"hnKbjUEfqhALzm2a","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","component.name":"unknown","host.address":"192.0.2.42","host.ip":"192.0.2.42","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4214"}
    , {"@id":"NhMhMLtBSNecT5UZ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.240","host.ip":"172.28.2.240","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3208"}
    , {"@id":"Y2ukaYQmCA8Imyhv","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.240","host.ip":"172.28.2.240","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3208"}
    , {"@id":"FIB4gtGYvQQAkw7f","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.240","host.ip":"172.28.2.240","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3208"}
    , {"@id":"mDNGVZ4Ffkzb86HD","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.240","host.ip":"172.28.2.240","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3208"}
    , {"@id":"FA53G6sUZabpqYeB","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.240","host.ip":"172.28.2.240","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3208"}
    , {"@id":"ucT45CEI2aJQKzwJ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.240","host.ip":"172.28.2.240","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3208"}
    , {"@id":"ztQ33kFR2bHSbctH","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.240","host.ip":"172.28.2.240","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3208"}
    , {"@id":"17Mxg1IfiKkRqZMKx","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.240","host.ip":"172.28.2.240","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3208"}
    , {"@id":"1E7nJ7aMnpdFTLTIc","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.240","host.ip":"172.28.2.240","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT3208"}
    , {"@id":"1E7nJ7N5llpD2ZvFN","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.240","host.ip":"172.28.2.240","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT3208"}
    , {"@id":"1E7nJ7TwyCFUwbYWO","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.240","host.ip":"172.28.2.240","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT3208"}
    , {"@id":"1E7nJ7KG1ih4Sw3TT","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.240","host.ip":"172.28.2.240","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT3208"}
    , {"@id":"1F6PYPxwCaowZ0oU2","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.240","host.ip":"172.28.2.240","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan1","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3208"}
    , {"@id":"1F6PYPkfAX0u8FGQn","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.240","host.ip":"172.28.2.240","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3208"}
    , {"@id":"1F6PYPrWMxRC2Gtho","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.240","host.ip":"172.28.2.240","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":25716,"host.interface.egress.bits_per_second":281,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":25435,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether1","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3208"}
    , {"@id":"1F6PYPhpQTslYbOet","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.240","host.ip":"172.28.2.240","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3208"}
    , {"@id":"1F6PYPxygcW3nom1K","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"5","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.240","host.ip":"172.28.2.240","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether3","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3208"}
    , {"@id":"1F6PYPmhlIrh4dJ0b","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"6","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.240","host.ip":"172.28.2.240","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether4","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3208"}
    , {"@id":"1F6PYPh1rHupup0Pc","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"7","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.240","host.ip":"172.28.2.240","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether5","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3208"}
    , {"@id":"1F6PYPsxIKLGpQzy7","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"8","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.240","host.ip":"172.28.2.240","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":17922,"host.interface.egress.bits_per_second":252,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":17670,"host.interface.ingress.errors_per_second":0,"host.interface.name":"bridge","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3208"}
    , {"@id":"1F6PYPvHNhOrAcG0M","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"9","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.240","host.ip":"172.28.2.240","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1488,"host.interface.egress.bits_per_second":247,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1240,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan801-mgmt","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3208"}
    , {"@id":"1F6PYPo40SLGTGu0T","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"10","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.240","host.ip":"172.28.2.240","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":14913,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":14913,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan802-inet","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3208"}
    , {"@id":"OqfkPMQbckbZ8Zdu","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"65536","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.240","host.ip":"172.28.2.240","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.memory.utilization":22,"component.name":"main memory","storage.bytes":60030976,"storage.name":"main memory","storage.type":"ram","storage.utilization":22,"host.hostname":"NYC-S75-APT3208"}
    , {"@id":"OqfkPXkOT01WgSgf","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"131072","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.240","host.ip":"172.28.2.240","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","storage.bytes":40816640,"storage.name":"system disk","storage.type":"fixedDisk","storage.utilization":30,"host.hostname":"NYC-S75-APT3208"}
    , {"@id":"hnKbjALLECUgiwU7","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","component.name":"unknown","host.address":"172.28.2.240","host.ip":"172.28.2.240","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3208"}
    , {"@id":"NhMhMfm5eyma6aQu","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.24","host.ip":"192.0.2.24","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4114"}
    , {"@id":"Y2ukasJgOlGGQTeG","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.24","host.ip":"192.0.2.24","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4114"}
    , {"@id":"FIB4hD9T81Y8OR40","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.24","host.ip":"192.0.2.24","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4114"}
    , {"@id":"mDNGVsx9sM7YlbDY","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.24","host.ip":"192.0.2.24","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4114"}
    , {"@id":"FA53GQlOmBjnU3aW","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.24","host.ip":"192.0.2.24","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4114"}
    , {"@id":"ucT45W7CFBRNyUse","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.24","host.ip":"192.0.2.24","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4114"}
    , {"@id":"ztQ3448LFCPQF7pc","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.24","host.ip":"192.0.2.24","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4114"}
    , {"@id":"17Mxg1cYcXLZoCrHI","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.24","host.ip":"192.0.2.24","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4114"}
    , {"@id":"1E7nJ7KhsbeZBIorX","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.24","host.ip":"192.0.2.24","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT4114"}
    , {"@id":"1E7nJ7SqEbzm9syUU","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.24","host.ip":"192.0.2.24","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT4114"}
    , {"@id":"1E7nJ7Vy3V7hsmf6z","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.24","host.ip":"192.0.2.24","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT4114"}
    , {"@id":"1E7nJ7UYHnjJL1IMq","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.24","host.ip":"192.0.2.24","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT4114"}
    , {"@id":"1F6PYPiHHMqGGyA2x","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.24","host.ip":"192.0.2.24","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan1","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4114"}
    , {"@id":"1F6PYPqPdNBTFYJfu","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.24","host.ip":"192.0.2.24","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4114"}
    , {"@id":"1F6PYPtXSGJOyS0IP","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.24","host.ip":"192.0.2.24","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":25922,"host.interface.egress.bits_per_second":279,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":25643,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether1","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT4114"}
    , {"@id":"1F6PYPs7gYv0QgdYG","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.24","host.ip":"192.0.2.24","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4114"}
    , {"@id":"1F6PYPs6lY6MGL5Yp","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"5","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.24","host.ip":"192.0.2.24","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether3","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4114"}
    , {"@id":"1F6PYPsIpmqozs11C","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"6","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.24","host.ip":"192.0.2.24","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether4","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4114"}
    , {"@id":"1F6PYPhSl9onuvA0n","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"7","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.24","host.ip":"192.0.2.24","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether5","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4114"}
    , {"@id":"1F6PYPsSnYNtLxDpk","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"8","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.24","host.ip":"192.0.2.24","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":17873,"host.interface.egress.bits_per_second":185,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":17688,"host.interface.ingress.errors_per_second":0,"host.interface.name":"bridge","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT4114"}
    , {"@id":"1F6PYPiDCWOmRqFiZ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"9","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.24","host.ip":"192.0.2.24","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1445,"host.interface.egress.bits_per_second":182,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1263,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan801-mgmt","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT4114"}
    , {"@id":"1F6PYPzpgrGL0StsQ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"10","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.24","host.ip":"192.0.2.24","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":14906,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":14906,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan802-inet","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT4114"}
    , {"@id":"OqfkPg2rzjjyR35j","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"65536","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.24","host.ip":"192.0.2.24","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.memory.utilization":22,"component.name":"main memory","storage.bytes":60674048,"storage.name":"main memory","storage.type":"ram","storage.utilization":22,"host.hostname":"NYC-S75-APT4114"}
    , {"@id":"OqfkPSgsPOtzmb8E","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"131072","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.24","host.ip":"192.0.2.24","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","storage.bytes":39976960,"storage.name":"system disk","storage.type":"fixedDisk","storage.utilization":29,"host.hostname":"NYC-S75-APT4114"}
    , {"@id":"hnKbjUEFQnceMRQS","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","component.name":"unknown","host.address":"192.0.2.24","host.ip":"192.0.2.24","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4114"}
    , {"@id":"NhMhMLtFz440CFU3","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.235","host.ip":"172.28.2.235","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3203"}
    , {"@id":"Y2ukaYQqiqXgW8hP","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.235","host.ip":"172.28.2.235","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3203"}
    , {"@id":"FIB4gtGdS6pYU679","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.235","host.ip":"172.28.2.235","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3203"}
    , {"@id":"mDNGVZ4KCROyrGGh","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.235","host.ip":"172.28.2.235","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3203"}
    , {"@id":"FA53G6sZ6H1DZidf","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.235","host.ip":"172.28.2.235","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3203"}
    , {"@id":"ucT45CEMZGio49vn","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.235","host.ip":"172.28.2.235","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3203"}
    , {"@id":"ztQ33kFVZHgqKmsl","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.235","host.ip":"172.28.2.235","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3203"}
    , {"@id":"17Mxg1IfmrQrEIWKR","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.235","host.ip":"172.28.2.235","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3203"}
    , {"@id":"1E7nJ7aMRwQ79RIfy","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.235","host.ip":"172.28.2.235","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT3203"}
    , {"@id":"1E7nJ7N5YI18DRFpZ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.235","host.ip":"172.28.2.235","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT3203"}
    , {"@id":"1E7nJ7TxTA4shB0q8","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.235","host.ip":"172.28.2.235","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT3203"}
    , {"@id":"1E7nJ7KFWkrgiMb9j","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.235","host.ip":"172.28.2.235","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT3203"}
    , {"@id":"1F6PYPxvqhboF6drO","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.235","host.ip":"172.28.2.235","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan1","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3203"}
    , {"@id":"1F6PYPkex3CpJ6b0z","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.235","host.ip":"172.28.2.235","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3203"}
    , {"@id":"1F6PYPrWrvGZmqM1Y","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.235","host.ip":"172.28.2.235","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":25924,"host.interface.egress.bits_per_second":281,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":25642,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether1","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3203"}
    , {"@id":"1F6PYPhovW3No1wL9","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.235","host.ip":"172.28.2.235","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3203"}
    , {"@id":"1F6PYPxyuDoicDDhu","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"5","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.235","host.ip":"172.28.2.235","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether3","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3203"}
    , {"@id":"1F6PYPmi7EZgixP3V","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"6","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.235","host.ip":"172.28.2.235","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether4","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3203"}
    , {"@id":"1F6PYPh1mlEQX5qQ8","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"7","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.235","host.ip":"172.28.2.235","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether5","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3203"}
    , {"@id":"1F6PYPsxMr1gDA9xb","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"8","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.235","host.ip":"172.28.2.235","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":17959,"host.interface.egress.bits_per_second":252,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":17707,"host.interface.ingress.errors_per_second":0,"host.interface.name":"bridge","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3203"}
    , {"@id":"1F6PYPvH1oBiqi5Ni","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"9","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.235","host.ip":"172.28.2.235","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1520,"host.interface.egress.bits_per_second":248,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1272,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan801-mgmt","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3203"}
    , {"@id":"1F6PYPo3moXkKSWtd","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"10","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.235","host.ip":"172.28.2.235","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":14915,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":14915,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan802-inet","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3203"}
    , {"@id":"OqfkPMQFjXTFEP1G","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"65536","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.235","host.ip":"172.28.2.235","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.memory.utilization":22,"component.name":"main memory","storage.bytes":59572224,"storage.name":"main memory","storage.type":"ram","storage.utilization":22,"host.hostname":"NYC-S75-APT3203"}
    , {"@id":"OqfkPXkBd9hyEc2z","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"131072","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.235","host.ip":"172.28.2.235","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","storage.bytes":39731200,"storage.name":"system disk","storage.type":"fixedDisk","storage.utilization":29,"host.hostname":"NYC-S75-APT3203"}
    , {"@id":"hnKbjALPksu4S6Tb","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","component.name":"unknown","host.address":"172.28.2.235","host.ip":"172.28.2.235","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3203"}
    , {"@id":"NhMhMfljkWDazS68","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.95","host.ip":"192.0.2.95","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT5215"}
    , {"@id":"Y2ukasJKUIhHJLJU","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.95","host.ip":"192.0.2.95","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT5215"}
    , {"@id":"FIB4hD97DYz9HIjE","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.95","host.ip":"192.0.2.95","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT5215"}
    , {"@id":"mDNGVswnxtYZeSsm","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.95","host.ip":"192.0.2.95","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT5215"}
    , {"@id":"FA53GQl2rjAoMvFk","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.95","host.ip":"192.0.2.95","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT5215"}
    , {"@id":"ucT45W6qKisOrMXs","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.95","host.ip":"192.0.2.95","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT5215"}
    , {"@id":"ztQ3447zKjqR7zUq","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.95","host.ip":"192.0.2.95","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT5215"}
    , {"@id":"17Mxg1cYGct0p5iwW","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.95","host.ip":"192.0.2.95","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT5215"}
    , {"@id":"1E7nJ7Kh6u0n62Cyd","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.95","host.ip":"192.0.2.95","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT5215"}
    , {"@id":"1E7nJ7SqjYZjFFT66","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.95","host.ip":"192.0.2.95","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT5215"}
    , {"@id":"1E7nJ7VygtbZnKaLh","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.95","host.ip":"192.0.2.95","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT5215"}
    , {"@id":"1E7nJ7UZ49Kqgyj1s","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.95","host.ip":"192.0.2.95","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT5215"}
    , {"@id":"1F6PYPiGVfCUBhYA3","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.95","host.ip":"192.0.2.95","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan1","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT5215"}
    , {"@id":"1F6PYPqQ8JlQKuoHW","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.95","host.ip":"192.0.2.95","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT5215"}
    , {"@id":"1F6PYPtY5enGszvX7","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.95","host.ip":"192.0.2.95","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":25924,"host.interface.egress.bits_per_second":279,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":25644,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether1","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT5215"}
    , {"@id":"1F6PYPs8SuWXme4DI","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.95","host.ip":"192.0.2.95","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT5215"}
    , {"@id":"1F6PYPs5zCUouNetn","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"5","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.95","host.ip":"192.0.2.95","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether3","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT5215"}
    , {"@id":"1F6PYPsICOMx5K5mU","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"6","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.95","host.ip":"192.0.2.95","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether4","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT5215"}
    , {"@id":"1F6PYPhTP7GiRK3B7","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"7","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.95","host.ip":"192.0.2.95","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether5","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT5215"}
    , {"@id":"1F6PYPsSRdvKMq5Uy","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"8","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.95","host.ip":"192.0.2.95","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":17929,"host.interface.egress.bits_per_second":250,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":17678,"host.interface.ingress.errors_per_second":0,"host.interface.name":"bridge","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT5215"}
    , {"@id":"1F6PYPiDYQrLQxO3L","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"9","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.95","host.ip":"192.0.2.95","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1509,"host.interface.egress.bits_per_second":246,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1262,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan801-mgmt","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT5215"}
    , {"@id":"1F6PYPzp3XmBkkpUE","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"10","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.95","host.ip":"192.0.2.95","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":14898,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":14898,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan802-inet","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT5215"}
    , {"@id":"OqfkPg3DuCIxYBQV","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"65536","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.95","host.ip":"192.0.2.95","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.memory.utilization":21,"component.name":"main memory","storage.bytes":58904576,"storage.name":"main memory","storage.type":"ram","storage.utilization":21,"host.hostname":"NYC-S75-APT5215"}
    , {"@id":"OqfkPShMi15oSGxi","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"131072","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.95","host.ip":"192.0.2.95","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","storage.bytes":40251392,"storage.name":"system disk","storage.type":"fixedDisk","storage.utilization":29,"host.hostname":"NYC-S75-APT5215"}
    , {"@id":"hnKbjUDtWL3fFJ5g","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","component.name":"unknown","host.address":"192.0.2.95","host.ip":"192.0.2.95","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT5215"}
    , {"@id":"NhMhMUU5eyJwtbuK","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.12","host.ip":"172.28.2.12","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-SW01-02"}
    , {"@id":"Y2ukah1gOkndDV7g","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.12","host.ip":"172.28.2.12","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-SW01-02"}
    , {"@id":"FIB4h1rT815VBSXQ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.12","host.ip":"172.28.2.12","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-SW01-02"}
    , {"@id":"mDNGVhf9sLevYcgy","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.12","host.ip":"172.28.2.12","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-SW01-02"}
    , {"@id":"FA53GFTOmBHAH53w","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.12","host.ip":"172.28.2.12","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-SW01-02"}
    , {"@id":"ucT45KpCFAyklWM4","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.12","host.ip":"172.28.2.12","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-SW01-02"}
    , {"@id":"ztQ33sqLFBwn29J2","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.12","host.ip":"172.28.2.12","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-SW01-02"}
    , {"@id":"17Mxg1RGcXL7Azski","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.12","host.ip":"172.28.2.12","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-SW01-02"}
    , {"@id":"1E7nJ7VzsXujosuFj","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.12","host.ip":"172.28.2.12","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":4,"component.name":"","host.hostname":"NYC-S75-SW01-02"}
    , {"@id":"1F6PYPtZHJ6QuYFR9","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.12","host.ip":"172.28.2.12","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1664993,"host.interface.egress.bits_per_second":1664259,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":733,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether1","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-02"}
    , {"@id":"1F6PYPfGOoV0WaAeU","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.12","host.ip":"172.28.2.12","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1664813,"host.interface.egress.bits_per_second":1664531,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether2","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-02"}
    , {"@id":"1F6PYPmUaTqY1B2rF","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.12","host.ip":"172.28.2.12","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether3","host.interface.oper_status":"down","host.hostname":"NYC-S75-SW01-02"}
    , {"@id":"1F6PYPzAphuaK8bca","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.12","host.ip":"172.28.2.12","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1664807,"host.interface.egress.bits_per_second":1664526,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether4","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-02"}
    , {"@id":"1F6PYPfUWuIXj8K7X","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"5","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.12","host.ip":"172.28.2.12","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1664814,"host.interface.egress.bits_per_second":1664532,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether5","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-02"}
    , {"@id":"1F6PYPh9bGfDbJnQ2","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"6","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.12","host.ip":"172.28.2.12","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1664805,"host.interface.egress.bits_per_second":1664524,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether6","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-02"}
    , {"@id":"1F6PYPsl30KJRKGFd","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"7","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.12","host.ip":"172.28.2.12","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1664781,"host.interface.egress.bits_per_second":1664500,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether7","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-02"}
    , {"@id":"1F6PYPkoKjSGcfVgm","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"8","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.12","host.ip":"172.28.2.12","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1664789,"host.interface.egress.bits_per_second":1664508,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether8","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-02"}
    , {"@id":"1F6PYPtM9g3euDSgZ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"9","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.12","host.ip":"172.28.2.12","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1664817,"host.interface.egress.bits_per_second":1664536,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether9","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-02"}
    , {"@id":"1F6PYPl2v7V2NZUTO","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"10","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.12","host.ip":"172.28.2.12","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1664858,"host.interface.egress.bits_per_second":1664576,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether10","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-02"}
    , {"@id":"1F6PYQ0bZINuArA3Z","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"11","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.12","host.ip":"172.28.2.12","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1664822,"host.interface.egress.bits_per_second":1664541,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether11","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-02"}
    , {"@id":"1F6PYPkd39TedH40C","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"12","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.12","host.ip":"172.28.2.12","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1664838,"host.interface.egress.bits_per_second":1664557,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether12","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-02"}
    , {"@id":"1F6PYPgvW9KTA7jkB","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"13","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.12","host.ip":"172.28.2.12","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1664837,"host.interface.egress.bits_per_second":1664556,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether13","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-02"}
    , {"@id":"1F6PYPwmoFSCRfhmk","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"14","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.12","host.ip":"172.28.2.12","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1664846,"host.interface.egress.bits_per_second":1664565,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether14","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-02"}
    , {"@id":"1F6PYPie7eRtrLecr","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"15","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.12","host.ip":"172.28.2.12","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether15","host.interface.oper_status":"down","host.hostname":"NYC-S75-SW01-02"}
    , {"@id":"1F6PYPsmmBzHS4QnY","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"16","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.12","host.ip":"172.28.2.12","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1664850,"host.interface.egress.bits_per_second":1664569,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether16","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-02"}
    , {"@id":"1F6PYPpd58euRj5kl","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"17","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.12","host.ip":"172.28.2.12","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1701665,"host.interface.egress.bits_per_second":1641406,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":60259,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether17","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-02"}
    , {"@id":"1F6PYPiep2xQGwDeo","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"18","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.12","host.ip":"172.28.2.12","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1664832,"host.interface.egress.bits_per_second":1664551,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether18","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-02"}
    , {"@id":"1F6PYPhDKH4kUSvLR","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"19","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.12","host.ip":"172.28.2.12","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":2771679,"host.interface.egress.bits_per_second":2542579,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":229099,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether19","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-02"}
    , {"@id":"1F6PYPiiBGH8qxMOC","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"20","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.12","host.ip":"172.28.2.12","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether20","host.interface.oper_status":"down","host.hostname":"NYC-S75-SW01-02"}
    , {"@id":"1F6PYPr6gCqDDfkuJ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"21","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.12","host.ip":"172.28.2.12","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether21","host.interface.oper_status":"down","host.hostname":"NYC-S75-SW01-02"}
    , {"@id":"1F6PYPuyvbNFEmxPW","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"22","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.12","host.ip":"172.28.2.12","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether22","host.interface.oper_status":"down","host.hostname":"NYC-S75-SW01-02"}
    , {"@id":"1F6PYPfSV5tvSLD69","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"23","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.12","host.ip":"172.28.2.12","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether23","host.interface.oper_status":"down","host.hostname":"NYC-S75-SW01-02"}
    , {"@id":"1F6PYPn3KqPQaDuwS","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"24","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.12","host.ip":"172.28.2.12","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether24","host.interface.oper_status":"down","host.hostname":"NYC-S75-SW01-02"}
    , {"@id":"1F6PYPlfEECBQfmaN","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"25","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.12","host.ip":"172.28.2.12","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"sfp-sfpplus1","host.interface.oper_status":"notPresent","host.hostname":"NYC-S75-SW01-02"}
    , {"@id":"1F6PYPxxILYwckgxy","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"26","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.12","host.ip":"172.28.2.12","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"sfp-sfpplus2","host.interface.oper_status":"notPresent","host.hostname":"NYC-S75-SW01-02"}
    , {"@id":"1F6PYPr9TnlvyeJOn","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"27","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.12","host.ip":"172.28.2.12","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":2812117,"host.interface.egress.bits_per_second":290718,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":2521398,"host.interface.ingress.errors_per_second":0,"host.interface.name":"sfp-sfpplus3","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-02"}
    , {"@id":"1F6PYPgSfnYtntOjs","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"28","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.12","host.ip":"172.28.2.12","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1664235,"host.interface.egress.bits_per_second":1664235,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"sfp-sfpplus4","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-02"}
    , {"@id":"1F6PYPrCprLUr6hEh","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"29","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.12","host.ip":"172.28.2.12","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":19771,"host.interface.egress.bits_per_second":1342,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":18428,"host.interface.ingress.errors_per_second":0,"host.interface.name":"bridge","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-02"}
    , {"@id":"1F6PYPsjPyfYs3I4A","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"30","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.12","host.ip":"172.28.2.12","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":3045,"host.interface.egress.bits_per_second":1321,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1724,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan801-mgmt","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-02"}
    , {"@id":"OqfkPVMBePtVqqvf","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"65536","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.12","host.ip":"172.28.2.12","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.memory.utilization":7,"component.name":"main memory","storage.bytes":40869888,"storage.name":"main memory","storage.type":"ram","storage.utilization":7,"host.hostname":"NYC-S75-SW01-02"}
    , {"@id":"OqfkPZjjWeZ19m58","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"131072","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.12","host.ip":"172.28.2.12","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","storage.bytes":14454784,"storage.name":"system disk","storage.type":"fixedDisk","storage.utilization":86,"host.hostname":"NYC-S75-SW01-02"}
    , {"@id":"hnKbjIwFQnA19Sts","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","component.name":"unknown","host.address":"172.28.2.12","host.ip":"172.28.2.12","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-SW01-02"}
    , {"@id":"NhMhMecMxmVbY0q0","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.2","host.ip":"192.0.2.2","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3308"}
    , {"@id":"Y2ukar9xhYzHru3M","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.2","host.ip":"192.0.2.2","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3308"}
    , {"@id":"FIB4hBzkQpH9prT6","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.2","host.ip":"192.0.2.2","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3308"}
    , {"@id":"mDNGVrnRB9qaD1ce","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.2","host.ip":"192.0.2.2","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3308"}
    , {"@id":"FA53GPbg4zSovTzc","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.2","host.ip":"192.0.2.2","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3308"}
    , {"@id":"ucT45UxTXzAPPvHk","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.2","host.ip":"192.0.2.2","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3308"}
    , {"@id":"ztQ342ycY08RgYEi","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.2","host.ip":"192.0.2.2","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3308"}
    , {"@id":"17Mxg1bOtq9IpeHgO","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.2","host.ip":"192.0.2.2","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3308"}
    , {"@id":"1E7nJ7d6qyWdnZIUD","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.2","host.ip":"192.0.2.2","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT3308"}
    , {"@id":"1E7nJ7YaSTGuLqPFy","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.2","host.ip":"192.0.2.2","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT3308"}
    , {"@id":"1E7nJ7ZTv0OE3zcrj","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.2","host.ip":"192.0.2.2","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT3308"}
    , {"@id":"1E7nJ7QnvunAgGE9M","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.2","host.ip":"192.0.2.2","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT3308"}
    , {"@id":"1F6PYQ0gFjiKtEdfd","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.2","host.ip":"192.0.2.2","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan1","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3308"}
    , {"@id":"1F6PYPw9rESbRVkRO","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.2","host.ip":"192.0.2.2","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3308"}
    , {"@id":"1F6PYPx3JlZv9ey39","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.2","host.ip":"192.0.2.2","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":27801,"host.interface.egress.bits_per_second":281,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":27519,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether1","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3308"}
    , {"@id":"1F6PYPoNKfyrlvZKm","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.2","host.ip":"192.0.2.2","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3308"}
    , {"@id":"1F6PYPxbe5rcD2BQL","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"5","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.2","host.ip":"192.0.2.2","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether3","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3308"}
    , {"@id":"1F6PYPuFSswJ3Hv6E","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"6","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.2","host.ip":"192.0.2.2","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether4","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3308"}
    , {"@id":"1F6PYPoSimSXtfsTP","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"7","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.2","host.ip":"192.0.2.2","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether5","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3308"}
    , {"@id":"1F6PYPtLAaePpGgYq","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"8","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.2","host.ip":"192.0.2.2","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":18065,"host.interface.egress.bits_per_second":351,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":17713,"host.interface.ingress.errors_per_second":0,"host.interface.name":"bridge","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3308"}
    , {"@id":"1F6PYPixbUZZot8Lx","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"9","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.2","host.ip":"192.0.2.2","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1527,"host.interface.egress.bits_per_second":247,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1279,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan801-mgmt","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3308"}
    , {"@id":"1F6PYPwVKz9WYpcGw","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"10","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.2","host.ip":"192.0.2.2","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":14913,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":14913,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan802-inet","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3308"}
    , {"@id":"OqfkPWm4KHd6vLFh","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"65536","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.2","host.ip":"192.0.2.2","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.memory.utilization":22,"component.name":"main memory","storage.bytes":59846656,"storage.name":"main memory","storage.type":"ram","storage.utilization":22,"host.hostname":"NYC-S75-APT3308"}
    , {"@id":"OqfkPdrECsakPFze","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"131072","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.2","host.ip":"192.0.2.2","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","storage.bytes":39735296,"storage.name":"system disk","storage.type":"fixedDisk","storage.utilization":29,"host.hostname":"NYC-S75-APT3308"}
    , {"@id":"hnKbjT4WjbLfnrpY","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","component.name":"unknown","host.address":"192.0.2.2","host.ip":"192.0.2.2","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3308"}
    , {"@id":"NhMhMMdmmbddyoso","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.175","host.ip":"172.28.2.175","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2120"}
    , {"@id":"Y2ukaZBNWO7KIi6A","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.175","host.ip":"172.28.2.175","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2120"}
    , {"@id":"FIB4gu1AFePCGfVu","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.175","host.ip":"172.28.2.175","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2120"}
    , {"@id":"mDNGVZoqzyycdpfS","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.175","host.ip":"172.28.2.175","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2120"}
    , {"@id":"FA53G7d5toarMI2Q","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.175","host.ip":"172.28.2.175","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2120"}
    , {"@id":"ucT45CytMoIRqjKY","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.175","host.ip":"172.28.2.175","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2120"}
    , {"@id":"ztQ33l02MpGU7MHW","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.175","host.ip":"172.28.2.175","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2120"}
    , {"@id":"17Mxg1JQJeyQs55jC","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.175","host.ip":"172.28.2.175","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2120"}
    , {"@id":"1E7nJ7ZZfGi66CQ3j","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.175","host.ip":"172.28.2.175","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT2120"}
    , {"@id":"1E7nJ7Ktv2AQDtv4i","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.175","host.ip":"172.28.2.175","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT2120"}
    , {"@id":"1E7nJ7W6qNlhxaKgT","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.175","host.ip":"172.28.2.175","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT2120"}
    , {"@id":"1E7nJ7L1lBUZqGZak","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.175","host.ip":"172.28.2.175","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":1,"component.name":"","host.hostname":"NYC-S75-APT2120"}
    , {"@id":"1F6PYPx941tnBrlF9","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.175","host.ip":"172.28.2.175","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":2538,"host.interface.egress.bits_per_second":1429,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1108,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan1","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT2120"}
    , {"@id":"1F6PYPiTJnM7JZGG8","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.175","host.ip":"172.28.2.175","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT2120"}
    , {"@id":"1F6PYPtgF8xP3Ffrt","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.175","host.ip":"172.28.2.175","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":28368,"host.interface.egress.bits_per_second":1419,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":26948,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether1","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT2120"}
    , {"@id":"1F6PYPib9wgGvvumA","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.175","host.ip":"172.28.2.175","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT2120"}
    , {"@id":"1F6PYPxCfnBpUJFGt","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"5","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.175","host.ip":"172.28.2.175","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether3","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT2120"}
    , {"@id":"1F6PYPkYB7pyGWMFo","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"6","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.175","host.ip":"172.28.2.175","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether4","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT2120"}
    , {"@id":"1F6PYPjKmIXCRQaQ9","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"7","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.175","host.ip":"172.28.2.175","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether5","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT2120"}
    , {"@id":"1F6PYPthteZFqwjMM","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"8","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.175","host.ip":"172.28.2.175","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":22248,"host.interface.egress.bits_per_second":2483,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":19765,"host.interface.ingress.errors_per_second":0,"host.interface.name":"bridge","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT2120"}
    , {"@id":"1F6PYPuWVAdaWbDfz","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"9","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.175","host.ip":"172.28.2.175","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1341,"host.interface.egress.bits_per_second":156,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1184,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan801-mgmt","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT2120"}
    , {"@id":"1F6PYPllMoFcsqKd6","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"10","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.175","host.ip":"172.28.2.175","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":17114,"host.interface.egress.bits_per_second":1077,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":16037,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan802-inet","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT2120"}
    , {"@id":"OqfkPLfiS1ZeQiXP","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"65536","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.175","host.ip":"172.28.2.175","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.memory.utilization":23,"component.name":"main memory","storage.bytes":62251008,"storage.name":"main memory","storage.type":"ram","storage.utilization":23,"host.hostname":"NYC-S75-APT2120"}
    , {"@id":"OqfkPVPUwjwWna5o","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"131072","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.175","host.ip":"172.28.2.175","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","storage.bytes":39952384,"storage.name":"system disk","storage.type":"fixedDisk","storage.utilization":29,"host.hostname":"NYC-S75-APT2120"}
    , {"@id":"hnKbjB5wYQTiEfsM","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","component.name":"unknown","host.address":"172.28.2.175","host.ip":"172.28.2.175","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2120"}
    , {"@id":"NhMhMMdZo1JR4EGE","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.104","host.ip":"172.28.2.104","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT1105"}
    , {"@id":"Y2ukaZBAXnn7O7Ta","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.104","host.ip":"172.28.2.104","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT1105"}
    , {"@id":"FIB4gu0xH44zM4tK","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.104","host.ip":"172.28.2.104","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT1105"}
    , {"@id":"mDNGVZoe1OePjF2s","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.104","host.ip":"172.28.2.104","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT1105"}
    , {"@id":"FA53G7csvEGeRhPq","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.104","host.ip":"172.28.2.104","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT1105"}
    , {"@id":"ucT45CygODyEw8hy","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.104","host.ip":"172.28.2.104","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT1105"}
    , {"@id":"ztQ33kzpOEwHClew","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.104","host.ip":"172.28.2.104","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT1105"}
    , {"@id":"17Mxg1JQ6gO6fAV6c","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.104","host.ip":"172.28.2.104","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT1105"}
    , {"@id":"1E7nJ7Za9ZKHus5tD","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.104","host.ip":"172.28.2.104","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT1105"}
    , {"@id":"1E7nJ7KtQ5aT8XQT6","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.104","host.ip":"172.28.2.104","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT1105"}
    , {"@id":"1E7nJ7W73MM2AUvJ3","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.104","host.ip":"172.28.2.104","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT1105"}
    , {"@id":"1E7nJ7L275x8pNhvW","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.104","host.ip":"172.28.2.104","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT1105"}
    , {"@id":"1F6PYPx9YKVz0XR4d","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.104","host.ip":"172.28.2.104","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan1","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT1105"}
    , {"@id":"1F6PYPiSoqmAECleW","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.104","host.ip":"172.28.2.104","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT1105"}
    , {"@id":"1F6PYPtgS7XjGAGUT","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.104","host.ip":"172.28.2.104","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1673575,"host.interface.egress.bits_per_second":281,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1673293,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether1","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT1105"}
    , {"@id":"1F6PYPibVr8pv336w","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.104","host.ip":"172.28.2.104","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT1105"}
    , {"@id":"1F6PYPxCbHkqln2zX","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"5","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.104","host.ip":"172.28.2.104","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether3","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT1105"}
    , {"@id":"1F6PYPkYFdGwz2YXA","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"6","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.104","host.ip":"172.28.2.104","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether4","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT1105"}
    , {"@id":"1F6PYPjKQO4dSJS5N","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"7","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.104","host.ip":"172.28.2.104","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether5","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT1105"}
    , {"@id":"1F6PYPthgfyve28jm","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"8","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.104","host.ip":"172.28.2.104","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":18017,"host.interface.egress.bits_per_second":351,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":17665,"host.interface.ingress.errors_per_second":0,"host.interface.name":"bridge","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT1105"}
    , {"@id":"1F6PYPuWzTFmLGtVT","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"9","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.104","host.ip":"172.28.2.104","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1488,"host.interface.egress.bits_per_second":248,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1240,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan801-mgmt","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT1105"}
    , {"@id":"1F6PYPlksVdR4Aenc","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"10","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.104","host.ip":"172.28.2.104","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":14908,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":14908,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan802-inet","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT1105"}
    , {"@id":"OqfkPLgDObWjnD91","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"65536","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.104","host.ip":"172.28.2.104","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.memory.utilization":22,"component.name":"main memory","storage.bytes":59387904,"storage.name":"main memory","storage.type":"ram","storage.utilization":22,"host.hostname":"NYC-S75-APT1105"}
    , {"@id":"OqfkPVP0e7ki7uGK","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"131072","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.104","host.ip":"172.28.2.104","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","storage.bytes":40091648,"storage.name":"system disk","storage.type":"fixedDisk","storage.utilization":29,"host.hostname":"NYC-S75-APT1105"}
    , {"@id":"hnKbjB5jZq9VK5Fm","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","component.name":"unknown","host.address":"172.28.2.104","host.ip":"172.28.2.104","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT1105"}
    , {"@id":"NhMhMLtP5F6GNEoo","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.210","host.ip":"172.28.2.210","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2315"}
    , {"@id":"Y2ukaYQzp1Zwh82A","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.210","host.ip":"172.28.2.210","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2315"}
    , {"@id":"FIB4gtGmYHrof5Ru","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.210","host.ip":"172.28.2.210","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2315"}
    , {"@id":"mDNGVZ4TIcRF2FbS","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.210","host.ip":"172.28.2.210","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2315"}
    , {"@id":"FA53G6siCS3TkhyQ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.210","host.ip":"172.28.2.210","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2315"}
    , {"@id":"ucT45CEVfRl4F9GY","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.210","host.ip":"172.28.2.210","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2315"}
    , {"@id":"ztQ33kFefSj6VmDW","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.210","host.ip":"172.28.2.210","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2315"}
    , {"@id":"17Mxg1IfvxbtUTVfC","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.210","host.ip":"172.28.2.210","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2315"}
    , {"@id":"1E7nJ7aMaqjZ688kV","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.210","host.ip":"172.28.2.210","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT2315"}
    , {"@id":"1E7nJ7N5Prg0DlWq8","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.210","host.ip":"172.28.2.210","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT2315"}
    , {"@id":"1E7nJ7TxK6OhlPwvd","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.210","host.ip":"172.28.2.210","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT2315"}
    , {"@id":"1E7nJ7KFfoXre7f4E","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.210","host.ip":"172.28.2.210","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT2315"}
    , {"@id":"1F6PYPxvzbvGBnTvv","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.210","host.ip":"172.28.2.210","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan1","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT2315"}
    , {"@id":"1F6PYPkeocrhJQs1Y","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.210","host.ip":"172.28.2.210","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT2315"}
    , {"@id":"1F6PYPrWiraOr5I73","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.210","host.ip":"172.28.2.210","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":32814,"host.interface.egress.bits_per_second":243,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":32571,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether1","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT2315"}
    , {"@id":"1F6PYPhp4ZjYjn0Fe","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.210","host.ip":"172.28.2.210","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT2315"}
    , {"@id":"1F6PYPxz2WfGcdAQZ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"5","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.210","host.ip":"172.28.2.210","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether3","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT2315"}
    , {"@id":"1F6PYPmhyvj8iXSKq","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"6","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.210","host.ip":"172.28.2.210","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether4","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT2315"}
    , {"@id":"1F6PYPh1eT0arHNYX","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"7","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.210","host.ip":"172.28.2.210","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether5","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT2315"}
    , {"@id":"1F6PYPsxVJExCeKWE","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"8","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.210","host.ip":"172.28.2.210","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":17946,"host.interface.egress.bits_per_second":265,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":17680,"host.interface.ingress.errors_per_second":0,"host.interface.name":"bridge","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT2315"}
    , {"@id":"1F6PYPvHAsUc74d9H","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"9","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.210","host.ip":"172.28.2.210","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1411,"host.interface.egress.bits_per_second":163,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1248,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan801-mgmt","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT2315"}
    , {"@id":"1F6PYPo3eOCcKmnuC","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"10","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.210","host.ip":"172.28.2.210","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":14914,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":14914,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan802-inet","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT2315"}
    , {"@id":"OqfkPMQO9sbEu80h","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"65536","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.210","host.ip":"172.28.2.210","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.memory.utilization":21,"component.name":"main memory","storage.bytes":59031552,"storage.name":"main memory","storage.type":"ram","storage.utilization":21,"host.hostname":"NYC-S75-APT2315"}
    , {"@id":"OqfkPXk2Yqohs4HQ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"131072","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.210","host.ip":"172.28.2.210","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","storage.bytes":40071168,"storage.name":"system disk","storage.type":"fixedDisk","storage.utilization":29,"host.hostname":"NYC-S75-APT2315"}
    , {"@id":"hnKbjALYr3wKd5oM","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","component.name":"unknown","host.address":"172.28.2.210","host.ip":"172.28.2.210","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2315"}
    , {"@id":"NhMhMfmW5oOme8pd","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.41","host.ip":"192.0.2.41","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4213"}
    , {"@id":"Y2ukasK6pasSy22z","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.41","host.ip":"192.0.2.41","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4213"}
    , {"@id":"FIB4hD9tYrAKvzSj","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.41","host.ip":"192.0.2.41","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4213"}
    , {"@id":"mDNGVsxaJBjlJ9cH","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.41","host.ip":"192.0.2.41","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4213"}
    , {"@id":"FA53GQlpD1M01bzF","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.41","host.ip":"192.0.2.41","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4213"}
    , {"@id":"ucT45W7cg13aW3HN","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.41","host.ip":"192.0.2.41","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4213"}
    , {"@id":"ztQ3448lg21cmgEL","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.41","host.ip":"192.0.2.41","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4213"}
    , {"@id":"17Mxg1cZ2yBC0kPg1","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.41","host.ip":"192.0.2.41","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4213"}
    , {"@id":"1E7nJ7Ki1fKk73sm2","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.41","host.ip":"192.0.2.41","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT4213"}
    , {"@id":"1E7nJ7SponFmEDnIh","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.41","host.ip":"192.0.2.41","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT4213"}
    , {"@id":"1E7nJ7VyTvKbkijee","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.41","host.ip":"192.0.2.41","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":1,"component.name":"","host.hostname":"NYC-S75-APT4213"}
    , {"@id":"1E7nJ7UY8k38PGESL","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.41","host.ip":"192.0.2.41","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT4213"}
    , {"@id":"1F6PYPiHQQWRCjDxS","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.41","host.ip":"192.0.2.41","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan1","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4213"}
    , {"@id":"1F6PYPqPDYRTJt8U7","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.41","host.ip":"192.0.2.41","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4213"}
    , {"@id":"1F6PYPtXsgWIqO4q4","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.41","host.ip":"192.0.2.41","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":25959,"host.interface.egress.bits_per_second":279,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":25679,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether1","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT4213"}
    , {"@id":"1F6PYPs7XVEpUvZdl","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.41","host.ip":"192.0.2.41","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4213"}
    , {"@id":"1F6PYPs6L7Gk3nXA6","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"5","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.41","host.ip":"192.0.2.41","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether3","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4213"}
    , {"@id":"1F6PYPsIyjf8GymVz","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"6","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.41","host.ip":"192.0.2.41","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether4","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4213"}
    , {"@id":"1F6PYPhScjTfvFR1M","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"7","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.41","host.ip":"192.0.2.41","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether5","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4213"}
    , {"@id":"1F6PYPsTDzDVYUmET","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"8","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.41","host.ip":"192.0.2.41","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":17960,"host.interface.egress.bits_per_second":250,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":17709,"host.interface.ingress.errors_per_second":0,"host.interface.name":"bridge","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT4213"}
    , {"@id":"1F6PYPiDLa4xNbJd4","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"9","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.41","host.ip":"192.0.2.41","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1530,"host.interface.egress.bits_per_second":246,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1283,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan801-mgmt","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT4213"}
    , {"@id":"1F6PYPzpH2WL4nigd","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"10","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.41","host.ip":"192.0.2.41","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":14906,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":14906,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan802-inet","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT4213"}
    , {"@id":"OqfkPg30PS9dVIE6","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"65536","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.41","host.ip":"192.0.2.41","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.memory.utilization":21,"component.name":"main memory","storage.bytes":58638336,"storage.name":"main memory","storage.type":"ram","storage.utilization":21,"host.hostname":"NYC-S75-APT4213"}
    , {"@id":"OqfkPSgRwh8nQbAJ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"131072","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.41","host.ip":"192.0.2.41","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","storage.bytes":40017920,"storage.name":"system disk","storage.type":"fixedDisk","storage.utilization":29,"host.hostname":"NYC-S75-APT4213"}
    , {"@id":"hnKbjUEfrdEqtzpB","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","component.name":"unknown","host.address":"192.0.2.41","host.ip":"192.0.2.41","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4213"}
    , {"@id":"NhMhMLtBSh0mlpQ6","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.243","host.ip":"172.28.2.243","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3211"}
    , {"@id":"Y2ukaYQmCTUT5idS","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.243","host.ip":"172.28.2.243","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3211"}
    , {"@id":"FIB4gtGYvjmL3g3C","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.243","host.ip":"172.28.2.243","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3211"}
    , {"@id":"mDNGVZ4Fg4LlQqCk","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.243","host.ip":"172.28.2.243","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3211"}
    , {"@id":"FA53G6sUZty09IZi","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.243","host.ip":"172.28.2.243","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3211"}
    , {"@id":"ucT45CEI2tfadjrq","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.243","host.ip":"172.28.2.243","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3211"}
    , {"@id":"ztQ33kFR2udcuMoo","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.243","host.ip":"172.28.2.243","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3211"}
    , {"@id":"17Mxg1IfiL3o0s6GU","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.243","host.ip":"172.28.2.243","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3211"}
    , {"@id":"1E7nJ7aMnpJtJ2jN5","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.243","host.ip":"172.28.2.243","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT3211"}
    , {"@id":"1E7nJ7N5lkt8XfhSm","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.243","host.ip":"172.28.2.243","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT3211"}
    , {"@id":"1E7nJ7TwyDBZRVmIz","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.243","host.ip":"172.28.2.243","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":1,"component.name":"","host.hostname":"NYC-S75-APT3211"}
    , {"@id":"1E7nJ7KG1j0QdEnP0","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.243","host.ip":"172.28.2.243","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT3211"}
    , {"@id":"1F6PYPxwCaVaOi4YV","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.243","host.ip":"172.28.2.243","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan1","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3211"}
    , {"@id":"1F6PYPkfAW4pdL2eC","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.243","host.ip":"172.28.2.243","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3211"}
    , {"@id":"1F6PYPrWMyNGXB7UP","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.243","host.ip":"172.28.2.243","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":25903,"host.interface.egress.bits_per_second":281,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":25622,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether1","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3211"}
    , {"@id":"1F6PYPhpQUC7iu8aQ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.243","host.ip":"172.28.2.243","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3211"}
    , {"@id":"1F6PYPxygcChdW25n","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"5","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.243","host.ip":"172.28.2.243","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether3","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3211"}
    , {"@id":"1F6PYPmhlHvcZj5E0","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"6","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.243","host.ip":"172.28.2.243","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether4","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3211"}
    , {"@id":"1F6PYPh1rIquPjECD","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"7","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.243","host.ip":"172.28.2.243","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether5","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3211"}
    , {"@id":"1F6PYPsxIKeczjjte","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"8","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.243","host.ip":"172.28.2.243","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":17931,"host.interface.egress.bits_per_second":252,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":17678,"host.interface.ingress.errors_per_second":0,"host.interface.name":"bridge","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3211"}
    , {"@id":"1F6PYPvHNh5V0JW4p","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"9","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.243","host.ip":"172.28.2.243","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1499,"host.interface.egress.bits_per_second":248,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1251,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan801-mgmt","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3211"}
    , {"@id":"1F6PYPo40RPByMgDs","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"10","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.243","host.ip":"172.28.2.243","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":14909,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":14909,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan802-inet","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3211"}
    , {"@id":"OqfkPMQbcRFOppiN","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"65536","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.243","host.ip":"172.28.2.243","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.memory.utilization":22,"component.name":"main memory","storage.bytes":59465728,"storage.name":"main memory","storage.type":"ram","storage.utilization":22,"host.hostname":"NYC-S75-APT3211"}
    , {"@id":"OqfkPXkOS3x1mEu4","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"131072","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.243","host.ip":"172.28.2.243","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","storage.bytes":40812544,"storage.name":"system disk","storage.type":"fixedDisk","storage.utilization":30,"host.hostname":"NYC-S75-APT3211"}
    , {"@id":"hnKbjALLEVqr1gPe","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","component.name":"unknown","host.address":"172.28.2.243","host.ip":"172.28.2.243","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3211"}
    , {"@id":"NhMhMfm5fur50oDV","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.27","host.ip":"192.0.2.27","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4117"}
    , {"@id":"Y2ukasJgPhKlKhQr","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.27","host.ip":"192.0.2.27","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4117"}
    , {"@id":"FIB4hD9T8xcdIeqb","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.27","host.ip":"192.0.2.27","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4117"}
    , {"@id":"mDNGVsx9tIC3fp09","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.27","host.ip":"192.0.2.27","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4117"}
    , {"@id":"FA53GQlOn7oIOHN7","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.27","host.ip":"192.0.2.27","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4117"}
    , {"@id":"ucT45W7CG7VssifF","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.27","host.ip":"192.0.2.27","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4117"}
    , {"@id":"ztQ3448LG8Tv9LcD","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.27","host.ip":"192.0.2.27","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4117"}
    , {"@id":"17Mxg1cYcYHeJ753t","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.27","host.ip":"192.0.2.27","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4117"}
    , {"@id":"1E7nJ7KhsbxvLbYn4","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.27","host.ip":"192.0.2.27","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT4117"}
    , {"@id":"1E7nJ7SqEbgPzaEYx","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.27","host.ip":"192.0.2.27","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT4117"}
    , {"@id":"1E7nJ7Vy3UBdNsRKO","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.27","host.ip":"192.0.2.27","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT4117"}
    , {"@id":"1E7nJ7UYHofNpvW9R","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.27","host.ip":"192.0.2.27","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT4117"}
    , {"@id":"1F6PYPiHHN9cRGtyU","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.27","host.ip":"192.0.2.27","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan1","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4117"}
    , {"@id":"1F6PYPqPdMs75FZkN","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.27","host.ip":"192.0.2.27","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4117"}
    , {"@id":"1F6PYPtXSFNKTXmVo","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.27","host.ip":"192.0.2.27","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":25947,"host.interface.egress.bits_per_second":279,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":25667,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether1","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT4117"}
    , {"@id":"1F6PYPs7gZr4varKr","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.27","host.ip":"192.0.2.27","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4117"}
    , {"@id":"1F6PYPs6lYPiQdpUM","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"5","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.27","host.ip":"192.0.2.27","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether3","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4117"}
    , {"@id":"1F6PYPsIpmXSpZH5f","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"6","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.27","host.ip":"192.0.2.27","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether4","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4117"}
    , {"@id":"1F6PYPhSl8sjQ0wEC","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"7","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.27","host.ip":"192.0.2.27","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether5","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4117"}
    , {"@id":"1F6PYPsSnZJxqrRcL","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"8","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.27","host.ip":"192.0.2.27","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":17959,"host.interface.egress.bits_per_second":250,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":17708,"host.interface.ingress.errors_per_second":0,"host.interface.name":"bridge","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT4117"}
    , {"@id":"1F6PYPiDCWi8c8ze6","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"9","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.27","host.ip":"192.0.2.27","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1528,"host.interface.egress.bits_per_second":246,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan801-mgmt","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT4117"}
    , {"@id":"1F6PYPzpgqwyqA9wt","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"10","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.27","host.ip":"192.0.2.27","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":14907,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":14907,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan802-inet","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT4117"}
    , {"@id":"OqfkPg2s0368jn1G","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"65536","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.27","host.ip":"192.0.2.27","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.memory.utilization":21,"component.name":"main memory","storage.bytes":58396672,"storage.name":"main memory","storage.type":"ram","storage.utilization":21,"host.hostname":"NYC-S75-APT4117"}
    , {"@id":"OqfkPSgsP5XpTrCh","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"131072","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.27","host.ip":"192.0.2.27","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","storage.bytes":40005632,"storage.name":"system disk","storage.type":"fixedDisk","storage.utilization":29,"host.hostname":"NYC-S75-APT4117"}
    , {"@id":"hnKbjUEFRjh9GfD3","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","component.name":"unknown","host.address":"192.0.2.27","host.ip":"192.0.2.27","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4117"}
    , {"@id":"NhMhMLtFzNQAUzPa","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.236","host.ip":"172.28.2.236","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3204"}
    , {"@id":"Y2ukaYQqj9tqoscw","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.236","host.ip":"172.28.2.236","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3204"}
    , {"@id":"FIB4gtGdSQBimq2g","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.236","host.ip":"172.28.2.236","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3204"}
    , {"@id":"mDNGVZ4KCkl9A0CE","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.236","host.ip":"172.28.2.236","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3204"}
    , {"@id":"FA53G6sZ6aNNsSZC","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.236","host.ip":"172.28.2.236","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3204"}
    , {"@id":"ucT45CEMZa4yMtrK","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.236","host.ip":"172.28.2.236","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3204"}
    , {"@id":"ztQ33kFVZb30dWoI","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.236","host.ip":"172.28.2.236","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3204"}
    , {"@id":"17Mxg1IfmrkDObGFy","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.236","host.ip":"172.28.2.236","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3204"}
    , {"@id":"1E7nJ7aMRw6kz8YkR","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.236","host.ip":"172.28.2.236","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":1,"component.name":"","host.hostname":"NYC-S75-APT3204"}
    , {"@id":"1E7nJ7N5YH53iX22y","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.236","host.ip":"172.28.2.236","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT3204"}
    , {"@id":"1E7nJ7TxTB0xC5Ecj","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.236","host.ip":"172.28.2.236","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT3204"}
    , {"@id":"1E7nJ7KFWlB2sfL5G","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.236","host.ip":"172.28.2.236","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT3204"}
    , {"@id":"1F6PYPxvqhIS4ntvr","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.236","host.ip":"172.28.2.236","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan1","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3204"}
    , {"@id":"1F6PYPkex2GkoCNEO","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.236","host.ip":"172.28.2.236","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3204"}
    , {"@id":"1F6PYPrWrwCeHkZo9","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.236","host.ip":"172.28.2.236","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":25870,"host.interface.egress.bits_per_second":281,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":25589,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether1","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3204"}
    , {"@id":"1F6PYPhovWMjyKgGg","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.236","host.ip":"172.28.2.236","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3204"}
    , {"@id":"1F6PYPxyuDVMRuTmN","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"5","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.236","host.ip":"172.28.2.236","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether3","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3204"}
    , {"@id":"1F6PYPmi7DdcE3BGu","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"6","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.236","host.ip":"172.28.2.236","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether4","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3204"}
    , {"@id":"1F6PYPh1mmAV204Cj","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"7","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.236","host.ip":"172.28.2.236","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether5","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3204"}
    , {"@id":"1F6PYPsxMrL2NStt8","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"8","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.236","host.ip":"172.28.2.236","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":17921,"host.interface.egress.bits_per_second":252,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":17669,"host.interface.ingress.errors_per_second":0,"host.interface.name":"bridge","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3204"}
    , {"@id":"1F6PYPvH1nsMgPLSB","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"9","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.236","host.ip":"172.28.2.236","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1488,"host.interface.egress.bits_per_second":247,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1240,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan801-mgmt","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3204"}
    , {"@id":"1F6PYPo3mnbfpYJ72","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"10","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.236","host.ip":"172.28.2.236","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":14912,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":14912,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan802-inet","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3204"}
    , {"@id":"OqfkPMQFjE74vf5j","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"65536","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.236","host.ip":"172.28.2.236","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.memory.utilization":22,"component.name":"main memory","storage.bytes":60743680,"storage.name":"main memory","storage.type":"ram","storage.utilization":22,"host.hostname":"NYC-S75-APT3204"}
    , {"@id":"OqfkPXkBcDdTKOGO","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"131072","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.236","host.ip":"172.28.2.236","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","storage.bytes":40816640,"storage.name":"system disk","storage.type":"fixedDisk","storage.utilization":30,"host.hostname":"NYC-S75-APT3204"}
    , {"@id":"hnKbjALPlCGEkqP8","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","component.name":"unknown","host.address":"172.28.2.236","host.ip":"172.28.2.236","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3204"}
    , {"@id":"NhMhMfljlSI5tfsj","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.96","host.ip":"192.0.2.96","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT5216"}
    , {"@id":"Y2ukasJKVElmDZ65","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.96","host.ip":"192.0.2.96","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT5216"}
    , {"@id":"FIB4hD97EV3eBWVp","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.96","host.ip":"192.0.2.96","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT5216"}
    , {"@id":"mDNGVswnypd4YgfN","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.96","host.ip":"192.0.2.96","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT5216"}
    , {"@id":"FA53GQl2sfFJH92L","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.96","host.ip":"192.0.2.96","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT5216"}
    , {"@id":"ucT45W6qLewtlaKT","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.96","host.ip":"192.0.2.96","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT5216"}
    , {"@id":"ztQ3447zLfuw2DHR","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.96","host.ip":"192.0.2.96","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT5216"}
    , {"@id":"17Mxg1cYGdp5Jzwj7","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.96","host.ip":"192.0.2.96","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT5216"}
    , {"@id":"1E7nJ7Kh6uK9GKwuA","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.96","host.ip":"192.0.2.96","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT5216"}
    , {"@id":"1E7nJ7SqjYGN4wjAZ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.96","host.ip":"192.0.2.96","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT5216"}
    , {"@id":"1E7nJ7VygsfVIQMZ6","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.96","host.ip":"192.0.2.96","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT5216"}
    , {"@id":"1E7nJ7UZ4AGvBswoT","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.96","host.ip":"192.0.2.96","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT5216"}
    , {"@id":"1F6PYPiGVfVqM0I5a","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.96","host.ip":"192.0.2.96","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan1","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT5216"}
    , {"@id":"1F6PYPqQ8JS4Ac4Lz","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.96","host.ip":"192.0.2.96","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT5216"}
    , {"@id":"1F6PYPtY5drCO5hkW","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.96","host.ip":"192.0.2.96","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":25913,"host.interface.egress.bits_per_second":281,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":25632,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether1","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT5216"}
    , {"@id":"1F6PYPs8SvScHYHzt","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.96","host.ip":"192.0.2.96","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT5216"}
    , {"@id":"1F6PYPs5zCoB4gOpK","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"5","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.96","host.ip":"192.0.2.96","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether3","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT5216"}
    , {"@id":"1F6PYPsICO3av1Lqx","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"6","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.96","host.ip":"192.0.2.96","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether4","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT5216"}
    , {"@id":"1F6PYPhTP6KdwPpOW","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"7","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.96","host.ip":"192.0.2.96","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether5","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT5216"}
    , {"@id":"1F6PYPsSRerOrkJHZ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"8","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.96","host.ip":"192.0.2.96","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":17875,"host.interface.egress.bits_per_second":206,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":17668,"host.interface.ingress.errors_per_second":0,"host.interface.name":"bridge","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT5216"}
    , {"@id":"1F6PYPiDYRAhbG7ys","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"9","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.96","host.ip":"192.0.2.96","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1459,"host.interface.egress.bits_per_second":203,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1256,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan801-mgmt","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT5216"}
    , {"@id":"1F6PYPzp3XSpaS5Yh","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"10","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.96","host.ip":"192.0.2.96","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":14895,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":14895,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan802-inet","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT5216"}
    , {"@id":"OqfkPg3DuVf7qvM2","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"65536","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.96","host.ip":"192.0.2.96","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.memory.utilization":22,"component.name":"main memory","storage.bytes":61116416,"storage.name":"main memory","storage.type":"ram","storage.utilization":22,"host.hostname":"NYC-S75-APT5216"}
    , {"@id":"OqfkPShMhhje9X2B","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"131072","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.96","host.ip":"192.0.2.96","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","storage.bytes":40255488,"storage.name":"system disk","storage.type":"fixedDisk","storage.utilization":29,"host.hostname":"NYC-S75-APT5216"}
    , {"@id":"hnKbjUDtXH8A9WsH","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","component.name":"unknown","host.address":"192.0.2.96","host.ip":"192.0.2.96","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT5216"}
    , {"@id":"NhMhMUU5fuORnpgv","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"Y2ukah1gPgs87iuH","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"FIB4h1rT8xA05gK1","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"mDNGVhf9tHjQSqTZ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"FA53GFTOn7LfBIqX","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"ucT45KpCG73Ffk8f","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"ztQ33sqLG81HwN5d","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"17Mxg1RGcYHBfu6XJ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1E7nJ7VzsYE5zBeBG","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":10,"component.name":"","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPtZHJPn4qzMg","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"qsfpplus1-1","host.interface.oper_status":"notPresent","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPfGOoBeMHQix","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"qsfpplus1-2","host.interface.oper_status":"notPresent","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPmUaSuTWGp4e","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"qsfpplus1-3","host.interface.oper_status":"notPresent","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPzApiqep2pPB","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"qsfpplus1-4","host.interface.oper_status":"notPresent","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPfUWubttR434","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"5","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"qsfpplus2-1","host.interface.oper_status":"notPresent","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPh9bGLrR13UV","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"6","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"qsfpplus2-2","host.interface.oper_status":"notPresent","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPsl2zOEwQ2T2","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"7","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"qsfpplus2-3","host.interface.oper_status":"notPresent","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPkoKkOL7ZjTN","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"8","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"qsfpplus2-4","host.interface.oper_status":"notPresent","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPtM9gN14WCc6","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"9","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"sfp-sfpplus1","host.interface.oper_status":"notPresent","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPl2v7BgDGkXr","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"10","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"sfp-sfpplus2","host.interface.oper_status":"notPresent","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYQ0bZHRpfwwGy","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"11","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":11044715,"host.interface.egress.bits_per_second":471243,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":10573471,"host.interface.ingress.errors_per_second":0,"host.interface.name":"sfp-sfpplus3","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPkd3APj8BHmn","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"12","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1642309,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1642309,"host.interface.ingress.errors_per_second":0,"host.interface.name":"sfp-sfpplus4","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPgvW9dpKQTfi","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"13","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":30432,"host.interface.egress.bits_per_second":30150,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether1","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPwmoF8qHMxrD","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"14","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":30431,"host.interface.egress.bits_per_second":30150,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether2","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPie7dVpMRQqG","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"15","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":30431,"host.interface.egress.bits_per_second":30150,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether3","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPsmmCvLwyea9","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"16","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":30431,"host.interface.egress.bits_per_second":30150,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether4","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPpd58yGc1pgI","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"17","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":30431,"host.interface.egress.bits_per_second":30150,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether5","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPiep2e46dTjH","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"18","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":30431,"host.interface.egress.bits_per_second":30150,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether6","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPhDKG8fzYhYq","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"19","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":30432,"host.interface.egress.bits_per_second":30150,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":282,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether7","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPiiBHDDLraAn","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"20","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":30431,"host.interface.egress.bits_per_second":30150,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether8","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPr6gD9ZNyUpq","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"21","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":30431,"host.interface.egress.bits_per_second":30150,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether9","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPuyvb3t4UDTz","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"22","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":30431,"host.interface.egress.bits_per_second":30150,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether10","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPfSV4xqxQzJY","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"23","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":30431,"host.interface.egress.bits_per_second":30150,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether11","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPn3KrLV588j3","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"24","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":32316,"host.interface.egress.bits_per_second":31180,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1136,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether12","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPlfEEVXayWVu","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"25","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":30431,"host.interface.egress.bits_per_second":30150,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether13","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPxxILFaSRx2R","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"26","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":30431,"host.interface.egress.bits_per_second":30150,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether14","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPr9TmprTk5cC","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"27","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":30431,"host.interface.egress.bits_per_second":30150,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether15","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPgSfoUyIncWT","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"28","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":30431,"host.interface.egress.bits_per_second":30150,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":280,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether16","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPrCprer1PRAE","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"29","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":30431,"host.interface.egress.bits_per_second":30150,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether17","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPsjPyMChkY8d","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"30","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":30431,"host.interface.egress.bits_per_second":30150,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether18","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPyiWTAFOGS2S","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"31","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":30431,"host.interface.egress.bits_per_second":30150,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether19","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPhBDDvua3fPN","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"32","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":30431,"host.interface.egress.bits_per_second":30150,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether20","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPkcuH5qCEj3K","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"33","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":30431,"host.interface.egress.bits_per_second":30150,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether21","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPvT5CEjO8jQZ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"34","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":30431,"host.interface.egress.bits_per_second":30150,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether22","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPkhlexEoep48","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"35","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":30581,"host.interface.egress.bits_per_second":30247,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":334,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether23","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPldU4Yjl8PpN","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"36","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":30431,"host.interface.egress.bits_per_second":30150,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether24","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPsYl7mvcGGH8","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"37","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":7675176,"host.interface.egress.bits_per_second":7534235,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":140940,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether25","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPxnFJHIDznap","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"38","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":30432,"host.interface.egress.bits_per_second":30151,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether26","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPmRQEICEYg08","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"39","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":30271,"host.interface.egress.bits_per_second":25609,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":4661,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether27","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPpyeIeml5n9l","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"40","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":30431,"host.interface.egress.bits_per_second":30150,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether28","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPjvbYDjki2jS","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"41","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether29","host.interface.oper_status":"down","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPetvUyr2FJut","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"42","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":30431,"host.interface.egress.bits_per_second":30150,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether30","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPkMC1xNPbkV2","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"43","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether31","host.interface.oper_status":"down","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPfI0vl8ozkKr","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"44","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":30431,"host.interface.egress.bits_per_second":30150,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether32","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPq3ZnqhqDSYQ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"45","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether33","host.interface.oper_status":"down","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPjFTEogU9N3X","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"46","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":30431,"host.interface.egress.bits_per_second":30150,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether34","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPlSxdqS8fbIm","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"47","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether35","host.interface.oper_status":"down","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPjHOngPnS8Sf","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"48","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":30431,"host.interface.egress.bits_per_second":30150,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether36","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPnu8PD8pnW1S","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"49","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether37","host.interface.oper_status":"down","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPrBV616BGzLv","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"50","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":30431,"host.interface.egress.bits_per_second":30150,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether38","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPi8FEVrGlV88","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"51","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether39","host.interface.oper_status":"down","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPfiU6e2NWOmb","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"52","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":30431,"host.interface.egress.bits_per_second":30150,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether40","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPvbo4QztGXfK","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"53","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether41","host.interface.oper_status":"down","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPzLTV3Z9okvX","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"54","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":30073,"host.interface.egress.bits_per_second":30073,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether42","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPsefHnXFTfMG","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"55","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether43","host.interface.oper_status":"down","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPguKbAudPtJx","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"56","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":30431,"host.interface.egress.bits_per_second":30150,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether44","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPypuk1tfoyHi","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"57","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether45","host.interface.oper_status":"down","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPh8uxyFj6uOR","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"58","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":30431,"host.interface.egress.bits_per_second":30150,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether46","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPsv8IltPzirc","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"59","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":29462,"host.interface.egress.bits_per_second":27362,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":2100,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether47","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPx66qDPEkM8L","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"60","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":3397567,"host.interface.egress.bits_per_second":3081121,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":316446,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether48","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPfbT9KmlA1uw","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"61","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether49","host.interface.oper_status":"down","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPukPn3TbCj1z","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"62","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":25461,"host.interface.egress.bits_per_second":2069,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":23391,"host.interface.ingress.errors_per_second":0,"host.interface.name":"bridge","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"1F6PYPjGSYCm3m2Dg","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"63","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":4040,"host.interface.egress.bits_per_second":2038,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":2002,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan801-mgmt","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"OqfkPVMBejFg9arC","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"65536","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.memory.utilization":66,"component.name":"main memory","storage.bytes":44638208,"storage.name":"main memory","storage.type":"ram","storage.utilization":66,"host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"OqfkPZjjWLCqr29b","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"131072","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","storage.bytes":13881344,"storage.name":"system disk","storage.type":"fixedDisk","storage.utilization":82,"host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"hnKbjIwFRjEW3ggT","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","component.name":"unknown","host.address":"172.28.2.11","host.ip":"172.28.2.11","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-SW01-01"}
    , {"@id":"NhMhMecMy5rlqklX","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.3","host.ip":"192.0.2.3","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3309"}
    , {"@id":"Y2ukar9xhsLSAdyt","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.3","host.ip":"192.0.2.3","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3309"}
    , {"@id":"FIB4hBzkR8dK8bOd","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.3","host.ip":"192.0.2.3","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3309"}
    , {"@id":"mDNGVrnRBTCkVlYB","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.3","host.ip":"192.0.2.3","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3309"}
    , {"@id":"FA53GPbg5IozEDv9","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.3","host.ip":"192.0.2.3","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3309"}
    , {"@id":"ucT45UxTYIWZifDH","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.3","host.ip":"192.0.2.3","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3309"}
    , {"@id":"ztQ342ycYJUbzIAF","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.3","host.ip":"192.0.2.3","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3309"}
    , {"@id":"17Mxg1bOtqSezx1bv","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.3","host.ip":"192.0.2.3","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3309"}
    , {"@id":"1E7nJ7d6qyDHdGYYg","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.3","host.ip":"192.0.2.3","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT3309"}
    , {"@id":"1E7nJ7YaSTaGW99BV","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.3","host.ip":"192.0.2.3","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT3309"}
    , {"@id":"1E7nJ7ZTv04rtgswC","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.3","host.ip":"192.0.2.3","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT3309"}
    , {"@id":"1E7nJ7Qnvv6WqYy4t","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.3","host.ip":"192.0.2.3","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT3309"}
    , {"@id":"1F6PYQ0gFjOyivtk6","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.3","host.ip":"192.0.2.3","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan1","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3309"}
    , {"@id":"1F6PYPw9rElxboUMv","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.3","host.ip":"192.0.2.3","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3309"}
    , {"@id":"1F6PYPx3JlGYzME7c","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.3","host.ip":"192.0.2.3","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":27727,"host.interface.egress.bits_per_second":281,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":27446,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether1","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3309"}
    , {"@id":"1F6PYPoNKgIDwEJGJ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.3","host.ip":"192.0.2.3","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3309"}
    , {"@id":"1F6PYPxbe5YG2jRUo","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"5","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.3","host.ip":"192.0.2.3","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether3","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3309"}
    , {"@id":"1F6PYPuFStFfDaf1l","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"6","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.3","host.ip":"192.0.2.3","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether4","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3309"}
    , {"@id":"1F6PYPoSim9BjN8Xs","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"7","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.3","host.ip":"192.0.2.3","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether5","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3309"}
    , {"@id":"1F6PYPtLAaxlzZQUN","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"8","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.3","host.ip":"192.0.2.3","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":17960,"host.interface.egress.bits_per_second":252,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":17707,"host.interface.ingress.errors_per_second":0,"host.interface.name":"bridge","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3309"}
    , {"@id":"1F6PYPixbUGDeaOQQ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"9","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.3","host.ip":"192.0.2.3","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1520,"host.interface.egress.bits_per_second":248,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1272,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan801-mgmt","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3309"}
    , {"@id":"1F6PYPwVKzSsj8MCT","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"10","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.3","host.ip":"192.0.2.3","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":14915,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":14915,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan802-inet","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3309"}
    , {"@id":"OqfkPWm4JyGwcbKA","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"65536","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.3","host.ip":"192.0.2.3","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.memory.utilization":22,"component.name":"main memory","storage.bytes":59322368,"storage.name":"main memory","storage.type":"ram","storage.utilization":22,"host.hostname":"NYC-S75-APT3309"}
    , {"@id":"OqfkPdrEDBwuhzvB","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"131072","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.3","host.ip":"192.0.2.3","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","storage.bytes":39755776,"storage.name":"system disk","storage.type":"fixedDisk","storage.utilization":29,"host.hostname":"NYC-S75-APT3309"}
    , {"@id":"hnKbjT4Wjuhq6bl5","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","component.name":"unknown","host.address":"192.0.2.3","host.ip":"192.0.2.3","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3309"}
    , {"@id":"NhMhMMdmmuzoHYoL","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.174","host.ip":"172.28.2.174","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2119"}
    , {"@id":"Y2ukaZBNWhTUbS1h","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.174","host.ip":"172.28.2.174","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2119"}
    , {"@id":"FIB4gu1AFxlMZPRR","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.174","host.ip":"172.28.2.174","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2119"}
    , {"@id":"mDNGVZor0IKmwZaz","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.174","host.ip":"172.28.2.174","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2119"}
    , {"@id":"FA53G7d5u7x1f1xx","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.174","host.ip":"172.28.2.174","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2119"}
    , {"@id":"ucT45CytN7ec9TG5","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.174","host.ip":"172.28.2.174","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2119"}
    , {"@id":"ztQ33l02N8ceQ6D3","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.174","host.ip":"172.28.2.174","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2119"}
    , {"@id":"17Mxg1JQJfHn2Npej","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.174","host.ip":"172.28.2.174","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2119"}
    , {"@id":"1E7nJ7ZZfGOjvtg8C","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.174","host.ip":"172.28.2.174","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT2119"}
    , {"@id":"1E7nJ7Ktv2TmOCf0F","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.174","host.ip":"172.28.2.174","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT2119"}
    , {"@id":"1E7nJ7W6qNSLnHakw","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.174","host.ip":"172.28.2.174","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT2119"}
    , {"@id":"1E7nJ7L1lBnw0ZJWH","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.174","host.ip":"172.28.2.174","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT2119"}
    , {"@id":"1F6PYPx941aR1Z1Jc","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.174","host.ip":"172.28.2.174","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1390,"host.interface.egress.bits_per_second":788,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":601,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan1","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT2119"}
    , {"@id":"1F6PYPiTJnfTTs0Bf","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.174","host.ip":"172.28.2.174","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":2832,"host.interface.egress.bits_per_second":1881,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":950,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan2","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT2119"}
    , {"@id":"1F6PYPtgF8e2swvwM","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.174","host.ip":"172.28.2.174","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":28527,"host.interface.egress.bits_per_second":1206,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":27321,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether1","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT2119"}
    , {"@id":"1F6PYPib9wzd6Eehh","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.174","host.ip":"172.28.2.174","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT2119"}
    , {"@id":"1F6PYPxCfmsTK0VLM","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"5","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.174","host.ip":"172.28.2.174","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether3","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT2119"}
    , {"@id":"1F6PYPkYB89KQp6BL","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"6","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.174","host.ip":"172.28.2.174","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether4","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT2119"}
    , {"@id":"1F6PYPjKmIDqH7qUc","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"7","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.174","host.ip":"172.28.2.174","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether5","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT2119"}
    , {"@id":"1F6PYPthtesc1FTHt","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"8","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.174","host.ip":"172.28.2.174","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":23693,"host.interface.egress.bits_per_second":3314,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":20378,"host.interface.ingress.errors_per_second":0,"host.interface.name":"bridge","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT2119"}
    , {"@id":"1F6PYPuWVAKEMITkS","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"9","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.174","host.ip":"172.28.2.174","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1466,"host.interface.egress.bits_per_second":250,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1216,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan801-mgmt","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT2119"}
    , {"@id":"1F6PYPllMoYz394Yd","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"10","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.174","host.ip":"172.28.2.174","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":17244,"host.interface.egress.bits_per_second":858,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":16385,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan802-inet","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT2119"}
    , {"@id":"OqfkPLfiRiDU7ybs","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"65536","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.174","host.ip":"172.28.2.174","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.memory.utilization":23,"component.name":"main memory","storage.bytes":61829120,"storage.name":"main memory","storage.type":"ram","storage.utilization":23,"host.hostname":"NYC-S75-APT2119"}
    , {"@id":"OqfkPVPUx3Ih6K1L","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"131072","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.174","host.ip":"172.28.2.174","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","storage.bytes":39878656,"storage.name":"system disk","storage.type":"fixedDisk","storage.utilization":29,"host.hostname":"NYC-S75-APT2119"}
    , {"@id":"hnKbjB5wYjpsXPnt","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","component.name":"unknown","host.address":"172.28.2.174","host.ip":"172.28.2.174","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT2119"}
    , {"@id":"NhMhMMdZoKfbMyBl","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.105","host.ip":"172.28.2.105","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT1106"}
    , {"@id":"Y2ukaZBAY79HgrP7","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.105","host.ip":"172.28.2.105","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT1106"}
    , {"@id":"FIB4gu0xHNR9eoor","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.105","host.ip":"172.28.2.105","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT1106"}
    , {"@id":"mDNGVZoe1i0a1yyP","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.105","host.ip":"172.28.2.105","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT1106"}
    , {"@id":"FA53G7csvXcokRLN","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.105","host.ip":"172.28.2.105","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT1106"}
    , {"@id":"ucT45CygOXKPEsdV","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.105","host.ip":"172.28.2.105","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT1106"}
    , {"@id":"ztQ33kzpOYIRVVaT","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.105","host.ip":"172.28.2.105","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT1106"}
    , {"@id":"17Mxg1JQ6ghSpTF29","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.105","host.ip":"172.28.2.105","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT1106"}
    , {"@id":"1E7nJ7Za9Z0vkZLxg","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.105","host.ip":"172.28.2.105","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT1106"}
    , {"@id":"1E7nJ7KtQ5tpIqAOd","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.105","host.ip":"172.28.2.105","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT1106"}
    , {"@id":"1E7nJ7W73M2g0CBNW","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.105","host.ip":"172.28.2.105","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT1106"}
    , {"@id":"1E7nJ7L276GUzgRr3","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.105","host.ip":"172.28.2.105","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT1106"}
    , {"@id":"1F6PYPx9YKCcqEh96","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.105","host.ip":"172.28.2.105","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan1","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT1106"}
    , {"@id":"1F6PYPiSor5WOVVa3","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.105","host.ip":"172.28.2.105","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT1106"}
    , {"@id":"1F6PYPtgS7EN5rWYw","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.105","host.ip":"172.28.2.105","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1658775,"host.interface.egress.bits_per_second":281,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1658494,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether1","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT1106"}
    , {"@id":"1F6PYPibVrSC5Ln2T","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.105","host.ip":"172.28.2.105","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT1106"}
    , {"@id":"1F6PYPxCbHRUbUJ40","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"5","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.105","host.ip":"172.28.2.105","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether3","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT1106"}
    , {"@id":"1F6PYPkYFdaJ9LISh","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"6","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.105","host.ip":"172.28.2.105","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether4","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT1106"}
    , {"@id":"1F6PYPjKQNlHI0i9q","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"7","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.105","host.ip":"172.28.2.105","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether5","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT1106"}
    , {"@id":"1F6PYPthggIHoKsfJ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"8","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.105","host.ip":"172.28.2.105","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":17917,"host.interface.egress.bits_per_second":252,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":17665,"host.interface.ingress.errors_per_second":0,"host.interface.name":"bridge","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT1106"}
    , {"@id":"1F6PYPuWzSwQAy9Zw","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"9","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.105","host.ip":"172.28.2.105","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1488,"host.interface.egress.bits_per_second":247,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1240,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan801-mgmt","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT1106"}
    , {"@id":"1F6PYPlksVwnETOj9","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"10","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.105","host.ip":"172.28.2.105","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":14908,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":14908,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan802-inet","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT1106"}
    , {"@id":"OqfkPLgDOIAZUTDU","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"65536","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.105","host.ip":"172.28.2.105","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.memory.utilization":21,"component.name":"main memory","storage.bytes":59035648,"storage.name":"main memory","storage.type":"ram","storage.utilization":21,"host.hostname":"NYC-S75-APT1106"}
    , {"@id":"OqfkPVP0eR6sQeBr","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"131072","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.105","host.ip":"172.28.2.105","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","storage.bytes":40660992,"storage.name":"system disk","storage.type":"fixedDisk","storage.utilization":30,"host.hostname":"NYC-S75-APT1106"}
    , {"@id":"hnKbjB5ja9VfcpBJ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","component.name":"unknown","host.address":"172.28.2.105","host.ip":"172.28.2.105","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT1106"}
    , {"@id":"NhMhMfMBmPVxQbsB","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.6","host.ip":"172.28.2.6","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-SW00-02"}
    , {"@id":"Y2ukartmWBzdkV5X","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.6","host.ip":"172.28.2.6","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-SW00-02"}
    , {"@id":"FIB4hCjZFSHViSVH","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.6","host.ip":"172.28.2.6","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-SW00-02"}
    , {"@id":"mDNGVsXFzmqw5cep","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.6","host.ip":"172.28.2.6","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-SW00-02"}
    , {"@id":"FA53GQLUtcTAo51n","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.6","host.ip":"172.28.2.6","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-SW00-02"}
    , {"@id":"ucT45VhIMcAlIWJv","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.6","host.ip":"172.28.2.6","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-SW00-02"}
    , {"@id":"ztQ343iRMd8nZ9Gt","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.6","host.ip":"172.28.2.6","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-SW00-02"}
    , {"@id":"17Mxg1c8iemJBWsiZ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.6","host.ip":"172.28.2.6","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-SW00-02"}
    , {"@id":"1E7nJ7cN27Om7Gm1m","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.6","host.ip":"172.28.2.6","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":3,"component.name":"","host.hostname":"NYC-S75-SW00-02"}
    , {"@id":"1F6PYPzwQsaTCw7DC","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.6","host.ip":"172.28.2.6","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":295,"host.interface.egress.bits_per_second":295,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether1","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW00-02"}
    , {"@id":"1F6PYPwtgjYEOV5fx","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.6","host.ip":"172.28.2.6","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether2","host.interface.oper_status":"down","host.hostname":"NYC-S75-SW00-02"}
    , {"@id":"1F6PYPwO1IkhYxsno","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.6","host.ip":"172.28.2.6","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether3","host.interface.oper_status":"down","host.hostname":"NYC-S75-SW00-02"}
    , {"@id":"1F6PYPp2d8o5Mcea7","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.6","host.ip":"172.28.2.6","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether4","host.interface.oper_status":"down","host.hostname":"NYC-S75-SW00-02"}
    , {"@id":"1F6PYPwpYb6xrKkhW","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"5","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.6","host.ip":"172.28.2.6","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether5","host.interface.oper_status":"down","host.hostname":"NYC-S75-SW00-02"}
    , {"@id":"1F6PYPuzILX4frKuX","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"6","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.6","host.ip":"172.28.2.6","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether6","host.interface.oper_status":"down","host.hostname":"NYC-S75-SW00-02"}
    , {"@id":"1F6PYPnitxpXXnHRE","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"7","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.6","host.ip":"172.28.2.6","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether7","host.interface.oper_status":"down","host.hostname":"NYC-S75-SW00-02"}
    , {"@id":"1F6PYPu9Vna4Gkio7","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"8","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.6","host.ip":"172.28.2.6","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether8","host.interface.oper_status":"down","host.hostname":"NYC-S75-SW00-02"}
    , {"@id":"1F6PYPiDlzTwrtn7O","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"9","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.6","host.ip":"172.28.2.6","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether9","host.interface.oper_status":"down","host.hostname":"NYC-S75-SW00-02"}
    , {"@id":"1F6PYPxAe5wVQDWIP","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"10","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.6","host.ip":"172.28.2.6","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether10","host.interface.oper_status":"down","host.hostname":"NYC-S75-SW00-02"}
    , {"@id":"1F6PYPjcBAXjvOoBs","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"11","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.6","host.ip":"172.28.2.6","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether11","host.interface.oper_status":"down","host.hostname":"NYC-S75-SW00-02"}
    , {"@id":"1F6PYPkM6zuvvSlct","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"12","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.6","host.ip":"172.28.2.6","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether12","host.interface.oper_status":"down","host.hostname":"NYC-S75-SW00-02"}
    , {"@id":"1F6PYPjnghnHKxx8s","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"13","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.6","host.ip":"172.28.2.6","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether13","host.interface.oper_status":"down","host.hostname":"NYC-S75-SW00-02"}
    , {"@id":"1F6PYPnoNhzSRxOhF","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"14","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.6","host.ip":"172.28.2.6","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether14","host.interface.oper_status":"down","host.hostname":"NYC-S75-SW00-02"}
    , {"@id":"1F6PYPll72yoMpQQG","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"15","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.6","host.ip":"172.28.2.6","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether15","host.interface.oper_status":"down","host.hostname":"NYC-S75-SW00-02"}
    , {"@id":"1F6PYPmwk0IknZzch","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"16","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.6","host.ip":"172.28.2.6","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether16","host.interface.oper_status":"down","host.hostname":"NYC-S75-SW00-02"}
    , {"@id":"1F6PYPt4JgbaSOg2g","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"17","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.6","host.ip":"172.28.2.6","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether17","host.interface.oper_status":"down","host.hostname":"NYC-S75-SW00-02"}
    , {"@id":"1F6PYPjkv68404ef7","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"18","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.6","host.ip":"172.28.2.6","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":650451,"host.interface.egress.bits_per_second":650396,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":54,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether18","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW00-02"}
    , {"@id":"1F6PYPiCgLzbhvtNA","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"19","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.6","host.ip":"172.28.2.6","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether19","host.interface.oper_status":"down","host.hostname":"NYC-S75-SW00-02"}
    , {"@id":"1F6PYPpZmbNypLzl1","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"20","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.6","host.ip":"172.28.2.6","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether20","host.interface.oper_status":"down","host.hostname":"NYC-S75-SW00-02"}
    , {"@id":"1F6PYQ0islaHC4qyg","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"21","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.6","host.ip":"172.28.2.6","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether21","host.interface.oper_status":"down","host.hostname":"NYC-S75-SW00-02"}
    , {"@id":"1F6PYPlwawL5osn4D","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"22","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.6","host.ip":"172.28.2.6","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether22","host.interface.oper_status":"down","host.hostname":"NYC-S75-SW00-02"}
    , {"@id":"1F6PYPoEJFkkrd0TM","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"23","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.6","host.ip":"172.28.2.6","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether23","host.interface.oper_status":"down","host.hostname":"NYC-S75-SW00-02"}
    , {"@id":"1F6PYPhplNZg0pjb1","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"24","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.6","host.ip":"172.28.2.6","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether24","host.interface.oper_status":"down","host.hostname":"NYC-S75-SW00-02"}
    , {"@id":"1F6PYPxRQfohOntI6","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"25","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.6","host.ip":"172.28.2.6","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"sfp-sfpplus1","host.interface.oper_status":"notPresent","host.hostname":"NYC-S75-SW00-02"}
    , {"@id":"1F6PYPtlpMnUGFpqH","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"26","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.6","host.ip":"172.28.2.6","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"sfp-sfpplus2","host.interface.oper_status":"notPresent","host.hostname":"NYC-S75-SW00-02"}
    , {"@id":"1F6PYPsLdgxAMc1Hs","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"27","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.6","host.ip":"172.28.2.6","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"sfp-sfpplus3","host.interface.oper_status":"notPresent","host.hostname":"NYC-S75-SW00-02"}
    , {"@id":"1F6PYPkl4A5iylrDb","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"28","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.6","host.ip":"172.28.2.6","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1950009,"host.interface.egress.bits_per_second":514,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1949495,"host.interface.ingress.errors_per_second":0,"host.interface.name":"sfp-sfpplus4","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW00-02"}
    , {"@id":"1F6PYPscx7R7SJA5a","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"29","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.6","host.ip":"172.28.2.6","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":22728,"host.interface.egress.bits_per_second":344,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":22383,"host.interface.ingress.errors_per_second":0,"host.interface.name":"bridge","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW00-02"}
    , {"@id":"1F6PYPh7sV2pyIeWn","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"30","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.6","host.ip":"172.28.2.6","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1657,"host.interface.egress.bits_per_second":338,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1319,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan801-mgmt","host.interface.oper_status":"up","host.hostname":"NYC-S75-SW00-02"}
    , {"@id":"OqfkPW2FT9lQconG","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"65536","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.6","host.ip":"172.28.2.6","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.memory.utilization":7,"component.name":"main memory","storage.bytes":39063552,"storage.name":"main memory","storage.type":"ram","storage.utilization":7,"host.hostname":"NYC-S75-SW00-02"}
    , {"@id":"OqfkPeWWfhoL6LEz","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"131072","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.6","host.ip":"172.28.2.6","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","storage.bytes":14520320,"storage.name":"system disk","storage.type":"fixedDisk","storage.utilization":86,"host.hostname":"NYC-S75-SW00-02"}
    , {"@id":"hnKbjToLYEM1gSrj","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","component.name":"unknown","host.address":"172.28.2.6","host.ip":"172.28.2.6","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-SW00-02"}
    , {"@id":"NhMhMfmW5V2cLOu6","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.40","host.ip":"192.0.2.40","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4212"}
    , {"@id":"Y2ukasK6pHWIfI7S","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.40","host.ip":"192.0.2.40","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4212"}
    , {"@id":"FIB4hD9tYXoAdFXC","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.40","host.ip":"192.0.2.40","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4212"}
    , {"@id":"mDNGVsxaIsNb0Pgk","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.40","host.ip":"192.0.2.40","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4212"}
    , {"@id":"FA53GQlpChzpis3i","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.40","host.ip":"192.0.2.40","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4212"}
    , {"@id":"ucT45W7cfhhQDJLq","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.40","host.ip":"192.0.2.40","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4212"}
    , {"@id":"ztQ3448lfifSTwIo","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.40","host.ip":"192.0.2.40","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4212"}
    , {"@id":"17Mxg1cZ2xrpqRfkU","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.40","host.ip":"192.0.2.40","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4212"}
    , {"@id":"1E7nJ7Ki1fe6HMchZ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.40","host.ip":"192.0.2.40","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT4212"}
    , {"@id":"1E7nJ7SpomwQ3v3NA","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.40","host.ip":"192.0.2.40","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT4212"}
    , {"@id":"1E7nJ7VyTvdxv1TaB","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.40","host.ip":"192.0.2.40","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT4212"}
    , {"@id":"1E7nJ7UY8jjmExUWo","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.40","host.ip":"192.0.2.40","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT4212"}
    , {"@id":"1F6PYPiHQQpnN1xsz","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.40","host.ip":"192.0.2.40","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan1","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4212"}
    , {"@id":"1F6PYPqPDY879aOYa","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.40","host.ip":"192.0.2.40","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4212"}
    , {"@id":"1F6PYPtXsgpf0golb","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.40","host.ip":"192.0.2.40","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":25950,"host.interface.egress.bits_per_second":279,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":25670,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether1","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT4212"}
    , {"@id":"1F6PYPs7XUvTKcpiE","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.40","host.ip":"192.0.2.40","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4212"}
    , {"@id":"1F6PYPs6L7a6E6H5d","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"5","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.40","host.ip":"192.0.2.40","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether3","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4212"}
    , {"@id":"1F6PYPsIyjLm6g2aS","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"6","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.40","host.ip":"192.0.2.40","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether4","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4212"}
    , {"@id":"1F6PYPhScjn25YAwt","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"7","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.40","host.ip":"192.0.2.40","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether5","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4212"}
    , {"@id":"1F6PYPsTDyu9OC2Iw","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"8","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.40","host.ip":"192.0.2.40","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":17959,"host.interface.egress.bits_per_second":250,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":17708,"host.interface.ingress.errors_per_second":0,"host.interface.name":"bridge","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT4212"}
    , {"@id":"1F6PYPiDLaOJXu3Yb","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"9","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.40","host.ip":"192.0.2.40","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1530,"host.interface.egress.bits_per_second":246,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1283,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan801-mgmt","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT4212"}
    , {"@id":"1F6PYPzpH2CyuUyl6","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"10","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.40","host.ip":"192.0.2.40","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":14905,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":14905,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan802-inet","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT4212"}
    , {"@id":"OqfkPg30PlVno29d","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"65536","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.40","host.ip":"192.0.2.40","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.memory.utilization":22,"component.name":"main memory","storage.bytes":61095936,"storage.name":"main memory","storage.type":"ram","storage.utilization":22,"host.hostname":"NYC-S75-APT4212"}
    , {"@id":"OqfkPSgRwNmd7rEm","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"131072","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.40","host.ip":"192.0.2.40","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","storage.bytes":40050688,"storage.name":"system disk","storage.type":"fixedDisk","storage.utilization":29,"host.hostname":"NYC-S75-APT4212"}
    , {"@id":"hnKbjUEfrJsgbFte","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","component.name":"unknown","host.address":"192.0.2.40","host.ip":"192.0.2.40","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4212"}
    , {"@id":"NhMhMLtBT0Mx4ZLd","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.242","host.ip":"172.28.2.242","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3210"}
    , {"@id":"Y2ukaYQmCmqdOSYz","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.242","host.ip":"172.28.2.242","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3210"}
    , {"@id":"FIB4gtGYw38VMPyj","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.242","host.ip":"172.28.2.242","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3210"}
    , {"@id":"mDNGVZ4FgNhvja8H","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.242","host.ip":"172.28.2.242","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3210"}
    , {"@id":"FA53G6sUaDKAS2VF","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.242","host.ip":"172.28.2.242","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3210"}
    , {"@id":"ucT45CEI3D1kwTnN","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.242","host.ip":"172.28.2.242","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3210"}
    , {"@id":"ztQ33kFR3DznD6kL","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.242","host.ip":"172.28.2.242","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3210"}
    , {"@id":"17Mxg1IfiLNABAqC1","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.242","host.ip":"172.28.2.242","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3210"}
    , {"@id":"1E7nJ7aMnp0X8jzRY","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.242","host.ip":"172.28.2.242","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT3210"}
    , {"@id":"1E7nJ7N5llCUhyROJ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.242","host.ip":"172.28.2.242","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT3210"}
    , {"@id":"1E7nJ7TwyCsDHD2NS","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.242","host.ip":"172.28.2.242","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT3210"}
    , {"@id":"1E7nJ7KG1jJmnXXKX","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.242","host.ip":"172.28.2.242","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT3210"}
    , {"@id":"1F6PYPxwCaCEEPKcy","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.242","host.ip":"172.28.2.242","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan1","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3210"}
    , {"@id":"1F6PYPkfAWOBndmZj","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.242","host.ip":"172.28.2.242","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3210"}
    , {"@id":"1F6PYPrWMy3uMsNYs","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.242","host.ip":"172.28.2.242","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":25799,"host.interface.egress.bits_per_second":281,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":25517,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether1","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3210"}
    , {"@id":"1F6PYPhpQUVTtCsVx","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.242","host.ip":"172.28.2.242","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3210"}
    , {"@id":"1F6PYPxygbtLTDIAG","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"5","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.242","host.ip":"172.28.2.242","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether3","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3210"}
    , {"@id":"1F6PYPmhlIEyk1p9X","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"6","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.242","host.ip":"172.28.2.242","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether4","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3210"}
    , {"@id":"1F6PYPh1rIXYFQUGg","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"7","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.242","host.ip":"172.28.2.242","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether5","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3210"}
    , {"@id":"1F6PYPsxIKxzA2TpB","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"8","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.242","host.ip":"172.28.2.242","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":17959,"host.interface.egress.bits_per_second":252,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":17707,"host.interface.ingress.errors_per_second":0,"host.interface.name":"bridge","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3210"}
    , {"@id":"1F6PYPvHNgm8q0m9I","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"9","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.242","host.ip":"172.28.2.242","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1520,"host.interface.egress.bits_per_second":248,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1272,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan801-mgmt","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3210"}
    , {"@id":"1F6PYPo40RiY8fQ9P","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"10","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.242","host.ip":"172.28.2.242","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":14915,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":14915,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan802-inet","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3210"}
    , {"@id":"OqfkPMQbc7tEX5mq","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"65536","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.242","host.ip":"172.28.2.242","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.memory.utilization":22,"component.name":"main memory","storage.bytes":61059072,"storage.name":"main memory","storage.type":"ram","storage.utilization":22,"host.hostname":"NYC-S75-APT3210"}
    , {"@id":"OqfkPXkOSNJC4ypb","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"131072","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.242","host.ip":"172.28.2.242","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","storage.bytes":40828928,"storage.name":"system disk","storage.type":"fixedDisk","storage.utilization":30,"host.hostname":"NYC-S75-APT3210"}
    , {"@id":"hnKbjALLEpD1KQLB","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","component.name":"unknown","host.address":"172.28.2.242","host.ip":"172.28.2.242","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3210"}
    , {"@id":"NhMhMfm5fbUui4Hy","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.26","host.ip":"192.0.2.26","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4116"}
    , {"@id":"Y2ukasJgPNyb1xVK","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.26","host.ip":"192.0.2.26","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4116"}
    , {"@id":"FIB4hD9T8eGSzuv4","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.26","host.ip":"192.0.2.26","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4116"}
    , {"@id":"mDNGVsx9syptN54c","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.26","host.ip":"192.0.2.26","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4116"}
    , {"@id":"FA53GQlOmoS85XRa","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.26","host.ip":"192.0.2.26","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4116"}
    , {"@id":"ucT45W7CFo9iZyji","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.26","host.ip":"192.0.2.26","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4116"}
    , {"@id":"ztQ3448LFp7kqbgg","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.26","host.ip":"192.0.2.26","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4116"}
    , {"@id":"17Mxg1cYcXyI8oL8M","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.26","host.ip":"192.0.2.26","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4116"}
    , {"@id":"1E7nJ7KhscHHVuIib","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.26","host.ip":"192.0.2.26","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT4116"}
    , {"@id":"1E7nJ7SqEbN3pHUdQ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.26","host.ip":"192.0.2.26","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT4116"}
    , {"@id":"1E7nJ7Vy3UUzYBBFv","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.26","host.ip":"192.0.2.26","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT4116"}
    , {"@id":"1E7nJ7UYHoM1fcmDu","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.26","host.ip":"192.0.2.26","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT4116"}
    , {"@id":"1F6PYPiHHNSybZdu1","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.26","host.ip":"192.0.2.26","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan1","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4116"}
    , {"@id":"1F6PYPqPdMYkuwpoq","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.26","host.ip":"192.0.2.26","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4116"}
    , {"@id":"1F6PYPtXSFggdqWRL","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.26","host.ip":"192.0.2.26","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":25843,"host.interface.egress.bits_per_second":279,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":25564,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether1","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT4116"}
    , {"@id":"1F6PYPs7gZXilI7PK","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.26","host.ip":"192.0.2.26","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4116"}
    , {"@id":"1F6PYPs6lYj4awZPt","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"5","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.26","host.ip":"192.0.2.26","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether3","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4116"}
    , {"@id":"1F6PYPsIpmE6fGXA8","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"6","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.26","host.ip":"192.0.2.26","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether4","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4116"}
    , {"@id":"1F6PYPhSl9C5aJg9j","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"7","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.26","host.ip":"192.0.2.26","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether5","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT4116"}
    , {"@id":"1F6PYPsSnZ0bgYhgo","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"8","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.26","host.ip":"192.0.2.26","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":17960,"host.interface.egress.bits_per_second":250,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":17709,"host.interface.ingress.errors_per_second":0,"host.interface.name":"bridge","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT4116"}
    , {"@id":"1F6PYPiDCX1UmRjZd","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"9","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.26","host.ip":"192.0.2.26","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1527,"host.interface.egress.bits_per_second":246,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1281,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan801-mgmt","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT4116"}
    , {"@id":"1F6PYPzpgqdcfrQ1M","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"10","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.26","host.ip":"192.0.2.26","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":14908,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":14908,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan802-inet","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT4116"}
    , {"@id":"OqfkPg2s0MSJ2Wwn","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"65536","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.26","host.ip":"192.0.2.26","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.memory.utilization":22,"component.name":"main memory","storage.bytes":60350464,"storage.name":"main memory","storage.type":"ram","storage.utilization":22,"host.hostname":"NYC-S75-APT4116"}
    , {"@id":"OqfkPSgsOmBfB7HA","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"131072","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.26","host.ip":"192.0.2.26","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","storage.bytes":39985152,"storage.name":"system disk","storage.type":"fixedDisk","storage.utilization":29,"host.hostname":"NYC-S75-APT4116"}
    , {"@id":"hnKbjUEFRQKyxvHW","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","component.name":"unknown","host.address":"192.0.2.26","host.ip":"192.0.2.26","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT4116"}
    , {"@id":"NhMhMLtFzgmKnjL7","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.237","host.ip":"172.28.2.237","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3205"}
    , {"@id":"Y2ukaYQqjTG17cYT","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.237","host.ip":"172.28.2.237","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3205"}
    , {"@id":"FIB4gtGdSjXt5ZyD","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.237","host.ip":"172.28.2.237","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3205"}
    , {"@id":"mDNGVZ4KD47JSk7l","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.237","host.ip":"172.28.2.237","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3205"}
    , {"@id":"FA53G6sZ6tjYBCUj","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.237","host.ip":"172.28.2.237","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3205"}
    , {"@id":"ucT45CEMZtR8fdmr","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.237","host.ip":"172.28.2.237","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3205"}
    , {"@id":"ztQ33kFVZuPAwGjp","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.237","host.ip":"172.28.2.237","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3205"}
    , {"@id":"17Mxg1Ifms3ZYu0BV","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.237","host.ip":"172.28.2.237","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3205"}
    , {"@id":"1E7nJ7aMRvnOopoou","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.237","host.ip":"172.28.2.237","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT3205"}
    , {"@id":"1E7nJ7N5YHOPsplyV","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.237","host.ip":"172.28.2.237","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT3205"}
    , {"@id":"1E7nJ7TxTAhb1mUhC","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.237","host.ip":"172.28.2.237","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT3205"}
    , {"@id":"1E7nJ7KFWlUP2y50n","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.237","host.ip":"172.28.2.237","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":1,"component.name":"","host.hostname":"NYC-S75-APT3205"}
    , {"@id":"1F6PYPxvqgz5uVA0K","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.237","host.ip":"172.28.2.237","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan1","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3205"}
    , {"@id":"1F6PYPkex2a6yV79v","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.237","host.ip":"172.28.2.237","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3205"}
    , {"@id":"1F6PYPrWrvtI7Rpsc","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.237","host.ip":"172.28.2.237","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":26116,"host.interface.egress.bits_per_second":281,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":25835,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether1","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3205"}
    , {"@id":"1F6PYPhovWg68dQCD","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.237","host.ip":"172.28.2.237","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3205"}
    , {"@id":"1F6PYPxyuDC0Hbjqq","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"5","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.237","host.ip":"172.28.2.237","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether3","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3205"}
    , {"@id":"1F6PYPmi7DwyOLvCR","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"6","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.237","host.ip":"172.28.2.237","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether4","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3205"}
    , {"@id":"1F6PYPh1mlr8rhKHC","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"7","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.237","host.ip":"172.28.2.237","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether5","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT3205"}
    , {"@id":"1F6PYPsxMreOXldof","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"8","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.237","host.ip":"172.28.2.237","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":17881,"host.interface.egress.bits_per_second":116,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":17765,"host.interface.ingress.errors_per_second":0,"host.interface.name":"bridge","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3205"}
    , {"@id":"1F6PYPvH1nZ0W6bWe","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"9","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.237","host.ip":"172.28.2.237","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1408,"host.interface.egress.bits_per_second":114,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1293,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan801-mgmt","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3205"}
    , {"@id":"1F6PYPo3mnv1zr32Z","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"10","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.237","host.ip":"172.28.2.237","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":14946,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":14946,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan802-inet","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT3205"}
    , {"@id":"OqfkPMQFiukucvAC","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"65536","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.237","host.ip":"172.28.2.237","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.memory.utilization":21,"component.name":"main memory","storage.bytes":58990592,"storage.name":"main memory","storage.type":"ram","storage.utilization":21,"host.hostname":"NYC-S75-APT3205"}
    , {"@id":"OqfkPXkBcWzdd8Bv","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"131072","organization.acronym":"nyc","agent.type":"freight","host.address":"172.28.2.237","host.ip":"172.28.2.237","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","storage.bytes":39878656,"storage.name":"system disk","storage.type":"fixedDisk","storage.utilization":29,"host.hostname":"NYC-S75-APT3205"}
    , {"@id":"hnKbjALPlVcP3aKf","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","component.name":"unknown","host.address":"172.28.2.237","host.ip":"172.28.2.237","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT3205"}
    , {"@id":"NhMhMfljl8vvavxC","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.97","host.ip":"192.0.2.97","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT5217"}
    , {"@id":"Y2ukasJKUvPbupAY","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.97","host.ip":"192.0.2.97","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT5217"}
    , {"@id":"FIB4hD97EBhTsmaI","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.97","host.ip":"192.0.2.97","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT5217"}
    , {"@id":"mDNGVswnyWGuFwjq","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.97","host.ip":"192.0.2.97","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT5217"}
    , {"@id":"FA53GQl2sLt8yP6o","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.97","host.ip":"192.0.2.97","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT5217"}
    , {"@id":"ucT45W6qLLajSqOw","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.97","host.ip":"192.0.2.97","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT5217"}
    , {"@id":"ztQ3447zLMYljTLu","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.97","host.ip":"192.0.2.97","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT5217"}
    , {"@id":"17Mxg1cYGdVj9hCna","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.97","host.ip":"192.0.2.97","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT5217"}
    , {"@id":"1E7nJ7Kh6udVQdgph","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.97","host.ip":"192.0.2.97","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT5217"}
    , {"@id":"1E7nJ7SqjXx0udzF2","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.97","host.ip":"192.0.2.97","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT5217"}
    , {"@id":"1E7nJ7VygsyrSj6Ud","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.97","host.ip":"192.0.2.97","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT5217"}
    , {"@id":"1E7nJ7UZ49xZ1aCsw","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.97","host.ip":"192.0.2.97","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.cpu.utilization":0,"component.name":"","host.hostname":"NYC-S75-APT5217"}
    , {"@id":"1F6PYPiGVfpCWJ217","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"1","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.97","host.ip":"192.0.2.97","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan1","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT5217"}
    , {"@id":"1F6PYPqQ8J8i0JKQS","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"2","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.97","host.ip":"192.0.2.97","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"wlan2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT5217"}
    , {"@id":"1F6PYPtY5eAYYORg3","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"3","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.97","host.ip":"192.0.2.97","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":25779,"host.interface.egress.bits_per_second":246,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":25532,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether1","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT5217"}
    , {"@id":"1F6PYPs8Sv9G7FY4M","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"4","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.97","host.ip":"192.0.2.97","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether2","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT5217"}
    , {"@id":"1F6PYPs5zD7XEz8kr","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"5","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.97","host.ip":"192.0.2.97","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether3","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT5217"}
    , {"@id":"1F6PYPsICNkEkibvQ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"6","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.97","host.ip":"192.0.2.97","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether4","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT5217"}
    , {"@id":"1F6PYPhTP6e06iZK3","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"7","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.97","host.ip":"192.0.2.97","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"down","host.interface.bits_per_second":0,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":0,"host.interface.ingress.errors_per_second":0,"host.interface.name":"ether5","host.interface.oper_status":"down","host.hostname":"NYC-S75-APT5217"}
    , {"@id":"1F6PYPsSReY2hRZM2","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"8","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.97","host.ip":"192.0.2.97","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":17886,"host.interface.egress.bits_per_second":219,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":17667,"host.interface.ingress.errors_per_second":0,"host.interface.name":"bridge","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT5217"}
    , {"@id":"1F6PYPiDYRU3lYruP","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"9","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.97","host.ip":"192.0.2.97","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":1471,"host.interface.egress.bits_per_second":215,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":1255,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan801-mgmt","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT5217"}
    , {"@id":"1F6PYPzp3X9TQ9LdA","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"10","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.97","host.ip":"192.0.2.97","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.interface.admin_status":"up","host.interface.bits_per_second":14895,"host.interface.egress.bits_per_second":0,"host.interface.egress.errors_per_second":0,"host.interface.ingress.bits_per_second":14895,"host.interface.ingress.errors_per_second":0,"host.interface.name":"vlan802-inet","host.interface.oper_status":"up","host.hostname":"NYC-S75-APT5217"}
    , {"@id":"OqfkPg3Dup1I9fHZ","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"65536","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.97","host.ip":"192.0.2.97","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","component.memory.utilization":22,"component.name":"main memory","storage.bytes":59092992,"storage.name":"main memory","storage.type":"ram","storage.utilization":22,"host.hostname":"NYC-S75-APT5217"}
    , {"@id":"OqfkPShMhONTqn6e","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","@row":"131072","organization.acronym":"nyc","agent.type":"freight","host.address":"192.0.2.97","host.ip":"192.0.2.97","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","storage.bytes":40243200,"storage.name":"system disk","storage.type":"fixedDisk","storage.utilization":29,"host.hostname":"NYC-S75-APT5217"}
    , {"@id":"hnKbjUDtWxlzqmwk","@service":"npm","@historical":false,"@timestamp":"2022-02-01T15:10:00Z","organization.acronym":"nyc","agent.type":"freight","component.name":"unknown","host.address":"192.0.2.97","host.ip":"192.0.2.97","host.model":"unknown","host.model_oid":"1.3.6.1.4.1.14988.1","host.vendor":"mikrotik","host.hostname":"NYC-S75-APT5217"}
    ]
  |]
