# kb-text-shape

Haskell wrapper for the `kb_text_shape.h` unicode segmentation and shaping library.

[kb\_text\_shape.h]: https://github.com/JimmyLefevre/kb/blob/main/kb_text_shape.h

## Automatic segmentation and shaping

Fonts and text go in, font and glyph indices go out:

```haskell
import KB.Text.Shape where qualified as TextShape

main = do
  TextShape.withContext \ctx -> do
    _font <- TextShape.pushFontFromFile ctx "test/Ubuntu-R.ttf" 0
    results <- TextShape.run ctx do
      TextShape.text_ "A bunch of characters"
      TextShape.char_ '!'
    forM_ results \(run, glyphs) -> do
      forM_ glyphs \glyph ->
        print (run.fontIndex, glyph.id)
```
