module KB.Text.Shape.FFI.API.Other where

import Prelude hiding (id, error)

import Foreign
import Foreign.C

import KB.Text.Shape.FFI.Handles
import KB.Text.Shape.FFI.Enums
import KB.Text.Shape.FFI.Structs

#include "kb_text_shape.h"

-- ** Quick test for font support of a sequence of codepoints.

-- | @void kbts_FontCoverageTestBegin(kbts_font_coverage_test *Test, kbts_font *Font);@
foreign import ccall "kbts_FontCoverageTestBegin" kbts_FontCoverageTestBegin
  :: Ptr FontCoverageTest
  -> Font
  -> IO ()

-- | @void kbts_FontCoverageTestCodepoint(kbts_font_coverage_test *Test, int Codepoint);@
foreign import ccall "kbts_FontCoverageTestCodepoint" kbts_FontCoverageTestCodepoint
  :: Ptr FontCoverageTest
  -> CInt -- ^ Codepoint
  -> IO ()

-- | @int  kbts_FontCoverageTestEnd(kbts_font_coverage_test *Test);@
foreign import ccall "kbts_FontCoverageTestEnd" kbts_FontCoverageTestEnd
  :: Ptr FontCoverageTest
  -> IO Int

-- ** Misc.

-- | @kbts_decode kbts_DecodeUtf8(const char *Utf8, kbts_un Length);@

-- | @kbts_encode_utf8 kbts_EncodeUtf8(int Codepoint);@

-- | @int kbts_ScriptIsComplex(kbts_script Script);@
foreign import ccall "kbts_ScriptIsComplex" kbts_ScriptIsComplex
  :: Script
  -> CInt

newtype ScriptTag = ScriptTag Word32
  deriving (Eq, Ord, Show)
  deriving newtype (Storable)

-- | @kbts_script kbts_ScriptTagToScript(kbts_script_tag Tag);@
foreign import ccall "kbts_ScriptTagToScript" kbts_ScriptTagToScript
  :: ScriptTag
  -> Script

--  define KBTS_FOURCC(A, B, C, D) ((A) | ((B) << 8) | ((C) << 16) | ((D) << 24))
