module KB.Text.Shape.FFI.API.Segmentation where

import Prelude hiding (id, error)

import Foreign
import Foreign.C

import KB.Text.Shape.FFI.Enums
import KB.Text.Shape.FFI.Structs

#include "kb_text_shape.h"

{- $doc
This is a quick guess that stops at the first glyph that has a strong script/direction associated to it.

It is convenient, but only works if you are sure your input text is mono-script and mono-direction.
-}

-- | @void kbts_GuessTextProperties(void *Text, int TextSizeInBytes, kbts_text_format Format, kbts_direction *Direction, kbts_script *Script);@
foreign import ccall "kbts_GuessTextProperties" kbts_GuessTextProperties
  :: Ptr () -- ^ Text
  -> CInt -- ^ TextSizeInBytes
  -> TextFormat
  -> Ptr Direction
  -> Ptr Script
  -> IO ()

-- | @void kbts_GuessTextPropertiesUtf32(const int *Utf32, int Utf32Count, kbts_direction *Direction, kbts_script *Script);@
foreign import ccall "kbts_GuessTextPropertiesUtf32" kbts_GuessTextPropertiesUtf32
  :: Ptr CInt
  -> CInt -- ^ Utf32Count
  -> Ptr Direction
  -> Ptr Script
  -> IO ()

-- | @void kbts_GuessTextPropertiesUtf8(const char *Utf8, int Utf8Length, kbts_direction *Direction, kbts_script *Script);@
foreign import ccall "kbts_GuessTextPropertiesUtf8" kbts_GuessTextPropertiesUtf8
  :: Ptr CChar
  -> CInt -- ^ Utf8Length
  -> Ptr Direction
  -> Ptr Script
  -> IO ()

-- | @void kbts_BreakBegin(kbts_break_state *State, kbts_direction ParagraphDirection, kbts_japanese_line_break_style JapaneseLineBreakStyle, kbts_break_config_flags ConfigFlags);@
foreign import ccall "kbts_BreakBegin" kbts_BreakBegin
  :: BreakState
  -> Direction -- ^ ParagraphDirection
  -> JapaneseLineBreakStyle
  -> BreakConfigFlags
  -> IO ()

-- | @void kbts_BreakAddCodepoint(kbts_break_state *State, int Codepoint, int PositionIncrement, int EndOfText);@
foreign import ccall "kbts_BreakAddCodepoint" kbts_BreakAddCodepoint
  :: BreakState
  -> CInt -- ^ Codepoint
  -> CInt -- ^ PositionIncrement
  -> CInt -- ^ EndOfText
  -> IO ()

-- | @void kbts_BreakEnd(kbts_break_state *State);@
foreign import ccall "kbts_BreakEnd" kbts_BreakEnd
  :: BreakState
  -> IO ()

-- | @int kbts_Break(kbts_break_state *State, kbts_break *Break);@
foreign import ccall "kbts_Break" kbts_Break
  :: BreakState
  -> Ptr Break
  -> IO ()

-- | @void kbts_BreakEntireString(kbts_direction Direction, kbts_japanese_line_break_style JapaneseLineBreakStyle, kbts_break_config_flags ConfigFlags, const void *Input, int InputSizeInBytes, kbts_text_format InputFormat, kbts_break *Breaks, int BreakCapacity, int *BreakCount, kbts_break_flags *BreakFlags, int BreakFlagCapacity, int *BreakFlagCount);@
foreign import ccall "kbts_BreakEntireString" kbts_BreakEntireString
  :: BreakState
  -> IO ()

-- | @void kbts_BreakEntireStringUtf32(kbts_direction Direction, kbts_japanese_line_break_style JapaneseLineBreakStyle, kbts_break_config_flags ConfigFlags, const int *Utf32, int Utf32Count, kbts_break *Breaks, int BreakCapacity, int *BreakCount, kbts_break_flags *BreakFlags, int BreakFlagCapacity, int *BreakFlagCount);@
foreign import ccall "kbts_BreakEntireStringUtf32" kbts_BreakEntireStringUtf32
  :: BreakState
  -> IO ()

-- | @void kbts_BreakEntireStringUtf8(kbts_direction Direction, kbts_japanese_line_break_style JapaneseLineBreakStyle, kbts_break_config_flags ConfigFlags, const char *Utf8, int Utf8Length, kbts_break *Breaks, int BreakCapacity, int *BreakCount, kbts_break_flags *BreakFlags, int BreakFlagCapacity, int *BreakFlagCount);@
foreign import ccall "kbts_BreakEntireStringUtf8" kbts_BreakEntireStringUtf8
  :: BreakState
  -> IO ()
