module KB.Text.Shape.FFI.Enums
  ( module KB.Text.Shape.FFI.Enums
  , module RE
  ) where

import Foreign

import KB.Text.Shape.FFI.Enums.FeatureTag as RE
import KB.Text.Shape.FFI.Enums.Language as RE
import KB.Text.Shape.FFI.Enums.Script as RE

#include "kb_text_shape.h"

newtype Direction = Direction Word32
  deriving (Eq, Ord, Show)
  deriving newtype (Storable)

pattern DIRECTION_DONT_KNOW :: Direction
pattern DIRECTION_DONT_KNOW = Direction (#const KBTS_DIRECTION_DONT_KNOW)

pattern DIRECTION_LTR :: Direction
pattern DIRECTION_LTR = Direction (#const KBTS_DIRECTION_LTR)

pattern DIRECTION_RTL :: Direction
pattern DIRECTION_RTL = Direction (#const KBTS_DIRECTION_RTL)

newtype ShapeError = ShapeError Word32
  deriving (Eq, Ord, Show)
  deriving newtype (Storable)

pattern SHAPE_ERROR_NONE :: ShapeError
pattern SHAPE_ERROR_NONE = ShapeError (#const KBTS_SHAPE_ERROR_NONE)

pattern SHAPE_ERROR_INVALID_FONT :: ShapeError
pattern SHAPE_ERROR_INVALID_FONT = ShapeError (#const KBTS_SHAPE_ERROR_INVALID_FONT)

pattern SHAPE_ERROR_GAVE_TEXT_BEFORE_CALLING_BEGIN :: ShapeError
pattern SHAPE_ERROR_GAVE_TEXT_BEFORE_CALLING_BEGIN = ShapeError (#const KBTS_SHAPE_ERROR_GAVE_TEXT_BEFORE_CALLING_BEGIN)

pattern SHAPE_ERROR_OUT_OF_MEMORY :: ShapeError
pattern SHAPE_ERROR_OUT_OF_MEMORY = ShapeError (#const KBTS_SHAPE_ERROR_OUT_OF_MEMORY)

newtype UserIdGenerationMode = UserIdGenerationMode Word32
  deriving (Eq, Ord, Show)
  deriving newtype (Storable)

pattern USER_ID_GENERATION_MODE_CODEPOINT_INDEX :: UserIdGenerationMode
pattern USER_ID_GENERATION_MODE_CODEPOINT_INDEX = UserIdGenerationMode (#const KBTS_USER_ID_GENERATION_MODE_CODEPOINT_INDEX)

pattern USER_ID_GENERATION_MODE_SOURCE_INDEX :: UserIdGenerationMode
pattern USER_ID_GENERATION_MODE_SOURCE_INDEX = UserIdGenerationMode (#const KBTS_USER_ID_GENERATION_MODE_SOURCE_INDEX)

pattern USER_ID_GENERATION_MODE_CONST :: UserIdGenerationMode
pattern USER_ID_GENERATION_MODE_CONST = UserIdGenerationMode (#const KBTS_USER_ID_GENERATION_MODE_COUNT)

newtype BreakFlags = BreakFlags Word32
  deriving (Eq, Ord, Show)
  deriving newtype (Storable)

newtype LoadFontError = LoadFontError Word32
  deriving (Eq, Ord, Show)
  deriving newtype (Storable)

pattern LOAD_FONT_ERROR_NONE :: LoadFontError
pattern LOAD_FONT_ERROR_NONE = LoadFontError #const KBTS_LOAD_FONT_ERROR_NONE

pattern LOAD_FONT_ERROR_NEED_TO_CREATE_BLOB :: LoadFontError
pattern LOAD_FONT_ERROR_NEED_TO_CREATE_BLOB = LoadFontError #const KBTS_LOAD_FONT_ERROR_NEED_TO_CREATE_BLOB

pattern LOAD_FONT_ERROR_INVALID_FONT :: LoadFontError
pattern LOAD_FONT_ERROR_INVALID_FONT = LoadFontError #const KBTS_LOAD_FONT_ERROR_INVALID_FONT

pattern LOAD_FONT_ERROR_OUT_OF_MEMORY :: LoadFontError
pattern LOAD_FONT_ERROR_OUT_OF_MEMORY = LoadFontError #const KBTS_LOAD_FONT_ERROR_OUT_OF_MEMORY

pattern LOAD_FONT_ERROR_COULD_NOT_OPEN_FILE :: LoadFontError
pattern LOAD_FONT_ERROR_COULD_NOT_OPEN_FILE = LoadFontError #const KBTS_LOAD_FONT_ERROR_COULD_NOT_OPEN_FILE

pattern LOAD_FONT_ERROR_READ_ERROR :: LoadFontError
pattern LOAD_FONT_ERROR_READ_ERROR = LoadFontError #const KBTS_LOAD_FONT_ERROR_READ_ERROR

newtype FontStyleFlags = FontStyleFlags Word32
  deriving (Eq, Show)
  deriving newtype (Storable, Bits)

instance Semigroup FontStyleFlags where
  {-# INLINE (<>) #-}
  (<>) = (.|.)

instance Monoid FontStyleFlags where
  {-# INLINE mempty #-}
  mempty = FontStyleFlags 0

pattern FONT_STYLE_FLAG_REGULAR :: FontStyleFlags
pattern FONT_STYLE_FLAG_REGULAR = FontStyleFlags (#const KBTS_FONT_STYLE_FLAG_REGULAR)

pattern FONT_STYLE_FLAG_ITALIC :: FontStyleFlags
pattern FONT_STYLE_FLAG_ITALIC = FontStyleFlags (#const KBTS_FONT_STYLE_FLAG_ITALIC)

pattern FONT_STYLE_FLAG_BOLD :: FontStyleFlags
pattern FONT_STYLE_FLAG_BOLD = FontStyleFlags (#const KBTS_FONT_STYLE_FLAG_BOLD)

newtype FontWeight = FontWeight Word32
  deriving (Eq, Ord, Show)
  deriving newtype (Storable)

pattern FONT_WEIGHT_UNKNOWN :: FontWeight
pattern FONT_WEIGHT_UNKNOWN = FontWeight (#const KBTS_FONT_WEIGHT_UNKNOWN)

pattern FONT_WEIGHT_THIN :: FontWeight
pattern FONT_WEIGHT_THIN = FontWeight (#const KBTS_FONT_WEIGHT_THIN)

pattern FONT_WEIGHT_EXTRA_LIGHT :: FontWeight
pattern FONT_WEIGHT_EXTRA_LIGHT = FontWeight (#const KBTS_FONT_WEIGHT_EXTRA_LIGHT)

pattern FONT_WEIGHT_LIGHT :: FontWeight
pattern FONT_WEIGHT_LIGHT = FontWeight (#const KBTS_FONT_WEIGHT_LIGHT)

pattern FONT_WEIGHT_NORMAL :: FontWeight
pattern FONT_WEIGHT_NORMAL = FontWeight (#const KBTS_FONT_WEIGHT_NORMAL)

pattern FONT_WEIGHT_MEDIUM :: FontWeight
pattern FONT_WEIGHT_MEDIUM = FontWeight (#const KBTS_FONT_WEIGHT_MEDIUM)

pattern FONT_WEIGHT_SEMI_BOLD :: FontWeight
pattern FONT_WEIGHT_SEMI_BOLD = FontWeight (#const KBTS_FONT_WEIGHT_SEMI_BOLD)

pattern FONT_WEIGHT_BOLD :: FontWeight
pattern FONT_WEIGHT_BOLD = FontWeight (#const KBTS_FONT_WEIGHT_BOLD)

pattern FONT_WEIGHT_EXTRA_BOLD :: FontWeight
pattern FONT_WEIGHT_EXTRA_BOLD = FontWeight (#const KBTS_FONT_WEIGHT_EXTRA_BOLD)

pattern FONT_WEIGHT_BLACK :: FontWeight
pattern FONT_WEIGHT_BLACK = FontWeight (#const KBTS_FONT_WEIGHT_BLACK)

newtype FontWidth = FontWidth Word32
  deriving (Eq, Show)
  deriving newtype (Storable)

pattern FONT_WIDTH_UNKNOWN :: FontWidth
pattern FONT_WIDTH_UNKNOWN = FontWidth (#const KBTS_FONT_WIDTH_UNKNOWN)

pattern FONT_WIDTH_ULTRA_CONDENSED :: FontWidth
pattern FONT_WIDTH_ULTRA_CONDENSED = FontWidth (#const KBTS_FONT_WIDTH_ULTRA_CONDENSED)

pattern FONT_WIDTH_EXTRA_CONDENSED :: FontWidth
pattern FONT_WIDTH_EXTRA_CONDENSED = FontWidth (#const KBTS_FONT_WIDTH_EXTRA_CONDENSED)

pattern FONT_WIDTH_CONDENSED :: FontWidth
pattern FONT_WIDTH_CONDENSED = FontWidth (#const KBTS_FONT_WIDTH_CONDENSED)

pattern FONT_WIDTH_SEMI_CONDENSED :: FontWidth
pattern FONT_WIDTH_SEMI_CONDENSED = FontWidth (#const KBTS_FONT_WIDTH_SEMI_CONDENSED)

pattern FONT_WIDTH_NORMAL :: FontWidth
pattern FONT_WIDTH_NORMAL = FontWidth (#const KBTS_FONT_WIDTH_NORMAL)

pattern FONT_WIDTH_SEMI_EXPANDED :: FontWidth
pattern FONT_WIDTH_SEMI_EXPANDED = FontWidth (#const KBTS_FONT_WIDTH_SEMI_EXPANDED)

pattern FONT_WIDTH_EXPANDED :: FontWidth
pattern FONT_WIDTH_EXPANDED = FontWidth (#const KBTS_FONT_WIDTH_EXPANDED)

pattern FONT_WIDTH_EXTRA_EXPANDED :: FontWidth
pattern FONT_WIDTH_EXTRA_EXPANDED = FontWidth (#const KBTS_FONT_WIDTH_EXTRA_EXPANDED)

pattern FONT_WIDTH_ULTRA_EXPANDED :: FontWidth
pattern FONT_WIDTH_ULTRA_EXPANDED = FontWidth (#const KBTS_FONT_WIDTH_ULTRA_EXPANDED)

pattern FONT_INFO_STRING_ID_COUNT :: Int
pattern FONT_INFO_STRING_ID_COUNT = #const KBTS_FONT_INFO_STRING_ID_COUNT

newtype TextFormat = TextFormat Word32
  deriving (Eq, Ord, Show)
  deriving newtype (Storable)

pattern TEXT_FORMAT_NONE :: TextFormat
pattern TEXT_FORMAT_NONE = TextFormat (#const KBTS_TEXT_FORMAT_NONE)

pattern TEXT_FORMAT_UTF32 :: TextFormat
pattern TEXT_FORMAT_UTF32 = TextFormat (#const KBTS_TEXT_FORMAT_UTF32)

pattern TEXT_FORMAT_UTF8 :: TextFormat
pattern TEXT_FORMAT_UTF8 = TextFormat (#const KBTS_TEXT_FORMAT_UTF8)

{- |
  Japanese text contains "kinsoku" characters, around which breaking a line is forbidden.
  Exactly which characters are "kinsoku" or not depends on the context:
  - Strict style has the largest amount of kinsoku characters, which leads to longer lines.
  - Loose style has the smallest amount of kinsoku characters, which leads to smaller lines.
  - Normal style is somewhere in the middle.
  Note that, while the Unicode standard mentions all three of these styles, it does not mention
  any differences between the normal and loose styles.
  As such, normal and loose styles currently behave the same.
-}
newtype JapaneseLineBreakStyle = JapaneseLineBreakStyle Word8
  deriving (Eq, Ord, Show)
  deriving (Storable)

{- |
  The Unicode standard does not define what strict style is used for.
  Supposedly, it is used for anything that does not fall into the other two categories of text.
-}
pattern JAPANESE_LINE_BREAK_STYLE_STRICT :: JapaneseLineBreakStyle
pattern JAPANESE_LINE_BREAK_STYLE_STRICT = JapaneseLineBreakStyle (#const KBTS_JAPANESE_LINE_BREAK_STYLE_STRICT)

-- | Normal style is used for books and documents.
pattern JAPANESE_LINE_BREAK_STYLE_NORMAL :: JapaneseLineBreakStyle
pattern JAPANESE_LINE_BREAK_STYLE_NORMAL = JapaneseLineBreakStyle (#const KBTS_JAPANESE_LINE_BREAK_STYLE_NORMAL)

-- | Loose style is used for newspapers, and (I assume) any other narrow column format.
pattern JAPANESE_LINE_BREAK_STYLE_LOOSE :: JapaneseLineBreakStyle
pattern JAPANESE_LINE_BREAK_STYLE_LOOSE = JapaneseLineBreakStyle (#const KBTS_JAPANESE_LINE_BREAK_STYLE_LOOSE)

newtype BreakStateFlags = BreakStateFlags Word32
  deriving (Eq, Ord, Show)
  deriving newtype (Storable, Bits)

instance Semigroup BreakStateFlags where
  {-# INLINE (<>) #-}
  (<>) = (.|.)

instance Monoid BreakStateFlags where
  {-# INLINE mempty #-}
  mempty = BreakStateFlags 0

pattern BREAK_STATE_FLAG_STARTED :: BreakStateFlags
pattern BREAK_STATE_FLAG_STARTED = BreakStateFlags (#const KBTS_BREAK_STATE_FLAG_STARTED)

pattern BREAK_STATE_FLAG_END :: BreakStateFlags
pattern BREAK_STATE_FLAG_END = BreakStateFlags (#const KBTS_BREAK_STATE_FLAG_END)

-- Bidirectional flags

pattern BREAK_STATE_FLAG_SAW_R_AFTER_L :: BreakStateFlags
pattern BREAK_STATE_FLAG_SAW_R_AFTER_L = BreakStateFlags (#const KBTS_BREAK_STATE_FLAG_SAW_R_AFTER_L)

pattern BREAK_STATE_FLAG_SAW_AL_AFTER_LR :: BreakStateFlags
pattern BREAK_STATE_FLAG_SAW_AL_AFTER_LR = BreakStateFlags (#const KBTS_BREAK_STATE_FLAG_SAW_AL_AFTER_LR)

pattern BREAK_STATE_FLAG_LAST_WAS_BRACKET :: BreakStateFlags
pattern BREAK_STATE_FLAG_LAST_WAS_BRACKET = BreakStateFlags (#const KBTS_BREAK_STATE_FLAG_LAST_WAS_BRACKET)

newtype BreakState = BreakState (Ptr BreakState)
  deriving (Eq, Show)
  deriving newtype (Storable)

newtype BreakConfigFlags = BreakConfigFlags Word32
  deriving (Eq, Ord, Show)
  deriving newtype (Storable, Bits)

instance Semigroup BreakConfigFlags where
  {-# INLINE (<>) #-}
  (<>) = (.|.)

instance Monoid BreakConfigFlags where
  {-# INLINE mempty #-}
  mempty = BreakConfigFlags 0

pattern BREAK_CONFIG_FLAG_END_OF_TEXT_GENERATES_HARD_LINE_BREAK :: BreakConfigFlags
pattern BREAK_CONFIG_FLAG_END_OF_TEXT_GENERATES_HARD_LINE_BREAK = BreakConfigFlags (#const KBTS_BREAK_CONFIG_FLAG_END_OF_TEXT_GENERATES_HARD_LINE_BREAK)
